/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.AnchorEndNode;
import com.github.sisyphsu.retree.AnchorStartNode;
import com.github.sisyphsu.retree.BeginNode;
import com.github.sisyphsu.retree.BoundNode;
import com.github.sisyphsu.retree.BranchNode;
import com.github.sisyphsu.retree.CharAnyNode;
import com.github.sisyphsu.retree.CharNode;
import com.github.sisyphsu.retree.CharRangeNode;
import com.github.sisyphsu.retree.CharRefNode;
import com.github.sisyphsu.retree.CharSetNode;
import com.github.sisyphsu.retree.CharSingleNode;
import com.github.sisyphsu.retree.CharTypeNode;
import com.github.sisyphsu.retree.CharUnionNode;
import com.github.sisyphsu.retree.CharWhitespaceNode;
import com.github.sisyphsu.retree.EndNode;
import com.github.sisyphsu.retree.GroupNode;
import com.github.sisyphsu.retree.LoopNode;
import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;

final class ReCompiler {
    private String pattern;
    private int patternLength;
    Node ret;
    Node root;
    EndNode endNode;
    private int[] ptnChars;
    private Map<String, Integer> namedGroups;
    private int groupCount;
    private int localCount;
    private int cursor;

    public static ReCompiler compile(String regex) {
        return new ReCompiler(regex);
    }

    private ReCompiler(String re) {
        this.pattern = re;
        this.groupCount = 1;
        this.localCount = 1;
        this.namedGroups = new HashMap<String, Integer>(2);
        this.endNode = new EndNode(re);
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = this.endNode;
        }
        this.endNode.init(this.localCount, this.groupCount, this.namedGroups);
        this.root = new BeginNode(this.root);
    }

    private void compile() {
        this.patternLength = this.pattern.length();
        this.ptnChars = new int[this.patternLength + 2];
        int chCount = 0;
        for (int off = 0; off < this.patternLength; ++off) {
            this.ptnChars[chCount++] = this.pattern.charAt(off);
        }
        this.patternLength = chCount;
        this.removeQEQuoting();
        this.root = this.parseExpress(this.endNode);
        if (this.cursor != this.patternLength) {
            throw this.error(this.peek() == 41 ? "Unmatched closing ')'" : "Unexpected internal error");
        }
        this.ptnChars = null;
        this.patternLength = 0;
    }

    private void removeQEQuoting() {
        int off;
        for (off = 0; off < this.patternLength - 1 && (this.ptnChars[off] != 92 || this.ptnChars[off + 1] != 81); ++off) {
        }
        if (off >= this.patternLength - 1) {
            return;
        }
        boolean inQuote = true;
        int[] newTemp = new int[this.patternLength * 2];
        System.arraycopy(this.ptnChars, 0, newTemp, 0, off);
        int newOff = off;
        off += 2;
        while (off < this.patternLength) {
            int ch;
            if (!Util.isAscii(ch = this.ptnChars[off++]) || Util.isAlpha(ch) || Util.isDigit(ch)) {
                newTemp[newOff++] = ch;
                continue;
            }
            if (ch != 92) {
                if (inQuote) {
                    newTemp[newOff++] = 92;
                }
                newTemp[newOff++] = ch;
                continue;
            }
            if (inQuote) {
                if (this.ptnChars[off] == 69) {
                    ++off;
                    inQuote = false;
                    continue;
                }
                newTemp[newOff++] = 92;
                newTemp[newOff++] = ch;
                continue;
            }
            if (this.ptnChars[off] == 81) {
                ++off;
                inQuote = true;
                continue;
            }
            newTemp[newOff++] = ch;
            if (off >= this.patternLength) continue;
            newTemp[newOff++] = this.ptnChars[off++];
        }
        this.patternLength = newOff;
        this.ptnChars = Arrays.copyOf(newTemp, newOff + 2);
    }

    private int peek() {
        return this.ptnChars[this.cursor];
    }

    private int read() {
        return this.ptnChars[this.cursor++];
    }

    private int next() {
        return this.ptnChars[++this.cursor];
    }

    private int skipAndRead() {
        ++this.cursor;
        return this.read();
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String s) {
        return new PatternSyntaxException(s, this.pattern, this.cursor - 1);
    }

    private Node parseExpress(Node end) {
        Node result = this.sequence(end);
        Node resultTail = this.ret;
        BranchNode branch = null;
        while (this.peek() == 124) {
            this.next();
            Node node = this.sequence(end);
            Node nodeTail = this.ret;
            if (node == end) {
                node = null;
            } else {
                nodeTail.next = end;
            }
            if (branch != null) {
                branch.add(node);
                continue;
            }
            if (result == end) {
                result = null;
            } else {
                resultTail.next = end;
            }
            branch = new BranchNode(end, result, node);
        }
        return branch == null ? result : branch;
    }

    private Node sequence(Node end) {
        Node head = null;
        Node tail = null;
        block10: while (true) {
            Node node;
            int ch;
            if ((ch = this.peek()) == 40) {
                Node groupHead = this.parseGroup();
                if (groupHead == null) continue;
                if (head == null) {
                    head = groupHead;
                } else {
                    tail.next = groupHead;
                }
                tail = this.ret;
                continue;
            }
            switch (ch) {
                case 41: 
                case 124: {
                    break block10;
                }
                case 91: {
                    node = this.parseClass();
                    break;
                }
                case 94: {
                    this.next();
                    node = new AnchorStartNode();
                    break;
                }
                case 36: {
                    this.next();
                    node = new AnchorEndNode(false);
                    break;
                }
                case 46: {
                    this.next();
                    node = new CharAnyNode();
                    break;
                }
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    this.next();
                    throw this.error("Dangling meta character '" + (char)ch + "'");
                }
                case 92: {
                    ch = this.parseEscape();
                    if (ch < 0) {
                        node = this.ret;
                        break;
                    }
                    node = new CharSingleNode(ch);
                    break;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block10;
                }
                default: {
                    this.next();
                    node = new CharSingleNode(ch);
                }
            }
            node = this.parseRepetition(node, node);
            if (head == null) {
                head = node;
            } else {
                tail.next = node;
            }
            tail = node;
        }
        if (head == null) {
            return end;
        }
        tail.next = end;
        this.ret = tail;
        return head;
    }

    private int parseEscape() {
        int ch = this.skipAndRead();
        switch (ch) {
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 88: 
            case 89: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 121: {
                break;
            }
            case 48: {
                return this.parseOctalEscape();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.ret = this.backReferenceEscape(ch - 48);
                return -1;
            }
            case 98: {
                this.ret = new BoundNode(BoundNode.WORD);
                return -1;
            }
            case 66: {
                this.ret = new BoundNode(BoundNode.NON_WORD);
                return -1;
            }
            case 100: {
                this.ret = new CharTypeNode(1, true);
                return -1;
            }
            case 68: {
                this.ret = new CharTypeNode(1, false);
                return -1;
            }
            case 104: {
                this.ret = new CharWhitespaceNode(true, true);
                return -1;
            }
            case 72: {
                this.ret = new CharWhitespaceNode(true, false);
                return -1;
            }
            case 115: {
                this.ret = new CharTypeNode(2, true);
                return -1;
            }
            case 83: {
                this.ret = new CharTypeNode(2, false);
                return -1;
            }
            case 118: {
                this.ret = new CharWhitespaceNode(false, true);
                return -1;
            }
            case 86: {
                this.ret = new CharWhitespaceNode(false, false);
                return -1;
            }
            case 119: {
                this.ret = new CharTypeNode(3, true);
                return -1;
            }
            case 87: {
                this.ret = new CharTypeNode(3, false);
                return -1;
            }
            case 65: {
                this.ret = new AnchorStartNode();
                return -1;
            }
            case 122: {
                this.ret = new AnchorEndNode(true);
                return -1;
            }
            case 90: {
                this.ret = new AnchorEndNode(false);
                return -1;
            }
            case 99: {
                return this.parseControlEscape();
            }
            case 117: {
                return this.parseUxxxx();
            }
            case 120: {
                return this.parseHexadecimalEscape();
            }
            case 107: {
                if (this.read() != 60) {
                    throw this.error("\\k is not followed by '<' for named capturing group");
                }
                String name = this.groupname();
                if (!this.namedGroups.containsKey(name)) {
                    throw this.error("(named capturing group <" + name + "> does not exit");
                }
                this.ret = new CharRefNode(this.namedGroups.get(name));
                return -1;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            default: {
                return ch;
            }
        }
        throw this.error("Illegal/unsupported escape sequence");
    }

    private Node backReferenceEscape(int refNum) {
        int newRefNum;
        int ch;
        while ((ch = this.peek()) >= 48 && ch <= 57 && this.groupCount - 1 >= (newRefNum = refNum * 10 + (ch - 48))) {
            refNum = newRefNum;
            this.read();
        }
        if (this.groupCount - 1 < refNum) {
            return new CharSingleNode(refNum);
        }
        return new CharRefNode(refNum);
    }

    private CharNode parseClass() {
        boolean include = true;
        int ch = this.next();
        if (ch == 94) {
            ch = this.next();
            include = false;
        }
        CharNode prev = null;
        CharSetNode bits = new CharSetNode();
        while (true) {
            if (ch == 0 && this.cursor >= this.patternLength) {
                throw this.error("Unclosed character class");
            }
            if (ch == 93 && prev != null) {
                this.next();
                return include ? prev : prev.complement();
            }
            CharNode node = this.clazzRange(bits);
            if (prev == null) {
                prev = node;
            } else if (prev != node) {
                prev = new CharUnionNode(prev, node);
            }
            ch = this.peek();
        }
    }

    private CharNode clazzRange(CharSetNode bits) {
        int ch = this.peek();
        if (ch == 92) {
            ch = this.clazzEscape(true, this.ptnChars[this.cursor + 2] == 45);
            if (ch == -1) {
                return (CharNode)this.ret;
            }
        } else {
            this.next();
        }
        if (this.peek() == 45) {
            int endRange = this.ptnChars[this.cursor + 1];
            if (endRange == 91) {
                throw this.error("Character range is out of order");
            }
            if (endRange != 93) {
                this.next();
                int m = this.peek();
                if (m == 92) {
                    m = this.clazzEscape(false, true);
                } else {
                    this.next();
                }
                if (m < ch) {
                    throw this.error("Illegal character range");
                }
                return new CharRangeNode(ch, m);
            }
        }
        return ch < 256 ? bits.add(ch) : new CharSingleNode(ch);
    }

    private int clazzEscape(boolean create, boolean isRange) {
        int ch = this.skipAndRead();
        if (ch >= 49 && ch <= 57) {
            return ch - 48;
        }
        switch (ch) {
            case 69: 
            case 76: 
            case 78: 
            case 80: 
            case 85: 
            case 108: 
            case 111: 
            case 112: {
                break;
            }
            case 48: {
                return this.parseOctalEscape();
            }
            case 98: {
                return 8;
            }
            case 100: {
                if (create) {
                    this.ret = new CharTypeNode(1, true);
                }
                return -1;
            }
            case 68: {
                if (create) {
                    this.ret = new CharTypeNode(1, false);
                }
                return -1;
            }
            case 104: {
                if (create) {
                    this.ret = new CharWhitespaceNode(true, true);
                }
                return -1;
            }
            case 72: {
                if (create) {
                    this.ret = new CharWhitespaceNode(true, false);
                }
                return -1;
            }
            case 115: {
                if (create) {
                    this.ret = new CharTypeNode(2, true);
                }
                return -1;
            }
            case 83: {
                if (create) {
                    this.ret = new CharTypeNode(2, false);
                }
                return -1;
            }
            case 118: {
                if (isRange) {
                    return 11;
                }
                if (create) {
                    this.ret = new CharWhitespaceNode(false, true);
                }
                return -1;
            }
            case 86: {
                if (create) {
                    this.ret = new CharWhitespaceNode(false, false);
                }
                return -1;
            }
            case 119: {
                if (create) {
                    this.ret = new CharTypeNode(3, true);
                }
                return -1;
            }
            case 87: {
                if (create) {
                    this.ret = new CharTypeNode(3, false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 99: {
                return this.parseControlEscape();
            }
            case 117: {
                return this.parseUxxxx();
            }
            case 120: {
                return this.parseHexadecimalEscape();
            }
            default: {
                return ch;
            }
        }
        throw this.error("Illegal/unsupported escape sequence");
    }

    private Node parseGroup() {
        Node tail;
        Node head;
        block8: {
            block7: {
                int ch = this.next();
                this.ret = null;
                if (ch != 63) break block7;
                ch = this.skipAndRead();
                switch (ch) {
                    case 58: {
                        head = this.createGroup(true);
                        tail = this.ret;
                        head.next = this.parseExpress(tail);
                        break block8;
                    }
                    case 62: {
                        head = this.createGroup(true);
                        tail = this.ret;
                        head.next = this.parseExpress(tail);
                        tail = new LoopNode(head, tail, 1, 1, 2, this.localCount++);
                        head = tail;
                        break block8;
                    }
                    case 60: {
                        String name = this.groupname();
                        if (this.namedGroups.containsKey(name)) {
                            throw this.error("Named capturing group <" + name + "> is already defined");
                        }
                        head = this.createGroup(false);
                        tail = this.ret;
                        this.namedGroups.put(name, this.groupCount - 1);
                        head.next = this.parseExpress(tail);
                        break block8;
                    }
                    default: {
                        throw this.error("Unknown group type");
                    }
                }
            }
            head = this.createGroup(false);
            tail = this.ret;
            head.next = this.parseExpress(tail);
        }
        if (41 != this.read()) {
            throw this.error("Unclosed group");
        }
        Node node = this.parseRepetition(head, tail);
        this.ret = node == head ? tail : node;
        return node;
    }

    private String groupname() {
        int ch;
        StringBuilder sb = new StringBuilder();
        while (Util.isLower(ch = this.read()) || Util.isUpper(ch) || Util.isDigit(ch)) {
            sb.append(Character.toChars(ch));
        }
        if (sb.length() == 0) {
            throw this.error("named capturing group has 0 length name");
        }
        if (ch != 62) {
            throw this.error("named capturing group is missing trailing '>'");
        }
        return sb.toString();
    }

    private GroupNode createGroup(boolean anonymous) {
        int n;
        if (anonymous) {
            n = 0;
        } else {
            int n2 = this.groupCount;
            n = n2;
            this.groupCount = n2 + 1;
        }
        int groupIndex = n;
        GroupNode head = new GroupNode(groupIndex);
        this.ret = head.tailNode;
        return head;
    }

    private Node parseRepetition(Node head, Node tail) {
        int ch = this.peek();
        switch (ch) {
            case 63: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new LoopNode(head, tail, 0, 1, 1, this.localCount++);
                }
                if (ch == 43) {
                    this.next();
                    return new LoopNode(head, tail, 0, 1, 2, this.localCount++);
                }
                return new LoopNode(head, tail, 0, 1, 0, this.localCount++);
            }
            case 42: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new LoopNode(head, tail, 0, Integer.MAX_VALUE, 1, this.localCount++);
                }
                if (ch == 43) {
                    this.next();
                    return new LoopNode(head, tail, 0, Integer.MAX_VALUE, 2, this.localCount++);
                }
                return new LoopNode(head, tail, 0, Integer.MAX_VALUE, 0, this.localCount++);
            }
            case 43: {
                ch = this.next();
                if (ch == 63) {
                    this.next();
                    return new LoopNode(head, tail, 1, Integer.MAX_VALUE, 1, this.localCount++);
                }
                if (ch == 43) {
                    this.next();
                    return new LoopNode(head, tail, 1, Integer.MAX_VALUE, 2, this.localCount++);
                }
                return new LoopNode(head, tail, 1, Integer.MAX_VALUE, 0, this.localCount++);
            }
            case 123: {
                ch = this.ptnChars[this.cursor + 1];
                if (Util.isDigit(ch)) {
                    LoopNode curly;
                    this.skipAndRead();
                    int cmin = 0;
                    do {
                        cmin = cmin * 10 + (ch - 48);
                    } while (Util.isDigit(ch = this.read()));
                    int cmax = cmin;
                    if (ch == 44) {
                        ch = this.read();
                        cmax = Integer.MAX_VALUE;
                        if (ch != 125) {
                            cmax = 0;
                            while (Util.isDigit(ch)) {
                                cmax = cmax * 10 + (ch - 48);
                                ch = this.read();
                            }
                        }
                    }
                    if (ch != 125) {
                        throw this.error("Unclosed counted closureRepetition");
                    }
                    if ((cmin | cmax | cmax - cmin) < 0) {
                        throw this.error("Illegal repetition range");
                    }
                    ch = this.peek();
                    if (ch == 63) {
                        this.next();
                        curly = new LoopNode(head, tail, cmin, cmax, 1, this.localCount++);
                    } else if (ch == 43) {
                        this.next();
                        curly = new LoopNode(head, tail, cmin, cmax, 2, this.localCount++);
                    } else {
                        curly = new LoopNode(head, tail, cmin, cmax, 0, this.localCount++);
                    }
                    return curly;
                }
                throw this.error("Illegal repetition");
            }
        }
        return head;
    }

    private int parseControlEscape() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw this.error("Illegal control escape sequence");
    }

    private int parseOctalEscape() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int m = this.read();
            if ((m - 48 | 55 - m) >= 0) {
                int o = this.read();
                if ((o - 48 | 55 - o) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (m - 48) * 8 + (o - 48);
                }
                this.unread();
                return (n - 48) * 8 + (m - 48);
            }
            this.unread();
            return n - 48;
        }
        throw this.error("Illegal octal escape sequence");
    }

    private int parseHexadecimalEscape() {
        int n = this.read();
        if (Util.isHexDigit(n)) {
            int m = this.read();
            if (Util.isHexDigit(m)) {
                return Util.toDigit(n) * 16 + Util.toDigit(m);
            }
        } else if (n == 123 && Util.isHexDigit(this.peek())) {
            int ch = 0;
            while (Util.isHexDigit(n = this.read())) {
                if ((ch = (ch << 4) + Util.toDigit(n)) <= 0x10FFFF) continue;
                throw this.error("Hexadecimal codepoint is too big");
            }
            if (n != 125) {
                throw this.error("Unclosed hexadecimal escape sequence");
            }
            return ch;
        }
        throw this.error("Illegal hexadecimal escape sequence");
    }

    private int parseUxxxx() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int ch = this.read();
            if (!Util.isHexDigit(ch)) {
                throw this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + Util.toDigit(ch);
        }
        return n;
    }
}

