/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReMatcher;

public final class AnchorEndNode
extends Node {
    private final boolean absolute;

    public AnchorEndNode(boolean absolute) {
        this.absolute = absolute;
    }

    @Override
    public boolean match(ReMatcher matcher, CharSequence input, int cursor) {
        int rest = matcher.to - cursor;
        if (rest == 0) {
            return this.next.match(matcher, input, cursor);
        }
        if (this.absolute) {
            return false;
        }
        if (rest > 2) {
            return false;
        }
        if (rest == 2) {
            if (input.charAt(cursor) != '\r' || input.charAt(cursor + 1) != '\n') {
                return false;
            }
            return this.next.match(matcher, input, cursor + 2);
        }
        if (cursor > matcher.from && input.charAt(cursor - 1) == '\r') {
            if (input.charAt(cursor) != '\n') {
                return false;
            }
            return this.next.match(matcher, input, cursor + 1);
        }
        char ch = input.charAt(cursor);
        if (ch != '\n' && ch != '\r' && ch != '\u0085' && (ch | '\u0001') != 8233) {
            return false;
        }
        return this.next.match(matcher, input, cursor + 1);
    }

    @Override
    public boolean alike(Node node) {
        if (node instanceof AnchorEndNode) {
            return this.absolute == ((AnchorEndNode)node).absolute;
        }
        return false;
    }
}

