/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.mockeri.generator;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.PostConstruct;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.mockeri.annotations.CompositeEntity;
import org.sindaryn.mockeri.annotations.MockEntity;
import org.sindaryn.mockeri.generator.EntityMocker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DatabasePopulator {
    @Value(value="${mockeri.quantity.min:20}")
    private String minQuantity;
    @Value(value="${mockeri.quantity.max:50}")
    private String maxQuantity;
    @Autowired
    private ReflectionCache reflectionCache;
    @Autowired
    private EntityMocker entityMocker;

    @PostConstruct
    private void populateDatabase() {
        if (DatabasePopulator.isDummyPopulateMode()) {
            int min = new Integer(this.minQuantity);
            int max = new Integer(this.maxQuantity);
            for (Map.Entry entry : this.reflectionCache.getEntitiesCache().entrySet()) {
                String name = (String)entry.getKey();
                CachedEntityType type = (CachedEntityType)entry.getValue();
                MockEntity mockEntityAnnotation = type.getClazz().getAnnotation(MockEntity.class);
                int actualQuantity = mockEntityAnnotation != null ? mockEntityAnnotation.quantity() : ThreadLocalRandom.current().nextInt(min, max);
                if (!DatabasePopulator.isPersistable(type)) continue;
                this.instantiateEntities(name, actualQuantity);
            }
        }
    }

    public static boolean isDummyPopulateMode() {
        return System.getenv("DUMMY_POPULATE") != null && System.getenv("DUMMY_POPULATE").equals("true");
    }

    public static boolean isPersistable(CachedEntityType type) {
        return DatabasePopulator.isPersistable(type.getClazz());
    }

    public static boolean isPersistable(Class<?> type) {
        boolean isMarkedForDirectApiExposure;
        boolean isAnnotatedAsWeakEntity = type.isAnnotationPresent(CompositeEntity.class);
        boolean bl = isMarkedForDirectApiExposure = type.isAnnotationPresent(GraphQLApiEntity.class) && type.getAnnotation(GraphQLApiEntity.class).exposeDirectly();
        if (isAnnotatedAsWeakEntity && isMarkedForDirectApiExposure) {
            throw new IllegalArgumentException("Make up your mind, you can't mark " + type.getSimpleName() + " entity as 'exposeDirectly = true' and then annotate it with '@CompositeEntity'!");
        }
        if (isAnnotatedAsWeakEntity) {
            return false;
        }
        return isMarkedForDirectApiExposure;
    }

    private void instantiateEntities(String name, int amountToAdd) {
        try {
            for (int i = 0; i < amountToAdd; ++i) {
                this.entityMocker.instantiateEntity(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

