/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.datafi.service;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.sindaryn.datafi.StaticUtils;
import org.sindaryn.datafi.persistence.GenericDao;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.datafi.service.DaoCollector;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseDataManager<T> {
    private Class<T> clazz;
    @Autowired
    protected ReflectionCache reflectionCache;
    private List<? extends GenericDao> daos;
    private Map<String, GenericDao> daoMap;
    @Autowired
    private DaoCollector daoCollector;

    public void setType(Class<T> type) {
        this.clazz = type;
    }

    @PostConstruct
    private void init() {
        this.daoMap = new HashMap<String, GenericDao>();
        this.daos = this.daoCollector.getDaos();
        this.daos.forEach(dao -> {
            String entityName = this.extractEntityName((GenericDao)dao);
            if (entityName != null) {
                this.daoMap.put(entityName, (GenericDao)dao);
            }
        });
    }

    private String extractEntityName(GenericDao dao) {
        int endIndex;
        Class[] interfaces = ((Advised)dao).getProxiedInterfaces();
        String daoName = "";
        for (Class interface_ : interfaces) {
            if (!interface_.getSimpleName().contains("Dao")) continue;
            daoName = interface_.getSimpleName();
            break;
        }
        return (endIndex = daoName.indexOf("Dao")) != -1 ? daoName.substring(0, endIndex) : null;
    }

    public List<T> findAll() {
        return this.findAll(this.clazz);
    }

    public List<T> findAll(Class<T> clazz) {
        return this.daoMap.get(clazz.getSimpleName()).findAll();
    }

    public List<T> findAll(Sort sort) {
        return this.daoMap.get(this.clazz.getSimpleName()).findAll(sort);
    }

    public List<T> findAll(Class<T> clazz, Sort sort) {
        return this.daoMap.get(clazz.getSimpleName()).findAll(sort);
    }

    public Page<T> findAll(Pageable pageable) {
        return this.daoMap.get(this.clazz.getSimpleName()).findAll(pageable);
    }

    public Page<T> findAll(Class<T> clazz, Pageable pageable) {
        return this.daoMap.get(clazz.getSimpleName()).findAll(pageable);
    }

    public List<T> findAllById(Iterable<?> iterable) {
        return this.daoMap.get(this.clazz.getSimpleName()).findAllById(iterable);
    }

    public List<T> findAllById(Class<T> clazz, Iterable<?> iterable) {
        return this.daoMap.get(clazz.getSimpleName()).findAllById(iterable);
    }

    public long count() {
        return this.daoMap.get(this.clazz.getSimpleName()).count();
    }

    public long count(Class<T> clazz) {
        return this.daoMap.get(clazz.getSimpleName()).count();
    }

    public void deleteById(Object id) {
        this.daoMap.get(this.clazz.getSimpleName()).deleteById(id);
    }

    public void deleteById(Class<T> clazz, Object id) {
        this.daoMap.get(clazz.getSimpleName()).deleteById(id);
    }

    public void delete(T t) {
        this.daoMap.get(t.getClass().getSimpleName()).delete(t);
    }

    public void deleteAll(Iterable<? extends T> iterable) {
        long size = StreamSupport.stream(iterable.spliterator(), false).count();
        if (size <= 0L) {
            return;
        }
        String clazzName = iterable.iterator().next().getClass().getSimpleName();
        this.daoMap.get(clazzName).deleteAll(iterable);
    }

    public void deleteAll() {
        this.daoMap.get(this.clazz.getSimpleName()).deleteAll();
    }

    public void deleteAll(Class<T> clazz) {
        this.daoMap.get(clazz.getSimpleName()).deleteAll();
    }

    public <S extends T> S save(S s) {
        return (S)this.daoMap.get(s.getClass().getSimpleName()).save(s);
    }

    public <S extends T> List<S> saveAll(Iterable<S> iterable) {
        long size = StreamSupport.stream(iterable.spliterator(), false).count();
        if (size <= 0L) {
            return new ArrayList();
        }
        String clazzName = iterable.iterator().next().getClass().getSimpleName();
        return this.daoMap.get(clazzName).saveAll(iterable);
    }

    public Optional<T> findById(Object id) {
        return this.daoMap.get(this.clazz.getSimpleName()).findById(id);
    }

    public Optional<T> findById(Class<T> clazz, Object id) {
        return this.daoMap.get(clazz.getSimpleName()).findById(id);
    }

    public boolean existsById(Object id) {
        return this.daoMap.get(this.clazz.getSimpleName()).existsById(id);
    }

    public boolean existsById(Class<T> clazz, Object id) {
        return this.daoMap.get(clazz.getSimpleName()).existsById(id);
    }

    public void flush() {
        this.daoMap.get(this.clazz.getSimpleName()).flush();
    }

    public void flush(Class<T> clazz) {
        this.daoMap.get(clazz.getSimpleName()).flush();
    }

    public <S extends T> S saveAndFlush(S s) {
        String clazzName = s.getClass().getSimpleName();
        return (S)this.daoMap.get(clazzName).saveAndFlush(s);
    }

    public void deleteInBatch(Iterable<T> iterable) {
        long size = StreamSupport.stream(iterable.spliterator(), false).count();
        if (size <= 0L) {
            return;
        }
        String clazzName = iterable.iterator().next().getClass().getSimpleName();
        this.daoMap.get(clazzName).deleteInBatch(iterable);
    }

    public void deleteAllInBatch() {
        this.daoMap.get(this.clazz.getSimpleName()).deleteAllInBatch();
    }

    public void deleteAllInBatch(Class<?> clazz) {
        this.daoMap.get(clazz.getSimpleName()).deleteAllInBatch();
    }

    public T getOne(Object id) {
        return (T)this.daoMap.get(this.clazz.getSimpleName()).getOne(id);
    }

    public T getOne(Class<T> clazz, Object id) {
        return (T)this.daoMap.get(clazz.getSimpleName()).getOne(id);
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        return Optional.empty();
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        String clazzName = example.getProbe().getClass().getSimpleName();
        return this.daoMap.get(clazzName).findAll(example);
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        String clazzName = example.getProbe().getClass().getSimpleName();
        return this.daoMap.get(clazzName).findAll(example, sort);
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        String clazzName = example.getProbe().getClass().getSimpleName();
        return this.daoMap.get(clazzName).findAll(example, pageable);
    }

    public <S extends T> long count(Example<S> example) {
        String clazzName = example.getProbe().getClass().getSimpleName();
        return this.daoMap.get(clazzName).count(example);
    }

    public <S extends T> boolean exists(Example<S> example) {
        String clazzName = example.getProbe().getClass().getSimpleName();
        return this.daoMap.get(clazzName).exists(example);
    }

    public List<T> getBy(String attributeName, Object attributeValue) {
        return this.getBy(this.clazz, attributeName, attributeValue);
    }

    public List<T> getBy(Class<T> clazz, String attributeName, Object attributeValue) {
        try {
            GenericDao dao = this.daoMap.get(clazz.getSimpleName());
            Class[] params = new Class[]{attributeValue.getClass()};
            String resolverName = "findBy" + StaticUtils.toPascalCase(attributeName);
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, dao);
            return (List)methodToInvoke.invoke((Object)dao, attributeValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<T> getByUnique(Class<T> clazz, String attributeName, Object attributeValue) {
        try {
            GenericDao dao = this.daoMap.get(clazz.getSimpleName());
            Class[] params = new Class[]{attributeValue.getClass()};
            String resolverName = "findBy" + StaticUtils.toPascalCase(attributeName);
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, dao);
            return (Optional)methodToInvoke.invoke((Object)dao, attributeValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> getAllBy(String attributeName, Object[] attributeValues) {
        return this.getAllBy(this.clazz, attributeName, attributeValues);
    }

    public List<T> getAllBy(Class<T> clazz, String attributeName, Object[] attributeValues) {
        try {
            GenericDao dao = this.daoMap.get(clazz.getSimpleName());
            Class[] params = new Class[]{List.class};
            String resolverName = "findAllBy" + StaticUtils.toPascalCase(attributeName) + "In";
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, dao);
            return (List)methodToInvoke.invoke((Object)dao, Arrays.asList(attributeValues));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<T> findOne(Specification<T> specification) {
        return this.daoMap.get(this.clazz.getSimpleName()).findOne(specification);
    }

    public Optional<T> findOne(Class<T> clazz, Specification<T> specification) {
        return this.daoMap.get(clazz.getSimpleName()).findOne(specification);
    }

    public List<T> findAll(Specification<T> specification) {
        return this.daoMap.get(this.clazz.getSimpleName()).findAll(specification);
    }

    public List<T> findAll(Class<T> clazz, Specification<T> specification) {
        return this.daoMap.get(clazz.getSimpleName()).findAll(specification);
    }

    public Page<T> findAll(Specification<T> specification, Pageable pageable) {
        return this.daoMap.get(this.clazz.getSimpleName()).findAll(specification, pageable);
    }

    public Page<T> findAll(Class<T> clazz, Specification<T> specification, Pageable pageable) {
        return this.daoMap.get(clazz.getSimpleName()).findAll(specification, pageable);
    }

    public List<T> findAll(Specification<T> specification, Sort sort) {
        return this.daoMap.get(this.clazz.getSimpleName()).findAll(specification, sort);
    }

    public List<T> findAll(Class<T> clazz, Specification<T> specification, Sort sort) {
        return this.daoMap.get(clazz.getSimpleName()).findAll(specification, sort);
    }

    public long count(Specification<T> specification) {
        return this.daoMap.get(this.clazz.getSimpleName()).count(specification);
    }

    public long count(Class<T> clazz, Specification<T> specification) {
        return this.daoMap.get(clazz.getSimpleName()).count(specification);
    }

    public List<T> selectByResolver(String resolverName, Object ... args) {
        return this.selectByResolver(this.clazz, resolverName, args);
    }

    public List<T> selectByResolver(Class<?> clazz, String resolverName, Object ... args) {
        try {
            GenericDao dao = this.daoMap.get(clazz.getSimpleName());
            Class[] params = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = args[i].getClass();
            }
            Method methodToInvoke = this.getMethodToInvoke(resolverName, params, dao);
            return (List)methodToInvoke.invoke((Object)dao, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T cascadedUpdate(T toUpdate, T source) {
        return (T)this.cascadedUpdateImpl(toUpdate, source);
    }

    public <HasTs> List<T> addNewToCollectionIn(HasTs toAddTo, String fieldName, List<T> toAdd) {
        String toAddName = toAdd.get(0).getClass().getSimpleName();
        GenericDao toAddDao = this.daoMap.get(toAddName);
        String toAddToName = toAddTo.getClass().getSimpleName();
        GenericDao toAddToDao = this.daoMap.get(toAddToName);
        if ((toAddTo = toAddToDao.findById(this.reflectionCache.getEntitiesCache().get(toAddToName).invokeGetter(toAddTo, "id")).orElse(null)) == null) {
            throw new IllegalArgumentException("Could not find an entity with the given id");
        }
        Method existingCollectionGetter = this.getMethodToInvoke("get" + StaticUtils.toPascalCase(fieldName), toAddTo);
        Collection existingCollection = (Collection)this.invoke(existingCollectionGetter, toAddTo, new Object[0]);
        existingCollection.addAll(toAdd);
        Method existingCollectionSetter = this.getMethodToInvoke("set" + StaticUtils.toPascalCase(fieldName), toAddTo);
        this.invoke(existingCollectionSetter, toAddTo, existingCollection);
        toAddToDao.save(toAddTo);
        toAddDao.saveAll(toAdd);
        return toAdd;
    }

    public <HasTs> List<T> attachExistingToCollectionIn(HasTs toAddTo, String fieldName, List<T> toAttach) {
        String toAddName = toAttach.get(0).getClass().getSimpleName();
        GenericDao toAddDao = this.daoMap.get(toAddName);
        String toAddToName = toAddTo.getClass().getSimpleName();
        GenericDao toAddToDao = this.daoMap.get(toAddToName);
        toAttach = toAddDao.findAllById(this.idList(toAttach));
        toAddTo = toAddToDao.findById(this.reflectionCache.getEntitiesCache().get(toAddToName).invokeGetter(toAddTo, "id")).orElse(null);
        if (toAddTo == null) {
            throw new IllegalArgumentException("Could not find an entity with the given id");
        }
        Method existingCollectionGetter = this.getMethodToInvoke("get" + StaticUtils.toPascalCase(fieldName), toAddTo);
        Collection existingCollection = (Collection)this.invoke(existingCollectionGetter, toAddTo, new Object[0]);
        existingCollection.addAll(toAttach);
        Method existingCollectionSetter = this.getMethodToInvoke("set" + StaticUtils.toPascalCase(fieldName), toAddTo);
        this.invoke(existingCollectionSetter, toAddTo, existingCollection);
        toAddToDao.save(toAddTo);
        return toAttach;
    }

    public List<T> cascadeUpdateCollection(Iterable<T> toUpdate, Iterable<T> updated) {
        GenericDao dao = this.daoMap.get(toUpdate.iterator().next().getClass().getSimpleName());
        Iterator<T> updatedEntitiesIterator = updated.iterator();
        Iterator<T> entitiesToUpdateIterator = toUpdate.iterator();
        while (updatedEntitiesIterator.hasNext() && entitiesToUpdateIterator.hasNext()) {
            T updatedEntity = updatedEntitiesIterator.next();
            T entityToUpdate = entitiesToUpdateIterator.next();
            this.cascadedUpdateImpl(entityToUpdate, updatedEntity);
        }
        return dao.saveAll(toUpdate);
    }

    private Object cascadedUpdateImpl(Object toUpdate, Object source) {
        Class<?> currentClazz = toUpdate.getClass();
        List<Field> fieldsToUpdate = this.reflectionCache.getEntitiesCache().get(currentClazz.getSimpleName()).getCascadeUpdatableFields();
        for (Field currentField : fieldsToUpdate) {
            try {
                currentField.setAccessible(true);
                Object sourceFieldValue = currentField.get(source);
                Object targetFieldValue = currentField.get(toUpdate);
                if (sourceFieldValue == null) continue;
                if (this.isForeignKey(currentField, toUpdate)) {
                    this.cascadedUpdateImpl(targetFieldValue, sourceFieldValue);
                    continue;
                }
                currentField.set(toUpdate, sourceFieldValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.daoMap.get(currentClazz.getSimpleName()).save(toUpdate);
    }

    private boolean isForeignKey(Field currentField, Object owner) {
        try {
            boolean isForeignKey;
            currentField.setAccessible(true);
            boolean bl = isForeignKey = currentField.isAnnotationPresent(OneToOne.class) || currentField.isAnnotationPresent(ManyToOne.class);
            if (isForeignKey) {
                if (currentField.get(owner) == null) {
                    currentField.set(owner, this.defaultInstanceOf(currentField.getType()));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object defaultInstanceOf(Class<?> type) {
        return this.reflectionCache.getEntitiesCache().get(type.getSimpleName()).getDefaultInstance();
    }

    private Method getMethodToInvoke(String resolverName, Object instance) {
        return this.getMethodToInvoke(resolverName, new Class[0], instance);
    }

    private Method getMethodToInvoke(String resolverName, Class<?>[] params, Object instance) {
        Method methodToInvoke = this.reflectionCache.getResolversCache().get(Maps.immutableEntry((Object)resolverName, params));
        if (methodToInvoke == null) {
            try {
                methodToInvoke = params.length > 0 ? instance.getClass().getMethod(resolverName, params) : instance.getClass().getMethod(resolverName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.reflectionCache.getResolversCache().put(Maps.immutableEntry((Object)resolverName, params), methodToInvoke);
        }
        return methodToInvoke;
    }

    private Object invoke(Method method, Object instance, Object ... args) {
        try {
            if (args.length > 0) {
                return method.invoke(instance, args);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> idList(Iterable<T> collection) {
        CachedEntityType entityType = this.reflectionCache.getEntitiesCache().get(collection.iterator().next().getClass().getSimpleName());
        ArrayList<Object> ids = new ArrayList<Object>();
        collection.forEach(item -> ids.add(entityType.invokeGetter(item, "id")));
        return ids;
    }

    public ReflectionCache getReflectionCache() {
        return this.reflectionCache;
    }
}

