/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.datafi.reflection;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.NonNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.sindaryn.datafi.annotations.MainClass;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ReflectionCache {
    private Reflections reflections;
    private Map<String, CachedEntityType> entitiesCache;
    private Map<Map.Entry<String, Class<?>[]>, Method> resolversCache;
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        this.reflections = new Reflections(this.getBasePackageName(), new Scanner[0]);
        this.entitiesCache = new HashMap<String, CachedEntityType>();
        this.resolversCache = new HashMap<Map.Entry<String, Class<?>[]>, Method>();
        Set<Class<?>> dataModelEntityTypes = this.getAnnotatedEntities();
        for (Class<?> currentType : dataModelEntityTypes) {
            if (!this.isPersistableEntity(currentType)) continue;
            this.entitiesCache.put(currentType.getSimpleName(), new CachedEntityType(currentType, ReflectionCache.getClassFields(currentType), this.getPublicMethodsOf(currentType)));
        }
    }

    private boolean isPersistableEntity(Class<?> currentType) {
        return currentType.isAnnotationPresent(Table.class) || currentType.isAnnotationPresent(Entity.class);
    }

    private Set<Class<?>> getAnnotatedEntities() {
        Set entities = this.reflections.getTypesAnnotatedWith(Entity.class);
        entities.addAll(this.reflections.getTypesAnnotatedWith(Table.class));
        entities = Sets.newHashSet((Iterable)entities);
        return entities;
    }

    private Collection<Method> getPublicMethodsOf(@NonNull Class<?> startClass) {
        if (startClass == null) {
            throw new NullPointerException("startClass is marked non-null but is null");
        }
        ArrayList currentClassMethods = Lists.newArrayList((Object[])startClass.getMethods());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            List parentClassFields = (List)this.getPublicMethodsOf(parentClass);
            currentClassMethods.addAll(parentClassFields);
        }
        return currentClassMethods;
    }

    public static Collection<Field> getClassFields(@NonNull Class<?> startClass) {
        if (startClass == null) {
            throw new NullPointerException("startClass is marked non-null but is null");
        }
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            List parentClassFields = (List)ReflectionCache.getClassFields(parentClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    private String getBasePackageName() {
        Map annotatedBeans = this.context.getBeansWithAnnotation(SpringBootApplication.class);
        if (annotatedBeans.isEmpty()) {
            annotatedBeans = this.context.getBeansWithAnnotation(MainClass.class);
        }
        if (annotatedBeans.isEmpty()) {
            throw new RuntimeException("Error building reflection cache: Main class must be annotated with either @SpringBootApplication or @MainClass");
        }
        String mainClassName = annotatedBeans.values().toArray()[0].getClass().getName();
        int lastDot = mainClassName.lastIndexOf(46);
        return mainClassName.substring(0, lastDot);
    }

    public Map<String, CachedEntityType> getEntitiesCache() {
        return this.entitiesCache;
    }

    public Map<Map.Entry<String, Class<?>[]>, Method> getResolversCache() {
        return this.resolversCache;
    }
}

