/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.datafi.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.sindaryn.datafi.annotations.WithResolver;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public class SqlQueryMethodParser {
    public static MethodSpec parseResolver(WithResolver resolver, TypeElement typeElement) {
        String prefix = SqlQueryMethodParser.prefix(resolver, typeElement);
        String whereClause = SqlQueryMethodParser.whereClause(resolver, typeElement);
        ParameterSpec[] args = SqlQueryMethodParser.args(resolver, typeElement);
        String orderByClause = resolver.orderBy();
        return MethodSpec.methodBuilder((String)resolver.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{prefix + whereClause + orderByClause}).build()).addParameters(Arrays.asList(args)).returns(SqlQueryMethodParser.returnType(resolver, typeElement)).build();
    }

    private static TypeName returnType(WithResolver resolver, TypeElement typeElement) {
        ParameterizedTypeName result;
        switch (resolver.type()) {
            case SELECT_BY: {
                result = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)typeElement)});
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)resolver.type()));
            }
        }
        return result;
    }

    private static ParameterSpec[] args(WithResolver resolver, TypeElement typeElement) {
        String[] args = resolver.args();
        ParameterSpec[] result = new ParameterSpec[args.length];
        Map<String, TypeName> fields = SqlQueryMethodParser.resolveFieldTypesOf(typeElement);
        for (int i = 0; i < args.length; ++i) {
            result[i] = ParameterSpec.builder((TypeName)fields.get(args[i]), (String)args[i], (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Param.class).addMember("value", "$S", new Object[]{args[i]}).build()).build();
        }
        return result;
    }

    private static Map<String, TypeName> resolveFieldTypesOf(TypeElement typeElement) {
        HashMap<String, TypeName> result = new HashMap<String, TypeName>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().isField()) continue;
            result.put(element.getSimpleName().toString(), ClassName.get((TypeMirror)element.asType()));
        }
        return result;
    }

    private static String prefix(WithResolver resolver, TypeElement typeElement) {
        String entityName = SqlQueryMethodParser.resolveEntityName(typeElement);
        String placeholder = entityName.substring(0, 1).toLowerCase();
        switch (resolver.type()) {
            case SELECT_BY: {
                return "SELECT " + placeholder + " FROM " + entityName + " " + placeholder + " ";
            }
        }
        return null;
    }

    private static String whereClause(WithResolver resolver, TypeElement typeElement) {
        String entityName = SqlQueryMethodParser.resolveEntityName(typeElement);
        String placeholder = entityName.substring(0, 1).toLowerCase();
        StringBuilder whereClause = new StringBuilder(resolver.where());
        String conditional = SqlQueryMethodParser.isPreDefinedConditional(whereClause);
        if (conditional != null) {
            whereClause = new StringBuilder("WHERE");
            String[] args = resolver.args();
            for (int i = 0; i < args.length; ++i) {
                whereClause.append(" ").append(placeholder).append(".").append(args[i]).append(" = :").append(args[i]);
                if (i + 1 == args.length) continue;
                whereClause.append(conditional);
            }
        } else if (!whereClause.toString().toLowerCase().matches("^\\s*where\\s+")) {
            whereClause = new StringBuilder("WHERE " + whereClause.toString());
        }
        return whereClause.toString();
    }

    private static String isPreDefinedConditional(StringBuilder whereClause) {
        switch (whereClause.toString()) {
            case "&&&": {
                return " AND";
            }
            case "|||": {
                return " OR";
            }
        }
        return null;
    }

    private static String resolveEntityName(TypeElement typeElement) {
        Entity entityAnnotation = typeElement.getAnnotation(Entity.class);
        Table tableAnnotation = typeElement.getAnnotation(Table.class);
        if (entityAnnotation != null && !entityAnnotation.name().equals("")) {
            return entityAnnotation.name();
        }
        if (tableAnnotation != null && !tableAnnotation.name().equals("")) {
            return tableAnnotation.name();
        }
        return typeElement.getSimpleName().toString();
    }
}

