/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.datafi.generator;

import com.google.common.collect.Sets;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.tools.Diagnostic;
import org.sindaryn.datafi.StaticUtils;
import org.sindaryn.datafi.annotations.GetAllBy;
import org.sindaryn.datafi.annotations.GetBy;
import org.sindaryn.datafi.annotations.GetByUnique;
import org.sindaryn.datafi.annotations.WithResolver;
import org.sindaryn.datafi.generator.SqlQueryMethodParser;
import org.sindaryn.datafi.persistence.GenericDao;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Repository;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class DataLayerAnnotationsProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        Set<? extends TypeElement> entities = this.getPersistableEntities(annotations, roundEnvironment);
        HashMap<TypeElement, List<VariableElement>> annotatedFieldsMap = new HashMap<TypeElement, List<VariableElement>>();
        HashMap<TypeElement, List<MethodSpec>> customResolversMap = new HashMap<TypeElement, List<MethodSpec>>();
        DataLayerAnnotationsProcessor.resolveCustomResolvers(entities, annotatedFieldsMap, customResolversMap);
        entities.forEach(entity -> this.generateDao((TypeElement)entity, (Map<TypeElement, List<VariableElement>>)annotatedFieldsMap, (Map<TypeElement, List<MethodSpec>>)customResolversMap));
        this.setComponentScan(entities);
        return false;
    }

    public static void resolveCustomResolvers(Set<? extends TypeElement> entities, Map<TypeElement, List<VariableElement>> annotatedFieldsMap, Map<TypeElement, List<MethodSpec>> customResolversMap) {
        for (TypeElement typeElement : entities) {
            List<VariableElement> annotatedFields = DataLayerAnnotationsProcessor.getAnnotatedFieldsOf(typeElement);
            WithResolver[] customResolvers = DataLayerAnnotationsProcessor.getResolvers(typeElement);
            if (customResolvers != null) {
                ArrayList<MethodSpec> customResolversImpl = new ArrayList<MethodSpec>();
                for (int i = 0; i < customResolvers.length; ++i) {
                    customResolversImpl.add(SqlQueryMethodParser.parseResolver(customResolvers[i], typeElement));
                }
                customResolversMap.put(typeElement, customResolversImpl);
            }
            if (annotatedFields.isEmpty()) continue;
            annotatedFieldsMap.put(typeElement, annotatedFields);
        }
    }

    private static WithResolver[] getResolvers(TypeElement entity) {
        WithResolver[] annotationsByType = (WithResolver[])entity.getAnnotationsByType(WithResolver.class);
        if (annotationsByType == null) {
            return null;
        }
        List<WithResolver> resolvers = Arrays.asList(annotationsByType);
        for (AnnotationMirror annotationMirror : entity.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().getAnnotation(WithResolver.class) == null) continue;
            resolvers.add(annotationMirror.getAnnotationType().getAnnotation(WithResolver.class));
        }
        return (WithResolver[])resolvers.toArray();
    }

    private void setComponentScan(Set<? extends TypeElement> entities) {
        if (!entities.isEmpty()) {
            String className = entities.iterator().next().getQualifiedName().toString();
            int lastdot = className.lastIndexOf(46);
            String basePackageName = className.substring(0, lastdot);
            String simpleClassName = "SindarynClasspathConfiguration";
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)simpleClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Configuration.class).addAnnotation(AnnotationSpec.builder(ComponentScan.class).addMember("basePackages", "{$S}", new Object[]{"org.sindaryn"}).build());
            StaticUtils.writeToJavaFile(simpleClassName, basePackageName, builder, this.processingEnv, "configuration source file");
        }
    }

    private void generateDao(TypeElement entity, Map<TypeElement, List<VariableElement>> annotatedFieldsMap, Map<TypeElement, List<MethodSpec>> customResolversMap) {
        String className = entity.getQualifiedName().toString();
        int lastDot = className.lastIndexOf(46);
        String packageName = className.substring(0, lastDot);
        String simpleClassName = className.substring(lastDot + 1);
        String repositoryName = simpleClassName + "Dao";
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)repositoryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Repository.class).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(GenericDao.class), (TypeName[])new TypeName[]{DataLayerAnnotationsProcessor.getIdType(entity, this.processingEnv), ClassName.get((TypeElement)entity)}));
        Collection annotatedFields = annotatedFieldsMap.get(entity);
        if (annotatedFields != null) {
            annotatedFields.forEach(annotatedField -> {
                if (annotatedField.getAnnotation(GetBy.class) != null) {
                    builder.addMethod(MethodSpec.methodBuilder((String)("findBy" + StaticUtils.toPascalCase(annotatedField.getSimpleName().toString()))).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(ClassName.get((TypeMirror)annotatedField.asType()), annotatedField.getSimpleName().toString(), new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)entity)})).build());
                }
                if (annotatedField.getAnnotation(GetAllBy.class) != null) {
                    builder.addMethod(MethodSpec.methodBuilder((String)("findAllBy" + StaticUtils.toPascalCase(annotatedField.getSimpleName().toString()) + "In")).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)annotatedField.asType())}), StaticUtils.toPlural(annotatedField.getSimpleName().toString()), new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)entity)})).build());
                }
                if (annotatedField.getAnnotation(GetByUnique.class) != null) {
                    if (annotatedField.getAnnotation(GetBy.class) != null) {
                        StaticUtils.logCompilationError(this.processingEnv, annotatedField, "@GetBy and @GetByUnique cannot by definition be used together");
                    } else if (annotatedField.getAnnotation(Column.class) == null || !annotatedField.getAnnotation(Column.class).unique()) {
                        StaticUtils.logCompilationError(this.processingEnv, annotatedField, "In order to use @GetByUnique on a field, annotate the field as @Column(unique = true)");
                    } else {
                        builder.addMethod(MethodSpec.methodBuilder((String)("findBy" + StaticUtils.toPascalCase(annotatedField.getSimpleName().toString()))).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(ClassName.get((TypeMirror)annotatedField.asType()), annotatedField.getSimpleName().toString(), new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)entity)})).build());
                    }
                }
            });
        }
        if (customResolversMap.get(entity) != null) {
            customResolversMap.get(entity).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        }
        StaticUtils.writeToJavaFile(entity.getSimpleName().toString(), packageName, builder, this.processingEnv, "JpaRepository");
    }

    public static ClassName getIdType(TypeElement entity, ProcessingEnvironment processingEnv) {
        for (Element element : entity.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || element.getAnnotation(Id.class) == null && element.getAnnotation(EmbeddedId.class) == null) continue;
            return (ClassName)ClassName.get((TypeMirror)element.asType());
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No id type found for entity " + entity.getSimpleName().toString(), entity);
        return null;
    }

    public static List<VariableElement> getAnnotatedFieldsOf(TypeElement entity) {
        ArrayList<VariableElement> annotatedFields = new ArrayList<VariableElement>();
        List<? extends Element> enclosedElements = entity.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (!DataLayerAnnotationsProcessor.isAnnotatedField(element)) continue;
            annotatedFields.add((VariableElement)element);
        }
        return annotatedFields;
    }

    private static boolean isAnnotatedField(Element enclosedElement) {
        return enclosedElement.getKind() == ElementKind.FIELD && (enclosedElement.getAnnotation(GetBy.class) != null || enclosedElement.getAnnotation(GetAllBy.class) != null) || enclosedElement.getAnnotation(GetByUnique.class) != null;
    }

    private Set<? extends TypeElement> getPersistableEntities(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        HashSet<Element> entities = new HashSet<Element>();
        entities.addAll(roundEnvironment.getElementsAnnotatedWith(Entity.class));
        entities.addAll(roundEnvironment.getElementsAnnotatedWith(Table.class));
        return Sets.newHashSet(entities);
    }

    private Collection<? extends TypeElement> getAnnotatedElements(RoundEnvironment roundEnvironment, TypeElement annotationType) {
        Set<? extends Element> result = roundEnvironment.getElementsAnnotatedWith(annotationType);
        result.removeIf(element -> element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE));
        return result;
    }
}

