/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.apifi.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import graphql.execution.batched.Batched;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLQuery;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import lombok.NonNull;
import org.sindaryn.apifi.StaticUtils;
import org.sindaryn.apifi.security.SecurityAnnotationsHandler;
import org.sindaryn.apifi.service.ApiLogic;
import org.sindaryn.datafi.annotations.WithResolver;
import org.sindaryn.datafi.generator.DataLayerAnnotationsProcessor;

public class MethodSpecs {
    @NonNull
    private ProcessingEnvironment processingEnvironment;
    @NonNull
    private SecurityAnnotationsHandler securityAnnotationsHandler;
    private static final String CREATE = "Create";
    private static final String READ = "Read";
    private static final String UPDATE = "Update";
    private static final String DELETE = "Delete";

    public MethodSpec generateGetAllEndpoint(TypeElement entity) {
        String queryName = "all" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(TypeName.INT, "limit", new Modifier[0]).addParameter(TypeName.INT, "offset", new Modifier[0]).addStatement("return $T.getAll($T.class, $L, $L, limit, offset)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, READ);
        return builder.build();
    }

    public MethodSpec generateGetByIdEndpoint(TypeElement entity) {
        String queryName = "get" + StaticUtils.pascalCaseNameOf(entity) + "ById";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter((TypeName)DataLayerAnnotationsProcessor.getIdType((TypeElement)entity, (ProcessingEnvironment)this.processingEnvironment), "input", new Modifier[0]).addStatement("return $T.getById($T.class, $L, $L, input)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, entity, READ);
        return builder.build();
    }

    public MethodSpec generateGetByUniqueEndpoint(TypeElement entity, VariableElement field) {
        String queryName = "get" + StaticUtils.pascalCaseNameOf(entity) + "ByUnique" + StaticUtils.pascalCaseNameOf(field);
        String fieldName = field.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(ClassName.get((TypeMirror)field.asType()), fieldName, new Modifier[0]).addStatement("return $T.getByUnique($T.class, $L, $L, $S, $L)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity), queryName, fieldName}).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, field, READ);
        return builder.build();
    }

    public MethodSpec generateGetByEndpoint(TypeElement entity, VariableElement field) {
        String queryName = "get" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity)) + "By" + StaticUtils.pascalCaseNameOf(field);
        String fieldName = field.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(ClassName.get((TypeMirror)field.asType()), fieldName, new Modifier[0]).addStatement("return $T.getBy($T.class, $L, $L, $S, $L)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity), field.getSimpleName(), fieldName}).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, field, READ);
        return builder.build();
    }

    public MethodSpec generateGetByAllEndpoint(TypeElement entity, VariableElement field) {
        String queryName = "getAll" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity)) + "By" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(field));
        String fieldName = field.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(StaticUtils.listOf(field), org.sindaryn.datafi.StaticUtils.toPlural((String)fieldName), new Modifier[0]).addStatement("return $T.getAllBy($T.class, $L, $L, $S, $L)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity), fieldName, org.sindaryn.datafi.StaticUtils.toPlural((String)fieldName)}).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, field, READ);
        return builder.build();
    }

    public MethodSpec generateCustomResolverEndpoint(TypeElement entity, WithResolver resolver) {
        String queryName = resolver.name();
        Map<String, TypeName> fieldTypes = this.mapFieldTypes(entity);
        String resolverParams = this.resolverParams(resolver);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build());
        for (String arg : resolver.args()) {
            builder.addParameter(fieldTypes.get(arg), arg, new Modifier[0]);
        }
        StaticUtils.argsToResolver(resolverParams, builder);
        builder.addStatement("return $T.selectBy($T.class, $L, $L, $S, args)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity), resolver.name()}).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, READ);
        return builder.build();
    }

    public MethodSpec generateAddEndpoint(TypeElement entity) {
        String mutationName = "add" + StaticUtils.pascalCaseNameOf(entity);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.parameterizeType(entity)).addStatement("$T entity = $T.add($L, input, $L)", new Object[]{ClassName.get((TypeElement)entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).addStatement("return entity", new Object[0]).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, entity, CREATE);
        return builder.build();
    }

    public MethodSpec generateUpdateEndpoint(TypeElement entity) {
        String mutationName = "update" + StaticUtils.pascalCaseNameOf(entity);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.parameterizeType(entity)).addStatement("$T entity = $T.update($L, input, $L, $L)", new Object[]{ClassName.get((TypeElement)entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), "reflectionCache", StaticUtils.metaOpsName(entity)}).addStatement("return entity", new Object[0]).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, entity, UPDATE);
        return builder.build();
    }

    public MethodSpec generateArchiveEndpoint(TypeElement entity) {
        String mutationName = "archive" + StaticUtils.pascalCaseNameOf(entity);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.parameterizeType(entity)).addStatement("$T entity = $T.archive($L, input, $L, $L)", new Object[]{ClassName.get((TypeElement)entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), "reflectionCache", StaticUtils.metaOpsName(entity)}).addStatement("return entity", new Object[0]).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, entity, UPDATE);
        return builder.build();
    }

    public MethodSpec generateDeArchiveEndpoint(TypeElement entity) {
        String mutationName = "deArchive" + StaticUtils.pascalCaseNameOf(entity);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.parameterizeType(entity)).addStatement("$T entity = $T.deArchive($L, input, $L, $L)", new Object[]{ClassName.get((TypeElement)entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), "reflectionCache", StaticUtils.metaOpsName(entity)}).addStatement("return entity", new Object[0]).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, entity, UPDATE);
        return builder.build();
    }

    public MethodSpec generateDeleteEndpoint(TypeElement entity) {
        String mutationName = "delete" + StaticUtils.pascalCaseNameOf(entity);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.parameterizeType(entity)).addStatement("$T entity = $T.delete($L, $L, input, $L)", new Object[]{ClassName.get((TypeElement)entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), "reflectionCache", StaticUtils.metaOpsName(entity)}).addStatement("return entity", new Object[0]).returns(TypeName.get((TypeMirror)entity.asType()));
        this.handleSecurityAnnotations(builder, entity, DELETE);
        return builder.build();
    }

    public MethodSpec generateGetCollectionByIdEndpoint(TypeElement entity) {
        String queryName = "get" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity)) + "ById";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(ParameterSpec.builder((TypeName)StaticUtils.listOf(DataLayerAnnotationsProcessor.getIdType((TypeElement)entity, (ProcessingEnvironment)this.processingEnvironment)), (String)"input", (Modifier[])new Modifier[0]).build()).addStatement("return $T.getCollectionById($T.class, $L, input)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeElement)entity), StaticUtils.dataManagerName(entity)}).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, READ);
        return builder.build();
    }

    public MethodSpec generateAddCollectionEndpoint(TypeElement entity) {
        String mutationName = "add" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asParamList(entity, new Class[0])).addStatement("$L = $T.addCollection($L, input, $L)", new Object[]{StaticUtils.entitiesList(entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).addStatement("return entities", new Object[0]).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, CREATE);
        return builder.build();
    }

    public MethodSpec generateUpdateCollectionEndpoint(TypeElement entity) {
        String mutationName = "update" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asParamList(entity, new Class[0])).addStatement("$L = $T.updateCollection($L, input, $L)", new Object[]{StaticUtils.entitiesList(entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).addStatement("return entities", new Object[0]).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, UPDATE);
        return builder.build();
    }

    public MethodSpec generateArchiveCollectionEndpoint(TypeElement entity) {
        String mutationName = "archive" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asParamList(entity, new Class[0])).addStatement("$L = $T.archiveCollection($L, input, $L)", new Object[]{StaticUtils.entitiesList(entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).addStatement("return entities", new Object[0]).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, UPDATE);
        return builder.build();
    }

    public MethodSpec generateDeArchiveCollectionEndpoint(TypeElement entity) {
        String mutationName = "deArchive" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asParamList(entity, new Class[0])).addStatement("$L = $T.deArchiveCollection($L, input, $L)", new Object[]{StaticUtils.entitiesList(entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).addStatement("return entities", new Object[0]).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, UPDATE);
        return builder.build();
    }

    public MethodSpec generateDeleteCollectionEndpoint(TypeElement entity) {
        String mutationName = "delete" + org.sindaryn.datafi.StaticUtils.toPlural((String)StaticUtils.pascalCaseNameOf(entity));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asParamList(entity, new Class[0])).addStatement("$L = $T.deleteCollection($L, input, $L)", new Object[]{StaticUtils.entitiesList(entity), ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(entity), StaticUtils.metaOpsName(entity)}).addStatement("return entities", new Object[0]).returns(StaticUtils.listOf(entity));
        this.handleSecurityAnnotations(builder, entity, DELETE);
        return builder.build();
    }

    public MethodSpec generateGetAsEmbeddedEntity(VariableElement embedded, TypeElement owner) {
        String queryName = StaticUtils.camelcaseNameOf(embedded);
        ParameterSpec input = StaticUtils.asParamList(owner, GraphQLContext.class);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(StaticUtils.suppressDeprecationWarning()).addAnnotation(Batched.class).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(input).addStatement("return $T.getAsEmbeddedEntity($T.class, $L, input, $S, $L)", new Object[]{ClassName.get(ApiLogic.class), ClassName.get((TypeMirror)embedded.asType()), StaticUtils.dataManagerName(embedded), embedded.getSimpleName(), "reflectionCache"}).returns(StaticUtils.listOf(embedded));
        this.handleSecurityAnnotations(builder, embedded, READ);
        return builder.build();
    }

    public MethodSpec generateGetAsEmbeddedEntityCollection(VariableElement embedded, TypeElement owner) {
        String queryName = StaticUtils.camelcaseNameOf(embedded);
        ParameterSpec input = StaticUtils.asParamList(owner, GraphQLContext.class);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)queryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(StaticUtils.suppressDeprecationWarning()).addAnnotation(Batched.class).addAnnotation(AnnotationSpec.builder(GraphQLQuery.class).addMember("name", "$S", new Object[]{queryName}).build()).addParameter(input).addStatement("return $T.getAsEmbeddedCollection($T.class, $L, input, $S, $L)", new Object[]{ClassName.get(ApiLogic.class), StaticUtils.collectionTypeName(embedded), StaticUtils.dataManagerName(embedded), StaticUtils.camelcaseNameOf(embedded), "reflectionCache"}).returns((TypeName)StaticUtils.listOfLists(embedded));
        this.handleSecurityAnnotations(builder, embedded, READ);
        return builder.build();
    }

    public MethodSpec generateAddNewToEmbeddedCollection(VariableElement embedded, TypeElement owner) {
        String mutationName = "addNew" + StaticUtils.pascalCaseNameOf(embedded) + "To" + StaticUtils.pascalCaseNameOf(owner);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asEmbeddedCollectionParamList(embedded)).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)owner), (String)StaticUtils.camelcaseNameOf(owner), (Modifier[])new Modifier[0]).build()).addStatement("return $T.addNewToEmbeddedCollection($L, $L, $L, $S, input, $L, $L)", new Object[]{ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(owner), StaticUtils.dataManagerName(embedded), StaticUtils.camelcaseNameOf(owner), StaticUtils.camelcaseNameOf(embedded), StaticUtils.embeddedCollectionMetaOpsName(embedded), "reflectionCache"}).returns((TypeName)StaticUtils.listOfEmbedded(embedded));
        this.handleSecurityAnnotations(builder, embedded, CREATE);
        return builder.build();
    }

    public MethodSpec generateAttachExistingToEmbeddedCollection(VariableElement embedded, TypeElement owner) {
        String mutationName = "attachExisting" + StaticUtils.pascalCaseNameOf(embedded) + "To" + StaticUtils.pascalCaseNameOf(owner);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asEmbeddedCollectionParamList(embedded)).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)owner), (String)StaticUtils.camelcaseNameOf(owner), (Modifier[])new Modifier[0]).build()).addStatement("return $T.attachExistingToEmbeddedCollection($L, $L, $L, $S, input, $L, $L)", new Object[]{ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(owner), StaticUtils.dataManagerName(embedded), StaticUtils.camelcaseNameOf(owner), StaticUtils.camelcaseNameOf(embedded), StaticUtils.embeddedCollectionMetaOpsName(embedded), "reflectionCache"}).returns((TypeName)StaticUtils.listOfEmbedded(embedded));
        this.handleSecurityAnnotations(builder, embedded, UPDATE);
        return builder.build();
    }

    public MethodSpec generateUpdateEmbeddedCollection(VariableElement embedded, TypeElement owner) {
        String mutationName = "update" + StaticUtils.pascalCaseNameOf(embedded) + "In" + StaticUtils.pascalCaseNameOf(owner);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asEmbeddedCollectionParamList(embedded)).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)owner), (String)StaticUtils.camelcaseNameOf(owner), (Modifier[])new Modifier[0]).build()).addStatement("return $T.updateEmbeddedCollection($L, $L, $L, input, $L, $L)", new Object[]{ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(owner), StaticUtils.dataManagerName(embedded), StaticUtils.camelcaseNameOf(owner), StaticUtils.embeddedCollectionMetaOpsName(embedded), "reflectionCache"}).returns((TypeName)StaticUtils.listOfEmbedded(embedded));
        this.handleSecurityAnnotations(builder, embedded, UPDATE);
        return builder.build();
    }

    public MethodSpec generateRemoveFromEmbeddedCollection(VariableElement embedded, TypeElement owner) {
        String mutationName = "remove" + StaticUtils.pascalCaseNameOf(embedded) + "From" + StaticUtils.pascalCaseNameOf(owner);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)mutationName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(GraphQLMutation.class).addMember("name", "$S", new Object[]{mutationName}).build()).addParameter(StaticUtils.asEmbeddedCollectionParamList(embedded)).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)owner), (String)StaticUtils.camelcaseNameOf(owner), (Modifier[])new Modifier[0]).build()).addStatement("return $T.removeFromEmbeddedCollection($L, $L, $L, $S, input, $L, $L)", new Object[]{ClassName.get(ApiLogic.class), StaticUtils.dataManagerName(owner), StaticUtils.dataManagerName(embedded), StaticUtils.camelcaseNameOf(owner), StaticUtils.camelcaseNameOf(embedded), StaticUtils.embeddedCollectionMetaOpsName(embedded), "reflectionCache"}).returns((TypeName)StaticUtils.listOfEmbedded(embedded));
        this.handleSecurityAnnotations(builder, embedded, DELETE);
        return builder.build();
    }

    private void handleSecurityAnnotations(MethodSpec.Builder builder, Element element, String operation) {
        ArrayList<Class<? extends Annotation>> alreadyAssigned;
        List<Object> assignedCRUDSecurityAnnotations;
        Map.Entry<List<AnnotationSpec>, List<Class<? extends Annotation>>> entry = this.securityAnnotationsHandler.handleCRUD(element, new ArrayList<Class<? extends Annotation>>());
        List<Object> operationSpecificSecurityAnnotations = new ArrayList();
        if (element instanceof TypeElement) {
            assignedCRUDSecurityAnnotations = new ArrayList();
            alreadyAssigned = new ArrayList();
        } else {
            assignedCRUDSecurityAnnotations = entry.getKey();
            alreadyAssigned = entry.getValue();
        }
        switch (operation) {
            case "Create": {
                operationSpecificSecurityAnnotations = this.securityAnnotationsHandler.handleCreate(element, alreadyAssigned).getKey();
                break;
            }
            case "Read": {
                operationSpecificSecurityAnnotations = this.securityAnnotationsHandler.handleRead(element, alreadyAssigned).getKey();
                break;
            }
            case "Update": {
                operationSpecificSecurityAnnotations = this.securityAnnotationsHandler.handleUpdate(element, alreadyAssigned).getKey();
                break;
            }
            case "Delete": {
                operationSpecificSecurityAnnotations = this.securityAnnotationsHandler.handleDelete(element, alreadyAssigned).getKey();
            }
        }
        if (!assignedCRUDSecurityAnnotations.isEmpty()) {
            builder.addAnnotations(assignedCRUDSecurityAnnotations);
        }
        if (!operationSpecificSecurityAnnotations.isEmpty()) {
            builder.addAnnotations(operationSpecificSecurityAnnotations);
        }
    }

    private String resolverParams(WithResolver resolverAnnotation) {
        StringBuilder format = new StringBuilder("");
        String[] args = resolverAnnotation.args();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            format.append(arg);
            format.append(i + 1 >= args.length ? "" : ", ");
        }
        return format.toString();
    }

    private Map<String, TypeName> mapFieldTypes(TypeElement entity) {
        HashMap<String, TypeName> mapFieldTypes = new HashMap<String, TypeName>();
        for (VariableElement field : StaticUtils.getFields(entity)) {
            mapFieldTypes.put(field.getSimpleName().toString(), ClassName.get((TypeMirror)field.asType()));
        }
        return mapFieldTypes;
    }

    public MethodSpecs(@NonNull ProcessingEnvironment processingEnvironment, @NonNull SecurityAnnotationsHandler securityAnnotationsHandler) {
        if (processingEnvironment == null) {
            throw new NullPointerException("processingEnvironment is marked non-null but is null");
        }
        if (securityAnnotationsHandler == null) {
            throw new NullPointerException("securityAnnotationsHandler is marked non-null but is null");
        }
        this.processingEnvironment = processingEnvironment;
        this.securityAnnotationsHandler = securityAnnotationsHandler;
    }
}

