/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.apifi.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import lombok.NonNull;
import org.sindaryn.apifi.StaticUtils;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;
import org.sindaryn.apifi.annotations.MetaOperations;
import org.sindaryn.apifi.generator.EntitiesInfoCache;
import org.sindaryn.apifi.service.EmbeddedCollectionMetaOperations;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.datafi.service.ArchivableDataManager;
import org.sindaryn.datafi.service.DataManager;
import org.springframework.beans.factory.annotation.Autowired;

public class FieldSpecs {
    @NonNull
    private ProcessingEnvironment processingEnv;
    @NonNull
    private EntitiesInfoCache entitiesInfoCache;

    public FieldSpec reflectionCache() {
        return FieldSpec.builder(ReflectionCache.class, (String)"reflectionCache", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Autowired.class).build();
    }

    public FieldSpec dataManager(TypeElement entity) {
        Class clazz = StaticUtils.isArchivable(entity, this.processingEnv) ? ArchivableDataManager.class : DataManager.class;
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(clazz), (TypeName[])new TypeName[]{ClassName.get((TypeElement)entity)}), (String)(StaticUtils.camelcaseNameOf(entity) + "DataManager"), (Modifier[])new Modifier[0]).addAnnotation(Autowired.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    public FieldSpec dataManager(TypeMirror entityType, String prefix) {
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DataManager.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)entityType)}), (String)(prefix + org.sindaryn.datafi.StaticUtils.toPascalCase((String)DataManager.class.getSimpleName())), (Modifier[])new Modifier[0]).addAnnotation(Autowired.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    public FieldSpec metaOps(GraphQLApiEntity apiEntityAnnotation, TypeElement entity) {
        TypeElement metaOps = this.apiMetaOpsClazz(apiEntityAnnotation);
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)metaOps), (TypeName[])new TypeName[]{ClassName.get((TypeElement)entity)}), (String)StaticUtils.metaOpsName(entity), (Modifier[])new Modifier[0]).addAnnotation(Autowired.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private TypeElement apiMetaOpsClazz(GraphQLApiEntity apiEntity) {
        try {
            apiEntity.apiMetaOperations();
        }
        catch (MirroredTypeException mte) {
            Types TypeUtils = this.processingEnv.getTypeUtils();
            return (TypeElement)TypeUtils.asElement(mte.getTypeMirror());
        }
        return null;
    }

    public FieldSpec embeddedCollectionMetaOps(VariableElement field) {
        TypeElement metaOps = null;
        ParameterizedTypeName metaOpsType = null;
        MetaOperations metaOperations = field.getAnnotation(MetaOperations.class);
        if (metaOperations != null) {
            try {
                metaOperations.metaOps();
            }
            catch (MirroredTypeException mte) {
                Types TypeUtils = this.processingEnv.getTypeUtils();
                metaOps = (TypeElement)TypeUtils.asElement(mte.getTypeMirror());
                metaOpsType = ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)metaOps), (TypeName[])new TypeName[0]);
            }
        } else {
            TypeElement typeElement = this.entitiesInfoCache.getTypeElementMap().get(this.entitiesInfoCache.getCollectionType(field));
            metaOpsType = ParameterizedTypeName.get((ClassName)ClassName.get(EmbeddedCollectionMetaOperations.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)typeElement), ClassName.get((TypeElement)((TypeElement)field.getEnclosingElement()))});
        }
        return FieldSpec.builder((TypeName)metaOpsType, (String)(StaticUtils.camelcaseNameOf(field) + EmbeddedCollectionMetaOperations.class.getSimpleName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Autowired.class).build();
    }

    public FieldSpecs(@NonNull ProcessingEnvironment processingEnv, @NonNull EntitiesInfoCache entitiesInfoCache) {
        if (processingEnv == null) {
            throw new NullPointerException("processingEnv is marked non-null but is null");
        }
        if (entitiesInfoCache == null) {
            throw new NullPointerException("entitiesInfoCache is marked non-null but is null");
        }
        this.processingEnv = processingEnv;
        this.entitiesInfoCache = entitiesInfoCache;
    }
}

