/*
 * Decompiled with CFR 0.152.
 */
package com.xiaofeng.flowlayoutmanager.cache;

import android.graphics.Point;
import android.util.SparseArray;
import com.xiaofeng.flowlayoutmanager.cache.Line;

public class CacheHelper {
    public static final int NOT_FOUND = -1;
    final int itemPerLine;
    int contentAreaWidth;
    SparseArray<Point> sizeMap;
    SparseArray<Line> lineMap;
    boolean batchSetting = false;

    public CacheHelper(int itemsPerLine, int contentAreaWidth) {
        this.itemPerLine = itemsPerLine;
        this.contentAreaWidth = contentAreaWidth;
        this.sizeMap = new SparseArray();
        this.lineMap = new SparseArray();
    }

    public void add(int startIndex, Point ... sizes) {
        if (!this.valid()) {
            return;
        }
        this.invalidateLineMapAfter(startIndex);
        this.makeSpace(startIndex, sizes.length);
        int index = startIndex;
        for (Point size : sizes) {
            this.sizeMap.put(index++, (Object)size);
        }
        this.refreshLineMap();
    }

    public void add(int startIndex, int count) {
        if (!this.valid()) {
            return;
        }
        this.invalidateLineMapAfter(startIndex);
        this.makeSpace(startIndex, count);
        this.refreshLineMap();
    }

    public void invalidSizes(int index, int count) {
        if (!this.valid()) {
            return;
        }
        this.invalidateLineMapAfter(index);
        int actualCount = this.actualCount(index, count);
        for (int i = 0; i < actualCount; ++i) {
            this.sizeMap.remove(index + i);
        }
        this.refreshLineMap();
    }

    public void remove(int index, int count) {
        int i;
        if (!this.valid()) {
            return;
        }
        this.invalidateLineMapAfter(index);
        int actualCount = this.actualCount(index, count);
        for (i = 0; i < actualCount; ++i) {
            this.sizeMap.remove(index + i);
        }
        for (i = index + actualCount; i < this.sizeMap.size() + actualCount; ++i) {
            Point tmp = (Point)this.sizeMap.get(i);
            this.sizeMap.remove(i);
            this.sizeMap.put(i - actualCount, (Object)tmp);
        }
        this.refreshLineMap();
    }

    public void setItem(int index, Point newSize) {
        if (!this.valid()) {
            return;
        }
        if (this.sizeMap.get(index, null) != null) {
            Point cachedPoint = (Point)this.sizeMap.get(index);
            if (!cachedPoint.equals((Object)newSize)) {
                this.invalidateLineMapAfter(index);
                this.sizeMap.put(index, (Object)newSize);
                this.refreshLineMap();
            }
        } else {
            this.invalidateLineMapAfter(index);
            this.sizeMap.put(index, (Object)newSize);
            this.refreshLineMap();
        }
    }

    public void move(int from, int to, int count) {
        if (!this.valid()) {
            return;
        }
        this.invalidateLineMapAfter(Math.min(from, to));
        Point[] itemsToMove = new Point[count];
        for (int i = from; i < from + count; ++i) {
            itemsToMove[i - from] = (Point)this.sizeMap.get(i);
        }
        boolean movingForward = from - to > 0;
        int itemsToShift = Math.abs(from - to);
        if (!movingForward) {
            itemsToShift -= count;
        }
        int shiftIndex = movingForward ? from - 1 : from + count;
        int shiftIndexStep = movingForward ? -1 : 1;
        for (int shifted = 0; shifted < itemsToShift; ++shifted) {
            this.sizeMap.put(shiftIndex - shiftIndexStep * count, this.sizeMap.get(shiftIndex));
            shiftIndex += shiftIndexStep;
        }
        int setIndex = to;
        if (!movingForward) {
            setIndex = from + itemsToShift;
        }
        for (Point item : itemsToMove) {
            this.sizeMap.put(setIndex++, (Object)item);
        }
        this.refreshLineMap();
    }

    public int[] getLineMap() {
        if (!this.valid()) {
            return new int[0];
        }
        int[] lineCounts = new int[this.lineMap.size()];
        for (int i = 0; i < this.lineMap.size(); ++i) {
            lineCounts[i] = ((Line)this.lineMap.get((int)i)).itemCount;
        }
        return lineCounts;
    }

    public int itemLineIndex(int itemIndex) {
        if (!this.valid()) {
            return -1;
        }
        int itemCount = 0;
        for (int i = 0; i < this.lineMap.size(); ++i) {
            if ((itemCount += ((Line)this.lineMap.get((int)i)).itemCount) < itemIndex + 1) continue;
            return i;
        }
        return -1;
    }

    public Line containingLine(int itemIndex) {
        if (!this.valid()) {
            return null;
        }
        return this.getLine(this.itemLineIndex(itemIndex));
    }

    public int firstItemIndex(int lineIndex) {
        if (!this.valid()) {
            return -1;
        }
        int itemCount = 0;
        for (int i = 0; i < lineIndex; ++i) {
            itemCount += ((Line)this.lineMap.get((int)i)).itemCount;
        }
        return itemCount;
    }

    public Line getLine(int lineIndex) {
        if (!this.valid()) {
            return null;
        }
        return (Line)this.lineMap.get(lineIndex, null);
    }

    public boolean hasPreviousLineCached(int itemIndex) {
        if (!this.valid()) {
            return false;
        }
        int lineIndex = this.itemLineIndex(itemIndex);
        if (lineIndex == -1) {
            return false;
        }
        return lineIndex > 0;
    }

    public boolean hasNextLineCached(int itemIndex) {
        if (!this.valid()) {
            return false;
        }
        int lineIndex = this.itemLineIndex(itemIndex);
        if (lineIndex == -1) {
            return false;
        }
        return !((Line)this.lineMap.get(lineIndex + 1, (Object)Line.EMPTY_LINE)).equals(Line.EMPTY_LINE);
    }

    public void clear() {
        this.sizeMap.clear();
        this.lineMap.clear();
    }

    public void contentAreaWidth(int width) {
        this.contentAreaWidth = width;
        this.lineMap.clear();
        this.refreshLineMap();
    }

    public int contentAreaWidth() {
        return this.contentAreaWidth;
    }

    public boolean valid() {
        return this.contentAreaWidth > 0;
    }

    public void startBatchSetting() {
        this.batchSetting = true;
    }

    public void endBatchSetting() {
        this.batchSetting = false;
        this.lineMap.clear();
        this.refreshLineMap();
    }

    private void makeSpace(int startIndex, int count) {
        int i;
        for (i = this.sizeMap.size() - 1; i >= startIndex; --i) {
            this.sizeMap.put(i + count, this.sizeMap.get(i));
        }
        for (i = startIndex; i < startIndex + count; ++i) {
            this.sizeMap.remove(i);
        }
    }

    private void refreshLineMap() {
        if (!this.valid() || this.batchSetting) {
            return;
        }
        int index = this.refreshLineMapStartIndex();
        Point cachedSize = (Point)this.sizeMap.get(index, null);
        int lineIndex = this.lineMap.size();
        int lineItemCount = 0;
        Line currentLine = this.containingLine(index);
        if (currentLine == null) {
            currentLine = new Line();
        } else {
            lineIndex = this.itemLineIndex(index);
        }
        int lineWidth = currentLine.totalWidth;
        while (cachedSize != null) {
            ++lineItemCount;
            if ((lineWidth += cachedSize.x) <= this.contentAreaWidth) {
                if (this.itemPerLine > 0) {
                    if (lineItemCount > this.itemPerLine) {
                        this.lineMap.put(lineIndex, (Object)currentLine);
                        currentLine = new Line();
                        this.addToLine(currentLine, cachedSize, index);
                        ++lineIndex;
                        lineWidth = cachedSize.x;
                        lineItemCount = 1;
                    } else {
                        this.addToLine(currentLine, cachedSize, index);
                    }
                } else {
                    this.addToLine(currentLine, cachedSize, index);
                }
            } else {
                this.lineMap.put(lineIndex, (Object)currentLine);
                currentLine = new Line();
                this.addToLine(currentLine, cachedSize, index);
                ++lineIndex;
                lineWidth = cachedSize.x;
                lineItemCount = 1;
            }
            cachedSize = (Point)this.sizeMap.get(++index, null);
        }
        if (currentLine.itemCount > 0) {
            this.lineMap.append(lineIndex, (Object)currentLine);
        }
    }

    private void addToLine(Line line, Point item, int index) {
        ++line.itemCount;
        line.totalWidth += item.x;
        int n = line.maxHeight = item.y > line.maxHeight ? item.y : line.maxHeight;
        if (item.y == line.maxHeight) {
            line.maxHeightIndex = index;
        }
    }

    private int actualCount(int index, int count) {
        return index + count > this.sizeMap.size() ? this.sizeMap.size() - index : count;
    }

    private void invalidateLineMapAfter(int itemIndex) {
        if (this.batchSetting) {
            return;
        }
        int itemLineIndex = this.itemLineIndex(itemIndex);
        Line line = (Line)this.lineMap.get(itemLineIndex, null);
        if (line == null && this.lineMap.size() > 0) {
            this.lineMap.remove(this.lineMap.size() - 1);
        }
        while (line != null) {
            this.lineMap.remove(itemLineIndex);
            line = (Line)this.lineMap.get(++itemLineIndex, null);
        }
    }

    private int refreshLineMapStartIndex() {
        int itemCount = 0;
        for (int i = 0; i < this.lineMap.size(); ++i) {
            itemCount += ((Line)this.lineMap.get((int)i)).itemCount;
        }
        if (itemCount >= this.sizeMap.size()) {
            return -1;
        }
        return itemCount;
    }
}

