/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public abstract class AbstractRowsEventDataDeserializer<T extends EventData>
implements EventDataDeserializer<T> {
    private static final int DIG_PER_DEC = 9;
    private static final int[] DIG_TO_BYTES = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};
    private final Map<Long, TableMapEventData> tableMapEventByTableId;

    public AbstractRowsEventDataDeserializer(Map<Long, TableMapEventData> tableMapEventByTableId) {
        this.tableMapEventByTableId = tableMapEventByTableId;
    }

    protected Serializable[] deserializeRow(long tableId, BitSet includedColumns, ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData tableMapEvent = this.tableMapEventByTableId.get(tableId);
        byte[] types = tableMapEvent.getColumnTypes();
        int[] metadata = tableMapEvent.getColumnMetadata();
        Serializable[] result = new Serializable[AbstractRowsEventDataDeserializer.numberOfBitsSet(includedColumns)];
        BitSet nullColumns = inputStream.readBitSet(result.length, true);
        int numberOfSkippedColumns = 0;
        for (int i = 0; i < types.length; ++i) {
            int typeCode = types[i] & 0xFF;
            int meta = metadata[i];
            int length = 0;
            if (typeCode == ColumnType.STRING.getCode() && meta > 256) {
                int meta0 = meta >> 8;
                int meta1 = meta & 0xFF;
                if ((meta0 & 0x30) != 48) {
                    typeCode = meta0 | 0x30;
                    length = meta1 | (meta0 & 0x30 ^ 0x30) << 4;
                } else if (meta0 == ColumnType.SET.getCode() || meta0 == ColumnType.ENUM.getCode() || meta0 == ColumnType.STRING.getCode()) {
                    typeCode = meta0;
                    length = meta1;
                } else {
                    throw new IOException("Unexpected meta " + meta + " for column of type " + typeCode);
                }
            }
            if (!includedColumns.get(i)) {
                ++numberOfSkippedColumns;
                continue;
            }
            int index = i - numberOfSkippedColumns;
            if (nullColumns.get(index)) continue;
            result[index] = this.deserializeCell(ColumnType.byCode(typeCode), meta, length, inputStream);
        }
        return result;
    }

    private Serializable deserializeCell(ColumnType type, int meta, int length, ByteArrayInputStream inputStream) throws IOException {
        switch (type) {
            case BIT: {
                int bitSetLength = (meta >> 8) * 8 + (meta & 0xFF);
                return inputStream.readBitSet(bitSetLength, false);
            }
            case TINY: {
                return Integer.valueOf((byte)inputStream.readInteger(1));
            }
            case SHORT: {
                return Integer.valueOf((short)inputStream.readInteger(2));
            }
            case INT24: {
                return Integer.valueOf(inputStream.readInteger(3) << 8 >> 8);
            }
            case LONG: {
                return Integer.valueOf(inputStream.readInteger(4));
            }
            case LONGLONG: {
                return Long.valueOf(inputStream.readLong(8));
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(inputStream.readInteger(4)));
            }
            case DOUBLE: {
                return Double.valueOf(Double.longBitsToDouble(inputStream.readLong(8)));
            }
            case NEWDECIMAL: {
                int precision = meta & 0xFF;
                int scale = meta >> 8;
                int decimalLength = AbstractRowsEventDataDeserializer.determineDecimalLength(precision, scale);
                return AbstractRowsEventDataDeserializer.toDecimal(precision, scale, inputStream.read(decimalLength));
            }
            case DATE: {
                return this.deserializeDate(inputStream);
            }
            case TIME: {
                return AbstractRowsEventDataDeserializer.deserializeTime(inputStream);
            }
            case TIME_V2: {
                return this.deserializeTimeV2(meta, inputStream);
            }
            case TIMESTAMP: {
                return this.deserializeTimestamp(inputStream);
            }
            case TIMESTAMP_V2: {
                return this.deserializeTimestampV2(meta, inputStream);
            }
            case DATETIME: {
                return this.deserializeDatetime(inputStream);
            }
            case DATETIME_V2: {
                return this.deserializeDatetimeV2(meta, inputStream);
            }
            case YEAR: {
                return Integer.valueOf(1900 + inputStream.readInteger(1));
            }
            case STRING: {
                int stringLength = length < 256 ? inputStream.readInteger(1) : inputStream.readInteger(2);
                return inputStream.readString(stringLength);
            }
            case VARCHAR: 
            case VAR_STRING: {
                int varcharLength = meta < 256 ? inputStream.readInteger(1) : inputStream.readInteger(2);
                return inputStream.readString(varcharLength);
            }
            case BLOB: {
                int blobLength = inputStream.readInteger(meta);
                return inputStream.read(blobLength);
            }
            case ENUM: {
                return Integer.valueOf(inputStream.readInteger(length));
            }
            case SET: {
                return Long.valueOf(inputStream.readLong(length));
            }
        }
        throw new IOException("Unsupported type " + (Object)((Object)type));
    }

    private java.sql.Date deserializeDate(ByteArrayInputStream inputStream) throws IOException {
        int value = inputStream.readInteger(3);
        int day = value % 32;
        int month = (value >>>= 5) % 16;
        int year = value >> 4;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    private static Time deserializeTime(ByteArrayInputStream inputStream) throws IOException {
        int value = inputStream.readInteger(3);
        int[] split = AbstractRowsEventDataDeserializer.split(value, 100, 3);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(11, split[2]);
        c.set(12, split[1]);
        c.set(13, split[0]);
        return new Time(c.getTimeInMillis());
    }

    private Time deserializeTimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long time = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(3), 0, 3);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(11, AbstractRowsEventDataDeserializer.extractBits(time, 2, 10, 24));
        c.set(12, AbstractRowsEventDataDeserializer.extractBits(time, 12, 6, 24));
        c.set(13, AbstractRowsEventDataDeserializer.extractBits(time, 18, 6, 24));
        c.set(14, this.getFractionalSeconds(meta, inputStream));
        return new Time(c.getTimeInMillis());
    }

    private Timestamp deserializeTimestamp(ByteArrayInputStream inputStream) throws IOException {
        long value = inputStream.readLong(4);
        return new Timestamp(value * 1000L);
    }

    private Timestamp deserializeTimestampV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long timestamp = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(4), 0, 4);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timestamp * 1000L);
        c.set(14, this.getFractionalSeconds(meta, inputStream));
        return new Timestamp(c.getTimeInMillis());
    }

    private Date deserializeDatetime(ByteArrayInputStream inputStream) throws IOException {
        long value = inputStream.readLong(8);
        int[] split = AbstractRowsEventDataDeserializer.split(value, 100, 6);
        Calendar c = Calendar.getInstance();
        c.set(1, split[5]);
        c.set(2, split[4] - 1);
        c.set(5, split[3]);
        c.set(11, split[2]);
        c.set(12, split[1]);
        c.set(13, split[0]);
        c.set(14, 0);
        return c.getTime();
    }

    private Date deserializeDatetimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long datetime = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(5), 0, 5);
        int yearMonth = AbstractRowsEventDataDeserializer.extractBits(datetime, 1, 17, 40);
        Calendar c = Calendar.getInstance();
        c.set(1, yearMonth / 13);
        c.set(2, yearMonth % 13 - 1);
        c.set(5, AbstractRowsEventDataDeserializer.extractBits(datetime, 18, 5, 40));
        c.set(11, AbstractRowsEventDataDeserializer.extractBits(datetime, 23, 5, 40));
        c.set(12, AbstractRowsEventDataDeserializer.extractBits(datetime, 28, 6, 40));
        c.set(13, AbstractRowsEventDataDeserializer.extractBits(datetime, 34, 6, 40));
        c.set(14, this.getFractionalSeconds(meta, inputStream));
        return c.getTime();
    }

    private int getFractionalSeconds(int meta, ByteArrayInputStream inputStream) throws IOException {
        int fractionalSecondsStorageSize = AbstractRowsEventDataDeserializer.getFractionalSecondsStorageSize(meta);
        if (fractionalSecondsStorageSize > 0) {
            long fractionalSeconds = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(meta), 0, meta);
            if (meta % 2 == 1) {
                fractionalSeconds /= 10L;
            }
            return (int)(fractionalSeconds / 1000L);
        }
        return 0;
    }

    private static int getFractionalSecondsStorageSize(int fsp) {
        switch (fsp) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: {
                return 3;
            }
        }
        return 0;
    }

    private static int extractBits(long value, int bitOffset, int numberOfBits, int payloadSize) {
        long result = value >> payloadSize - (bitOffset + numberOfBits);
        return (int)(result & (long)((1 << numberOfBits) - 1));
    }

    private static int numberOfBitsSet(BitSet bitSet) {
        int result = 0;
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            ++result;
            i = bitSet.nextSetBit(i + 1);
        }
        return result;
    }

    private static int[] split(long value, int divider, int length) {
        int[] result = new int[length];
        for (int i = 0; i < length - 1; ++i) {
            result[i] = (int)(value % (long)divider);
            value /= (long)divider;
        }
        result[length - 1] = (int)value;
        return result;
    }

    private static int determineDecimalLength(int precision, int scale) {
        int x = precision - scale;
        int ipDigits = x / 9;
        int fpDigits = scale / 9;
        int ipDigitsX = x - ipDigits * 9;
        int fpDigitsX = scale - fpDigits * 9;
        return (ipDigits << 2) + DIG_TO_BYTES[ipDigitsX] + (fpDigits << 2) + DIG_TO_BYTES[fpDigitsX];
    }

    private static BigDecimal toDecimal(int precision, int scale, byte[] value) {
        int i;
        BigDecimal ip;
        boolean positive = (value[0] & 0x80) == 128;
        value[0] = (byte)(value[0] ^ 0x80);
        if (!positive) {
            int i2 = 0;
            while (i2 < value.length) {
                int n = i2++;
                value[n] = (byte)(value[n] ^ 0xFF);
            }
        }
        int x = precision - scale;
        int ipDigits = x / 9;
        int ipDigitsX = x - ipDigits * 9;
        int ipSize = (ipDigits << 2) + DIG_TO_BYTES[ipDigitsX];
        int offset = DIG_TO_BYTES[ipDigitsX];
        BigDecimal bigDecimal = ip = offset > 0 ? BigDecimal.valueOf(AbstractRowsEventDataDeserializer.bigEndianInteger(value, 0, offset)) : BigDecimal.ZERO;
        while (offset < ipSize) {
            int i3 = AbstractRowsEventDataDeserializer.bigEndianInteger(value, offset, 4);
            ip = ip.movePointRight(9).add(BigDecimal.valueOf(i3));
            offset += 4;
        }
        int shift = 0;
        BigDecimal fp = BigDecimal.ZERO;
        while (shift + 9 <= scale) {
            i = AbstractRowsEventDataDeserializer.bigEndianInteger(value, offset, 4);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(shift + 9));
            shift += 9;
            offset += 4;
        }
        if (shift < scale) {
            i = AbstractRowsEventDataDeserializer.bigEndianInteger(value, offset, DIG_TO_BYTES[scale - shift]);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(scale));
        }
        BigDecimal result = ip.add(fp);
        return positive ? result : result.negate();
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
        }
        return result;
    }

    private static long bigEndianLong(byte[] bytes, int offset, int length) {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (long)(b >= 0 ? b : b + 256);
        }
        return result;
    }
}

