/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.github.shyiko.mysql.binlog.event.deserialization.DeleteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventHeaderDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventHeaderV4Deserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.FormatDescriptionEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.NullEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.QueryEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RotateEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RowsQueryEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.UpdateRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.WriteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.XidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EventDeserializer {
    private final EventHeaderDeserializer eventHeaderDeserializer;
    private final EventDataDeserializer defaultEventDataDeserializer;
    private final Map<EventType, EventDataDeserializer> eventDataDeserializers;
    private int checksumLength;
    private final Map<Long, TableMapEventData> tableMapEventByTableId;

    public EventDeserializer() {
        this(new EventHeaderV4Deserializer(), new NullEventDataDeserializer());
    }

    public EventDeserializer(EventHeaderDeserializer eventHeaderDeserializer) {
        this(eventHeaderDeserializer, new NullEventDataDeserializer());
    }

    public EventDeserializer(EventDataDeserializer defaultEventDataDeserializer) {
        this(new EventHeaderV4Deserializer(), defaultEventDataDeserializer);
    }

    public EventDeserializer(EventHeaderDeserializer eventHeaderDeserializer, EventDataDeserializer defaultEventDataDeserializer) {
        this(eventHeaderDeserializer, defaultEventDataDeserializer, new HashMap<EventType, EventDataDeserializer>(), new HashMap<Long, TableMapEventData>());
        this.registerDefaultEventDataDeserializers();
    }

    public EventDeserializer(EventHeaderDeserializer eventHeaderDeserializer, EventDataDeserializer defaultEventDataDeserializer, Map<EventType, EventDataDeserializer> eventDataDeserializers, Map<Long, TableMapEventData> tableMapEventByTableId) {
        this.eventHeaderDeserializer = eventHeaderDeserializer;
        this.defaultEventDataDeserializer = defaultEventDataDeserializer;
        this.eventDataDeserializers = eventDataDeserializers;
        this.tableMapEventByTableId = tableMapEventByTableId;
    }

    private void registerDefaultEventDataDeserializers() {
        this.eventDataDeserializers.put(EventType.FORMAT_DESCRIPTION, new FormatDescriptionEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.ROTATE, new RotateEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.QUERY, new QueryEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.TABLE_MAP, new TableMapEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.XID, new XidEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.WRITE_ROWS, new WriteRowsEventDataDeserializer(this.tableMapEventByTableId));
        this.eventDataDeserializers.put(EventType.UPDATE_ROWS, new UpdateRowsEventDataDeserializer(this.tableMapEventByTableId));
        this.eventDataDeserializers.put(EventType.DELETE_ROWS, new DeleteRowsEventDataDeserializer(this.tableMapEventByTableId));
        this.eventDataDeserializers.put(EventType.EXT_WRITE_ROWS, new WriteRowsEventDataDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        this.eventDataDeserializers.put(EventType.EXT_UPDATE_ROWS, new UpdateRowsEventDataDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        this.eventDataDeserializers.put(EventType.EXT_DELETE_ROWS, new DeleteRowsEventDataDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        this.eventDataDeserializers.put(EventType.ROWS_QUERY, new RowsQueryEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.GTID, new GtidEventDataDeserializer());
    }

    public void setEventDataDeserializer(EventType eventType, EventDataDeserializer eventDataDeserializer) {
        this.eventDataDeserializers.put(eventType, eventDataDeserializer);
    }

    public void setChecksumType(ChecksumType checksumType) {
        this.checksumLength = checksumType.getLength();
    }

    public Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
        if (inputStream.peek() == -1) {
            return null;
        }
        Object eventHeader = this.eventHeaderDeserializer.deserialize(inputStream);
        EventData eventData = this.deserializeEventData(inputStream, (EventHeader)eventHeader);
        if (eventHeader.getEventType() == EventType.TABLE_MAP) {
            TableMapEventData tableMapEvent = (TableMapEventData)eventData;
            this.tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
        }
        return new Event((EventHeader)eventHeader, eventData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventData deserializeEventData(ByteArrayInputStream inputStream, EventHeader eventHeader) throws EventDataDeserializationException {
        Object eventData;
        EventDataDeserializer eventDataDeserializer = this.getEventDataDeserializer(eventHeader.getEventType());
        int eventBodyLength = (int)eventHeader.getDataLength() - this.checksumLength;
        try {
            inputStream.enterBlock(eventBodyLength);
            try {
                eventData = eventDataDeserializer.deserialize(inputStream);
            }
            finally {
                inputStream.skipToTheEndOfTheBlock();
                inputStream.skip(this.checksumLength);
            }
        }
        catch (IOException e) {
            throw new EventDataDeserializationException(eventHeader, (Throwable)e);
        }
        return eventData;
    }

    private EventDataDeserializer getEventDataDeserializer(EventType eventType) {
        EventDataDeserializer eventDataDeserializer = this.eventDataDeserializers.get((Object)eventType);
        return eventDataDeserializer != null ? eventDataDeserializer : this.defaultEventDataDeserializer;
    }
}

