/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer.util;

import android.support.annotation.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DownloadUtil {
    private static DownloadUtil downloadUtil;
    private final OkHttpClient okHttpClient = new OkHttpClient();

    public static DownloadUtil get() {
        if (downloadUtil == null) {
            downloadUtil = new DownloadUtil();
        }
        return downloadUtil;
    }

    private DownloadUtil() {
    }

    public void download(final String url, final String saveDir, final OnDownloadListener listener) {
        Request request = new Request.Builder().url(url).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                listener.onDownloadFailed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                InputStream is = null;
                byte[] buf = new byte[2048];
                int len = 0;
                FileOutputStream fos = null;
                String savePath = DownloadUtil.this.isExistDir(saveDir);
                try {
                    is = response.body().byteStream();
                    long total = response.body().contentLength();
                    int index = url.lastIndexOf("/");
                    String fileName = url.substring(index);
                    File file = new File(saveDir, fileName);
                    fos = new FileOutputStream(file);
                    long sum = 0L;
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                        int progress = (int)((float)(sum += (long)len) * 1.0f / (float)total * 100.0f);
                        listener.onDownloading(progress);
                    }
                    fos.flush();
                    listener.onDownloadSuccess(file);
                }
                catch (Exception e) {
                    listener.onDownloadFailed();
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    private String isExistDir(String saveDir) throws IOException {
        File downloadFile = new File(saveDir);
        if (!downloadFile.mkdirs()) {
            downloadFile.createNewFile();
        }
        String savePath = downloadFile.getAbsolutePath();
        return savePath;
    }

    @NonNull
    private String getNameFromUrl(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public static interface OnDownloadListener {
        public void onDownloadSuccess(File var1);

        public void onDownloading(int var1);

        public void onDownloadFailed();
    }
}

