/*
 * Decompiled with CFR 0.152.
 */
package com.shuhart.stepview;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.ColorUtils;
import androidx.core.view.ViewCompat;
import com.shuhart.stepview.R;
import com.shuhart.stepview.animation.AnimatorListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class StepView
extends View {
    public static final int ANIMATION_LINE = 0;
    public static final int ANIMATION_CIRCLE = 1;
    public static final int ANIMATION_ALL = 2;
    public static final int ANIMATION_NONE = 3;
    public static final int DISPLAY_MODE_WITH_TEXT = 0;
    public static final int DISPLAY_MODE_NO_TEXT = 1;
    private OnStepClickListener onStepClickListener;
    private static final int ANIMATE_STEP_TRANSITION = 0;
    private static final int IDLE = 1;
    private static final int START_STEP = 0;
    private int displayMode = 0;
    private List<String> steps = new ArrayList<String>();
    private int stepsNumber = 0;
    private int currentStep = 0;
    private int nextAnimatedStep;
    private int state = 1;
    private int animationType;
    @ColorInt
    private int selectedCircleColor;
    @Dimension
    private int selectedCircleRadius;
    @ColorInt
    private int selectedTextColor;
    @ColorInt
    private int doneCircleColor;
    @Dimension
    private int doneCircleRadius;
    @ColorInt
    private int doneTextColor;
    @ColorInt
    private int nextTextColor;
    @Dimension
    private int stepPadding;
    @ColorInt
    private int nextStepLineColor;
    @ColorInt
    private int doneStepLineColor;
    @Dimension
    private int stepLineWidth;
    @Dimension(unit=2)
    private float textSize;
    @Dimension
    private int textPadding;
    private int selectedStepNumberColor;
    @Dimension(unit=2)
    private float stepNumberTextSize;
    @ColorInt
    private int doneStepMarkColor;
    private int animationDuration;
    private boolean nextStepCircleEnabled;
    @ColorInt
    private int nextStepCircleColor;
    private Paint paint;
    private TextPaint textPaint;
    private ValueAnimator animator;
    private int[] circlesX;
    private int[] startLinesX;
    private int[] endLinesX;
    private float[] constraints;
    private int circlesY;
    private int textY;
    private float animatedFraction;
    private boolean done;
    private StaticLayout[] textLayouts;
    private Rect bounds = new Rect();

    public StepView(Context context) {
        this(context, null);
    }

    public StepView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sv_stepViewStyle);
    }

    public StepView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.textPaint = new TextPaint(1);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.applyStyles(context, attrs, defStyleAttr);
        this.drawEditMode();
    }

    private void applyStyles(Context context, AttributeSet attrs, int defStyleAttr) {
        int fontId;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.StepView, defStyleAttr, R.style.StepView);
        this.selectedCircleColor = ta.getColor(R.styleable.StepView_sv_selectedCircleColor, 0);
        this.selectedCircleRadius = ta.getDimensionPixelSize(R.styleable.StepView_sv_selectedCircleRadius, 0);
        this.selectedTextColor = ta.getColor(R.styleable.StepView_sv_selectedTextColor, 0);
        this.selectedStepNumberColor = ta.getColor(R.styleable.StepView_sv_selectedStepNumberColor, 0);
        this.doneStepMarkColor = ta.getColor(R.styleable.StepView_sv_doneStepMarkColor, 0);
        this.doneCircleColor = ta.getColor(R.styleable.StepView_sv_doneCircleColor, 0);
        this.doneCircleRadius = ta.getDimensionPixelSize(R.styleable.StepView_sv_doneCircleRadius, 0);
        this.doneTextColor = ta.getColor(R.styleable.StepView_sv_doneTextColor, 0);
        this.nextTextColor = ta.getColor(R.styleable.StepView_sv_nextTextColor, 0);
        this.stepPadding = ta.getDimensionPixelSize(R.styleable.StepView_sv_stepPadding, 0);
        this.nextStepLineColor = ta.getColor(R.styleable.StepView_sv_nextStepLineColor, 0);
        this.doneStepLineColor = ta.getColor(R.styleable.StepView_sv_doneStepLineColor, 0);
        this.stepLineWidth = ta.getDimensionPixelSize(R.styleable.StepView_sv_stepLineWidth, 0);
        this.textPadding = ta.getDimensionPixelSize(R.styleable.StepView_sv_textPadding, 0);
        this.stepNumberTextSize = ta.getDimension(R.styleable.StepView_sv_stepNumberTextSize, 0.0f);
        this.textSize = ta.getDimension(R.styleable.StepView_sv_textSize, 0.0f);
        this.animationDuration = ta.getInteger(R.styleable.StepView_sv_animationDuration, 0);
        this.animationType = ta.getInteger(R.styleable.StepView_sv_animationType, 0);
        this.stepsNumber = ta.getInteger(R.styleable.StepView_sv_stepsNumber, 0);
        this.nextStepCircleEnabled = ta.getBoolean(R.styleable.StepView_sv_nextStepCircleEnabled, false);
        this.nextStepCircleColor = ta.getColor(R.styleable.StepView_sv_nextStepCircleColor, 0);
        CharSequence[] descriptions = ta.getTextArray(R.styleable.StepView_sv_steps);
        if (descriptions != null) {
            for (CharSequence description : descriptions) {
                this.steps.add(description.toString());
            }
            this.displayMode = 0;
        } else {
            this.displayMode = 1;
        }
        Drawable background = ta.getDrawable(R.styleable.StepView_sv_background);
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        if ((fontId = ta.getResourceId(R.styleable.StepView_sv_typeface, 0)) != 0) {
            Typeface typeface = ResourcesCompat.getFont((Context)context, (int)fontId);
            this.setTypeface(typeface);
        }
        this.textPaint.setTextSize(this.textSize);
        ta.recycle();
    }

    private void setTypeface(Typeface typeface) {
        if (typeface != null) {
            this.textPaint.setTypeface(typeface);
            this.paint.setTypeface(typeface);
        }
    }

    private void drawEditMode() {
        if (this.isInEditMode()) {
            if (this.displayMode == 0) {
                if (this.steps.isEmpty()) {
                    this.steps.add("Step 1");
                    this.steps.add("Step 2");
                    this.steps.add("Step 3");
                }
                this.setSteps(this.steps);
            } else {
                if (this.stepsNumber == 0) {
                    this.stepsNumber = 4;
                }
                this.setStepsNumber(this.stepsNumber);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action;
        boolean superResult = super.onTouchEvent(event);
        if (this.onStepClickListener != null && this.isEnabled() && (action = event.getActionMasked()) == 1) {
            float x = event.getX();
            float y = event.getY();
            int step = this.getStepByPointer(x, y);
            this.onStepClickListener.onStepClick(step);
        }
        return superResult;
    }

    protected int getStepByPointer(float x, float y) {
        int count = this.getStepCount();
        for (int i = 0; i < this.constraints.length; ++i) {
            float constraint = this.constraints[i];
            if (!(x <= constraint)) continue;
            return i;
        }
        return count - 1;
    }

    public void setOnStepClickListener(OnStepClickListener listener) {
        this.setClickable(listener != null);
        this.onStepClickListener = listener;
    }

    public void setSteps(List<String> steps) {
        this.stepsNumber = 0;
        this.displayMode = 0;
        this.steps.clear();
        this.steps.addAll(steps);
        this.requestLayout();
        this.go(0, false);
    }

    public void setStepsNumber(int number) {
        this.steps.clear();
        this.displayMode = 1;
        this.stepsNumber = number;
        this.requestLayout();
        this.go(0, false);
    }

    public State getState() {
        return new State();
    }

    public void go(int step, boolean animate) {
        if (step >= 0 && step < this.getStepCount()) {
            if (animate && this.animationType != 3 && this.startLinesX != null) {
                if (Math.abs(step - this.currentStep) > 1) {
                    this.endAnimation();
                    this.currentStep = step;
                    this.invalidate();
                } else {
                    this.nextAnimatedStep = step;
                    this.state = 0;
                    this.animate(step);
                    this.invalidate();
                }
            } else {
                this.currentStep = step;
                this.invalidate();
            }
        }
    }

    public void done(boolean isDone) {
        this.done = isDone;
        this.invalidate();
    }

    private void endAnimation() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.end();
        }
    }

    private void animate(final int step) {
        this.endAnimation();
        this.animator = this.getAnimator(step);
        if (this.animator == null) {
            return;
        }
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                StepView.this.animatedFraction = valueAnimator.getAnimatedFraction();
                StepView.this.invalidate();
            }
        });
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                StepView.this.state = 1;
                StepView.this.currentStep = step;
                StepView.this.invalidate();
            }
        });
        this.animator.setDuration((long)this.animationDuration);
        this.animator.start();
    }

    @Nullable
    private ValueAnimator getAnimator(int step) {
        ValueAnimator animator = null;
        if (step > this.currentStep) {
            if (this.animationType == 0) {
                int i = step - 1;
                animator = ValueAnimator.ofInt((int[])new int[]{this.startLinesX[i], this.endLinesX[i]});
            } else if (this.animationType == 1) {
                animator = ValueAnimator.ofInt((int[])new int[]{0, this.selectedCircleRadius});
            } else if (this.animationType == 2) {
                int i = step - 1;
                animator = ValueAnimator.ofInt((int[])new int[]{0, (this.endLinesX[i] - this.startLinesX[i] + this.selectedCircleRadius) / 2});
            }
        } else if (step < this.currentStep) {
            if (this.animationType == 0) {
                int i = step;
                animator = ValueAnimator.ofInt((int[])new int[]{this.endLinesX[i], this.startLinesX[i]});
            } else if (this.animationType == 1) {
                animator = ValueAnimator.ofInt((int[])new int[]{0, this.selectedCircleRadius});
            } else if (this.animationType == 2) {
                int i = step;
                animator = ValueAnimator.ofInt((int[])new int[]{0, (this.endLinesX[i] - this.startLinesX[i] + this.selectedCircleRadius) / 2});
            }
        }
        return animator;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public int getStepCount() {
        return this.displayMode == 0 ? this.steps.size() : this.stepsNumber;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureWidth(widthMeasureSpec);
        if (this.getStepCount() == 0) {
            this.setMeasuredDimension(width, 0);
            return;
        }
        if (width == 0) {
            this.setMeasuredDimension(width, 0);
            return;
        }
        this.measureConstraints(width);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.measureAttributes();
    }

    private int measureWidth(int widthMeasureSpec) {
        return View.MeasureSpec.getSize((int)widthMeasureSpec);
    }

    private void measureConstraints(int width) {
        this.constraints = new float[this.getStepCount()];
        this.constraints[0] = width / this.getStepCount();
        for (int i = 1; i < this.constraints.length; ++i) {
            this.constraints[i] = this.constraints[0] * (float)(i + 1);
        }
    }

    private int measureHeight(int heightMeasureSpec) {
        int specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int desiredSize = this.getPaddingTop() + this.getPaddingBottom() + Math.max(this.selectedCircleRadius, this.doneCircleRadius) * 2 + (this.displayMode == 0 ? this.textPadding : 0);
        if (!this.steps.isEmpty()) {
            desiredSize += this.measureStepsHeight();
        }
        int result = 0;
        switch (specMode) {
            case 0: {
                result = desiredSize;
                break;
            }
            case -2147483648: {
                result = Math.min(desiredSize, specSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    private int measureStepsHeight() {
        this.textLayouts = new StaticLayout[this.steps.size()];
        this.textPaint.setTextSize(this.textSize);
        int max = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            String text = this.steps.get(i);
            Layout.Alignment alignment = this.isRtl() ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
            this.textLayouts[i] = new StaticLayout((CharSequence)text, this.textPaint, this.getMeasuredWidth() / this.steps.size(), alignment, 1.0f, 0.0f, true);
            int height = this.textLayouts[i].getHeight();
            max = Math.max(height, max);
        }
        return max;
    }

    @TargetApi(value=17)
    private boolean isRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    private void measureAttributes() {
        this.circlesY = this.getCircleY();
        if (this.displayMode == 1) {
            this.circlesY += this.getPaddingTop();
        }
        this.circlesX = this.getCirclePositions();
        if (this.displayMode == 1) {
            this.paint.setTextSize(this.stepNumberTextSize);
        } else {
            this.paint.setTextSize(this.stepNumberTextSize);
            this.paint.setTextSize(this.textSize);
            this.textY = this.circlesY + this.selectedCircleRadius + this.textPadding;
        }
        this.measureLines();
    }

    private int getCircleY() {
        int availableHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        if (this.displayMode == 1) {
            return availableHeight / 2;
        }
        int maxItemHeight = this.getMaxTextHeight() + Math.max(this.selectedCircleRadius, this.doneCircleRadius) + this.textPadding;
        int additionalPadding = (availableHeight - maxItemHeight) / 2;
        return this.getPaddingTop() + additionalPadding + this.selectedCircleRadius;
    }

    private int getMaxTextHeight() {
        int max = 0;
        if (this.textLayouts == null || this.textLayouts.length == 0) {
            return max;
        }
        for (StaticLayout tl : this.textLayouts) {
            max = Math.max(tl.getHeight(), max);
        }
        return max;
    }

    private int[] getCirclePositions() {
        int stepsCount = this.getStepCount();
        int[] result = new int[stepsCount];
        if (result.length == 0) {
            return result;
        }
        result[0] = this.getStartCirclePosition();
        if (result.length == 1) {
            return result;
        }
        result[stepsCount - 1] = this.getEndCirclePosition();
        if (result.length < 3) {
            return result;
        }
        float spaceLeft = this.isRtl() ? (float)(result[0] - result[stepsCount - 1]) : (float)(result[stepsCount - 1] - result[0]);
        int margin = (int)(spaceLeft / (float)(stepsCount - 1));
        if (this.isRtl()) {
            for (int i = 1; i < stepsCount - 1; ++i) {
                result[i] = result[i - 1] - margin;
            }
        } else {
            for (int i = 1; i < stepsCount - 1; ++i) {
                result[i] = result[i - 1] + margin;
            }
        }
        return result;
    }

    private int getStartCirclePosition() {
        int result = this.displayMode == 0 ? (this.isRtl() ? this.getMeasuredWidth() - this.getPaddingRight() - Math.max(this.getMaxLineWidth(this.textLayouts[0]) / 2, this.selectedCircleRadius) : this.getPaddingLeft() + Math.max(this.getMaxLineWidth(this.textLayouts[0]) / 2, this.selectedCircleRadius)) : (this.isRtl() ? this.getMeasuredWidth() - this.getPaddingRight() - this.selectedCircleRadius : this.getPaddingLeft() + this.selectedCircleRadius);
        return result;
    }

    private int getMaxLineWidth(StaticLayout layout) {
        int lineCount = layout.getLineCount();
        int max = 0;
        for (int i = 0; i < lineCount; ++i) {
            max = (int)Math.max(layout.getLineWidth(i), (float)max);
        }
        return max;
    }

    private int getEndCirclePosition() {
        int result = this.displayMode == 0 ? (this.isRtl() ? this.getPaddingLeft() + Math.max(this.getMaxLineWidth(this.last(this.textLayouts)) / 2, this.selectedCircleRadius) : this.getMeasuredWidth() - this.getPaddingRight() - Math.max(this.getMaxLineWidth(this.last(this.textLayouts)) / 2, this.selectedCircleRadius)) : (this.isRtl() ? this.getPaddingLeft() + this.selectedCircleRadius : this.getMeasuredWidth() - this.getPaddingRight() - this.selectedCircleRadius);
        return result;
    }

    private <T> T last(T[] array) {
        return array[array.length - 1];
    }

    private void measureLines() {
        this.startLinesX = new int[this.getStepCount() - 1];
        this.endLinesX = new int[this.getStepCount() - 1];
        int padding = this.stepPadding + this.selectedCircleRadius;
        for (int i = 1; i < this.getStepCount(); ++i) {
            if (this.isRtl()) {
                this.startLinesX[i - 1] = this.circlesX[i - 1] - padding;
                this.endLinesX[i - 1] = this.circlesX[i] + padding;
                continue;
            }
            this.startLinesX[i - 1] = this.circlesX[i - 1] + padding;
            this.endLinesX[i - 1] = this.circlesX[i] - padding;
        }
    }

    protected void onDraw(Canvas canvas) {
        int i;
        if (this.getHeight() == 0) {
            return;
        }
        int stepSize = this.getStepCount();
        if (stepSize == 0) {
            return;
        }
        for (i = 0; i < stepSize; ++i) {
            this.drawStep(canvas, i, this.circlesX[i], this.circlesY);
        }
        for (i = 0; i < this.startLinesX.length; ++i) {
            int animatedX;
            if (this.state == 0 && i == this.nextAnimatedStep - 1 && this.nextAnimatedStep > this.currentStep && (this.animationType == 0 || this.animationType == 2)) {
                animatedX = (int)((float)this.startLinesX[i] + this.animatedFraction * (float)(this.endLinesX[i] - this.startLinesX[i]));
                this.drawLine(canvas, this.startLinesX[i], animatedX, this.circlesY, true);
                this.drawLine(canvas, animatedX, this.endLinesX[i], this.circlesY, false);
                continue;
            }
            if (this.state == 0 && i == this.nextAnimatedStep && this.nextAnimatedStep < this.currentStep && (this.animationType == 0 || this.animationType == 2)) {
                animatedX = (int)((float)this.endLinesX[i] - this.animatedFraction * (float)(this.endLinesX[i] - this.startLinesX[i]));
                this.drawLine(canvas, this.startLinesX[i], animatedX, this.circlesY, true);
                this.drawLine(canvas, animatedX, this.endLinesX[i], this.circlesY, false);
                continue;
            }
            if (i < this.currentStep) {
                this.drawLine(canvas, this.startLinesX[i], this.endLinesX[i], this.circlesY, true);
                continue;
            }
            this.drawLine(canvas, this.startLinesX[i], this.endLinesX[i], this.circlesY, false);
        }
    }

    private void drawStep(Canvas canvas, int step, int circleCenterX, int circleCenterY) {
        boolean isSelected;
        String text = this.displayMode == 0 ? this.steps.get(step) : "";
        boolean bl = isSelected = step == this.currentStep;
        boolean isDone = this.done ? step <= this.currentStep : step < this.currentStep;
        String number = String.valueOf(step + 1);
        if (isSelected && !isDone) {
            int radius;
            this.paint.setColor(this.selectedCircleColor);
            if (this.state == 0 && (this.animationType == 1 || this.animationType == 2) && this.nextAnimatedStep < this.currentStep) {
                radius = !this.nextStepCircleEnabled || this.nextStepCircleColor == 0 ? (int)((float)this.selectedCircleRadius - (float)this.selectedCircleRadius * this.animatedFraction) : this.selectedCircleRadius;
                if (this.nextStepCircleEnabled && this.nextStepCircleColor != 0) {
                    this.paint.setColor(ColorUtils.blendARGB((int)this.selectedCircleColor, (int)this.nextStepCircleColor, (float)this.animatedFraction));
                }
            } else {
                radius = this.selectedCircleRadius;
            }
            canvas.drawCircle((float)circleCenterX, (float)circleCenterY, (float)radius, this.paint);
            this.paint.setColor(this.selectedStepNumberColor);
            this.paint.setTextSize(this.stepNumberTextSize);
            this.drawNumber(canvas, number, circleCenterX, this.paint);
            this.textPaint.setTextSize(this.textSize);
            this.textPaint.setColor(this.selectedTextColor);
            this.drawText(canvas, text, this.textY, step);
        } else if (isDone) {
            this.paint.setColor(this.doneCircleColor);
            canvas.drawCircle((float)circleCenterX, (float)circleCenterY, (float)this.doneCircleRadius, this.paint);
            this.drawCheckMark(canvas, circleCenterX, circleCenterY);
            if (this.state == 0 && step == this.nextAnimatedStep && this.nextAnimatedStep < this.currentStep) {
                this.paint.setColor(this.selectedTextColor);
                int alpha = Math.max(Color.alpha((int)this.doneTextColor), (int)(this.animatedFraction * 255.0f));
                this.paint.setAlpha(alpha);
            } else {
                this.paint.setColor(this.doneTextColor);
            }
            this.textPaint.setTextSize(this.textSize);
            this.textPaint.setColor(this.doneTextColor);
            this.drawText(canvas, text, this.textY, step);
        } else if (this.state == 0 && step == this.nextAnimatedStep && this.nextAnimatedStep > this.currentStep) {
            int alpha;
            if (this.animationType == 1 || this.animationType == 2) {
                if (this.nextStepCircleEnabled && this.nextStepCircleColor != 0) {
                    this.paint.setColor(ColorUtils.blendARGB((int)this.nextStepCircleColor, (int)this.selectedCircleColor, (float)this.animatedFraction));
                    canvas.drawCircle((float)circleCenterX, (float)circleCenterY, (float)this.selectedCircleRadius, this.paint);
                } else {
                    int animatedRadius = (int)((float)this.selectedCircleRadius * this.animatedFraction);
                    this.paint.setColor(this.selectedCircleColor);
                    canvas.drawCircle((float)circleCenterX, (float)circleCenterY, (float)animatedRadius, this.paint);
                }
            }
            if (this.animationType != 3) {
                if (this.animationType == 1 || this.animationType == 2) {
                    this.paint.setColor(this.selectedStepNumberColor);
                    alpha = (int)(this.animatedFraction * 255.0f);
                    this.paint.setAlpha(alpha);
                    this.paint.setTextSize(this.stepNumberTextSize * this.animatedFraction);
                    this.drawNumber(canvas, number, circleCenterX, this.paint);
                } else {
                    this.paint.setTextSize(this.stepNumberTextSize);
                    this.paint.setColor(this.nextTextColor);
                    this.drawNumber(canvas, number, circleCenterX, this.paint);
                }
            } else {
                this.paint.setTextSize(this.stepNumberTextSize);
                this.paint.setColor(this.nextTextColor);
                this.drawNumber(canvas, number, circleCenterX, this.paint);
            }
            this.textPaint.setTextSize(this.textSize);
            this.textPaint.setColor(this.nextTextColor);
            alpha = (int)Math.max((float)Color.alpha((int)this.nextTextColor), this.animatedFraction * 255.0f);
            this.textPaint.setAlpha(alpha);
            this.drawText(canvas, text, this.textY, step);
        } else {
            if (this.nextStepCircleEnabled && this.nextStepCircleColor != 0) {
                this.paint.setColor(this.nextStepCircleColor);
                canvas.drawCircle((float)circleCenterX, (float)circleCenterY, (float)this.selectedCircleRadius, this.paint);
            }
            this.paint.setColor(this.nextTextColor);
            this.paint.setTextSize(this.stepNumberTextSize);
            this.drawNumber(canvas, number, circleCenterX, this.paint);
            this.textPaint.setTextSize(this.textSize);
            this.textPaint.setColor(this.nextTextColor);
            this.drawText(canvas, text, this.textY, step);
        }
    }

    private void drawNumber(Canvas canvas, String number, int circleCenterX, Paint paint) {
        paint.getTextBounds(number, 0, number.length(), this.bounds);
        float y = (float)this.circlesY + (float)this.bounds.height() / 2.0f - (float)this.bounds.bottom;
        canvas.drawText(number, (float)circleCenterX, y, paint);
    }

    private void drawText(Canvas canvas, String text, int y, int step) {
        if (text.isEmpty()) {
            return;
        }
        StaticLayout layout = this.textLayouts[step];
        canvas.save();
        canvas.translate((float)this.circlesX[step], (float)y);
        layout.draw(canvas);
        canvas.restore();
    }

    private void drawCheckMark(Canvas canvas, int circleCenterX, int circleCenterY) {
        this.paint.setColor(this.doneStepMarkColor);
        float width = this.stepNumberTextSize * 0.1f;
        this.paint.setStrokeWidth(width);
        Rect bounds = new Rect((int)((double)circleCenterX - (double)width * 4.5), (int)((double)circleCenterY - (double)width * 3.5), (int)((double)circleCenterX + (double)width * 4.5), (int)((double)circleCenterY + (double)width * 3.5));
        canvas.drawLine((float)bounds.left + 0.5f * width, (float)bounds.bottom - 3.25f * width, (float)bounds.left + 3.25f * width, (float)bounds.bottom - 0.75f * width, this.paint);
        canvas.drawLine((float)bounds.left + 2.75f * width, (float)bounds.bottom - 0.75f * width, (float)bounds.right - 0.375f * width, (float)bounds.top + 0.75f * width, this.paint);
    }

    private void drawLine(Canvas canvas, int startX, int endX, int centerY, boolean highlight) {
        if (highlight) {
            this.paint.setColor(this.doneStepLineColor);
            this.paint.setStrokeWidth((float)this.stepLineWidth);
            canvas.drawLine((float)startX, (float)centerY, (float)endX, (float)centerY, this.paint);
        } else {
            this.paint.setColor(this.nextStepLineColor);
            this.paint.setStrokeWidth((float)this.stepLineWidth);
            canvas.drawLine((float)startX, (float)centerY, (float)endX, (float)centerY, this.paint);
        }
    }

    public static interface OnStepClickListener {
        public void onStepClick(int var1);
    }

    public class State {
        private List<String> steps;
        private int stepsNumber;
        private int animationType;
        @ColorInt
        private int selectedCircleColor;
        @Dimension
        private int selectedCircleRadius;
        @ColorInt
        private int selectedTextColor;
        @ColorInt
        private int doneCircleColor;
        @Dimension
        private int doneCircleRadius;
        @ColorInt
        private int doneTextColor;
        @ColorInt
        private int nextTextColor;
        @Dimension
        private int stepPadding;
        @ColorInt
        private int nextStepLineColor;
        @ColorInt
        private int doneStepLineColor;
        @Dimension
        private int stepLineWidth;
        @Dimension(unit=2)
        private float textSize;
        @Dimension
        private int textPadding;
        @ColorInt
        private int selectedStepNumberColor;
        @Dimension(unit=2)
        private float stepNumberTextSize;
        @ColorInt
        private int doneStepMarkColor;
        private int animationDuration;
        private boolean nextStepCircleEnabled;
        @ColorInt
        private int nextStepCircleColor;
        private Typeface typeface;

        public State() {
            this.animationType = StepView.this.animationType;
            this.selectedCircleColor = StepView.this.selectedCircleColor;
            this.selectedCircleRadius = StepView.this.selectedCircleRadius;
            this.selectedTextColor = StepView.this.selectedTextColor;
            this.doneCircleColor = StepView.this.doneCircleColor;
            this.doneCircleRadius = StepView.this.doneCircleRadius;
            this.doneTextColor = StepView.this.doneTextColor;
            this.nextTextColor = StepView.this.nextTextColor;
            this.stepPadding = StepView.this.stepPadding;
            this.nextStepLineColor = StepView.this.nextStepLineColor;
            this.doneStepLineColor = StepView.this.doneStepLineColor;
            this.stepLineWidth = StepView.this.stepLineWidth;
            this.textSize = StepView.this.textSize;
            this.textPadding = StepView.this.textPadding;
            this.selectedStepNumberColor = StepView.this.selectedStepNumberColor;
            this.stepNumberTextSize = StepView.this.stepNumberTextSize;
            this.doneStepMarkColor = StepView.this.doneStepMarkColor;
            this.animationDuration = StepView.this.animationDuration;
            this.nextStepCircleEnabled = StepView.this.nextStepCircleEnabled;
            this.nextStepCircleColor = StepView.this.nextStepCircleColor;
            this.typeface = StepView.this.paint.getTypeface();
        }

        public State animationType(int animationType) {
            this.animationType = animationType;
            return this;
        }

        public State selectedCircleColor(@ColorInt int selectedCircleColor) {
            this.selectedCircleColor = selectedCircleColor;
            return this;
        }

        public State selectedCircleRadius(@Dimension int selectedCircleRadius) {
            this.selectedCircleRadius = selectedCircleRadius;
            return this;
        }

        public State selectedTextColor(@ColorInt int selectedTextColor) {
            this.selectedTextColor = selectedTextColor;
            return this;
        }

        public State doneCircleColor(@ColorInt int doneCircleColor) {
            this.doneCircleColor = doneCircleColor;
            return this;
        }

        public State doneCircleRadius(@Dimension int doneCircleRadius) {
            this.doneCircleRadius = doneCircleRadius;
            return this;
        }

        public State doneTextColor(@ColorInt int doneTextColor) {
            this.doneTextColor = doneTextColor;
            return this;
        }

        public State nextTextColor(@ColorInt int nextTextColor) {
            this.nextTextColor = nextTextColor;
            return this;
        }

        public State stepPadding(@Dimension int stepPadding) {
            this.stepPadding = stepPadding;
            return this;
        }

        public State nextStepLineColor(@ColorInt int nextStepLineColor) {
            this.nextStepLineColor = nextStepLineColor;
            return this;
        }

        public State doneStepLineColor(@ColorInt int doneStepLineColor) {
            this.doneStepLineColor = doneStepLineColor;
            return this;
        }

        public State stepLineWidth(@Dimension int stepLineWidth) {
            this.stepLineWidth = stepLineWidth;
            return this;
        }

        public State textSize(@Dimension(unit=2) int textSize) {
            this.textSize = textSize;
            return this;
        }

        public State textPadding(@Dimension int textPadding) {
            this.textPadding = textPadding;
            return this;
        }

        public State selectedStepNumberColor(@ColorInt int selectedStepNumberColor) {
            this.selectedStepNumberColor = selectedStepNumberColor;
            return this;
        }

        public State stepNumberTextSize(@Dimension(unit=2) int stepNumberTextSize) {
            this.stepNumberTextSize = stepNumberTextSize;
            return this;
        }

        public State doneStepMarkColor(@ColorInt int doneStepMarkColor) {
            this.doneStepMarkColor = doneStepMarkColor;
            return this;
        }

        public State animationDuration(int animationDuration) {
            this.animationDuration = animationDuration;
            return this;
        }

        public State steps(List<String> steps) {
            this.steps = steps;
            return this;
        }

        public State stepsNumber(int stepsNumber) {
            this.stepsNumber = stepsNumber;
            return this;
        }

        public State typeface(Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        public State nextStepCircleEnabled(boolean enabled) {
            this.nextStepCircleEnabled = enabled;
            return this;
        }

        public State nextStepCircleColor(@ColorInt int color) {
            this.nextStepCircleColor = color;
            return this;
        }

        public void commit() {
            StepView.this.animationType = this.animationType;
            StepView.this.selectedTextColor = this.selectedTextColor;
            StepView.this.selectedCircleRadius = this.selectedCircleRadius;
            StepView.this.selectedCircleColor = this.selectedCircleColor;
            StepView.this.doneCircleColor = this.doneCircleColor;
            StepView.this.doneCircleRadius = this.doneCircleRadius;
            StepView.this.doneTextColor = this.doneTextColor;
            StepView.this.nextTextColor = this.nextTextColor;
            StepView.this.stepPadding = this.stepPadding;
            StepView.this.nextStepLineColor = this.nextStepLineColor;
            StepView.this.doneStepLineColor = this.doneStepLineColor;
            StepView.this.stepLineWidth = this.stepLineWidth;
            StepView.this.textSize = this.textSize;
            StepView.this.textPadding = this.textPadding;
            StepView.this.selectedStepNumberColor = this.selectedStepNumberColor;
            StepView.this.stepNumberTextSize = this.stepNumberTextSize;
            StepView.this.doneStepMarkColor = this.doneStepMarkColor;
            StepView.this.animationDuration = this.animationDuration;
            StepView.this.setTypeface(this.typeface);
            StepView.this.nextStepCircleEnabled = this.nextStepCircleEnabled;
            StepView.this.nextStepCircleColor = this.nextStepCircleColor;
            if (this.steps != null && !StepView.this.steps.equals(this.steps)) {
                StepView.this.setSteps(this.steps);
            } else if (this.stepsNumber != 0 && this.stepsNumber != StepView.this.stepsNumber) {
                StepView.this.setStepsNumber(this.stepsNumber);
            } else {
                StepView.this.invalidate();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

