/*
 * Decompiled with CFR 0.152.
 */
package com.sgiosviews;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import com.sgiosviews.R;
import java.util.Timer;
import java.util.TimerTask;

public class SGStepper
extends View {
    private Activity mActivity;
    private Paint mPaint;
    private Paint fPaint;
    private int start;
    private int width;
    private int height;
    private int roundedRadius;
    private boolean decrementPressed = false;
    private boolean incrementPressed = false;
    private int valueCounter = 0;
    private Timer decrementTimer = null;
    private Timer incrementTimer = null;
    private SGStepperListener valueChangedlistener;

    public void setValueChangedlistener(SGStepperListener newListener) {
        this.valueChangedlistener = newListener;
    }

    public void setBorderColor(int color) {
        if (this.mPaint != null) {
            this.mPaint.setColor(color);
        }
    }

    public void setHighlightColor(int color) {
        if (this.fPaint != null) {
            this.fPaint.setColor(color);
        }
        this.fPaint.setAlpha(40);
    }

    public SGStepper(Context context) {
        super(context);
    }

    public SGStepper(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        if (context instanceof Activity) {
            this.mActivity = (Activity)context;
        }
        this.start = 0;
        this.width = 250;
        this.width = (int)SGStepper.convertDpToPixel(90.0f, context);
        this.height = (int)SGStepper.convertDpToPixel(30.0f, context);
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-7829368);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(3.0f);
        this.fPaint = new Paint(1);
        int highlightDefColor = -16776961;
        this.fPaint.setStyle(Paint.Style.FILL);
        TypedArray values = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SGStepper, 0, 0);
        try {
            int borderColor = values.getColor(R.styleable.SGStepper_bordercolor, -16776961);
            this.mPaint.setColor(borderColor);
            int highlightColor = values.getColor(R.styleable.SGStepper_highlightcolor, highlightDefColor);
            this.fPaint.setColor(highlightColor);
            this.roundedRadius = values.getDimensionPixelSize(R.styleable.SGStepper_roundedradius, 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fPaint.setAlpha(40);
        values.recycle();
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    protected void onDraw(Canvas canvas) {
        Path leftHalfPath;
        if (this.isInEditMode()) {
            return;
        }
        super.onDraw(canvas);
        int padding = 5;
        Path roundedPath = SGStepper.RoundedRect(padding + this.start, 0.0f, this.width, this.height, this.roundedRadius, this.roundedRadius, false);
        canvas.drawPath(roundedPath, this.mPaint);
        if (this.decrementPressed) {
            leftHalfPath = SGStepper.LeftRect(this.start, 2.0f, this.width / 2 - padding, this.height - 2, this.roundedRadius, this.roundedRadius, true);
            canvas.drawPath(leftHalfPath, this.fPaint);
        }
        if (this.incrementPressed) {
            leftHalfPath = SGStepper.RightRect(this.start + this.width / 2, 2.0f, this.width, this.height - 2, this.roundedRadius, this.roundedRadius, true);
            canvas.drawPath(leftHalfPath, this.fPaint);
        }
        canvas.drawLine((float)(this.width / 2), 0.0f, (float)(this.width / 2), (float)this.height, this.mPaint);
        float signWidth = (float)this.height - (float)this.height * 0.23f;
        canvas.drawLine((float)this.width * 0.75f, (float)this.height - signWidth, (float)this.width * 0.75f, signWidth, this.mPaint);
        canvas.drawLine((float)this.width * 0.75f - signWidth * 0.45f, (float)this.height * 0.5f, (float)this.width * 0.75f + signWidth * 0.45f, (float)this.height * 0.5f, this.mPaint);
        canvas.drawLine((float)this.width * 0.25f - signWidth * 0.45f, (float)this.height * 0.5f, (float)this.width * 0.25f + signWidth * 0.45f, (float)this.height * 0.5f, this.mPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minw = this.getPaddingLeft() + this.getPaddingRight() + this.getSuggestedMinimumWidth() + this.width;
        int w = SGStepper.resolveSizeAndState((int)minw, (int)widthMeasureSpec, (int)1);
        this.setMeasuredDimension(w, this.height);
    }

    public static Path LeftRect(float left, float top, float right, float bottom, float rx, float ry, boolean conformToOriginalPost) {
        Path path = new Path();
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if (ry < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / 2.0f) {
            rx = width / 2.0f;
        }
        if (ry > height / 2.0f) {
            ry = height / 2.0f;
        }
        float widthMinusCorners = width - 2.0f * rx;
        float heightMinusCorners = height - 2.0f * ry;
        path.moveTo(right - rx, top);
        path.rLineTo(-widthMinusCorners, 0.0f);
        path.rQuadTo(-rx, 0.0f, -rx, ry);
        path.rLineTo(0.0f, heightMinusCorners);
        if (conformToOriginalPost) {
            path.rQuadTo(0.0f, ry, rx, ry);
            path.rLineTo(width - rx + 3.0f, 0.0f);
        } else {
            path.rQuadTo(0.0f, ry, rx, ry);
            path.rLineTo(widthMinusCorners, 0.0f);
            path.rQuadTo(rx, 0.0f, rx, -ry);
        }
        path.lineTo(right, -height);
        path.close();
        return path;
    }

    public static Path RightRect(float left, float top, float right, float bottom, float rx, float ry, boolean conformToOriginalPost) {
        Path path = new Path();
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if (ry < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / 2.0f) {
            rx = width / 2.0f;
        }
        if (ry > height / 2.0f) {
            ry = height / 2.0f;
        }
        float widthMinusCorners = width - 2.0f * rx;
        float heightMinusCorners = height - 2.0f * ry;
        path.moveTo(right, top + ry);
        path.rQuadTo(0.0f, -ry, -rx, -ry);
        path.rLineTo(-width + rx, 0.0f);
        path.rLineTo(0.0f, height);
        if (conformToOriginalPost) {
            path.rLineTo(widthMinusCorners + rx, 0.0f);
            path.rQuadTo(rx, 0.0f, rx, -ry);
        } else {
            path.rQuadTo(0.0f, ry, rx, ry);
            path.rLineTo(widthMinusCorners, 0.0f);
            path.rQuadTo(rx, 0.0f, rx, -ry);
        }
        path.rLineTo(0.0f, -heightMinusCorners);
        path.close();
        return path;
    }

    public static Path RoundedRect(float left, float top, float right, float bottom, float rx, float ry, boolean conformToOriginalPost) {
        Path path = new Path();
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if (ry < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / 2.0f) {
            rx = width / 2.0f;
        }
        if (ry > height / 2.0f) {
            ry = height / 2.0f;
        }
        float widthMinusCorners = width - 2.0f * rx;
        float heightMinusCorners = height - 2.0f * ry;
        path.moveTo(right, top + ry);
        path.rQuadTo(0.0f, -ry, -rx, -ry);
        path.rLineTo(-widthMinusCorners, 0.0f);
        path.rQuadTo(-rx, 0.0f, -rx, ry);
        path.rLineTo(0.0f, heightMinusCorners);
        if (conformToOriginalPost) {
            path.rLineTo(0.0f, ry);
            path.rLineTo(width, 0.0f);
            path.rLineTo(0.0f, -ry);
        } else {
            path.rQuadTo(0.0f, ry, rx, ry);
            path.rLineTo(widthMinusCorners, 0.0f);
            path.rQuadTo(rx, 0.0f, rx, -ry);
        }
        path.rLineTo(0.0f, -heightMinusCorners);
        path.close();
        return path;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        switch (event.getAction()) {
            case 0: {
                if (x < this.width / 2) {
                    this.decrementPressed = true;
                    this.decrementPressedMethod();
                }
                if (x <= this.width / 2) break;
                this.incrementPressed = true;
                this.incrementPressedMethod();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.decrementPressed = false;
                this.incrementPressed = false;
                if (this.decrementTimer != null) {
                    this.decrementTimer.cancel();
                    this.decrementTimer = null;
                }
                if (this.incrementTimer != null) {
                    this.incrementTimer.cancel();
                    this.incrementTimer = null;
                }
                this.mActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SGStepper.this.valueChangedlistener != null) {
                            SGStepper.this.valueChangedlistener.afterValueChanged(SGStepper.this, SGStepper.this.valueCounter);
                        }
                    }
                });
            }
        }
        this.invalidate();
        return true;
    }

    private void decrementPressedMethod() {
        this.decrementTimer = new Timer();
        this.decrementTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (SGStepper.this.valueCounter > 0) {
                    SGStepper.this.valueCounter--;
                }
                SGStepper.this.mActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SGStepper.this.valueChangedlistener != null) {
                            SGStepper.this.valueChangedlistener.valuesChanged(SGStepper.this, SGStepper.this.valueCounter);
                        }
                    }
                });
            }
        }, 0L, 200L);
    }

    private void incrementPressedMethod() {
        this.incrementTimer = new Timer();
        this.incrementTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SGStepper.this.valueCounter++;
                SGStepper.this.mActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SGStepper.this.valueChangedlistener != null) {
                            SGStepper.this.valueChangedlistener.valuesChanged(SGStepper.this, SGStepper.this.valueCounter);
                        }
                    }
                });
            }
        }, 0L, 200L);
    }

    public static interface SGStepperListener {
        public void valuesChanged(SGStepper var1, int var2);

        public void afterValueChanged(SGStepper var1, int var2);
    }
}

