/*
 * Decompiled with CFR 0.152.
 */
package com.sgiosviews;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.sgiosviews.R;
import java.util.ArrayList;

public class SGPickerView
extends FrameLayout {
    private Context mContext;
    private SGPickerScrollView mScrollView;
    private LinearLayout mLinLayout;
    private int height;
    private boolean debugging = false;
    private ArrayList<String> items;
    private int defaultItemTextColor = -3355444;
    private int selectedItemTextColor = -12303292;
    private SGPickerViewListener mListener;

    public SGPickerView(Context context) {
        super(context);
        this.mContext = context;
    }

    public SGPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point dSize = new Point();
        display.getSize(dSize);
        this.height = (int)((float)dSize.y * 0.23f);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mScrollView = new SGPickerScrollView(context);
        this.mScrollView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mScrollView.setFillViewport(true);
        this.addView((View)this.mScrollView, (ViewGroup.LayoutParams)params);
        this.mScrollView.setOverScrollMode(2);
        this.mScrollView.setVerticalScrollBarEnabled(false);
        RelativeLayout layout = new RelativeLayout(this.mContext);
        this.mScrollView.addView((View)layout);
        this.mLinLayout = new LinearLayout(this.mContext);
        this.mLinLayout.setOrientation(1);
        this.mLinLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        layout.addView((View)this.mLinLayout);
        View highlighter = new View(context);
        highlighter.setBackgroundColor(this.defaultItemTextColor);
        params = new FrameLayout.LayoutParams(-1, 2);
        params.topMargin = this.height / 2 - (int)((float)this.height * 0.12f);
        highlighter.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(highlighter);
        View highlighter2 = new View(context);
        highlighter2.setBackgroundColor(this.defaultItemTextColor);
        params = new FrameLayout.LayoutParams(-1, 2);
        params.topMargin = this.height / 2 + (int)((float)this.height * 0.12f);
        highlighter2.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(highlighter2);
        if (this.debugging) {
            TextView debugLabel = new TextView(this.mContext);
            RelativeLayout.LayoutParams params1 = new RelativeLayout.LayoutParams(-1, 50);
            debugLabel.setLayoutParams((ViewGroup.LayoutParams)params1);
            this.addView((View)debugLabel);
            this.mScrollView.debugLabel = debugLabel;
        }
        TypedArray values = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SGPickerView, 0, 0);
        try {
            this.defaultItemTextColor = values.getColor(R.styleable.SGPickerView_defaultTextColor, this.defaultItemTextColor);
            this.selectedItemTextColor = values.getColor(R.styleable.SGPickerView_selectedTextColor, this.selectedItemTextColor);
        }
        catch (Exception e) {
            // empty catch block
        }
        values.recycle();
    }

    public void setItems(ArrayList<String> items) {
        this.items = items;
        this.mLinLayout.removeAllViews();
        View upperView = new View(this.mContext);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.height / 2 - (int)((float)this.height * 0.12f));
        upperView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mLinLayout.addView(upperView);
        for (int i = 0; i < this.items.size(); ++i) {
            TextView textView = new TextView(this.mContext);
            LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-1, -2);
            textView.setLayoutParams((ViewGroup.LayoutParams)params3);
            textView.setGravity(1);
            textView.setTextSize(0, (float)this.height * 0.17f);
            textView.setTextColor(this.defaultItemTextColor);
            textView.setText((CharSequence)items.get(i));
            this.mLinLayout.addView((View)textView);
        }
        View bottomView = new View(this.mContext);
        bottomView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mLinLayout.addView(bottomView);
        this.mScrollView.scrollToParticularElement = true;
        this.mScrollView.elementIndexToScroll = 0;
        this.mScrollView.currentSelectedIndex = 0;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SGPickerView.this.mScrollView.scrollBy(0, 4);
            }
        }, 100L);
    }

    public int getCurrentSelectedItemIndex() {
        return this.mScrollView.currentSelectedIndex;
    }

    public String getCurrentSelectedItem() {
        return this.items.get(this.getCurrentSelectedItemIndex());
    }

    public void setPickerListener(SGPickerViewListener listener) {
        this.mListener = listener;
    }

    public void setDefaultItemTextColor(int newColor) {
        this.defaultItemTextColor = newColor;
        this.mScrollView.scrollBy(0, 1);
    }

    public void setSelectedItemTextColor(int newColor) {
        this.selectedItemTextColor = newColor;
        this.mScrollView.scrollBy(0, 1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(widthMeasureSpec, this.height);
    }

    private class SGPickerScrollView
    extends ScrollView {
        private int newCheck;
        private boolean innerScrolling;
        public TextView debugLabel;
        public boolean scrollToParticularElement;
        public int elementIndexToScroll;
        public int currentSelectedIndex;
        private Runnable scrollerTask;

        public SGPickerScrollView(Context context) {
            super(context);
            this.newCheck = 400;
            this.scrollToParticularElement = false;
            this.elementIndexToScroll = -1;
            this.currentSelectedIndex = -1;
            this.scrollerTask = new Runnable(){

                @Override
                public void run() {
                    SGPickerScrollView.this.innerScrolling = true;
                    if (SGPickerView.this.debugging) {
                        Log.w((String)"tag", (String)" inner scroll changed to true");
                    }
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (SGPickerView.this.debugging) {
                                Log.w((String)"tag", (String)" inner scroll changed to false");
                            }
                            SGPickerScrollView.this.scrollToParticularElement = true;
                            SGPickerScrollView.this.elementIndexToScroll = SGPickerScrollView.this.currentSelectedIndex;
                            SGPickerView.this.mScrollView.smoothScrollBy(0, 2);
                            SGPickerScrollView.this.changeInnerScrolling();
                        }
                    }, 200L);
                }
            };
            this.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 1) {
                        SGPickerScrollView.this.postDelayed(SGPickerScrollView.this.scrollerTask, SGPickerScrollView.this.newCheck);
                    }
                    return false;
                }
            });
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(widthMeasureSpec, SGPickerView.this.height);
        }

        private void changeInnerScrolling() {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    SGPickerScrollView.this.innerScrolling = false;
                }
            }, 200L);
        }

        public int getMiddle() {
            return this.getScrollY() + SGPickerView.this.height / 2;
        }

        protected void onScrollChanged(int newX, int newY, int oldX, int oldY) {
            super.onScrollChanged(newX, newY, oldX, oldY);
            if (this.innerScrolling || !this.scrollToParticularElement) {
                // empty if block
            }
            RelativeLayout relLayout = (RelativeLayout)this.getChildAt(0);
            LinearLayout linLayout = (LinearLayout)relLayout.getChildAt(0);
            for (int _numChildren = 0; _numChildren < linLayout.getChildCount(); ++_numChildren) {
                View _child = linLayout.getChildAt(_numChildren);
                if (!(_child instanceof TextView)) continue;
                TextView textview = (TextView)_child;
                textview.setTextColor(SGPickerView.this.defaultItemTextColor);
                boolean isCenterField = false;
                if (textview.getTop() < this.getMiddle()) {
                    textview.setTextSize(0, (float)SGPickerView.this.height * 0.19f - (float)(this.getMiddle() - textview.getTop()) / 10.0f);
                    textview.setRotationX((float)(this.getMiddle() - textview.getTop()) * 0.1f);
                    if (this.getMiddle() - (textview.getTop() + textview.getHeight() / 2) < 50) {
                        textview.setTextColor(SGPickerView.this.selectedItemTextColor);
                        textview.invalidate();
                        isCenterField = true;
                    }
                } else {
                    textview.setTextSize(0, (float)SGPickerView.this.height * 0.19f - (float)(textview.getTop() - this.getMiddle()) / 10.0f);
                    textview.setRotationX((float)(textview.getTop() - this.getMiddle()) * -0.1f);
                    if (textview.getTop() + textview.getHeight() / 2 - this.getMiddle() < 50) {
                        textview.setTextColor(SGPickerView.this.selectedItemTextColor);
                        textview.invalidate();
                        isCenterField = true;
                    }
                }
                if (isCenterField) {
                    this.currentSelectedIndex = SGPickerView.this.items.indexOf(textview.getText().toString());
                }
                if (!this.scrollToParticularElement) continue;
                int index = SGPickerView.this.items.indexOf(textview.getText().toString());
                if (!isCenterField) continue;
                if (SGPickerView.this.debugging) {
                    Log.w((String)"tag", (String)("center field " + String.valueOf(textview.getText().toString())));
                    this.debugLabel.setText((CharSequence)String.valueOf(textview.getTop() - this.getMiddle()));
                }
                if (index == this.elementIndexToScroll) {
                    if (textview.getTop() + textview.getHeight() / 2 - this.getMiddle() > 4) {
                        SGPickerView.this.mScrollView.smoothScrollBy(0, 1);
                        continue;
                    }
                    if (this.getMiddle() - (textview.getTop() + textview.getHeight() / 2) > 4) {
                        SGPickerView.this.mScrollView.smoothScrollBy(0, -1);
                        continue;
                    }
                    this.scrollToParticularElement = false;
                    if (SGPickerView.this.mListener == null) continue;
                    SGPickerView.this.mListener.itemSelected(textview.getText().toString(), index);
                    continue;
                }
                if (index < this.elementIndexToScroll) {
                    SGPickerView.this.mScrollView.smoothScrollBy(0, 1);
                    continue;
                }
                SGPickerView.this.mScrollView.smoothScrollBy(0, -1);
            }
        }
    }

    public static interface SGPickerViewListener {
        public void itemSelected(String var1, int var2);
    }
}

