/*
 * Decompiled with CFR 0.152.
 */
package jp.shts.android.storiesprogressview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import java.util.ArrayList;
import java.util.List;
import jp.shts.android.storiesprogressview.R;

public class StoriesProgressView
extends LinearLayout {
    private static final int PROGRESS_MAX = 100;
    private final LinearLayout.LayoutParams PROGRESS_BAR_LAYOUT_PARAM = new LinearLayout.LayoutParams(0, -2, 1.0f);
    private final LinearLayout.LayoutParams SPACE_LAYOUT_PARAM = new LinearLayout.LayoutParams(5, -2);
    private final List<ProgressBar> progressBars = new ArrayList<ProgressBar>();
    private final List<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
    private int storiesCount = -1;
    private int current = 0;
    private StoriesListener storiesListener;

    public StoriesProgressView(Context context) {
        this(context, null);
    }

    public StoriesProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StoriesProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public StoriesProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.setOrientation(0);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StoriesProgressView);
        this.storiesCount = typedArray.getInt(R.styleable.StoriesProgressView_progressCount, 0);
        typedArray.recycle();
        this.bindViews();
    }

    private void bindViews() {
        this.removeAllViews();
        for (int i = 0; i < this.storiesCount; ++i) {
            ProgressBar p = this.createProgressBar();
            p.setMax(100);
            this.progressBars.add(p);
            this.addView((View)p);
            if (i + 1 >= this.storiesCount) continue;
            this.addView(this.createSpace());
        }
    }

    private ProgressBar createProgressBar() {
        ProgressBar p = new ProgressBar(this.getContext(), null, 16842872);
        p.setLayoutParams((ViewGroup.LayoutParams)this.PROGRESS_BAR_LAYOUT_PARAM);
        p.setProgressDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.progress));
        return p;
    }

    private View createSpace() {
        View v = new View(this.getContext());
        v.setLayoutParams((ViewGroup.LayoutParams)this.SPACE_LAYOUT_PARAM);
        return v;
    }

    public void setStoriesCount(int storiesCount) {
        this.storiesCount = storiesCount;
        this.bindViews();
    }

    public void setStoriesListener(StoriesListener storiesListener) {
        this.storiesListener = storiesListener;
    }

    public void skip() {
        ProgressBar p = this.progressBars.get(this.current);
        p.setProgress(p.getMax());
        this.animators.get(this.current).cancel();
    }

    public void setStoryDuration(long duration) {
        this.animators.clear();
        for (int i = 0; i < this.progressBars.size(); ++i) {
            this.animators.add(this.createAnimator(i, duration));
        }
    }

    public void setStoriesCountWithDurations(@NonNull long[] durations) {
        this.storiesCount = durations.length;
        this.bindViews();
        this.animators.clear();
        for (int i = 0; i < this.progressBars.size(); ++i) {
            this.animators.add(this.createAnimator(i, durations[i]));
        }
    }

    public void startStories() {
        this.animators.get(0).start();
    }

    public void destroy() {
        for (ObjectAnimator a : this.animators) {
            a.removeAllListeners();
            a.cancel();
        }
    }

    private ObjectAnimator createAnimator(final int index, long duration) {
        ObjectAnimator animation = ObjectAnimator.ofInt((Object)this.progressBars.get(index), (String)"progress", (int[])new int[]{100});
        animation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animation.setDuration(duration);
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                StoriesProgressView.this.current = index;
            }

            public void onAnimationEnd(Animator animation) {
                animation.removeAllListeners();
                int next = StoriesProgressView.this.current + 1;
                if (next <= StoriesProgressView.this.animators.size() - 1) {
                    if (StoriesProgressView.this.storiesListener != null) {
                        StoriesProgressView.this.storiesListener.onNext();
                    }
                    ((ObjectAnimator)StoriesProgressView.this.animators.get(next)).start();
                } else if (StoriesProgressView.this.storiesListener != null) {
                    StoriesProgressView.this.storiesListener.onComplete();
                }
            }

            public void onAnimationCancel(Animator animation) {
                animation.removeAllListeners();
                int next = StoriesProgressView.this.current + 1;
                if (next <= StoriesProgressView.this.animators.size() - 1) {
                    if (StoriesProgressView.this.storiesListener != null) {
                        StoriesProgressView.this.storiesListener.onNext();
                    }
                    ((ObjectAnimator)StoriesProgressView.this.animators.get(next)).start();
                } else if (StoriesProgressView.this.storiesListener != null) {
                    StoriesProgressView.this.storiesListener.onComplete();
                }
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        return animation;
    }

    public static interface StoriesListener {
        public void onNext();

        public void onComplete();
    }
}

