/*
 * Decompiled with CFR 0.152.
 */
package com.github.shootmoon.xmlconfigmapper.processor;

import com.github.shootmoon.xmlconfigmapper.core.annotation.XmlConfigMapping;
import com.github.shootmoon.xmlconfigmapper.processor.field.AnnotatedClass;
import com.github.shootmoon.xmlconfigmapper.processor.generator.TypeAdapterCodeGenerator;
import com.github.shootmoon.xmlconfigmapper.processor.scan.AnnotationDetector;
import com.github.shootmoon.xmlconfigmapper.processor.scan.AnnotationScanner;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class MappingProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;
    private Elements elements;
    private Types types;
    private AnnotationDetector annotationDetector;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(XmlConfigMapping.class.getCanonicalName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.annotationDetector = new AnnotationDetector(this.elements, this.types);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            AnnotationScanner scanner = new AnnotationScanner(this.annotationDetector);
            Set<? extends Element> configElements = roundEnv.getElementsAnnotatedWith(XmlConfigMapping.class);
            for (Element element : configElements) {
                if (element.getKind() != ElementKind.CLASS || element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                AnnotatedClass clazz = new AnnotatedClass(element);
                scanner.scan(clazz);
                TypeAdapterCodeGenerator generator = new TypeAdapterCodeGenerator(this.filer, this.elements, this.types);
                generator.generateCode(clazz);
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return false;
    }
}

