/*
 * Decompiled with CFR 0.152.
 */
package com.cooltechworks.views.shimmer;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.cooltechworks.views.shimmer.R;
import io.supercharge.shimmerlayout.ShimmerLayout;

public class ShimmerViewHolder
extends RecyclerView.ViewHolder {
    private ShimmerLayout mShimmerLayout;

    public ShimmerViewHolder(LayoutInflater inflater, ViewGroup parent, int innerViewResId) {
        super(inflater.inflate(R.layout.viewholder_shimmer, parent, false));
        this.mShimmerLayout = (ShimmerLayout)this.itemView;
        inflater.inflate(innerViewResId, (ViewGroup)this.mShimmerLayout, true);
    }

    public void setShimmerAngle(int angle) {
        this.mShimmerLayout.setShimmerAngle(angle);
    }

    public void setShimmerColor(int color2) {
        this.mShimmerLayout.setShimmerColor(color2);
    }

    public void setShimmerViewHolderBackground(Drawable viewHolderBackground) {
        if (viewHolderBackground != null) {
            this.setBackground(viewHolderBackground);
        }
    }

    public void setShimmerAnimationDuration(int duration) {
        this.mShimmerLayout.setShimmerAnimationDuration(duration);
    }

    public void bind() {
        this.mShimmerLayout.startShimmerAnimation();
    }

    private void setBackground(Drawable background) {
        if (Build.VERSION.SDK_INT > 16) {
            this.mShimmerLayout.setBackground(background);
        } else {
            this.mShimmerLayout.setBackgroundDrawable(background);
        }
    }
}

