/*
 * Decompiled with CFR 0.152.
 */
package com.shaon2016.propicker.pro_image_picker.image_picker_util;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/shaon2016/propicker/pro_image_picker/image_picker_util/Cropper;", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "(Landroidx/appcompat/app/AppCompatActivity;)V", "mCrop", "", "mCropAspectX", "", "mCropAspectY", "mMaxHeight", "", "mMaxWidth", "cropImage", "", "sourceFile", "Ljava/io/File;", "croppedFile", "isCropEnabled", "startCropUsingUCrop", "Companion", "propicker_release"})
public final class Cropper {
    private final boolean mCrop;
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final float mCropAspectX;
    private final float mCropAspectY;
    private final AppCompatActivity activity;
    @NotNull
    private static final String CROPPED_FILE;
    @NotNull
    private static final String SOURCE_FILE;
    public static final Companion Companion;

    public final boolean isCropEnabled() {
        return this.mCrop;
    }

    public final void startCropUsingUCrop(@NotNull File sourceFile, @NotNull File croppedFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)croppedFile, (String)"croppedFile");
        this.cropImage(sourceFile, croppedFile);
    }

    private final void cropImage(File sourceFile, File croppedFile) {
        UCrop uCrop = UCrop.of((Uri)Uri.fromFile((File)sourceFile), (Uri)Uri.fromFile((File)croppedFile));
        if (this.mCropAspectX > 0.0f && this.mCropAspectY > 0.0f) {
            uCrop.withAspectRatio(this.mCropAspectX, this.mCropAspectY);
        }
        if (this.mMaxWidth > 0 && this.mMaxHeight > 0) {
            uCrop.withMaxResultSize(this.mMaxWidth, this.mMaxHeight);
        }
        uCrop.start((Activity)this.activity, 69);
    }

    public Cropper(@NotNull AppCompatActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        Intent intent = this.activity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"activity.intent");
        Bundle bundle = intent.getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"activity.intent.extras!!");
        Bundle bundle2 = bundle;
        this.mCrop = bundle2.getBoolean("extra.crop", false);
        this.mMaxWidth = bundle2.getInt("extra.max_width", 0);
        this.mMaxHeight = bundle2.getInt("extra.max_height", 0);
        this.mCropAspectX = bundle2.getFloat("extra.crop_x", 0.0f);
        this.mCropAspectY = bundle2.getFloat("extra.crop_y", 0.0f);
    }

    static {
        Companion = new Companion(null);
        CROPPED_FILE = "extras.crop_file";
        SOURCE_FILE = "extras.source_file";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/shaon2016/propicker/pro_image_picker/image_picker_util/Cropper$Companion;", "", "()V", "CROPPED_FILE", "", "getCROPPED_FILE$propicker_release", "()Ljava/lang/String;", "SOURCE_FILE", "getSOURCE_FILE$propicker_release", "propicker_release"})
    public static final class Companion {
        @NotNull
        public final String getCROPPED_FILE$propicker_release() {
            return CROPPED_FILE;
        }

        @NotNull
        public final String getSOURCE_FILE$propicker_release() {
            return SOURCE_FILE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

