/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiGroup;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.ApiReturn;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocPathUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public interface IDocBuildTemplate<T> {
    default public String createDocRenderHeaders(List<ApiReqParam> headers, boolean isAdoc) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isEmpty(headers)) {
            headers = new ArrayList<ApiReqParam>(0);
        }
        for (ApiReqParam header : headers) {
            if (isAdoc) {
                builder.append("|");
            }
            builder.append(header.getName()).append("|").append(header.getType()).append("|").append(header.getDesc()).append("|").append(header.isRequired()).append("|").append(header.getSince()).append("\n");
        }
        return builder.toString();
    }

    default public String paramCommentResolve(String comment) {
        if (StringUtil.isEmpty((String)comment)) {
            comment = "No comments found.";
        } else if (comment.contains("|")) {
            comment = comment.substring(0, comment.indexOf("|"));
        }
        return comment;
    }

    default public void handleApiDoc(JavaClass cls, List<ApiDoc> apiDocList, List<ApiMethodDoc> apiMethodDocs, int order, boolean isUseMD5) {
        String controllerName = cls.getName();
        ApiDoc apiDoc = new ApiDoc();
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        apiDoc.setOrder(order);
        apiDoc.setName(controllerName);
        apiDoc.setAuthor(classAuthor);
        apiDoc.setAlias(controllerName);
        apiDoc.setFolder(true);
        apiDoc.setPackageName(cls.getPackage().getName());
        List classTags = cls.getTagsByName("tag");
        apiDoc.setTags((String[])classTags.stream().map(DocletTag::getValue).toArray(String[]::new));
        if (isUseMD5) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        String desc = DocUtil.getEscapeAndCleanComment(cls.getComment());
        apiDoc.setDesc(desc);
        apiDoc.setList(apiMethodDocs);
        apiDocList.add(apiDoc);
    }

    default public List<ApiDoc> handleApiGroup(List<ApiDoc> apiDocList, ApiConfig apiConfig) {
        if (CollectionUtil.isEmpty(apiDocList) || apiConfig == null) {
            return apiDocList;
        }
        List<ApiGroup> groups = apiConfig.getGroups();
        ArrayList<ApiDoc> finalApiDocs = new ArrayList<ApiDoc>();
        ApiDoc defaultGroup = ApiDoc.buildGroupApiDoc("default");
        AtomicInteger order = new AtomicInteger(1);
        finalApiDocs.add(defaultGroup);
        if (CollectionUtil.isEmpty(groups)) {
            defaultGroup.setOrder(order.getAndIncrement());
            defaultGroup.getChildrenApiDocs().addAll(apiDocList);
            return finalApiDocs;
        }
        HashMap hasInsert = new HashMap();
        for (ApiGroup group2 : groups) {
            ApiDoc groupApiDoc = ApiDoc.buildGroupApiDoc(group2.getName());
            finalApiDocs.add(groupApiDoc);
            for (ApiDoc doc : apiDocList) {
                if (hasInsert.containsKey(doc.getAlias()) || !DocUtil.isMatch(group2.getApis(), doc.getPackageName())) continue;
                hasInsert.put(doc.getAlias(), null);
                groupApiDoc.getChildrenApiDocs().add(doc);
                doc.setOrder(groupApiDoc.getChildrenApiDocs().size());
                doc.setGroup(group2.getName());
                if (StringUtil.isEmpty((String)group2.getPaths())) continue;
                List<ApiMethodDoc> methodDocs = doc.getList().stream().filter(l -> DocPathUtil.matches(l.getPath(), group2.getPaths(), null)).collect(Collectors.toList());
                doc.setList(methodDocs);
            }
        }
        for (ApiDoc doc : apiDocList) {
            String key = doc.getAlias();
            if (hasInsert.containsKey(key)) continue;
            defaultGroup.getChildrenApiDocs().add(doc);
            doc.setOrder(defaultGroup.getChildrenApiDocs().size());
            hasInsert.put(doc.getAlias(), null);
        }
        if (CollectionUtil.isEmpty(defaultGroup.getChildrenApiDocs())) {
            finalApiDocs.remove(defaultGroup);
        }
        finalApiDocs.forEach(group -> group.setOrder(order.getAndIncrement()));
        return finalApiDocs;
    }

    default public List<ApiParam> buildReturnApiParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder projectBuilder) {
        String typeName;
        String responseBodyAdvice;
        JavaMethod method = docJavaMethod.getJavaMethod();
        if (method.getReturns().isVoid() && Objects.isNull(projectBuilder.getApiConfig().getResponseBodyAdvice())) {
            return new ArrayList<ApiParam>(0);
        }
        DocletTag downloadTag = method.getTagByName("download");
        if (Objects.nonNull(downloadTag)) {
            return new ArrayList<ApiParam>(0);
        }
        String returnTypeGenericCanonicalName = method.getReturnType().getGenericCanonicalName();
        if (Objects.nonNull(projectBuilder.getApiConfig().getResponseBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreResponseBodyAdvice")) && !returnTypeGenericCanonicalName.startsWith(responseBodyAdvice = projectBuilder.getApiConfig().getResponseBodyAdvice().getClassName())) {
            returnTypeGenericCanonicalName = new StringBuffer().append(responseBodyAdvice).append("<").append(returnTypeGenericCanonicalName).append(">").toString();
        }
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        ApiReturn apiReturn = DocClassUtil.processReturnType(returnTypeGenericCanonicalName);
        String returnType = apiReturn.getGenericCanonicalName();
        if (Objects.nonNull(actualTypesMap)) {
            for (Map.Entry<String, JavaType> entry : actualTypesMap.entrySet()) {
                returnType = returnType.replace(entry.getKey(), entry.getValue().getCanonicalName());
            }
        }
        if (this.ignoreReturnObject(typeName = apiReturn.getSimpleName(), projectBuilder.getApiConfig().getIgnoreRequestParams())) {
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isPrimitive(typeName)) {
            docJavaMethod.setReturnSchema(OpenApiSchemaUtil.primaryTypeSchema(typeName));
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isCollection(typeName)) {
            if (returnType.contains("<")) {
                String gicName = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    docJavaMethod.setReturnSchema(OpenApiSchemaUtil.arrayTypeSchema(gicName));
                    return new ArrayList<ApiParam>(0);
                }
                return ParamsBuildHelper.buildParams(gicName, "", 0, null, Boolean.TRUE, new HashMap<String, String>(), projectBuilder, null, 0, Boolean.FALSE);
            }
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isMap(typeName)) {
            String[] keyValue = DocClassUtil.getMapKeyValueType(returnType);
            if (keyValue.length == 0) {
                return new ArrayList<ApiParam>(0);
            }
            if (JavaClassValidateUtil.isPrimitive(keyValue[1])) {
                docJavaMethod.setReturnSchema(OpenApiSchemaUtil.mapTypeSchema(keyValue[1]));
                return new ArrayList<ApiParam>(0);
            }
            return ParamsBuildHelper.buildParams(keyValue[1], "", 0, null, Boolean.TRUE, new HashMap<String, String>(), projectBuilder, null, 0, Boolean.FALSE);
        }
        if (StringUtil.isNotEmpty((String)returnType)) {
            return ParamsBuildHelper.buildParams(returnType, "", 0, null, Boolean.TRUE, new HashMap<String, String>(), projectBuilder, null, 0, Boolean.FALSE);
        }
        return new ArrayList<ApiParam>(0);
    }

    default public Set<String> ignoreParamsSets(JavaMethod method) {
        HashSet<String> ignoreSets = new HashSet<String>();
        DocletTag ignoreParam = method.getTagByName("ignoreParams");
        if (Objects.nonNull(ignoreParam)) {
            String[] igParams;
            for (String str : igParams = ignoreParam.getValue().split(" ")) {
                ignoreSets.add(str);
            }
        }
        return ignoreSets;
    }

    public List<T> getApiData(ProjectDocConfigBuilder var1);

    public T getSingleApiData(ProjectDocConfigBuilder var1, String var2);

    public boolean ignoreReturnObject(String var1, List<String> var2);
}

