/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.os.ParcelFileDescriptor;
import org.spatialite.database.SQLiteDatabase;
import org.spatialite.database.SQLiteProgram;

public final class SQLiteStatement
extends SQLiteProgram {
    SQLiteStatement(SQLiteDatabase db, String sql, Object[] bindArgs) {
        super(db, sql, bindArgs, null);
    }

    public void execute() {
        this.acquireReference();
        try {
            this.getSession().execute(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
        }
        catch (SQLiteDatabaseCorruptException ex) {
            this.onCorruption();
            throw ex;
        }
        finally {
            this.releaseReference();
        }
    }

    public int executeUpdateDelete() {
        this.acquireReference();
        try {
            int n = this.getSession().executeForChangedRowCount(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return n;
        }
        catch (SQLiteDatabaseCorruptException ex) {
            this.onCorruption();
            throw ex;
        }
        finally {
            this.releaseReference();
        }
    }

    public long executeInsert() {
        this.acquireReference();
        try {
            long l = this.getSession().executeForLastInsertedRowId(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return l;
        }
        catch (SQLiteDatabaseCorruptException ex) {
            this.onCorruption();
            throw ex;
        }
        finally {
            this.releaseReference();
        }
    }

    public long simpleQueryForLong() {
        this.acquireReference();
        try {
            long l = this.getSession().executeForLong(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return l;
        }
        catch (SQLiteDatabaseCorruptException ex) {
            this.onCorruption();
            throw ex;
        }
        finally {
            this.releaseReference();
        }
    }

    public String simpleQueryForString() {
        this.acquireReference();
        try {
            String string = this.getSession().executeForString(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return string;
        }
        catch (SQLiteDatabaseCorruptException ex) {
            this.onCorruption();
            throw ex;
        }
        finally {
            this.releaseReference();
        }
    }

    public ParcelFileDescriptor simpleQueryForBlobFileDescriptor() {
        this.acquireReference();
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.getSession().executeForBlobFileDescriptor(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return parcelFileDescriptor;
        }
        catch (SQLiteDatabaseCorruptException ex) {
            this.onCorruption();
            throw ex;
        }
        finally {
            this.releaseReference();
        }
    }

    public String toString() {
        return "SQLiteProgram: " + this.getSql();
    }
}

