/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import android.os.SystemClock;
import org.spatialite.database.SQLiteDatabase;
import org.spatialite.database.SQLiteProgram;

public class SQLiteStatement
extends SQLiteProgram {
    SQLiteStatement(SQLiteDatabase db, String sql) {
        super(db, sql);
    }

    public void execute() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            long l = this.mDatabase.lastChangeCount() > 0 ? this.mDatabase.lastInsertRow() : -1L;
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeUpdateDelete() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            long l = this.mDatabase.lastChangeCount();
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long simpleQueryForLong() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            long retValue = this.native_1x1_long();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            long l = retValue;
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simpleQueryForString() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            String retValue = this.native_1x1_string();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            String string = retValue;
            return string;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    private final native void native_execute();

    private final native long native_1x1_long();

    private final native String native_1x1_string();
}

