/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import android.content.res.AssetFileDescriptor;
import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.spatialite.Cursor;
import org.spatialite.database.SQLiteDatabase;

public class SQLiteContentHelper {
    public static AssetFileDescriptor getBlobColumnAsAssetFile(SQLiteDatabase db, String sql, String[] selectionArgs) throws FileNotFoundException {
        ParcelFileDescriptor fd = null;
        try {
            MemoryFile file = SQLiteContentHelper.simpleQueryForBlobMemoryFile(db, sql, selectionArgs);
            if (file == null) {
                throw new FileNotFoundException("No results.");
            }
            Class<?> c = file.getClass();
            try {
                Method m = c.getDeclaredMethod("getParcelFileDescriptor", new Class[0]);
                m.setAccessible(true);
                fd = (ParcelFileDescriptor)m.invoke((Object)file, new Object[0]);
            }
            catch (Exception e) {
                Log.i((String)"SQLiteContentHelper", (String)("SQLiteCursor.java: " + e));
            }
            AssetFileDescriptor afd = new AssetFileDescriptor(fd, 0L, (long)file.length());
            return afd;
        }
        catch (IOException ex) {
            throw new FileNotFoundException(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MemoryFile simpleQueryForBlobMemoryFile(SQLiteDatabase db, String sql, String[] selectionArgs) throws IOException {
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        if (cursor == null) {
            return null;
        }
        try {
            if (!cursor.moveToFirst()) {
                MemoryFile memoryFile = null;
                return memoryFile;
            }
            byte[] bytes = cursor.getBlob(0);
            if (bytes == null) {
                MemoryFile memoryFile = null;
                return memoryFile;
            }
            MemoryFile file = new MemoryFile(null, bytes.length);
            file.writeBytes(bytes, 0, 0, bytes.length);
            MemoryFile memoryFile = file;
            return memoryFile;
        }
        finally {
            cursor.close();
        }
    }
}

