/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import android.util.Log;
import org.spatialite.database.DatabaseObjectNotClosedException;
import org.spatialite.database.SQLiteDatabase;
import org.spatialite.database.SQLiteDebug;

class SQLiteCompiledSql {
    private static final String TAG = "SQLiteCompiledSql";
    SQLiteDatabase mDatabase;
    int nHandle = 0;
    int nStatement = 0;
    private String mSqlStmt = null;
    private Throwable mStackTrace = null;
    private boolean mInUse = false;

    SQLiteCompiledSql(SQLiteDatabase db, String sql) {
        if (!db.isOpen()) {
            throw new IllegalStateException("database " + db.getPath() + " already closed");
        }
        this.mDatabase = db;
        this.mSqlStmt = sql;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.nHandle = db.mNativeHandle;
        this.compile(sql, true);
    }

    private void compile(String sql, boolean forceCompilation) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        if (forceCompilation) {
            this.mDatabase.lock();
            try {
                this.native_compile(sql);
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    void releaseSqlStatement() {
        if (this.nStatement != 0) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v((String)TAG, (String)("closed and deallocated DbObj (id#" + this.nStatement + ")"));
            }
            try {
                this.mDatabase.lock();
                this.native_finalize();
                this.nStatement = 0;
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    synchronized boolean acquire() {
        if (this.mInUse) {
            return false;
        }
        this.mInUse = true;
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v((String)TAG, (String)("Acquired DbObj (id#" + this.nStatement + ") from DB cache"));
        }
        return true;
    }

    synchronized void release() {
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v((String)TAG, (String)("Released DbObj (id#" + this.nStatement + ") back to DB cache"));
        }
        this.mInUse = false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nStatement == 0) {
                return;
            }
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v((String)TAG, (String)("** warning ** Finalized DbObj (id#" + this.nStatement + ")"));
            }
            int len = this.mSqlStmt.length();
            Log.w((String)TAG, (String)("Releasing statement in a finalizer. Please ensure that you explicitly call close() on your cursor: " + this.mSqlStmt.substring(0, len > 100 ? 100 : len)), (Throwable)this.mStackTrace);
            this.releaseSqlStatement();
        }
        finally {
            super.finalize();
        }
    }

    private final native void native_compile(String var1);

    private final native void native_finalize();
}

