/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite.database;

import org.spatialite.database.SQLiteDatabase;
import org.spatialite.database.SQLiteProgram;
import org.spatialite.database.SQLiteQuery;
import org.spatialite.database.SQLiteStatement;

public abstract class SQLiteClosable {
    private int mReferenceCount = 1;
    private Object mLock = new Object();

    protected abstract void onAllReferencesReleased();

    protected void onAllReferencesReleasedFromContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireReference() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReferenceCount <= 0) {
                throw new IllegalStateException("attempt to re-open an already-closed object: " + this.getObjInfo());
            }
            ++this.mReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReference() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleased();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReferenceFromContainer() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleasedFromContainer();
            }
        }
    }

    private String getObjInfo() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getClass().getName());
        buff.append(" (");
        if (this instanceof SQLiteDatabase) {
            buff.append("database = ");
            buff.append(((SQLiteDatabase)this).getPath());
        } else if (this instanceof SQLiteProgram || this instanceof SQLiteStatement || this instanceof SQLiteQuery) {
            buff.append("mSql = ");
            buff.append(((SQLiteProgram)this).mSql);
        }
        buff.append(") ");
        return buff.toString();
    }
}

