/*
 * Decompiled with CFR 0.152.
 */
package org.spatialite;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.HashMap;
import org.spatialite.BulkCursorProxy;
import org.spatialite.CursorWindow;
import org.spatialite.DatabaseUtils;
import org.spatialite.IBulkCursor;
import org.spatialite.IContentObserver;

public abstract class BulkCursorNative
extends Binder
implements IBulkCursor {
    public BulkCursorNative() {
        this.attachInterface(this, "android.content.IBulkCursor");
    }

    public static IBulkCursor asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IBulkCursor in = (IBulkCursor)obj.queryLocalInterface("android.content.IBulkCursor");
        if (in != null) {
            return in;
        }
        return new BulkCursorProxy(obj);
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            switch (code) {
                case 1: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int startPos = data.readInt();
                    CursorWindow window = this.getWindow(startPos);
                    if (window == null) {
                        reply.writeInt(0);
                        return true;
                    }
                    reply.writeNoException();
                    reply.writeInt(1);
                    window.writeToParcel(reply, 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int count = this.count();
                    reply.writeNoException();
                    reply.writeInt(count);
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.content.IBulkCursor");
                    String[] columnNames = this.getColumnNames();
                    reply.writeNoException();
                    reply.writeInt(columnNames.length);
                    int length = columnNames.length;
                    for (int i = 0; i < length; ++i) {
                        reply.writeString(columnNames[i]);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface("android.content.IBulkCursor");
                    this.deactivate();
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface("android.content.IBulkCursor");
                    this.close();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("android.content.IBulkCursor");
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    CursorWindow window = (CursorWindow)((Object)CursorWindow.CREATOR.createFromParcel(data));
                    int count = this.requery(observer, window);
                    reply.writeNoException();
                    reply.writeInt(count);
                    reply.writeBundle(this.getExtras());
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.content.IBulkCursor");
                    HashMap values = data.readHashMap(null);
                    boolean result = this.updateRows(values);
                    reply.writeNoException();
                    reply.writeInt(result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int position = data.readInt();
                    boolean result = this.deleteRow(position);
                    reply.writeNoException();
                    reply.writeInt(result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface("android.content.IBulkCursor");
                    int position = data.readInt();
                    this.onMove(position);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("android.content.IBulkCursor");
                    boolean result = this.getWantsAllOnMoveCalls();
                    reply.writeNoException();
                    reply.writeInt(result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.content.IBulkCursor");
                    Bundle extras = this.getExtras();
                    reply.writeNoException();
                    reply.writeBundle(extras);
                    return true;
                }
                case 11: {
                    data.enforceInterface("android.content.IBulkCursor");
                    Bundle extras = data.readBundle();
                    Bundle returnExtras = this.respond(extras);
                    reply.writeNoException();
                    reply.writeBundle(returnExtras);
                    return true;
                }
            }
        }
        catch (Exception e) {
            DatabaseUtils.writeExceptionToParcel(reply, e);
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    public IBinder asBinder() {
        return this;
    }
}

