/*
 * Decompiled with CFR 0.152.
 */
package org.proj4;

import org.proj4.GridInfo;
import org.proj4.PJException;

public class PJ {
    public static final int DIMENSION_MAX = 100;
    private final long ptr;

    public static native void setDataPath(String var0);

    public static native void setSearchPaths(String[] var0);

    public static native GridInfo readGridInfo(String var0) throws PJException;

    public static native int getGlobalLastErrorCode();

    public static native String getGlobalLastErrorString();

    public static native void clearGlobalLastError();

    public PJ(String definition) throws IllegalArgumentException {
        this.ptr = PJ.allocatePJ(definition);
        if (this.ptr == 0L) {
            throw new IllegalArgumentException(definition);
        }
    }

    public PJ(PJ crs, Type type) throws IllegalArgumentException {
        if (crs == null) {
            throw new NullPointerException("The CRS must be non-null.");
        }
        if (type != Type.GEOGRAPHIC) {
            throw new IllegalArgumentException("Can not derive the " + (Object)((Object)type) + " type.");
        }
        this.ptr = PJ.allocateGeoPJ(crs);
        if (this.ptr == 0L) {
            throw new IllegalArgumentException(crs.getLastError());
        }
    }

    private static native long allocatePJ(String var0);

    private static native long allocateGeoPJ(PJ var0);

    public static native String getVersion();

    public native String getDefinition();

    public native Type getType();

    public native double getSemiMajorAxis();

    public native double getSemiMinorAxis();

    public native double getEccentricitySquared();

    public native char[] getAxisDirections();

    public native double getGreenwichLongitude();

    public native double getLinearUnitToMetre(boolean var1);

    public native void transform(PJ var1, int var2, double[] var3, int var4, int var5) throws PJException;

    public native String getLastError();

    public native String toString();

    protected final native void finalize();

    public static enum Type {
        GEOGRAPHIC,
        GEOCENTRIC,
        PROJECTED;

    }
}

