/*
 * Decompiled with CFR 0.152.
 */
package com.github.sett4.dataformat.xlsx;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.github.sett4.dataformat.xlsx.impl.XlsxWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Logger;

public class XlsxGenerator
extends GeneratorBase {
    Logger log = Logger.getLogger(XlsxGenerator.class.getCanonicalName());
    private final int xlsxFeatures;
    private CsvSchema _schema;
    private final XlsxWriter _writer;
    protected boolean _handleFirstLine = true;
    protected int _nextColumnByName = -1;
    protected boolean _skipValue;
    protected String _arraySeparator = "";
    protected StringBuilder _arrayContents;
    protected int _arrayElements;
    protected JsonWriteContext _skipWithin;

    public XlsxGenerator(IOContext ioCtxt, int generatorFeatures, int xlsxFeatures, ObjectCodec codec, OutputStream out, CsvSchema schema) {
        super(generatorFeatures, codec);
        this.xlsxFeatures = xlsxFeatures;
        this._writer = new XlsxWriter(out);
        this._schema = schema;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public XlsxGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public XlsxGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer.getOutputTarget();
    }

    public void setSchema(FormatSchema schema) {
        if (schema instanceof CsvSchema) {
            if (this._schema != schema) {
                this._schema = (CsvSchema)schema;
            }
        } else {
            super.setSchema(schema);
        }
    }

    public int getFormatFeatures() {
        return this.xlsxFeatures;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public boolean canOmitFields() {
        return false;
    }

    public boolean canWriteFormattedNumbers() {
        return true;
    }

    public void flush() throws IOException {
        this.log.fine("flush");
    }

    public void close() throws IOException {
        this.log.fine("close");
        super.close();
        this.finishRow();
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
        this._writer.close();
    }

    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        if (this._writeContext.inObject()) {
            if (this._skipWithin == null && this._skipValue && this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipWithin = this._writeContext;
            } else if (!this._skipValue) {
                CsvSchema.Column col;
                String sep = this._nextColumnByName >= 0 ? ((col = this._schema.column(this._nextColumnByName)).isArray() ? col.getArrayElementSeparator() : "") : "";
                if (sep.isEmpty()) {
                    if (!this._schema.hasArrayElementSeparator()) {
                        this._reportError("XLSX generator does not support Array values for properties without setting 'arrayElementSeparator' in schema");
                    }
                    sep = this._schema.getArrayElementSeparator();
                }
                this._arraySeparator = sep;
                if (this._arrayContents == null) {
                    this._arrayContents = new StringBuilder();
                } else {
                    this._arrayContents.setLength(0);
                }
                this._arrayElements = 0;
            }
        } else if (!this._arraySeparator.isEmpty()) {
            this._reportError("XSLX generator does not support nested Array values");
        }
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._skipWithin != null) {
            if (this._writeContext == this._skipWithin) {
                this._skipWithin = null;
            }
            return;
        }
        if (!this._arraySeparator.isEmpty()) {
            this._arraySeparator = "";
            this._writer.write(this._columnIndex(), this._arrayContents.toString());
        }
        if (!this._writeContext.inObject()) {
            this.finishRow();
        }
    }

    public final void writeStartObject() throws IOException {
        this.log.fine("writeStartObject");
        this._verifyValueWrite("start an object");
        if ((this._writeContext.inObject() || this._writeContext.inArray() && !this._writeContext.getParent().inRoot()) && this._skipWithin == null) {
            if (this._skipValue && this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipWithin = this._writeContext;
            } else {
                this._reportMappingError("CSV generator does not support Object values for properties (nested Objects)");
            }
        }
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() throws IOException {
        this.log.fine("writeEndObject");
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._skipWithin != null) {
            if (this._writeContext == this._skipWithin) {
                this._skipWithin = null;
            }
            return;
        }
        this.finishRow();
    }

    protected void finishRow() throws IOException {
        this.log.fine("finishRow");
        this._writer.endRow();
        this._nextColumnByName = -1;
    }

    public void writeFieldName(String name) throws IOException {
        this.log.fine("writeFieldName: " + name);
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    public final void writeFieldName(SerializableString name) throws IOException {
        this.log.fine("writeFieldName: " + name);
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name.getValue());
    }

    public final void writeStringField(String fieldName, String value) throws IOException {
        this.log.fine("writeStringField");
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    private void _writeFieldName(String name) throws IOException {
        if (this._schema == null) {
            this._reportMappingError("Unrecognized column '" + name + "', can not resolve without CsvSchema");
        }
        if (this._skipWithin != null) {
            this._skipValue = true;
            this._nextColumnByName = -1;
            return;
        }
        CsvSchema.Column col = this._schema.column(name, this._nextColumnByName + 1);
        if (col == null) {
            if (this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                this._skipValue = true;
                this._nextColumnByName = -1;
                return;
            }
            this._reportMappingError("Unrecognized column '" + name + "': known columns: " + this._schema.getColumnDesc());
        }
        this._skipValue = false;
        this._nextColumnByName = col.getIndex();
    }

    public void writeString(String text) throws IOException {
        this.log.fine("writeString");
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(text);
            } else {
                this._writer.write(this._columnIndex(), text);
            }
        }
    }

    public void writeString(char[] chars, int i, int i1) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    public void writeRawUTF8String(byte[] bytes, int i, int i1) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    public void writeUTF8String(byte[] bytes, int i, int i1) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    public void writeRaw(String text) throws IOException {
        this._writer.write(this._columnIndex(), text);
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    public void writeRaw(char c) throws IOException {
        this._writer.write(this._columnIndex(), c);
    }

    public void writeRawValue(String text) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.write(this._columnIndex(), text);
        }
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.write(this._columnIndex(), text.substring(offset, offset + len));
        }
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.write(this._columnIndex(), new String(text, offset, len));
        }
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        this.log.fine("writeRaw");
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (!this._skipValue) {
            if (offset > 0 || offset + len != data.length) {
                data = Arrays.copyOfRange(data, offset, offset + len);
            }
            String encoded = b64variant.encode(data);
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(encoded);
            } else {
                this._writer.write(this._columnIndex(), encoded);
            }
        }
    }

    public void writeNumber(int v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(long v) throws IOException {
        if (v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            this.writeNumber((int)v);
        } else {
            this._verifyValueWrite("write number");
            if (!this._skipValue) {
                if (!this._arraySeparator.isEmpty()) {
                    this._addToArray(String.valueOf(v));
                } else {
                    this._writer.write(this._columnIndex(), v);
                }
            }
        }
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write number");
            if (!this._skipValue) {
                if (!this._arraySeparator.isEmpty()) {
                    this._addToArray(String.valueOf(v));
                } else {
                    this._writer.write(this._columnIndex(), v.doubleValue());
                }
            }
        }
    }

    public void writeNumber(double v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(float v) throws IOException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
    }

    public void writeNumber(BigDecimal v) throws IOException {
        if (v == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write number");
            if (!this._skipValue) {
                if (this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN)) {
                    String str;
                    String string = str = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN) ? v.toPlainString() : v.toString();
                    if (!this._arraySeparator.isEmpty()) {
                        this._addToArray(String.valueOf(v));
                    } else {
                        this._writer.write(this._columnIndex(), str);
                    }
                } else {
                    this._writer.write(this._columnIndex(), v.doubleValue());
                }
            }
        }
    }

    public void writeNumber(String encodedValue) throws IOException {
        if (encodedValue == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write number");
            if (!this._skipValue) {
                if (!this._arraySeparator.isEmpty()) {
                    this._addToArray(encodedValue);
                } else {
                    this._writer.write(this._columnIndex(), encodedValue);
                }
            }
        }
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(state ? "true" : "false");
            } else {
                this._writer.write(this._columnIndex(), state);
            }
        }
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(this._schema.getNullValueOrEmpty());
            } else if (this._writeContext.inObject()) {
                this._writer.writeNull(this._columnIndex());
            } else if (this._writeContext.inArray() && !this._writeContext.getParent().inRoot()) {
                this._writer.writeNull(this._columnIndex());
            }
        }
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
    }

    protected void _handleFirstLine() throws IOException {
        this._handleFirstLine = false;
        if (this._schema.usesHeader()) {
            int count = this._schema.size();
            if (count == 0) {
                this._reportMappingError("Schema specified that header line is to be written; but contains no column names");
            }
            for (CsvSchema.Column column : this._schema) {
                this._writer.writeColumnName(column.getName(), column.getIndex());
            }
            this.finishRow();
        }
    }

    protected void _reportMappingError(String msg) throws JsonProcessingException {
        throw new JsonGenerationException(msg, (JsonGenerator)this);
    }

    protected final int _columnIndex() {
        int ix = this._nextColumnByName;
        if (ix < 0) {
            ix = this._writer.nextColumnIndex();
        }
        return ix;
    }

    protected void _addToArray(String value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append(this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }

    protected void _addToArray(char[] value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append(this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }
}

