/*
 * Decompiled with CFR 0.152.
 */
package com.github.sett4.dataformat.xlsx;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.github.sett4.dataformat.xlsx.PackageVersion;
import com.github.sett4.dataformat.xlsx.XlsxGenerator;
import com.github.sett4.dataformat.xlsx.XlsxParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;

public class XlsxFactory
extends JsonFactory
implements Serializable {
    public static final String FORMAT_NAME_XLSX = "XLSX";
    protected static final CsvSchema DEFAULT_SCHEMA = CsvSchema.emptySchema();
    private static final long serialVersionUID = 1L;
    protected CsvSchema _schema;

    public XlsxFactory() {
    }

    public XlsxFactory(ObjectCodec oc) {
        super(oc);
    }

    protected XlsxFactory(XlsxFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._schema = src._schema;
    }

    public XlsxFactory copy() {
        this._checkInvalidCopy(XlsxFactory.class);
        return new XlsxFactory(this, null);
    }

    protected Object readResolve() {
        return new XlsxFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return true;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_XLSX;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public Class<CsvParser.Feature> getFormatReadFeatureType() {
        return CsvParser.Feature.class;
    }

    public Class<CsvGenerator.Feature> getFormatWriteFeatureType() {
        return CsvGenerator.Feature.class;
    }

    public XlsxParser createParser(File f) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(f), true);
        return this._createParser(this._decorate(new FileInputStream(f), ctxt), ctxt);
    }

    public XlsxParser createParser(URL url) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(url), true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(url), ctxt), ctxt);
    }

    public XlsxParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(in), true);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    public XlsxParser createParser(Reader r) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(r), true);
        return this._createParser(this._decorate(r, ctxt), ctxt);
    }

    public XlsxParser createParser(String doc) throws IOException {
        return (XlsxParser)super.createParser(doc);
    }

    public XlsxParser createParser(byte[] data) throws IOException {
        return (XlsxParser)super.createParser(data);
    }

    public XlsxParser createParser(byte[] data, int offset, int len) throws IOException {
        return (XlsxParser)super.createParser(data, offset, len);
    }

    public XlsxParser createParser(char[] data) throws IOException {
        return (XlsxParser)super.createParser(data);
    }

    public CsvParser createParser(char[] data, int offset, int len) throws IOException {
        return (CsvParser)super.createParser(data, offset, len);
    }

    protected XlsxParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    protected XlsxParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    protected XlsxParser _createParser(Reader r, IOContext ctxt) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    protected XlsxParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    protected XlsxGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    protected XlsxGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(ctxt, out);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    protected IOContext _createContext(ContentReference contentRef, boolean resourceManaged) {
        return new IOContext(this._getBufferRecycler(), contentRef, resourceManaged);
    }

    private XlsxGenerator _createGenerator(IOContext ctxt, OutputStream out) throws IOException {
        XlsxGenerator gen = new XlsxGenerator(ctxt, this._generatorFeatures, -1, this._objectCodec, out, this._schema);
        return gen;
    }
}

