/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.xtooltip;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.core.util.ObjectsCompat;
import it.sephiroth.android.library.xtooltip.R;
import it.sephiroth.android.library.xtooltip.Tooltip;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002JP\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\nH\u0016J\b\u0010+\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.H\u0017J\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0010H\u0014J\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\nH\u0016J \u00103\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u00104\u001a\u00020\u001c2\b\u00105\u001a\u0004\u0018\u000106H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lit/sephiroth/android/library/xtooltip/TooltipTextDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "builder", "Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;", "(Landroid/content/Context;Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;)V", "arrowRatio", "", "arrowWeight", "", "bgPaint", "Landroid/graphics/Paint;", "gravity", "Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;", "outlineRect", "Landroid/graphics/Rect;", "padding", "path", "Landroid/graphics/Path;", "point", "Landroid/graphics/Point;", "radius", "rectF", "Landroid/graphics/RectF;", "stPaint", "tmpPoint", "calculatePath", "", "outBounds", "calculatePathWithGravity", "left", "top", "right", "bottom", "maxY", "maxX", "minY", "minX", "draw", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "getOpacity", "getOutline", "outline", "Landroid/graphics/Outline;", "onBoundsChange", "bounds", "setAlpha", "alpha", "setAnchor", "setColorFilter", "cf", "Landroid/graphics/ColorFilter;", "Companion", "xtooltip_release"})
public final class TooltipTextDrawable
extends Drawable {
    private final RectF rectF;
    private final Path path;
    private final Point tmpPoint;
    private final Rect outlineRect;
    private final Paint bgPaint;
    private final Paint stPaint;
    private final float arrowRatio;
    private final float radius;
    private Point point;
    private int padding;
    private int arrowWeight;
    private Tooltip.Gravity gravity;
    public static final float ARROW_RATIO_DEFAULT = 1.4f;
    public static final Companion Companion = new Companion(null);

    public void draw(@NotNull Canvas canvas) {
        block1: {
            Paint it;
            Paint paint;
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Paint paint2 = this.bgPaint;
            if (paint2 != null) {
                it = paint = paint2;
                canvas.drawPath(this.path, it);
            }
            Paint paint3 = this.stPaint;
            if (paint3 == null) break block1;
            it = paint = paint3;
            canvas.drawPath(this.path, it);
        }
    }

    public final void setAnchor(@NotNull Tooltip.Gravity gravity, int padding, @Nullable Point point) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)gravity), (String)"gravity");
        if (gravity != this.gravity || padding != this.padding || !ObjectsCompat.equals((Object)this.point, (Object)point)) {
            this.gravity = gravity;
            this.padding = padding;
            this.arrowWeight = (int)((float)padding / this.arrowRatio);
            Point point2 = point;
            if (point2 != null) {
                Point point3;
                Point it = point3 = point2;
                this.point = new Point(it);
            } else {
                TooltipTextDrawable tooltipTextDrawable;
                TooltipTextDrawable $receiver = tooltipTextDrawable = this;
                $receiver.point = null;
            }
            Rect rect = this.getBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
            if (!rect.isEmpty()) {
                Rect rect2 = this.getBounds();
                Intrinsics.checkExpressionValueIsNotNull((Object)rect2, (String)"bounds");
                this.calculatePath(rect2);
                this.invalidateSelf();
            }
        }
    }

    private final void calculatePath(Rect outBounds) {
        int left = outBounds.left + this.padding;
        int top = outBounds.top + this.padding;
        int right = outBounds.right - this.padding;
        int bottom = outBounds.bottom - this.padding;
        float maxY = (float)bottom - this.radius;
        float maxX = (float)right - this.radius;
        float minY = (float)top + this.radius;
        float minX = (float)left + this.radius;
        if (this.point != null && this.gravity != null) {
            this.calculatePathWithGravity(outBounds, left, top, right, bottom, maxY, maxX, minY, minX);
        } else {
            this.rectF.set((float)left, (float)top, (float)right, (float)bottom);
            this.path.addRoundRect(this.rectF, this.radius, this.radius, Path.Direction.CW);
        }
    }

    private final void calculatePathWithGravity(Rect outBounds, int left, int top, int right, int bottom, float maxY, float maxX, float minY, float minX) {
        Point point = this.point;
        if (point == null) {
            Intrinsics.throwNpe();
        }
        boolean drawPoint = TooltipTextDrawable.Companion.isDrawPoint(left, top, right, bottom, maxY, maxX, minY, minX, this.tmpPoint, point, this.gravity, this.arrowWeight);
        Timber.v((String)("drawPoint: " + drawPoint), (Object[])new Object[0]);
        TooltipTextDrawable.Companion.clampPoint(left, top, right, bottom, this.tmpPoint);
        this.path.reset();
        this.path.moveTo((float)left + this.radius, (float)top);
        if (drawPoint && this.gravity == Tooltip.Gravity.BOTTOM) {
            this.path.lineTo((float)(left + this.tmpPoint.x - this.arrowWeight), (float)top);
            this.path.lineTo((float)(left + this.tmpPoint.x), (float)outBounds.top);
            this.path.lineTo((float)(left + this.tmpPoint.x + this.arrowWeight), (float)top);
        }
        this.path.lineTo((float)right - this.radius, (float)top);
        this.path.quadTo((float)right, (float)top, (float)right, (float)top + this.radius);
        if (drawPoint && this.gravity == Tooltip.Gravity.LEFT) {
            this.path.lineTo((float)right, (float)(top + this.tmpPoint.y - this.arrowWeight));
            this.path.lineTo((float)outBounds.right, (float)(top + this.tmpPoint.y));
            this.path.lineTo((float)right, (float)(top + this.tmpPoint.y + this.arrowWeight));
        }
        this.path.lineTo((float)right, (float)bottom - this.radius);
        this.path.quadTo((float)right, (float)bottom, (float)right - this.radius, (float)bottom);
        if (drawPoint && this.gravity == Tooltip.Gravity.TOP) {
            this.path.lineTo((float)(left + this.tmpPoint.x + this.arrowWeight), (float)bottom);
            this.path.lineTo((float)(left + this.tmpPoint.x), (float)outBounds.bottom);
            this.path.lineTo((float)(left + this.tmpPoint.x - this.arrowWeight), (float)bottom);
        }
        this.path.lineTo((float)left + this.radius, (float)bottom);
        this.path.quadTo((float)left, (float)bottom, (float)left, (float)bottom - this.radius);
        if (drawPoint && this.gravity == Tooltip.Gravity.RIGHT) {
            this.path.lineTo((float)left, (float)(top + this.tmpPoint.y + this.arrowWeight));
            this.path.lineTo((float)outBounds.left, (float)(top + this.tmpPoint.y));
            this.path.lineTo((float)left, (float)(top + this.tmpPoint.y - this.arrowWeight));
        }
        this.path.lineTo((float)left, (float)top + this.radius);
        this.path.quadTo((float)left, (float)top, (float)left + this.radius, (float)top);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.calculatePath(bounds);
    }

    public int getAlpha() {
        int n;
        Paint paint = this.bgPaint;
        if (paint != null) {
            n = paint.getAlpha();
        } else {
            TooltipTextDrawable tooltipTextDrawable;
            TooltipTextDrawable $receiver = tooltipTextDrawable = this;
            n = 0;
        }
        return n;
    }

    public void setAlpha(int alpha) {
        block1: {
            Paint paint = this.bgPaint;
            if (paint != null) {
                paint.setAlpha(alpha);
            }
            Paint paint2 = this.stPaint;
            if (paint2 == null) break block1;
            paint2.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    @TargetApi(value=21)
    public void getOutline(@NotNull Outline outline) {
        Intrinsics.checkParameterIsNotNull((Object)outline, (String)"outline");
        this.copyBounds(this.outlineRect);
        this.outlineRect.inset(this.padding, this.padding);
        outline.setRoundRect(this.outlineRect, this.radius);
        if (this.getAlpha() < 255) {
            outline.setAlpha(0.0f);
        }
    }

    public TooltipTextDrawable(@NotNull Context context, @NotNull Tooltip.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.tmpPoint = new Point();
        this.outlineRect = new Rect();
        TypedArray theme = context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.getDefStyleAttr$xtooltip_release(), builder.getDefStyleRes$xtooltip_release());
        this.radius = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_cornerRadius, 4);
        int strokeWidth = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_strokeWeight, 2);
        int backgroundColor = theme.getColor(R.styleable.TooltipLayout_ttlm_backgroundColor, 0);
        int strokeColor = theme.getColor(R.styleable.TooltipLayout_ttlm_strokeColor, 0);
        this.arrowRatio = theme.getFloat(R.styleable.TooltipLayout_ttlm_arrowRatio, 1.4f);
        theme.recycle();
        this.rectF = new RectF();
        if (backgroundColor != 0) {
            this.bgPaint = new Paint(1);
            this.bgPaint.setColor(backgroundColor);
            this.bgPaint.setStyle(Paint.Style.FILL);
        } else {
            this.bgPaint = null;
        }
        if (strokeColor != 0) {
            this.stPaint = new Paint(1);
            this.stPaint.setColor(strokeColor);
            this.stPaint.setStyle(Paint.Style.STROKE);
            this.stPaint.setStrokeWidth((float)strokeWidth);
        } else {
            this.stPaint = null;
        }
        this.path = new Path();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002Jj\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lit/sephiroth/android/library/xtooltip/TooltipTextDrawable$Companion;", "", "()V", "ARROW_RATIO_DEFAULT", "", "clampPoint", "", "left", "", "top", "right", "bottom", "tmpPoint", "Landroid/graphics/Point;", "isDrawPoint", "", "maxY", "maxX", "minY", "minX", "point", "gravity", "Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;", "arrowWeight", "xtooltip_release"})
    public static final class Companion {
        private final boolean isDrawPoint(int left, int top, int right, int bottom, float maxY, float maxX, float minY, float minX, Point tmpPoint, Point point, Tooltip.Gravity gravity, int arrowWeight) {
            Timber.i((String)("isDrawPoint: " + left + ", " + top + ", " + right + ", " + bottom + ", " + maxX + ", " + maxY + ", " + minX + ", " + minY + ", " + point + ", " + arrowWeight), (Object[])new Object[0]);
            boolean drawPoint = false;
            tmpPoint.set(point.x, point.y);
            if (gravity == Tooltip.Gravity.RIGHT || gravity == Tooltip.Gravity.LEFT) {
                int n = tmpPoint.y;
                if (top <= n && bottom >= n) {
                    if ((float)(top + tmpPoint.y + arrowWeight) > maxY) {
                        tmpPoint.y = (int)(maxY - (float)arrowWeight - (float)top);
                    } else if ((float)(top + tmpPoint.y - arrowWeight) < minY) {
                        tmpPoint.y = (int)(minY + (float)arrowWeight - (float)top);
                    }
                    drawPoint = true;
                }
            } else {
                int n = tmpPoint.x;
                if (left <= n && right >= n && left <= (n = tmpPoint.x) && right >= n) {
                    if ((float)(left + tmpPoint.x + arrowWeight) > maxX) {
                        tmpPoint.x = (int)(maxX - (float)arrowWeight - (float)left);
                    } else if ((float)(left + tmpPoint.x - arrowWeight) < minX) {
                        tmpPoint.x = (int)(minX + (float)arrowWeight - (float)left);
                    }
                    drawPoint = true;
                }
            }
            return drawPoint;
        }

        private final void clampPoint(int left, int top, int right, int bottom, Point tmpPoint) {
            if (tmpPoint.y < top) {
                tmpPoint.y = top;
            } else if (tmpPoint.y > bottom) {
                tmpPoint.y = bottom;
            }
            if (tmpPoint.x < left) {
                tmpPoint.x = left;
            }
            if (tmpPoint.x > right) {
                tmpPoint.x = right;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

