/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Html;
import android.text.TextUtils;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.TextView;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.TooltipOverlay;
import it.sephiroth.android.library.tooltip.TooltipTextDrawable;
import it.sephiroth.android.library.tooltip.Typefaces;
import it.sephiroth.android.library.tooltip.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Tooltip {
    public static boolean dbg = false;

    private Tooltip() {
    }

    public static TooltipView make(Context context, Builder builder) {
        return new TooltipViewImpl(context, builder);
    }

    public static boolean remove(Context context, int tooltipId) {
        Activity act = Utils.getActivity(context);
        if (act != null) {
            ViewGroup rootView = (ViewGroup)act.getWindow().getDecorView();
            for (int i = 0; i < rootView.getChildCount(); ++i) {
                View child = rootView.getChildAt(i);
                if (!(child instanceof TooltipView) || ((TooltipView)child).getTooltipId() != tooltipId) continue;
                Utils.log("Tooltip", 2, "removing: %d", ((TooltipView)child).getTooltipId());
                ((TooltipView)child).remove();
                return true;
            }
        }
        return false;
    }

    public static boolean removeAll(Context context) {
        Activity act = Utils.getActivity(context);
        if (act != null) {
            ViewGroup rootView = (ViewGroup)act.getWindow().getDecorView();
            for (int i = rootView.getChildCount() - 1; i >= 0; --i) {
                View child = rootView.getChildAt(i);
                if (!(child instanceof TooltipView)) continue;
                Utils.log("Tooltip", 2, "removing: %d", ((TooltipView)child).getTooltipId());
                ((TooltipView)child).remove();
            }
        }
        return false;
    }

    public static final class Builder {
        private static int sNextId = 0;
        int id;
        CharSequence text;
        View view;
        Gravity gravity;
        int actionbarSize = 0;
        int textResId = R.layout.tooltip_textview;
        int closePolicy = 0;
        long showDuration;
        Point point;
        long showDelay = 0L;
        boolean hideArrow;
        int maxWidth = -1;
        int defStyleRes = R.style.ToolTipLayoutDefaultStyle;
        int defStyleAttr = R.attr.ttlm_defaultStyle;
        long activateDelay = 0L;
        boolean isCustomView;
        boolean restrictToScreenEdges = true;
        long fadeDuration = 200L;
        Callback closeCallback;
        boolean completed;
        boolean overlay = true;
        AnimationBuilder floatingAnimation;
        Typeface typeface;

        public Builder(int id2) {
            this.id = id2;
        }

        public Builder() {
            this.id = sNextId++;
        }

        public Builder withCustomView(int resId) {
            this.throwIfCompleted();
            return this.withCustomView(resId, true);
        }

        private void throwIfCompleted() {
            if (this.completed) {
                throw new IllegalStateException("Builder cannot be modified");
            }
        }

        public Builder withCustomView(int resId, boolean replaceBackground) {
            this.textResId = resId;
            this.isCustomView = replaceBackground;
            return this;
        }

        public Builder withStyleId(int styleId) {
            this.throwIfCompleted();
            this.defStyleAttr = 0;
            this.defStyleRes = styleId;
            return this;
        }

        public Builder fitToScreen(boolean value) {
            this.throwIfCompleted();
            this.restrictToScreenEdges = value;
            return this;
        }

        public Builder fadeDuration(long ms) {
            this.throwIfCompleted();
            this.fadeDuration = ms;
            return this;
        }

        public Builder withCallback(Callback callback) {
            this.throwIfCompleted();
            this.closeCallback = callback;
            return this;
        }

        public Builder text(Resources res, @StringRes int resId) {
            return this.text(res.getString(resId));
        }

        public Builder text(CharSequence text) {
            this.throwIfCompleted();
            this.text = text;
            return this;
        }

        public Builder typeface(Typeface typeface) {
            this.throwIfCompleted();
            this.typeface = typeface;
            return this;
        }

        public Builder maxWidth(Resources res, @DimenRes int dimension) {
            return this.maxWidth(res.getDimensionPixelSize(dimension));
        }

        public Builder maxWidth(int maxWidth) {
            this.throwIfCompleted();
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder floatingAnimation(AnimationBuilder builder) {
            this.throwIfCompleted();
            this.floatingAnimation = builder;
            return this;
        }

        public Builder withOverlay(boolean value) {
            this.throwIfCompleted();
            this.overlay = value;
            return this;
        }

        public Builder anchor(View view, Gravity gravity) {
            this.throwIfCompleted();
            this.point = null;
            this.view = view;
            this.gravity = gravity;
            return this;
        }

        public Builder anchor(Point point, Gravity gravity) {
            this.throwIfCompleted();
            this.view = null;
            this.point = new Point(point);
            this.gravity = gravity;
            return this;
        }

        @Deprecated
        public Builder toggleArrow(boolean show) {
            return this.withArrow(show);
        }

        public Builder withArrow(boolean show) {
            this.throwIfCompleted();
            this.hideArrow = !show;
            return this;
        }

        public Builder actionBarSize(Resources resources, int resId) {
            return this.actionBarSize(resources.getDimensionPixelSize(resId));
        }

        public Builder actionBarSize(int actionBarSize) {
            this.throwIfCompleted();
            this.actionbarSize = actionBarSize;
            return this;
        }

        public Builder closePolicy(ClosePolicy policy, long milliseconds) {
            this.throwIfCompleted();
            this.closePolicy = policy.build();
            this.showDuration = milliseconds;
            return this;
        }

        public Builder activateDelay(long ms) {
            this.throwIfCompleted();
            this.activateDelay = ms;
            return this;
        }

        public Builder showDelay(long ms) {
            this.throwIfCompleted();
            this.showDelay = ms;
            return this;
        }

        public Builder build() {
            this.throwIfCompleted();
            if (this.floatingAnimation != null && !this.floatingAnimation.completed) {
                throw new IllegalStateException("Builder not closed");
            }
            this.completed = true;
            this.overlay = this.overlay && this.gravity != Gravity.CENTER;
            return this;
        }
    }

    public static final class AnimationBuilder {
        int radius = 8;
        int direction = 0;
        long duration = 400L;
        boolean completed;
        public static final AnimationBuilder DEFAULT = new AnimationBuilder().build();
        public static final AnimationBuilder SLOW = new AnimationBuilder().setDuration(600L).setRadius(4).build();

        public AnimationBuilder setRadius(int value) {
            this.throwIfCompleted();
            this.radius = value;
            return this;
        }

        private void throwIfCompleted() {
            if (this.completed) {
                throw new IllegalStateException("Builder cannot be modified");
            }
        }

        public AnimationBuilder setDirection(int value) {
            this.throwIfCompleted();
            this.direction = value;
            return this;
        }

        public AnimationBuilder setDuration(long value) {
            this.throwIfCompleted();
            this.duration = value;
            return this;
        }

        public AnimationBuilder build() {
            this.throwIfCompleted();
            this.completed = true;
            return this;
        }
    }

    @SuppressLint(value={"ViewConstructor"})
    static class TooltipViewImpl
    extends ViewGroup
    implements TooltipView {
        public static final int TOLERANCE_VALUE = 10;
        private static final String TAG = "TooltipView";
        private static final List<Gravity> GRAVITY_LIST = new ArrayList<Gravity>(Arrays.asList(Gravity.LEFT, Gravity.RIGHT, Gravity.TOP, Gravity.BOTTOM, Gravity.CENTER));
        private final List<Gravity> viewGravities = new ArrayList<Gravity>(GRAVITY_LIST);
        private final long mShowDelay;
        private final int mTextAppearance;
        private final int mTextGravity;
        private final int mToolTipId;
        private final Rect mDrawRect;
        private final long mShowDuration;
        private final int mClosePolicy;
        private final Point mPoint;
        private final int mTextResId;
        private final int mTopRule;
        private final int mMaxWidth;
        private final boolean mHideArrow;
        private final long mActivateDelay;
        private final boolean mRestrict;
        private final long mFadeDuration;
        private final TooltipTextDrawable mDrawable;
        private final Rect mTempRect = new Rect();
        private final int[] mTempLocation = new int[2];
        private final Handler mHandler = new Handler();
        private final Rect mScreenRect = new Rect();
        private final Point mTmpPoint = new Point();
        private final Rect mHitRect = new Rect();
        private final float mTextViewElevation;
        private Callback mCallback;
        private int[] mOldLocation;
        private Gravity mGravity;
        private Animator mShowAnimation;
        private boolean mShowing;
        private WeakReference<View> mViewAnchor;
        private boolean mAttached;
        private final View.OnAttachStateChangeListener mAttachedStateListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            @TargetApi(value=17)
            public void onViewDetachedFromWindow(View v) {
                Utils.log(TooltipViewImpl.TAG, 4, "[%d] onViewDetachedFromWindow", TooltipViewImpl.this.mToolTipId);
                TooltipViewImpl.this.removeViewListeners(v);
                if (!TooltipViewImpl.this.mAttached) {
                    return;
                }
                Activity activity = Utils.getActivity(TooltipViewImpl.this.getContext());
                if (null != activity) {
                    if (activity.isFinishing()) {
                        Utils.log(TooltipViewImpl.TAG, 5, "[%d] skipped because activity is finishing...", TooltipViewImpl.this.mToolTipId);
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                        return;
                    }
                    TooltipViewImpl.this.onClose(false, false, true);
                }
            }
        };
        private Runnable hideRunnable = new Runnable(){

            @Override
            public void run() {
                TooltipViewImpl.this.onClose(false, false, false);
            }
        };
        private boolean mInitialized;
        private boolean mActivated;
        Runnable activateRunnable = new Runnable(){

            @Override
            public void run() {
                TooltipViewImpl.this.mActivated = true;
            }
        };
        private int mPadding;
        private CharSequence mText;
        private Rect mViewRect;
        private View mView;
        private TooltipOverlay mViewOverlay;
        private final ViewTreeObserver.OnPreDrawListener mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                View view;
                if (!TooltipViewImpl.this.mAttached) {
                    TooltipViewImpl.this.removePreDrawObserver(null);
                    return true;
                }
                if (null != TooltipViewImpl.this.mViewAnchor && null != (view = (View)TooltipViewImpl.this.mViewAnchor.get())) {
                    view.getLocationOnScreen(TooltipViewImpl.this.mTempLocation);
                    if (TooltipViewImpl.this.mOldLocation == null) {
                        TooltipViewImpl.access$802(TooltipViewImpl.this, new int[]{TooltipViewImpl.this.mTempLocation[0], TooltipViewImpl.this.mTempLocation[1]});
                    }
                    if (TooltipViewImpl.this.mOldLocation[0] != TooltipViewImpl.this.mTempLocation[0] || TooltipViewImpl.this.mOldLocation[1] != TooltipViewImpl.this.mTempLocation[1]) {
                        TooltipViewImpl.this.mView.setTranslationX((float)(TooltipViewImpl.this.mTempLocation[0] - TooltipViewImpl.this.mOldLocation[0]) + TooltipViewImpl.this.mView.getTranslationX());
                        TooltipViewImpl.this.mView.setTranslationY((float)(TooltipViewImpl.this.mTempLocation[1] - TooltipViewImpl.this.mOldLocation[1]) + TooltipViewImpl.this.mView.getTranslationY());
                        if (null != TooltipViewImpl.this.mViewOverlay) {
                            TooltipViewImpl.this.mViewOverlay.setTranslationX((float)(TooltipViewImpl.this.mTempLocation[0] - TooltipViewImpl.this.mOldLocation[0]) + TooltipViewImpl.this.mViewOverlay.getTranslationX());
                            TooltipViewImpl.this.mViewOverlay.setTranslationY((float)(TooltipViewImpl.this.mTempLocation[1] - TooltipViewImpl.this.mOldLocation[1]) + TooltipViewImpl.this.mViewOverlay.getTranslationY());
                        }
                    }
                    ((TooltipViewImpl)TooltipViewImpl.this).mOldLocation[0] = TooltipViewImpl.this.mTempLocation[0];
                    ((TooltipViewImpl)TooltipViewImpl.this).mOldLocation[1] = TooltipViewImpl.this.mTempLocation[1];
                }
                return true;
            }
        };
        private TextView mTextView;
        private Typeface mTypeface;
        private int mSizeTolerance;
        private Animator mAnimator;
        private AnimationBuilder mFloatingAnimation;
        private boolean mAlreadyCheck;
        private final ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (!TooltipViewImpl.this.mAttached) {
                    TooltipViewImpl.this.removeGlobalLayoutObserver(null);
                    return;
                }
                if (null != TooltipViewImpl.this.mViewAnchor) {
                    View view = (View)TooltipViewImpl.this.mViewAnchor.get();
                    if (null != view) {
                        view.getHitRect(TooltipViewImpl.this.mTempRect);
                        view.getLocationOnScreen(TooltipViewImpl.this.mTempLocation);
                        if (dbg) {
                            Utils.log(TooltipViewImpl.TAG, 4, "[%d] onGlobalLayout(dirty: %b)", TooltipViewImpl.this.mToolTipId, view.isDirty());
                            Utils.log(TooltipViewImpl.TAG, 2, "[%d] hitRect: %s, old: %s", TooltipViewImpl.this.mToolTipId, TooltipViewImpl.this.mTempRect, TooltipViewImpl.this.mHitRect);
                        }
                        if (!TooltipViewImpl.this.mTempRect.equals((Object)TooltipViewImpl.this.mHitRect)) {
                            TooltipViewImpl.this.mHitRect.set(TooltipViewImpl.this.mTempRect);
                            TooltipViewImpl.this.mTempRect.offsetTo(TooltipViewImpl.this.mTempLocation[0], TooltipViewImpl.this.mTempLocation[1]);
                            TooltipViewImpl.this.mViewRect.set(TooltipViewImpl.this.mTempRect);
                            TooltipViewImpl.this.calculatePositions();
                        }
                    } else if (dbg) {
                        Utils.log(TooltipViewImpl.TAG, 5, "[%d] view is null", TooltipViewImpl.this.mToolTipId);
                    }
                }
            }
        };
        private boolean mIsCustomView;

        public TooltipViewImpl(Context context, Builder builder) {
            super(context);
            TypedArray theme = context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.defStyleAttr, builder.defStyleRes);
            this.mPadding = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_padding, 30);
            this.mTextAppearance = theme.getResourceId(R.styleable.TooltipLayout_android_textAppearance, 0);
            this.mTextGravity = theme.getInt(R.styleable.TooltipLayout_android_gravity, 0x800033);
            this.mTextViewElevation = theme.getDimension(R.styleable.TooltipLayout_ttlm_elevation, 0.0f);
            int overlayStyle = theme.getResourceId(R.styleable.TooltipLayout_ttlm_overlayStyle, R.style.ToolTipOverlayDefaultStyle);
            String font = theme.getString(R.styleable.TooltipLayout_ttlm_font);
            theme.recycle();
            this.mToolTipId = builder.id;
            this.mText = builder.text;
            this.mGravity = builder.gravity;
            this.mTextResId = builder.textResId;
            this.mMaxWidth = builder.maxWidth;
            this.mTopRule = builder.actionbarSize;
            this.mClosePolicy = builder.closePolicy;
            this.mShowDuration = builder.showDuration;
            this.mShowDelay = builder.showDelay;
            this.mHideArrow = builder.hideArrow;
            this.mActivateDelay = builder.activateDelay;
            this.mRestrict = builder.restrictToScreenEdges;
            this.mFadeDuration = builder.fadeDuration;
            this.mCallback = builder.closeCallback;
            this.mFloatingAnimation = builder.floatingAnimation;
            this.mSizeTolerance = (int)(context.getResources().getDisplayMetrics().density * 10.0f);
            if (builder.typeface != null) {
                this.mTypeface = builder.typeface;
            } else if (!TextUtils.isEmpty((CharSequence)font)) {
                this.mTypeface = Typefaces.get(context, font);
            }
            this.setClipChildren(false);
            this.setClipToPadding(false);
            if (null != builder.point) {
                this.mPoint = new Point(builder.point);
                this.mPoint.y += this.mTopRule;
            } else {
                this.mPoint = null;
            }
            this.mDrawRect = new Rect();
            if (null != builder.view) {
                this.mViewRect = new Rect();
                builder.view.getHitRect(this.mHitRect);
                builder.view.getLocationOnScreen(this.mTempLocation);
                this.mViewRect.set(this.mHitRect);
                this.mViewRect.offsetTo(this.mTempLocation[0], this.mTempLocation[1]);
                this.mViewAnchor = new WeakReference<View>(builder.view);
                if (builder.view.getViewTreeObserver().isAlive()) {
                    builder.view.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalLayoutListener);
                    builder.view.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
                    builder.view.addOnAttachStateChangeListener(this.mAttachedStateListener);
                }
            }
            if (builder.overlay) {
                this.mViewOverlay = new TooltipOverlay(this.getContext(), null, 0, overlayStyle);
                this.mViewOverlay.setAdjustViewBounds(true);
                this.mViewOverlay.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            if (!builder.isCustomView) {
                this.mDrawable = new TooltipTextDrawable(context, builder);
            } else {
                this.mDrawable = null;
                this.mIsCustomView = true;
            }
            this.setVisibility(4);
        }

        @Override
        public void show() {
            if (this.getParent() == null) {
                Activity act = Utils.getActivity(this.getContext());
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
                if (act != null) {
                    ViewGroup rootView = (ViewGroup)act.getWindow().getDecorView();
                    rootView.addView((View)this, params);
                }
            }
        }

        @Override
        public void hide() {
            this.hide(this.mFadeDuration);
        }

        private void hide(long fadeDuration) {
            Utils.log(TAG, 4, "[%d] hide(%d)", this.mToolTipId, fadeDuration);
            if (!this.isAttached()) {
                return;
            }
            this.fadeOut(fadeDuration);
        }

        protected void fadeOut(long fadeDuration) {
            if (!this.isAttached() || !this.mShowing) {
                return;
            }
            Utils.log(TAG, 4, "[%d] fadeOut(%d)", this.mToolTipId, fadeDuration);
            if (null != this.mShowAnimation) {
                this.mShowAnimation.cancel();
            }
            this.mShowing = false;
            if (fadeDuration > 0L) {
                float alpha = this.getAlpha();
                this.mShowAnimation = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{alpha, 0.0f});
                this.mShowAnimation.setDuration(fadeDuration);
                this.mShowAnimation.addListener(new Animator.AnimatorListener(){
                    boolean cancelled;

                    public void onAnimationStart(Animator animation) {
                        this.cancelled = false;
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (this.cancelled) {
                            return;
                        }
                        if (null != TooltipViewImpl.this.mCallback) {
                            TooltipViewImpl.this.mCallback.onTooltipHidden(TooltipViewImpl.this);
                        }
                        TooltipViewImpl.this.remove();
                        TooltipViewImpl.this.mShowAnimation = null;
                    }

                    public void onAnimationCancel(Animator animation) {
                        this.cancelled = true;
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mShowAnimation.start();
            } else {
                this.setVisibility(4);
                this.remove();
            }
        }

        void removeFromParent() {
            Utils.log(TAG, 4, "[%d] removeFromParent", this.mToolTipId);
            ViewParent parent = this.getParent();
            this.removeCallbacks();
            if (null != parent) {
                ((ViewGroup)parent).removeView((View)this);
                if (null != this.mShowAnimation && this.mShowAnimation.isStarted()) {
                    this.mShowAnimation.cancel();
                }
            }
        }

        private void removeCallbacks() {
            this.mHandler.removeCallbacks(this.hideRunnable);
            this.mHandler.removeCallbacks(this.activateRunnable);
        }

        @Override
        public void remove() {
            Utils.log(TAG, 4, "[%d] remove()", this.mToolTipId);
            if (this.isAttached()) {
                this.removeFromParent();
            }
        }

        @Override
        public int getTooltipId() {
            return this.mToolTipId;
        }

        @Override
        public void offsetTo(int x, int y) {
            this.mView.setTranslationX((float)(x + this.mDrawRect.left));
            this.mView.setTranslationY((float)(y + this.mDrawRect.top));
        }

        @Override
        public void offsetBy(int x, int y) {
            this.mView.setTranslationX((float)x + this.mView.getTranslationX());
            this.mView.setTranslationY((float)y + this.mView.getTranslationY());
        }

        @Override
        public void offsetXBy(float x) {
            this.mView.setTranslationX(x + this.mView.getTranslationX());
        }

        @Override
        public void offsetXTo(float x) {
            this.mView.setTranslationX(x + (float)this.mDrawRect.left);
        }

        @Override
        public void setText(@StringRes int resId) {
            if (null != this.mView) {
                this.setText(this.getResources().getString(resId));
            }
        }

        @Override
        public void setTextColor(int color) {
            if (null != this.mTextView) {
                this.mTextView.setTextColor(color);
            }
        }

        @Override
        public void setTextColor(ColorStateList color) {
            if (null != this.mTextView) {
                this.mTextView.setTextColor(color);
            }
        }

        @Override
        public boolean isAttached() {
            return this.mAttached;
        }

        public boolean isShowing() {
            return this.mShowing;
        }

        protected void onAttachedToWindow() {
            Utils.log(TAG, 4, "[%d] onAttachedToWindow", this.mToolTipId);
            super.onAttachedToWindow();
            this.mAttached = true;
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            display.getRectSize(this.mScreenRect);
            this.initializeView();
            this.showInternal();
        }

        protected void onDetachedFromWindow() {
            Utils.log(TAG, 4, "[%d] onDetachedFromWindow", this.mToolTipId);
            this.removeListeners();
            this.stopFloatingAnimations();
            this.mAttached = false;
            this.mViewAnchor = null;
            super.onDetachedFromWindow();
        }

        protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
            super.onVisibilityChanged(changedView, visibility);
            if (null != this.mAnimator) {
                if (visibility == 0) {
                    this.mAnimator.start();
                } else {
                    this.mAnimator.cancel();
                }
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            if (null != this.mView) {
                this.mView.layout(this.mView.getLeft(), this.mView.getTop(), this.mView.getMeasuredWidth(), this.mView.getMeasuredHeight());
            }
            if (null != this.mViewOverlay) {
                this.mViewOverlay.layout(this.mViewOverlay.getLeft(), this.mViewOverlay.getTop(), this.mViewOverlay.getMeasuredWidth(), this.mViewOverlay.getMeasuredHeight());
            }
            if (changed) {
                View view;
                if (this.mViewAnchor != null && null != (view = (View)this.mViewAnchor.get())) {
                    view.getHitRect(this.mTempRect);
                    view.getLocationOnScreen(this.mTempLocation);
                    this.mTempRect.offsetTo(this.mTempLocation[0], this.mTempLocation[1]);
                    this.mViewRect.set(this.mTempRect);
                }
                this.calculatePositions();
            }
        }

        private void removeListeners() {
            this.mCallback = null;
            if (null != this.mViewAnchor) {
                View view = (View)this.mViewAnchor.get();
                this.removeViewListeners(view);
            }
        }

        private void stopFloatingAnimations() {
            if (null != this.mAnimator) {
                this.mAnimator.cancel();
                this.mAnimator = null;
            }
        }

        private void removeViewListeners(View view) {
            Utils.log(TAG, 4, "[%d] removeListeners", this.mToolTipId);
            this.removeGlobalLayoutObserver(view);
            this.removePreDrawObserver(view);
            this.removeOnAttachStateObserver(view);
        }

        private void removeGlobalLayoutObserver(@Nullable View view) {
            if (null == view && null != this.mViewAnchor) {
                view = (View)this.mViewAnchor.get();
            }
            if (null != view && view.getViewTreeObserver().isAlive()) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener(this.mGlobalLayoutListener);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
                }
            } else {
                Utils.log(TAG, 6, "[%d] removeGlobalLayoutObserver failed", this.mToolTipId);
            }
        }

        private void removePreDrawObserver(@Nullable View view) {
            if (null == view && null != this.mViewAnchor) {
                view = (View)this.mViewAnchor.get();
            }
            if (null != view && view.getViewTreeObserver().isAlive()) {
                view.getViewTreeObserver().removeOnPreDrawListener(this.mPreDrawListener);
            } else {
                Utils.log(TAG, 6, "[%d] removePreDrawObserver failed", this.mToolTipId);
            }
        }

        private void removeOnAttachStateObserver(@Nullable View view) {
            if (null == view && null != this.mViewAnchor) {
                view = (View)this.mViewAnchor.get();
            }
            if (null != view) {
                view.removeOnAttachStateChangeListener(this.mAttachedStateListener);
            } else {
                Utils.log(TAG, 6, "[%d] removeOnAttachStateObserver failed", this.mToolTipId);
            }
        }

        private void initializeView() {
            if (!this.isAttached() || this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            Utils.log(TAG, 2, "[%d] initializeView", this.mToolTipId);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
            this.mView = LayoutInflater.from((Context)this.getContext()).inflate(this.mTextResId, (ViewGroup)this, false);
            this.mView.setLayoutParams(params);
            this.mTextView = (TextView)this.mView.findViewById(16908308);
            this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)this.mText)));
            if (this.mMaxWidth > -1) {
                this.mTextView.setMaxWidth(this.mMaxWidth);
                Utils.log(TAG, 2, "[%d] maxWidth: %d", this.mToolTipId, this.mMaxWidth);
            }
            if (0 != this.mTextAppearance) {
                this.mTextView.setTextAppearance(this.getContext(), this.mTextAppearance);
            }
            this.mTextView.setGravity(this.mTextGravity);
            if (this.mTypeface != null) {
                this.mTextView.setTypeface(this.mTypeface);
            }
            if (null != this.mDrawable) {
                this.mTextView.setBackgroundDrawable((Drawable)this.mDrawable);
                if (this.mHideArrow) {
                    this.mTextView.setPadding(this.mPadding / 2, this.mPadding / 2, this.mPadding / 2, this.mPadding / 2);
                } else {
                    this.mTextView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
                }
            }
            this.addView(this.mView);
            if (null != this.mViewOverlay) {
                this.addView((View)this.mViewOverlay);
            }
            if (!this.mIsCustomView && this.mTextViewElevation > 0.0f && Build.VERSION.SDK_INT >= 21) {
                this.setupElevation();
            }
        }

        private void showInternal() {
            Utils.log(TAG, 4, "[%d] show", this.mToolTipId);
            if (!this.isAttached()) {
                Utils.log(TAG, 6, "[%d] not attached!", this.mToolTipId);
                return;
            }
            this.fadeIn(this.mFadeDuration);
        }

        @SuppressLint(value={"NewApi"})
        private void setupElevation() {
            this.mTextView.setElevation(this.mTextViewElevation);
            this.mTextView.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        }

        protected void fadeIn(long fadeDuration) {
            if (this.mShowing) {
                return;
            }
            if (null != this.mShowAnimation) {
                this.mShowAnimation.cancel();
            }
            Utils.log(TAG, 4, "[%d] fadeIn", this.mToolTipId);
            this.mShowing = true;
            if (fadeDuration > 0L) {
                this.mShowAnimation = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
                this.mShowAnimation.setDuration(fadeDuration);
                if (this.mShowDelay > 0L) {
                    this.mShowAnimation.setStartDelay(this.mShowDelay);
                }
                this.mShowAnimation.addListener(new Animator.AnimatorListener(){
                    boolean cancelled;

                    public void onAnimationStart(Animator animation) {
                        TooltipViewImpl.this.setVisibility(0);
                        this.cancelled = false;
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (!this.cancelled) {
                            if (null != TooltipViewImpl.this.mCallback) {
                                TooltipViewImpl.this.mCallback.onTooltipShown(TooltipViewImpl.this);
                            }
                            TooltipViewImpl.this.postActivate(TooltipViewImpl.this.mActivateDelay);
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                        this.cancelled = true;
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mShowAnimation.start();
            } else {
                this.setVisibility(0);
                if (!this.mActivated) {
                    this.postActivate(this.mActivateDelay);
                }
            }
            if (this.mShowDuration > 0L) {
                this.mHandler.removeCallbacks(this.hideRunnable);
                this.mHandler.postDelayed(this.hideRunnable, this.mShowDuration);
            }
        }

        void postActivate(long ms) {
            Utils.log(TAG, 2, "[%d] postActivate: %d", this.mToolTipId, ms);
            if (ms > 0L) {
                if (this.isAttached()) {
                    this.mHandler.postDelayed(this.activateRunnable, ms);
                }
            } else {
                this.mActivated = true;
            }
        }

        private void calculatePositions() {
            this.calculatePositions(this.mRestrict);
        }

        private void calculatePositions(boolean restrict) {
            this.viewGravities.clear();
            this.viewGravities.addAll(GRAVITY_LIST);
            this.viewGravities.remove((Object)this.mGravity);
            this.viewGravities.add(0, this.mGravity);
            this.calculatePositions(this.viewGravities, restrict);
        }

        private void calculatePositions(List<Gravity> gravities, boolean checkEdges) {
            int overlayHeight;
            int overlayWidth;
            if (!this.isAttached()) {
                return;
            }
            if (gravities.size() < 1) {
                if (null != this.mCallback) {
                    this.mCallback.onTooltipFailed(this);
                }
                this.setVisibility(8);
                return;
            }
            Gravity gravity = gravities.remove(0);
            if (dbg) {
                Utils.log(TAG, 3, "[%s] calculatePositions. gravity: %s, GRAVITY_LIST: %d, restrict: %b", new Object[]{this.mToolTipId, gravity, gravities.size(), checkEdges});
            }
            int statusbarHeight = this.mScreenRect.top;
            if (null != this.mViewOverlay && gravity != Gravity.CENTER) {
                int margin = this.mViewOverlay.getLayoutMargins();
                overlayWidth = this.mViewOverlay.getWidth() / 2 + margin;
                overlayHeight = this.mViewOverlay.getHeight() / 2 + margin;
            } else {
                overlayWidth = 0;
                overlayHeight = 0;
            }
            if (this.mViewRect == null) {
                this.mViewRect = new Rect();
                this.mViewRect.set(this.mPoint.x, this.mPoint.y + statusbarHeight, this.mPoint.x, this.mPoint.y + statusbarHeight);
            }
            int screenTop = this.mScreenRect.top + this.mTopRule;
            int width = this.mView.getWidth();
            int height = this.mView.getHeight();
            if (gravity == Gravity.BOTTOM) {
                if (this.calculatePositionBottom(checkEdges, overlayHeight, screenTop, width, height)) {
                    Utils.log(TAG, 5, "no enough space for BOTTOM", new Object[0]);
                    this.calculatePositions(gravities, checkEdges);
                    return;
                }
            } else if (gravity == Gravity.TOP) {
                if (this.calculatePositionTop(checkEdges, overlayHeight, screenTop, width, height)) {
                    Utils.log(TAG, 5, "no enough space for TOP", new Object[0]);
                    this.calculatePositions(gravities, checkEdges);
                    return;
                }
            } else if (gravity == Gravity.RIGHT) {
                if (this.calculatePositionRight(checkEdges, overlayWidth, screenTop, width, height)) {
                    Utils.log(TAG, 5, "no enough space for RIGHT", new Object[0]);
                    this.calculatePositions(gravities, checkEdges);
                    return;
                }
            } else if (gravity == Gravity.LEFT) {
                if (this.calculatePositionLeft(checkEdges, overlayWidth, screenTop, width, height)) {
                    Utils.log(TAG, 5, "no enough space for LEFT", new Object[0]);
                    this.calculatePositions(gravities, checkEdges);
                    return;
                }
            } else if (gravity == Gravity.CENTER) {
                this.calculatePositionCenter(checkEdges, screenTop, width, height);
            }
            if (dbg) {
                Utils.log(TAG, 2, "[%d] mScreenRect: %s, mTopRule: %d, statusBar: %d", this.mToolTipId, this.mScreenRect, this.mTopRule, statusbarHeight);
                Utils.log(TAG, 2, "[%d] mDrawRect: %s", this.mToolTipId, this.mDrawRect);
                Utils.log(TAG, 2, "[%d] mViewRect: %s", this.mToolTipId, this.mViewRect);
            }
            if (gravity != this.mGravity) {
                Utils.log(TAG, 6, "gravity changed from %s to %s", new Object[]{this.mGravity, gravity});
                this.mGravity = gravity;
                if (gravity == Gravity.CENTER && null != this.mViewOverlay) {
                    this.removeView((View)this.mViewOverlay);
                    this.mViewOverlay = null;
                }
            }
            if (null != this.mViewOverlay) {
                this.mViewOverlay.setTranslationX(this.mViewRect.centerX() - this.mViewOverlay.getWidth() / 2);
                this.mViewOverlay.setTranslationY(this.mViewRect.centerY() - this.mViewOverlay.getHeight() / 2);
            }
            this.mView.setTranslationX((float)this.mDrawRect.left);
            this.mView.setTranslationY((float)this.mDrawRect.top);
            if (null != this.mDrawable) {
                this.getAnchorPoint(gravity, this.mTmpPoint);
                this.mDrawable.setAnchor(gravity, this.mHideArrow ? 0 : this.mPadding / 2, this.mHideArrow ? null : this.mTmpPoint);
            }
            if (!this.mAlreadyCheck) {
                this.mAlreadyCheck = true;
                this.startFloatingAnimations();
            }
        }

        private void calculatePositionCenter(boolean checkEdges, int screenTop, int width, int height) {
            this.mDrawRect.set(this.mViewRect.centerX() - width / 2, this.mViewRect.centerY() - height / 2, this.mViewRect.centerX() + width / 2, this.mViewRect.centerY() + height / 2);
            if (checkEdges && !Utils.rectContainsRectWithTolerance(this.mScreenRect, this.mDrawRect, this.mSizeTolerance)) {
                if (this.mDrawRect.bottom > this.mScreenRect.bottom) {
                    this.mDrawRect.offset(0, this.mScreenRect.bottom - this.mDrawRect.bottom);
                } else if (this.mDrawRect.top < screenTop) {
                    this.mDrawRect.offset(0, screenTop - this.mDrawRect.top);
                }
                if (this.mDrawRect.right > this.mScreenRect.right) {
                    this.mDrawRect.offset(this.mScreenRect.right - this.mDrawRect.right, 0);
                } else if (this.mDrawRect.left < this.mScreenRect.left) {
                    this.mDrawRect.offset(this.mScreenRect.left - this.mDrawRect.left, 0);
                }
            }
        }

        private boolean calculatePositionLeft(boolean checkEdges, int overlayWidth, int screenTop, int width, int height) {
            this.mDrawRect.set(this.mViewRect.left - width, this.mViewRect.centerY() - height / 2, this.mViewRect.left, this.mViewRect.centerY() + height / 2);
            if (this.mViewRect.width() / 2 < overlayWidth) {
                this.mDrawRect.offset(-(overlayWidth - this.mViewRect.width() / 2), 0);
            }
            if (checkEdges && !Utils.rectContainsRectWithTolerance(this.mScreenRect, this.mDrawRect, this.mSizeTolerance)) {
                if (this.mDrawRect.bottom > this.mScreenRect.bottom) {
                    this.mDrawRect.offset(0, this.mScreenRect.bottom - this.mDrawRect.bottom);
                } else if (this.mDrawRect.top < screenTop) {
                    this.mDrawRect.offset(0, screenTop - this.mDrawRect.top);
                }
                if (this.mDrawRect.left < this.mScreenRect.left) {
                    return true;
                }
                if (this.mDrawRect.right > this.mScreenRect.right) {
                    this.mDrawRect.offset(this.mScreenRect.right - this.mDrawRect.right, 0);
                }
            }
            return false;
        }

        private boolean calculatePositionRight(boolean checkEdges, int overlayWidth, int screenTop, int width, int height) {
            this.mDrawRect.set(this.mViewRect.right, this.mViewRect.centerY() - height / 2, this.mViewRect.right + width, this.mViewRect.centerY() + height / 2);
            if (this.mViewRect.width() / 2 < overlayWidth) {
                this.mDrawRect.offset(overlayWidth - this.mViewRect.width() / 2, 0);
            }
            if (checkEdges && !Utils.rectContainsRectWithTolerance(this.mScreenRect, this.mDrawRect, this.mSizeTolerance)) {
                if (this.mDrawRect.bottom > this.mScreenRect.bottom) {
                    this.mDrawRect.offset(0, this.mScreenRect.bottom - this.mDrawRect.bottom);
                } else if (this.mDrawRect.top < screenTop) {
                    this.mDrawRect.offset(0, screenTop - this.mDrawRect.top);
                }
                if (this.mDrawRect.right > this.mScreenRect.right) {
                    return true;
                }
                if (this.mDrawRect.left < this.mScreenRect.left) {
                    this.mDrawRect.offset(this.mScreenRect.left - this.mDrawRect.left, 0);
                }
            }
            return false;
        }

        private boolean calculatePositionTop(boolean checkEdges, int overlayHeight, int screenTop, int width, int height) {
            this.mDrawRect.set(this.mViewRect.centerX() - width / 2, this.mViewRect.top - height, this.mViewRect.centerX() + width / 2, this.mViewRect.top);
            if (this.mViewRect.height() / 2 < overlayHeight) {
                this.mDrawRect.offset(0, -(overlayHeight - this.mViewRect.height() / 2));
            }
            if (checkEdges && !Utils.rectContainsRectWithTolerance(this.mScreenRect, this.mDrawRect, this.mSizeTolerance)) {
                if (this.mDrawRect.right > this.mScreenRect.right) {
                    this.mDrawRect.offset(this.mScreenRect.right - this.mDrawRect.right, 0);
                } else if (this.mDrawRect.left < this.mScreenRect.left) {
                    this.mDrawRect.offset(-this.mDrawRect.left, 0);
                }
                if (this.mDrawRect.top < screenTop) {
                    return true;
                }
                if (this.mDrawRect.bottom > this.mScreenRect.bottom) {
                    this.mDrawRect.offset(0, this.mScreenRect.bottom - this.mDrawRect.bottom);
                }
            }
            return false;
        }

        private boolean calculatePositionBottom(boolean checkEdges, int overlayHeight, int screenTop, int width, int height) {
            this.mDrawRect.set(this.mViewRect.centerX() - width / 2, this.mViewRect.bottom, this.mViewRect.centerX() + width / 2, this.mViewRect.bottom + height);
            if (this.mViewRect.height() / 2 < overlayHeight) {
                this.mDrawRect.offset(0, overlayHeight - this.mViewRect.height() / 2);
            }
            if (checkEdges && !Utils.rectContainsRectWithTolerance(this.mScreenRect, this.mDrawRect, this.mSizeTolerance)) {
                if (this.mDrawRect.right > this.mScreenRect.right) {
                    this.mDrawRect.offset(this.mScreenRect.right - this.mDrawRect.right, 0);
                } else if (this.mDrawRect.left < this.mScreenRect.left) {
                    this.mDrawRect.offset(-this.mDrawRect.left, 0);
                }
                if (this.mDrawRect.bottom > this.mScreenRect.bottom) {
                    return true;
                }
                if (this.mDrawRect.top < screenTop) {
                    this.mDrawRect.offset(0, screenTop - this.mDrawRect.top);
                }
            }
            return false;
        }

        private void startFloatingAnimations() {
            if (this.mTextView == this.mView || null == this.mFloatingAnimation) {
                return;
            }
            float endValue = this.mFloatingAnimation.radius;
            long duration = this.mFloatingAnimation.duration;
            int direction = this.mFloatingAnimation.direction == 0 ? (this.mGravity == Gravity.TOP || this.mGravity == Gravity.BOTTOM ? 2 : 1) : this.mFloatingAnimation.direction;
            String property = direction == 2 ? "translationY" : "translationX";
            ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)this.mTextView, (String)property, (float[])new float[]{-endValue, endValue});
            anim1.setDuration(duration);
            anim1.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)this.mTextView, (String)property, (float[])new float[]{endValue, -endValue});
            anim2.setDuration(duration);
            anim2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            AnimatorSet set = new AnimatorSet();
            set.playSequentially(new Animator[]{anim1, anim2});
            set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (TooltipViewImpl.this.isAttached()) {
                        Utils.log(TooltipViewImpl.TAG, 2, "animation restart", new Object[0]);
                        animation.start();
                    }
                }
            });
            this.mAnimator = set;
            this.mAnimator.start();
        }

        void getAnchorPoint(Gravity gravity, Point outPoint) {
            if (gravity == Gravity.BOTTOM) {
                outPoint.x = this.mViewRect.centerX();
                outPoint.y = this.mViewRect.bottom;
            } else if (gravity == Gravity.TOP) {
                outPoint.x = this.mViewRect.centerX();
                outPoint.y = this.mViewRect.top;
            } else if (gravity == Gravity.RIGHT) {
                outPoint.x = this.mViewRect.right;
                outPoint.y = this.mViewRect.centerY();
            } else if (gravity == Gravity.LEFT) {
                outPoint.x = this.mViewRect.left;
                outPoint.y = this.mViewRect.centerY();
            } else if (this.mGravity == Gravity.CENTER) {
                outPoint.x = this.mViewRect.centerX();
                outPoint.y = this.mViewRect.centerY();
            }
            outPoint.x -= this.mDrawRect.left;
            outPoint.y -= this.mDrawRect.top;
            if (!this.mHideArrow) {
                if (gravity == Gravity.LEFT || gravity == Gravity.RIGHT) {
                    outPoint.y -= this.mPadding / 2;
                } else if (gravity == Gravity.TOP || gravity == Gravity.BOTTOM) {
                    outPoint.x -= this.mPadding / 2;
                }
            }
        }

        @Override
        public void setText(CharSequence text) {
            this.mText = text;
            if (null != this.mTextView) {
                this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)text)));
            }
        }

        public boolean onTouchEvent(@NonNull MotionEvent event) {
            if (!(this.mAttached && this.mShowing && this.isShown() && this.mClosePolicy != 0)) {
                return false;
            }
            int action = event.getActionMasked();
            Utils.log(TAG, 4, "[%d] onTouchEvent: %d, active: %b", this.mToolTipId, action, this.mActivated);
            if (!this.mActivated && this.mActivateDelay > 0L) {
                Utils.log(TAG, 5, "[%d] not yet activated...", this.mToolTipId);
                return false;
            }
            if (action == 0) {
                Rect outRect = new Rect();
                this.mView.getGlobalVisibleRect(outRect);
                Utils.log(TAG, 2, "[%d] text rect: %s", this.mToolTipId, outRect);
                boolean containsTouch = outRect.contains((int)event.getX(), (int)event.getY());
                Utils.log(TAG, 2, "containsTouch: %b", containsTouch);
                if (null != this.mViewOverlay) {
                    this.mViewOverlay.getGlobalVisibleRect(outRect);
                    containsTouch |= outRect.contains((int)event.getX(), (int)event.getY());
                    Utils.log(TAG, 2, "[%d] overlay rect: %s", this.mToolTipId, outRect);
                }
                if (dbg) {
                    Utils.log(TAG, 2, "[%d] containsTouch: %b", this.mToolTipId, containsTouch);
                    Utils.log(TAG, 2, "[%d] mDrawRect: %s, point: %g, %g", this.mToolTipId, this.mDrawRect, Float.valueOf(event.getX()), Float.valueOf(event.getY()));
                    Utils.log(TAG, 2, "[%d] real drawing rect: %s, contains: %b", this.mToolTipId, outRect, outRect.contains((int)event.getX(), (int)event.getY()));
                }
                if (dbg) {
                    Utils.log(TAG, 3, "containsTouch: %b", containsTouch);
                    Utils.log(TAG, 3, "touchOutside: %b", ClosePolicy.touchOutside(this.mClosePolicy));
                    Utils.log(TAG, 3, "consumeOutside: %b", ClosePolicy.consumeOutside(this.mClosePolicy));
                    Utils.log(TAG, 3, "touchInside: %b", ClosePolicy.touchInside(this.mClosePolicy));
                    Utils.log(TAG, 3, "consumeInside: %b", ClosePolicy.consumeInside(this.mClosePolicy));
                }
                if (containsTouch) {
                    if (ClosePolicy.touchInside(this.mClosePolicy)) {
                        this.onClose(true, true, false);
                    }
                    return ClosePolicy.consumeInside(this.mClosePolicy);
                }
                if (ClosePolicy.touchOutside(this.mClosePolicy)) {
                    this.onClose(true, false, false);
                }
                return ClosePolicy.consumeOutside(this.mClosePolicy);
            }
            return false;
        }

        protected void onDraw(Canvas canvas) {
            if (!this.mAttached) {
                return;
            }
            super.onDraw(canvas);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int childHeightMeasureSpec;
            int childWidthMeasureSpec;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int myWidth = 0;
            int myHeight = 0;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthMode != 0) {
                myWidth = widthSize;
            }
            if (heightMode != 0) {
                myHeight = heightSize;
            }
            Utils.log(TAG, 2, "[%d] onMeasure myWidth: %d, myHeight: %d", this.mToolTipId, myWidth, myHeight);
            if (null != this.mView) {
                if (this.mView.getVisibility() != 8) {
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)myWidth, (int)Integer.MIN_VALUE);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)myHeight, (int)Integer.MIN_VALUE);
                    this.mView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                } else {
                    myWidth = 0;
                    myHeight = 0;
                }
            }
            if (null != this.mViewOverlay && this.mViewOverlay.getVisibility() != 8) {
                childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)Integer.MIN_VALUE);
                childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)Integer.MIN_VALUE);
                this.mViewOverlay.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
            this.setMeasuredDimension(myWidth, myHeight);
        }

        private void onClose(boolean fromUser, boolean containsTouch, boolean immediate) {
            Utils.log(TAG, 4, "[%d] onClose. fromUser: %b, containsTouch: %b, immediate: %b", this.mToolTipId, fromUser, containsTouch, immediate);
            if (!this.isAttached()) {
                Utils.log(TAG, 5, "not yet attached!", new Object[0]);
                return;
            }
            if (null != this.mCallback) {
                this.mCallback.onTooltipClose(this, fromUser, containsTouch);
            }
            this.hide(immediate ? 0L : this.mFadeDuration);
        }

        static /* synthetic */ int[] access$802(TooltipViewImpl x0, int[] x1) {
            x0.mOldLocation = x1;
            return x1;
        }
    }

    public static interface Callback {
        public void onTooltipClose(TooltipView var1, boolean var2, boolean var3);

        public void onTooltipFailed(TooltipView var1);

        public void onTooltipShown(TooltipView var1);

        public void onTooltipHidden(TooltipView var1);
    }

    public static interface TooltipView {
        public void show();

        public void hide();

        public void remove();

        public int getTooltipId();

        public void offsetTo(int var1, int var2);

        public void offsetBy(int var1, int var2);

        public void offsetXBy(float var1);

        public void offsetXTo(float var1);

        public boolean isAttached();

        public boolean isShown();

        public void setText(CharSequence var1);

        public void setText(@StringRes int var1);

        public void setTextColor(int var1);

        public void setTextColor(ColorStateList var1);

        public void requestLayout();
    }

    public static enum Gravity {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }

    public static class ClosePolicy {
        static final int NONE = 0;
        static final int TOUCH_INSIDE = 2;
        static final int TOUCH_OUTSIDE = 4;
        static final int CONSUME_INSIDE = 8;
        static final int CONSUME_OUTSIDE = 16;
        private int policy;
        public static final ClosePolicy TOUCH_NONE = new ClosePolicy(0);
        public static final ClosePolicy TOUCH_INSIDE_CONSUME = new ClosePolicy(10);
        public static final ClosePolicy TOUCH_INSIDE_NO_CONSUME = new ClosePolicy(2);
        public static final ClosePolicy TOUCH_OUTSIDE_CONSUME = new ClosePolicy(20);
        public static final ClosePolicy TOUCH_OUTSIDE_NO_CONSUME = new ClosePolicy(4);
        public static final ClosePolicy TOUCH_ANYWHERE_NO_CONSUME = new ClosePolicy(6);
        public static final ClosePolicy TOUCH_ANYWHERE_CONSUME = new ClosePolicy(30);

        public ClosePolicy() {
            this.policy = 0;
        }

        ClosePolicy(int policy) {
            this.policy = policy;
        }

        public ClosePolicy insidePolicy(boolean close, boolean consume) {
            this.policy = close ? this.policy | 2 : this.policy & 0xFFFFFFFD;
            this.policy = consume ? this.policy | 8 : this.policy & 0xFFFFFFF7;
            return this;
        }

        public ClosePolicy outsidePolicy(boolean close, boolean consume) {
            this.policy = close ? this.policy | 4 : this.policy & 0xFFFFFFFB;
            this.policy = consume ? this.policy | 0x10 : this.policy & 0xFFFFFFEF;
            return this;
        }

        public ClosePolicy clear() {
            this.policy = 0;
            return this;
        }

        public int build() {
            return this.policy;
        }

        public int getPolicy() {
            return this.policy;
        }

        public static boolean touchInside(int value) {
            return (value & 2) == 2;
        }

        public static boolean touchOutside(int value) {
            return (value & 4) == 4;
        }

        public static boolean consumeInside(int value) {
            return (value & 8) == 8;
        }

        public static boolean consumeOutside(int value) {
            return (value & 0x10) == 16;
        }
    }
}

