/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import java.util.Hashtable;

public final class Typefaces {
    private static final String TAG = "Typefaces";
    private static final Hashtable<String, Typeface> FONT_CACHE = new Hashtable();

    private Typefaces() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface get(Context c, String assetPath) {
        Hashtable<String, Typeface> hashtable = FONT_CACHE;
        synchronized (hashtable) {
            if (!FONT_CACHE.containsKey(assetPath)) {
                try {
                    Typeface t = Typeface.createFromAsset((AssetManager)c.getAssets(), (String)assetPath);
                    FONT_CACHE.put(assetPath, t);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Could not get typeface '" + assetPath + "' because " + e.getMessage()));
                    return null;
                }
            }
            return FONT_CACHE.get(assetPath);
        }
    }
}

