/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateDecelerateInterpolator;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.TooltipOverlay;

public class TooltipOverlayDrawable
extends Drawable {
    public static final String TAG = TooltipOverlay.class.getSimpleName();
    public static final float ALPHA_MAX = 255.0f;
    public static final double FADEOUT_START_DELAY = 0.55;
    public static final double FADEIN_DURATION = 0.3;
    public static final double SECOND_ANIM_START_DELAY = 0.25;
    private Paint mOuterPaint = new Paint(1);
    private Paint mInnerPaint = new Paint(1);
    private float mOuterRadius;
    private float mInnerRadius = 0.0f;
    private AnimatorSet mFirstAnimatorSet;
    private AnimatorSet mSecondAnimatorSet;
    private ValueAnimator mFirstAnimator;
    private ValueAnimator mSecondAnimator;
    private int mRepeatIndex;
    private boolean mStarted;
    private int mOuterAlpha;
    private int mInnerAlpha;
    private int mRepeatCount = 1;
    private long mDuration = 400L;

    public TooltipOverlayDrawable(Context context, int defStyleResId) {
        this.mOuterPaint.setStyle(Paint.Style.FILL);
        this.mInnerPaint.setStyle(Paint.Style.FILL);
        TypedArray array = context.getTheme().obtainStyledAttributes(defStyleResId, R.styleable.TooltipOverlay);
        for (int i = 0; i < array.getIndexCount(); ++i) {
            int index = array.getIndex(i);
            if (index == R.styleable.TooltipOverlay_android_color) {
                int color = array.getColor(index, 0);
                this.mOuterPaint.setColor(color);
                this.mInnerPaint.setColor(color);
                continue;
            }
            if (index == R.styleable.TooltipOverlay_ttlm_repeatCount) {
                this.mRepeatCount = array.getInt(index, 1);
                continue;
            }
            if (index == R.styleable.TooltipOverlay_android_alpha) {
                int alpha = (int)(array.getFloat(index, (float)this.mInnerPaint.getAlpha() / 255.0f) * 255.0f);
                this.mInnerPaint.setAlpha(alpha);
                this.mOuterPaint.setAlpha(alpha);
                continue;
            }
            if (index != R.styleable.TooltipOverlay_ttlm_duration) continue;
            this.mDuration = array.getInt(index, 400);
        }
        array.recycle();
        this.mOuterAlpha = this.getOuterAlpha();
        this.mInnerAlpha = this.getInnerAlpha();
        ObjectAnimator fadeIn = ObjectAnimator.ofInt((Object)((Object)this), (String)"outerAlpha", (int[])new int[]{0, this.mOuterAlpha});
        fadeIn.setDuration((long)((double)this.mDuration * 0.3));
        ObjectAnimator fadeOut = ObjectAnimator.ofInt((Object)((Object)this), (String)"outerAlpha", (int[])new int[]{this.mOuterAlpha, 0, 0});
        fadeOut.setStartDelay((long)((double)this.mDuration * 0.55));
        fadeOut.setDuration((long)((double)this.mDuration * 0.44999999999999996));
        this.mFirstAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"outerRadius", (float[])new float[]{0.0f, 1.0f});
        this.mFirstAnimator.setDuration(this.mDuration);
        this.mFirstAnimatorSet = new AnimatorSet();
        this.mFirstAnimatorSet.playTogether(new Animator[]{fadeIn, this.mFirstAnimator, fadeOut});
        this.mFirstAnimatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mFirstAnimatorSet.setDuration(this.mDuration);
        fadeIn = ObjectAnimator.ofInt((Object)((Object)this), (String)"innerAlpha", (int[])new int[]{0, this.mInnerAlpha});
        fadeIn.setDuration((long)((double)this.mDuration * 0.3));
        fadeOut = ObjectAnimator.ofInt((Object)((Object)this), (String)"innerAlpha", (int[])new int[]{this.mInnerAlpha, 0, 0});
        fadeOut.setStartDelay((long)((double)this.mDuration * 0.55));
        fadeOut.setDuration((long)((double)this.mDuration * 0.44999999999999996));
        this.mSecondAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"innerRadius", (float[])new float[]{0.0f, 1.0f});
        this.mSecondAnimator.setDuration(this.mDuration);
        this.mSecondAnimatorSet = new AnimatorSet();
        this.mSecondAnimatorSet.playTogether(new Animator[]{fadeIn, this.mSecondAnimator, fadeOut});
        this.mSecondAnimatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mSecondAnimatorSet.setStartDelay((long)((double)this.mDuration * 0.25));
        this.mSecondAnimatorSet.setDuration(this.mDuration);
        this.mFirstAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean cancelled;

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.cancelled = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.cancelled && TooltipOverlayDrawable.this.isVisible() && ++TooltipOverlayDrawable.this.mRepeatIndex < TooltipOverlayDrawable.this.mRepeatCount) {
                    TooltipOverlayDrawable.this.mFirstAnimatorSet.start();
                }
            }
        });
        this.mSecondAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean cancelled;

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.cancelled = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.cancelled && TooltipOverlayDrawable.this.isVisible() && TooltipOverlayDrawable.this.mRepeatIndex < TooltipOverlayDrawable.this.mRepeatCount) {
                    TooltipOverlayDrawable.this.mSecondAnimatorSet.setStartDelay(0L);
                    TooltipOverlayDrawable.this.mSecondAnimatorSet.start();
                }
            }
        });
    }

    public int getOuterAlpha() {
        return this.mOuterPaint.getAlpha();
    }

    public void setOuterAlpha(int value) {
        this.mOuterPaint.setAlpha(value);
        this.invalidateSelf();
    }

    public int getInnerAlpha() {
        return this.mInnerPaint.getAlpha();
    }

    public void setInnerAlpha(int value) {
        this.mInnerPaint.setAlpha(value);
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int centerX = bounds.width() / 2;
        int centerY = bounds.height() / 2;
        canvas.drawCircle((float)centerX, (float)centerY, this.mOuterRadius, this.mOuterPaint);
        canvas.drawCircle((float)centerX, (float)centerY, this.mInnerRadius, this.mInnerPaint);
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed;
        boolean bl = changed = this.isVisible() != visible;
        if (visible) {
            if (restart || !this.mStarted) {
                this.replay();
            }
        } else {
            this.stop();
        }
        return changed;
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mOuterRadius = Math.min(bounds.width(), bounds.height()) / 2;
        this.mFirstAnimator.setFloatValues(new float[]{0.0f, this.mOuterRadius});
        this.mSecondAnimator.setFloatValues(new float[]{0.0f, this.mOuterRadius});
    }

    public int getIntrinsicWidth() {
        return 96;
    }

    public int getIntrinsicHeight() {
        return 96;
    }

    public void play() {
        this.mRepeatIndex = 0;
        this.mStarted = true;
        this.mFirstAnimatorSet.start();
        this.mSecondAnimatorSet.setStartDelay((long)((double)this.mDuration * 0.25));
        this.mSecondAnimatorSet.start();
    }

    public void replay() {
        this.stop();
        this.play();
    }

    public void stop() {
        this.mFirstAnimatorSet.cancel();
        this.mSecondAnimatorSet.cancel();
        this.mRepeatIndex = 0;
        this.mStarted = false;
        this.setInnerRadius(0.0f);
        this.setOuterRadius(0.0f);
    }

    public float getInnerRadius() {
        return this.mInnerRadius;
    }

    public void setInnerRadius(float rippleRadius) {
        this.mInnerRadius = rippleRadius;
        this.invalidateSelf();
    }

    public float getOuterRadius() {
        return this.mOuterRadius;
    }

    public void setOuterRadius(float value) {
        this.mOuterRadius = value;
        this.invalidateSelf();
    }
}

