/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.Html;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.Tooltip;
import it.sephiroth.android.library.tooltip.TooltipManager;
import it.sephiroth.android.library.tooltip.TooltipTextDrawable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TooltipView
extends ViewGroup
implements Tooltip,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "TooltipView";
    private static final List<TooltipManager.Gravity> gravities = new ArrayList<TooltipManager.Gravity>(Arrays.asList(TooltipManager.Gravity.LEFT, TooltipManager.Gravity.RIGHT, TooltipManager.Gravity.TOP, TooltipManager.Gravity.BOTTOM, TooltipManager.Gravity.CENTER));
    private final List<TooltipManager.Gravity> viewGravities = new ArrayList<TooltipManager.Gravity>(gravities);
    private final long showDelay;
    private final int textAppearance;
    private WeakReference<View> mViewAnchor;
    private boolean mAttached;
    private boolean mInitialized;
    private boolean mActivated;
    private final int toolTipId;
    private final Rect drawRect;
    private final Rect tempRect;
    private final long showDuration;
    private final TooltipManager.ClosePolicy closePolicy;
    private final Point point;
    private final int textResId;
    private final int topRule;
    private final int maxWidth;
    private final boolean hideArrow;
    private int padding;
    private final long activateDelay;
    private final boolean restrict;
    private final long fadeDuration;
    private final TooltipManager.onTooltipClosingCallback closeCallback;
    private CharSequence text;
    private Rect viewRect;
    TooltipManager.Gravity gravity;
    private View mView;
    private TextView mTextView;
    private final TooltipTextDrawable mDrawable;
    Animator mShowAnimation;
    boolean mShowing;
    Runnable activateRunnable = new Runnable(){

        @Override
        public void run() {
            if (TooltipManager.DBG) {
                Log.v((String)TooltipView.TAG, (String)"activated..");
            }
            TooltipView.this.mActivated = true;
        }
    };
    Runnable hideRunnable = new Runnable(){

        @Override
        public void run() {
            TooltipView.this.onClose(false, false);
        }
    };
    private OnCloseListener closeListener;
    private OnToolTipListener tooltipListener;

    public TooltipView(Context context, TooltipManager.Builder builder) {
        super(context);
        TypedArray theme = context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.defStyleAttr, builder.defStyleRes);
        this.padding = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_padding, 30);
        this.textAppearance = theme.getResourceId(R.styleable.TooltipLayout_android_textAppearance, 0);
        theme.recycle();
        this.toolTipId = builder.id;
        this.text = builder.text;
        this.gravity = builder.gravity;
        this.textResId = builder.textResId;
        this.maxWidth = builder.maxWidth;
        this.topRule = builder.actionbarSize;
        this.closePolicy = builder.closePolicy;
        this.showDuration = builder.showDuration;
        this.showDelay = builder.showDelay;
        this.hideArrow = builder.hideArrow;
        this.activateDelay = builder.activateDelay;
        this.restrict = builder.restrictToScreenEdges;
        this.fadeDuration = builder.fadeDuration;
        this.closeCallback = builder.closeCallback;
        if (null != builder.point) {
            this.point = new Point(builder.point);
            this.point.y += this.topRule;
        } else {
            this.point = null;
        }
        this.drawRect = new Rect();
        this.tempRect = new Rect();
        if (null != builder.view) {
            this.viewRect = new Rect();
            builder.view.getGlobalVisibleRect(this.viewRect);
            this.mViewAnchor = new WeakReference<View>(builder.view);
            builder.view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.mDrawable = !builder.isCustomView ? new TooltipTextDrawable(context, builder) : null;
        this.setVisibility(4);
    }

    int getTooltipId() {
        return this.toolTipId;
    }

    @Override
    public void show() {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"show");
        }
        if (!this.isAttached()) {
            if (TooltipManager.DBG) {
                Log.e((String)TAG, (String)"not attached!");
            }
            return;
        }
        this.fadeIn();
    }

    @Override
    public void hide(boolean remove) {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"hide");
        }
        if (!this.isAttached()) {
            return;
        }
        this.fadeOut(remove);
    }

    protected void fadeIn() {
        if (this.mShowing) {
            return;
        }
        if (null != this.mShowAnimation) {
            this.mShowAnimation.cancel();
        }
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"fadeIn");
        }
        this.mShowing = true;
        if (this.fadeDuration > 0L) {
            this.mShowAnimation = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            this.mShowAnimation.setDuration(this.fadeDuration);
            if (this.showDelay > 0L) {
                this.mShowAnimation.setStartDelay(this.showDelay);
            }
            this.mShowAnimation.addListener(new Animator.AnimatorListener(){
                boolean cancelled;

                public void onAnimationStart(Animator animation) {
                    TooltipView.this.setVisibility(0);
                    this.cancelled = false;
                }

                public void onAnimationEnd(Animator animation) {
                    if (TooltipManager.DBG) {
                        Log.i((String)TooltipView.TAG, (String)("fadein::onAnimationEnd, cancelled: " + this.cancelled));
                    }
                    if (null != TooltipView.this.tooltipListener && !this.cancelled) {
                        TooltipView.this.tooltipListener.onShowCompleted(TooltipView.this);
                        TooltipView.this.postActivate(TooltipView.this.activateDelay);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    if (TooltipManager.DBG) {
                        Log.i((String)TooltipView.TAG, (String)"fadein::onAnimationCancel");
                    }
                    this.cancelled = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mShowAnimation.start();
        } else {
            this.setVisibility(0);
            this.tooltipListener.onShowCompleted(this);
            if (!this.mActivated) {
                this.postActivate(this.activateDelay);
            }
        }
        if (this.showDuration > 0L) {
            this.getHandler().removeCallbacks(this.hideRunnable);
            this.getHandler().postDelayed(this.hideRunnable, this.showDuration);
        }
    }

    boolean isShowing() {
        return this.mShowing;
    }

    void postActivate(long ms) {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("postActivate: " + ms));
        }
        if (ms > 0L) {
            if (this.isAttached()) {
                this.postDelayed(this.activateRunnable, ms);
            }
        } else {
            this.mActivated = true;
        }
    }

    void removeFromParent() {
        ViewParent parent;
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("removeFromParent: " + this.toolTipId));
        }
        if (null != (parent = this.getParent())) {
            if (null != this.getHandler()) {
                this.getHandler().removeCallbacks(this.hideRunnable);
            }
            ((ViewGroup)parent).removeView((View)this);
            if (null != this.mShowAnimation && this.mShowAnimation.isStarted()) {
                this.mShowAnimation.cancel();
            }
        }
    }

    protected void fadeOut(final boolean remove) {
        if (!this.isAttached() || !this.mShowing) {
            return;
        }
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"fadeOut");
        }
        if (null != this.mShowAnimation) {
            this.mShowAnimation.cancel();
        }
        this.mShowing = false;
        if (this.fadeDuration > 0L) {
            float alpha = this.getAlpha();
            this.mShowAnimation = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{alpha, 0.0f});
            this.mShowAnimation.setDuration(this.fadeDuration);
            this.mShowAnimation.addListener(new Animator.AnimatorListener(){
                boolean cancelled;

                public void onAnimationStart(Animator animation) {
                    this.cancelled = false;
                }

                public void onAnimationEnd(Animator animation) {
                    if (TooltipManager.DBG) {
                        Log.i((String)TooltipView.TAG, (String)("fadeout::onAnimationEnd, cancelled: " + this.cancelled));
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (remove) {
                        TooltipView.this.fireOnHideCompleted();
                    }
                    TooltipView.this.mShowAnimation = null;
                }

                public void onAnimationCancel(Animator animation) {
                    if (TooltipManager.DBG) {
                        Log.i((String)TooltipView.TAG, (String)"fadeout::onAnimationCancel");
                    }
                    this.cancelled = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mShowAnimation.start();
        } else {
            this.setVisibility(4);
            if (remove) {
                this.fireOnHideCompleted();
            }
        }
    }

    private void fireOnHideCompleted() {
        if (null != this.tooltipListener) {
            this.tooltipListener.onHideCompleted(this);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("onLayout, changed: " + changed + ", " + l + ", " + t + ", " + r + ", " + b));
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.layout(child.getLeft(), child.getTop(), child.getMeasuredWidth(), child.getMeasuredHeight());
        }
        if (changed) {
            this.viewGravities.clear();
            this.viewGravities.addAll(gravities);
            this.viewGravities.remove((Object)this.gravity);
            this.viewGravities.add(0, this.gravity);
            this.calculatePositions(this.viewGravities);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"onMeasure");
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int myWidth = 0;
        int myHeight = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        if (TooltipManager.DBG) {
            Log.v((String)TAG, (String)("myWidth: " + myWidth));
            Log.v((String)TAG, (String)("myHeight: " + myHeight));
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)myWidth, (int)Integer.MIN_VALUE);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)myHeight, (int)Integer.MIN_VALUE);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.setMeasuredDimension(myWidth, myHeight);
    }

    protected void onAttachedToWindow() {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"onAttachedToWindow");
        }
        super.onAttachedToWindow();
        this.mAttached = true;
        this.initializeView();
        this.show();
    }

    protected void onDetachedFromWindow() {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"onDetachedFromWindow");
        }
        super.onDetachedFromWindow();
        this.removeTreeObserver();
        this.mAttached = false;
        this.mViewAnchor = null;
    }

    private void removeTreeObserver() {
        View view;
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"removeTreeObserver");
        }
        if (null != this.mViewAnchor && null != (view = (View)this.mViewAnchor.get())) {
            if (Build.VERSION.SDK_INT >= 16) {
                view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }

    private void initializeView() {
        if (!this.isAttached() || this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)"initializeView");
        }
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        this.mView = LayoutInflater.from((Context)this.getContext()).inflate(this.textResId, (ViewGroup)this, false);
        this.mView.setLayoutParams(params);
        if (null != this.mDrawable) {
            this.mView.setBackgroundDrawable((Drawable)this.mDrawable);
            if (this.hideArrow) {
                this.mView.setPadding(this.padding / 2, this.padding / 2, this.padding / 2, this.padding / 2);
            } else {
                this.mView.setPadding(this.padding, this.padding, this.padding, this.padding);
            }
        }
        this.mTextView = (TextView)this.mView.findViewById(16908308);
        this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)this.text)));
        if (this.maxWidth > -1) {
            this.mTextView.setMaxWidth(this.maxWidth);
        }
        if (0 != this.textAppearance) {
            this.mTextView.setTextAppearance(this.getContext(), this.textAppearance);
        }
        this.addView(this.mView);
    }

    private void calculatePositions(List<TooltipManager.Gravity> gravities) {
        if (!this.isAttached()) {
            return;
        }
        if (gravities.size() < 1) {
            if (null != this.tooltipListener) {
                this.tooltipListener.onShowFailed(this);
            }
            this.setVisibility(8);
            return;
        }
        TooltipManager.Gravity gravity = gravities.remove(0);
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("calculatePositions: " + (Object)((Object)gravity) + ", gravities: " + gravities.size()));
        }
        Rect screenRect = new Rect();
        Activity act = TooltipManager.getActivity(this.getContext());
        if (act != null) {
            Window window = act.getWindow();
            window.getDecorView().getWindowVisibleDisplayFrame(screenRect);
        } else {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            display.getRectSize(screenRect);
        }
        int statusbarHeight = screenRect.top;
        if (this.viewRect == null) {
            this.viewRect = new Rect();
            this.viewRect.set(this.point.x, this.point.y + statusbarHeight, this.point.x, this.point.y + statusbarHeight);
        }
        screenRect.top += this.topRule;
        int width = this.mView.getWidth();
        int height = this.mView.getMeasuredHeight();
        if (TooltipManager.DBG) {
            Log.v((String)TAG, (String)("mView.size: " + width + "x" + height));
        }
        Point point = new Point();
        if (gravity == TooltipManager.Gravity.BOTTOM) {
            this.drawRect.set(this.viewRect.centerX() - width / 2, this.viewRect.bottom, this.viewRect.centerX() + width / 2, this.viewRect.bottom + height);
            point.x = this.viewRect.centerX();
            point.y = this.viewRect.bottom;
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                if (this.drawRect.right > screenRect.right) {
                    this.drawRect.offset(screenRect.right - this.drawRect.right, 0);
                } else if (this.drawRect.left < screenRect.left) {
                    this.drawRect.offset(-this.drawRect.left, 0);
                }
                if (this.drawRect.bottom > screenRect.bottom) {
                    this.calculatePositions(gravities);
                    return;
                }
                if (this.drawRect.top < screenRect.top) {
                    this.drawRect.offset(0, screenRect.top - this.drawRect.top);
                }
            }
        } else if (gravity == TooltipManager.Gravity.TOP) {
            this.drawRect.set(this.viewRect.centerX() - width / 2, this.viewRect.top - height, this.viewRect.centerX() + width / 2, this.viewRect.top);
            point.x = this.viewRect.centerX();
            point.y = this.viewRect.top;
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                if (this.drawRect.right > screenRect.right) {
                    this.drawRect.offset(screenRect.right - this.drawRect.right, 0);
                } else if (this.drawRect.left < screenRect.left) {
                    this.drawRect.offset(-this.drawRect.left, 0);
                }
                if (this.drawRect.top < screenRect.top) {
                    this.calculatePositions(gravities);
                    return;
                }
                if (this.drawRect.bottom > screenRect.bottom) {
                    this.drawRect.offset(0, screenRect.bottom - this.drawRect.bottom);
                }
            }
        } else if (gravity == TooltipManager.Gravity.RIGHT) {
            this.drawRect.set(this.viewRect.right, this.viewRect.centerY() - height / 2, this.viewRect.right + width, this.viewRect.centerY() + height / 2);
            point.x = this.viewRect.right;
            point.y = this.viewRect.centerY();
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                if (this.drawRect.bottom > screenRect.bottom) {
                    this.drawRect.offset(0, screenRect.bottom - this.drawRect.bottom);
                } else if (this.drawRect.top < screenRect.top) {
                    this.drawRect.offset(0, screenRect.top - this.drawRect.top);
                }
                if (this.drawRect.right > screenRect.right) {
                    this.calculatePositions(gravities);
                    return;
                }
                if (this.drawRect.left < screenRect.left) {
                    this.drawRect.offset(screenRect.left - this.drawRect.left, 0);
                }
            }
        } else if (gravity == TooltipManager.Gravity.LEFT) {
            this.drawRect.set(this.viewRect.left - width, this.viewRect.centerY() - height / 2, this.viewRect.left, this.viewRect.centerY() + height / 2);
            point.x = this.viewRect.left;
            point.y = this.viewRect.centerY();
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                if (this.drawRect.bottom > screenRect.bottom) {
                    this.drawRect.offset(0, screenRect.bottom - this.drawRect.bottom);
                } else if (this.drawRect.top < screenRect.top) {
                    this.drawRect.offset(0, screenRect.top - this.drawRect.top);
                }
                if (this.drawRect.left < screenRect.left) {
                    this.gravity = TooltipManager.Gravity.RIGHT;
                    this.calculatePositions(gravities);
                    return;
                }
                if (this.drawRect.right > screenRect.right) {
                    this.drawRect.offset(screenRect.right - this.drawRect.right, 0);
                }
            }
        } else if (this.gravity == TooltipManager.Gravity.CENTER) {
            this.drawRect.set(this.viewRect.centerX() - width / 2, this.viewRect.centerY() - height / 2, this.viewRect.centerX() - width / 2, this.viewRect.centerY() + height / 2);
            point.x = this.viewRect.centerX();
            point.y = this.viewRect.centerY();
            if (this.restrict && !screenRect.contains(this.drawRect)) {
                if (this.drawRect.bottom > screenRect.bottom) {
                    this.drawRect.offset(0, screenRect.bottom - this.drawRect.bottom);
                } else if (this.drawRect.top < screenRect.top) {
                    this.drawRect.offset(0, screenRect.top - this.drawRect.top);
                }
                if (this.drawRect.right > screenRect.right) {
                    this.drawRect.offset(screenRect.right - this.drawRect.right, 0);
                } else if (this.drawRect.left < screenRect.left) {
                    this.drawRect.offset(screenRect.left - this.drawRect.left, 0);
                }
            }
        }
        if (TooltipManager.DBG) {
            Log.d((String)TAG, (String)("screenRect: " + screenRect + ", topRule: " + this.topRule + ", statusBar: " + statusbarHeight));
            Log.d((String)TAG, (String)("drawRect: " + this.drawRect));
        }
        this.mView.setTranslationX((float)this.drawRect.left);
        this.mView.setTranslationY((float)this.drawRect.top);
        if (null != this.mDrawable) {
            this.mView.getGlobalVisibleRect(this.tempRect);
            if (TooltipManager.DBG) {
                Log.v((String)TAG, (String)("mView visible rect: " + this.tempRect));
            }
            point.x -= this.tempRect.left;
            point.y -= this.tempRect.top;
            if (!this.hideArrow) {
                if (gravity == TooltipManager.Gravity.LEFT || gravity == TooltipManager.Gravity.RIGHT) {
                    point.y -= this.padding / 2;
                } else if (gravity == TooltipManager.Gravity.TOP || gravity == TooltipManager.Gravity.BOTTOM) {
                    point.x -= this.padding / 2;
                }
            }
            this.mDrawable.setAnchor(gravity, this.hideArrow ? 0 : this.padding / 2, this.hideArrow ? null : point);
        }
    }

    @Override
    public void setOffsetX(int x) {
        this.setTranslationX(x - this.viewRect.left);
    }

    @Override
    public void setOffsetY(int y) {
        this.setTranslationY(y - this.viewRect.top);
    }

    @Override
    public void offsetTo(int x, int y) {
        this.setTranslationX(x - this.viewRect.left);
        this.setTranslationY(y - this.viewRect.top);
    }

    @Override
    public boolean isAttached() {
        return this.mAttached;
    }

    void setText(CharSequence text) {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("setText: " + text));
        }
        this.text = text;
        if (null != this.mTextView) {
            this.mTextView.setText((CharSequence)Html.fromHtml((String)((String)text)));
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!(this.mAttached && this.mShowing && this.isShown())) {
            return false;
        }
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("onTouchEvent: " + event.getAction() + ", active: " + this.mActivated));
        }
        int action = event.getActionMasked();
        if (this.closePolicy == TooltipManager.ClosePolicy.TouchOutside || this.closePolicy == TooltipManager.ClosePolicy.TouchInside || this.closePolicy == TooltipManager.ClosePolicy.TouchInsideExclusive || this.closePolicy == TooltipManager.ClosePolicy.TouchOutsideExclusive) {
            if (!this.mActivated) {
                if (TooltipManager.DBG) {
                    Log.w((String)TAG, (String)("not yet activated..., " + action));
                }
                return true;
            }
            if (action == 0) {
                boolean containsTouch = this.drawRect.contains((int)event.getX(), (int)event.getY());
                if (this.closePolicy == TooltipManager.ClosePolicy.TouchInside || this.closePolicy == TooltipManager.ClosePolicy.TouchInsideExclusive) {
                    if (containsTouch) {
                        this.onClose(true, true);
                        return true;
                    }
                    return this.closePolicy == TooltipManager.ClosePolicy.TouchInsideExclusive;
                }
                this.onClose(true, containsTouch);
                return this.closePolicy == TooltipManager.ClosePolicy.TouchOutsideExclusive || containsTouch;
            }
        }
        return false;
    }

    private void onClose(boolean fromUser, boolean containsTouch) {
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("onClose. fromUser: " + fromUser + ", containsTouch: " + containsTouch));
        }
        if (null == this.getHandler()) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        this.getHandler().removeCallbacks(this.hideRunnable);
        if (null != this.closeListener) {
            this.closeListener.onClose(this);
        }
        if (null != this.closeCallback) {
            this.closeCallback.onClosing(this.toolTipId, fromUser, containsTouch);
        }
    }

    void setOnCloseListener(OnCloseListener listener) {
        this.closeListener = listener;
    }

    void setOnToolTipListener(OnToolTipListener listener) {
        this.tooltipListener = listener;
    }

    public void onGlobalLayout() {
        if (!this.mAttached) {
            this.removeTreeObserver();
            return;
        }
        if (TooltipManager.DBG) {
            Log.i((String)TAG, (String)("onGlobalLayout: " + this.mViewAnchor));
        }
        if (null != this.mViewAnchor) {
            View view = (View)this.mViewAnchor.get();
            if (null != view) {
                Rect rect = new Rect();
                view.getGlobalVisibleRect(rect);
                if (TooltipManager.DBG) {
                    Log.v((String)TAG, (String)("oldRect: " + this.viewRect));
                    Log.v((String)TAG, (String)("newRect: " + rect));
                    Log.v((String)TAG, (String)("equals: " + this.viewRect.equals((Object)rect)));
                }
                if (!this.viewRect.equals((Object)rect)) {
                    this.viewRect.set(rect);
                    this.viewGravities.clear();
                    this.viewGravities.addAll(gravities);
                    this.viewGravities.remove((Object)this.gravity);
                    this.viewGravities.add(0, this.gravity);
                    this.calculatePositions(this.viewGravities);
                    this.requestLayout();
                }
            } else if (TooltipManager.DBG) {
                Log.w((String)TAG, (String)"view is null");
            }
        }
    }

    static interface OnToolTipListener {
        public void onHideCompleted(TooltipView var1);

        public void onShowCompleted(TooltipView var1);

        public void onShowFailed(TooltipView var1);
    }

    static interface OnCloseListener {
        public void onClose(TooltipView var1);
    }
}

