/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.GeometryKt;
import it.sephiroth.android.library.uigestures.UIDiscreteGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0001AB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000201H\u0002J\b\u00103\u001a\u000201H\u0002J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0014J\b\u00107\u001a\u000201H\u0002J\b\u00108\u001a\u00020\u0013H\u0016J\u0010\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\u0001H\u0016J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u000201H\u0002J\b\u0010?\u001a\u000201H\u0014J\b\u0010@\u001a\u000201H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010\u0011R\u001a\u0010*\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u001a\u0010-\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 \u00a8\u0006B"}, d2={"Lit/sephiroth/android/library/uigestures/UITapGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIDiscreteGestureRecognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentLocationX", "", "getCurrentLocationX", "()F", "currentLocationY", "getCurrentLocationY", "doubleTapTimeout", "", "getDoubleTapTimeout", "()J", "setDoubleTapTimeout", "(J)V", "mAlwaysInTapRegion", "", "mDownCurrentLocation", "Landroid/graphics/PointF;", "mDownFocus", "mNumTaps", "", "mPreviousTapLocation", "mStarted", "<set-?>", "numberOfTouches", "getNumberOfTouches", "()I", "setNumberOfTouches$uigesturerecognizer_release", "(I)V", "scaledDoubleTapSlop", "getScaledDoubleTapSlop", "setScaledDoubleTapSlop", "scaledTouchSlop", "getScaledTouchSlop", "setScaledTouchSlop", "tapTimeout", "getTapTimeout", "setTapTimeout", "tapsRequired", "getTapsRequired", "setTapsRequired", "touchesRequired", "getTouchesRequired", "setTouchesRequired", "delayedFail", "", "fireActionEventIfCanRecognizeSimultaneously", "handleFailed", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onStateChanged", "recognizer", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "postReset", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UITapGestureRecognizer
extends UIGestureRecognizer
implements UIDiscreteGestureRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int touchesRequired;
    private int numberOfTouches;
    private int tapsRequired;
    private long tapTimeout;
    private long doubleTapTimeout;
    private int scaledTouchSlop;
    private int scaledDoubleTapSlop;
    private boolean mAlwaysInTapRegion;
    @NotNull
    private PointF mDownFocus;
    private boolean mStarted;
    private int mNumTaps;
    @NotNull
    private final PointF mPreviousTapLocation;
    @NotNull
    private final PointF mDownCurrentLocation;
    private static final int MESSAGE_FAILED = 1;
    private static final int MESSAGE_RESET = 2;
    private static final int MESSAGE_POINTER_UP = 3;
    private static final int MESSAGE_LONG_PRESS = 4;

    public UITapGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.touchesRequired = 1;
        this.tapsRequired = 1;
        this.tapTimeout = UIGestureRecognizer.Companion.getTAP_TIMEOUT();
        this.doubleTapTimeout = UIGestureRecognizer.Companion.getDOUBLE_TAP_TIMEOUT();
        this.mDownFocus = new PointF();
        this.mPreviousTapLocation = new PointF();
        this.mDownCurrentLocation = new PointF();
        this.mStarted = false;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.scaledTouchSlop = configuration.getScaledTouchSlop();
        this.scaledDoubleTapSlop = configuration.getScaledDoubleTapSlop();
        if (UIGestureRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "tapTimeout: " + this.tapTimeout);
            this.logMessage(4, "doubleTapTimeout: " + this.doubleTapTimeout);
            this.logMessage(4, "scaledTouchSlop: " + this.scaledTouchSlop);
            this.logMessage(4, "scaledDoubleTapSlop: " + this.scaledDoubleTapSlop);
        }
    }

    @Override
    public float getCurrentLocationX() {
        return this.mDownCurrentLocation.x;
    }

    @Override
    public float getCurrentLocationY() {
        return this.mDownCurrentLocation.y;
    }

    public final int getTouchesRequired() {
        return this.touchesRequired;
    }

    public final void setTouchesRequired(int n) {
        this.touchesRequired = n;
    }

    @Override
    public int getNumberOfTouches() {
        return this.numberOfTouches;
    }

    public void setNumberOfTouches$uigesturerecognizer_release(int n) {
        this.numberOfTouches = n;
    }

    public final int getTapsRequired() {
        return this.tapsRequired;
    }

    public final void setTapsRequired(int n) {
        this.tapsRequired = n;
    }

    public final long getTapTimeout() {
        return this.tapTimeout;
    }

    public final void setTapTimeout(long l) {
        this.tapTimeout = l;
    }

    public final long getDoubleTapTimeout() {
        return this.doubleTapTimeout;
    }

    public final void setDoubleTapTimeout(long l) {
        this.doubleTapTimeout = l;
    }

    public final int getScaledTouchSlop() {
        return this.scaledTouchSlop;
    }

    public final void setScaledTouchSlop(int n) {
        this.scaledTouchSlop = n;
    }

    public final int getScaledDoubleTapSlop() {
        return this.scaledDoubleTapSlop;
    }

    public final void setScaledDoubleTapSlop(int n) {
        this.scaledDoubleTapSlop = n;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (msg.what) {
            case 2: {
                this.logMessage(4, "handleMessage(MESSAGE_RESET)");
                this.handleReset();
                break;
            }
            case 1: {
                this.logMessage(4, "handleMessage(MESSAGE_FAILED)");
                this.handleFailed();
                break;
            }
            case 3: {
                this.logMessage(4, "handleMessage(MESSAGE_POINTER_UP)");
                this.setNumberOfTouches$uigesturerecognizer_release(msg.arg1);
                break;
            }
            case 4: {
                this.logMessage(4, "handleMessage(MESSAGE_LONG_PRESS)");
                this.handleFailed();
            }
        }
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (UIGestureRecognizer.Companion.getLogEnabled()) {
            UIGestureRecognizer.State state = recognizer.getState();
            this.logMessage(2, "onStateChanged(" + (state != null ? state.name() : null) + ")");
            this.logMessage(2, "mStarted: " + this.mStarted);
        }
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Ended) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
            this.postReset();
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.mStarted && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Ended})) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
                this.mStarted = false;
            }
        }
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        int count = event.getPointerCount();
        switch (action) {
            case 0: {
                if (!this.mStarted) {
                    Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) {
                        return this.getCancelsTouchesInView();
                    }
                }
                this.removeMessages();
                this.mAlwaysInTapRegion = true;
                this.setNumberOfTouches$uigesturerecognizer_release(count);
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                if (!this.mStarted) {
                    this.stopListenForOtherStateChanges();
                    this.mNumTaps = 0;
                    this.mStarted = true;
                } else if (this.touchesRequired == 1 && this.tapsRequired > 1) {
                    float distance = GeometryKt.distance(this.getMDownLocation(), this.getMPreviousDownLocation());
                    this.logMessage(2, "distance: " + distance);
                    if (distance > (float)this.scaledDoubleTapSlop) {
                        this.logMessage(5, "second touch too far away (" + distance + " > " + this.scaledDoubleTapSlop + ")");
                        this.handleFailed();
                        return this.getCancelsTouchesInView();
                    }
                }
                this.getMHandler().sendEmptyMessageDelayed(4, this.tapTimeout + (long)5);
                int distance = this.mNumTaps;
                this.mNumTaps = distance + 1;
                this.mDownFocus.set(this.getMCurrentLocation());
                this.mDownCurrentLocation.set(this.getMCurrentLocation());
                break;
            }
            case 5: {
                if (this.getState() != UIGestureRecognizer.State.Possible || !this.mStarted) break;
                int[] distance = new int[]{3};
                this.removeMessages(distance);
                this.setNumberOfTouches$uigesturerecognizer_release(count);
                if (this.getNumberOfTouches() > 1) {
                    if (this.getNumberOfTouches() > this.touchesRequired) {
                        this.logMessage(5, "too many touches: " + this.getNumberOfTouches() + " > " + this.touchesRequired);
                        this.setState(UIGestureRecognizer.State.Failed);
                    } else if (this.getNumberOfTouches() == this.touchesRequired && this.tapsRequired > 1) {
                        if (this.mNumTaps < this.tapsRequired) {
                            this.mPreviousTapLocation.set(this.getMCurrentLocation());
                        } else if (this.mNumTaps == this.tapsRequired && (distance = GeometryKt.distance(this.getMCurrentLocation(), this.mPreviousTapLocation)) > (float)this.scaledDoubleTapSlop) {
                            this.logMessage(5, "distance is " + distance + " > " + this.scaledDoubleTapSlop);
                            this.handleFailed();
                            return this.getCancelsTouchesInView();
                        }
                    }
                }
                this.mDownFocus.set(this.getMCurrentLocation());
                this.mDownCurrentLocation.set(this.getMCurrentLocation());
                break;
            }
            case 6: {
                if (this.getState() != UIGestureRecognizer.State.Possible || !this.mStarted) break;
                int[] distance = new int[]{1, 2, 3};
                this.removeMessages(distance);
                this.mDownFocus.set(this.getMCurrentLocation());
                Message message = this.getMHandler().obtainMessage(3);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtainMessage(...)");
                Message message2 = message;
                message2.arg1 = this.getNumberOfTouches() - 1;
                this.getMHandler().sendMessageDelayed(message2, UIGestureRecognizer.Companion.getTAP_TIMEOUT());
                break;
            }
            case 2: {
                int slop;
                if (this.getState() != UIGestureRecognizer.State.Possible || !this.mStarted || !this.mAlwaysInTapRegion) break;
                float distance = GeometryKt.distance(this.mDownFocus, this.getMCurrentLocation());
                int n = slop = this.touchesRequired > 1 && this.tapsRequired > 1 ? this.scaledDoubleTapSlop : this.scaledTouchSlop;
                if (!(distance > (float)slop)) break;
                this.mDownCurrentLocation.set(this.getMCurrentLocation());
                this.logMessage(5, "distance: " + distance + ", slop: " + slop);
                this.mAlwaysInTapRegion = false;
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
                break;
            }
            case 1: {
                Object[] objectArray = new int[]{2, 3, 4};
                this.removeMessages((int[])objectArray);
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    if (this.getNumberOfTouches() != this.touchesRequired) {
                        this.logMessage(5, "number touches not correct: " + this.getNumberOfTouches() + " != " + this.touchesRequired);
                        this.handleFailed();
                        break;
                    }
                    if (this.mNumTaps < this.tapsRequired) {
                        this.delayedFail();
                        break;
                    }
                    Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    Boolean bl = function1 != null && (function1 = function1.getShouldBegin()) != null ? (Boolean)function1.invoke((Object)this) : null;
                    Intrinsics.checkNotNull(bl);
                    if (bl.booleanValue()) {
                        this.setState(UIGestureRecognizer.State.Ended);
                        if (this.getRequireFailureOf() == null) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            this.postReset();
                        } else {
                            UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                            Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                            if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                                this.postReset();
                            } else {
                                UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                                Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                                objectArray = (Object[])new UIGestureRecognizer.State[3];
                                objectArray[0] = (int)UIGestureRecognizer.State.Began;
                                objectArray[1] = (int)UIGestureRecognizer.State.Ended;
                                objectArray[2] = (int)UIGestureRecognizer.State.Changed;
                                if (uIGestureRecognizer2.inState((UIGestureRecognizer.State[])objectArray)) {
                                    this.setState(UIGestureRecognizer.State.Failed);
                                } else {
                                    this.listenForOtherStateChanges();
                                }
                            }
                        }
                    } else {
                        this.setState(UIGestureRecognizer.State.Failed);
                    }
                    this.mStarted = false;
                    break;
                }
                this.handleReset();
                break;
            }
            case 3: {
                this.removeMessages();
                this.mStarted = false;
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.postReset();
            }
        }
        return this.getCancelsTouchesInView();
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
        Boolean bl = uIGestureRecognizerDelegate != null ? Boolean.valueOf(uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) : null;
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue()) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Ended};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{1, 2, 3, 4};
        this.removeMessages(nArray);
    }

    private final void postReset() {
        this.getMHandler().sendEmptyMessage(2);
    }

    private final void delayedFail() {
        this.getMHandler().sendEmptyMessageDelayed(1, this.doubleTapTimeout);
    }

    private final void handleFailed() {
        this.setState(UIGestureRecognizer.State.Failed);
        this.setBeginFiringEvents(false);
        this.removeMessages();
        this.mStarted = false;
    }

    private final void handleReset() {
        this.setState(UIGestureRecognizer.State.Possible);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lit/sephiroth/android/library/uigestures/UITapGestureRecognizer$Companion;", "", "()V", "MESSAGE_FAILED", "", "MESSAGE_LONG_PRESS", "MESSAGE_POINTER_UP", "MESSAGE_RESET", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

