/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.GeometryKt;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020?H\u0014J\b\u0010@\u001a\u00020<H\u0002J\b\u0010A\u001a\u00020\u0007H\u0016J\u0010\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020\u0001H\u0016J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020<H\u0014J\b\u0010H\u001a\u00020<H\u0016R\u0017\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u0019R\u0017\u0010\u001f\u001a\u00020 8F\u00a2\u0006\f\u0012\u0004\b!\u0010\t\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020 8F\u00a2\u0006\f\u0012\u0004\b%\u0010\t\u001a\u0004\b&\u0010#R\u001a\u0010'\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0017\"\u0004\b)\u0010\u0019R\u001e\u0010+\u001a\u00020 2\u0006\u0010*\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010#R\u001e\u0010-\u001a\u00020 2\u0006\u0010*\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010#R\u0011\u0010/\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010#R\u0011\u00101\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010#R\u001e\u00103\u001a\u00020 2\u0006\u0010*\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010#R\u001e\u00105\u001a\u00020 2\u0006\u0010*\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010#R\u001e\u00107\u001a\u00020 2\u0006\u0010*\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010#R\u001e\u00109\u001a\u00020 2\u0006\u0010*\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010#\u00a8\u0006J"}, d2={"Lit/sephiroth/android/library/uigestures/UIPanGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIContinuousRecognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isFling", "", "isFling$annotations", "()V", "()Z", "mDown", "mDownFocusLocation", "Landroid/graphics/PointF;", "mLastFocusLocation", "mStartLocation", "mStarted", "mVelocityTracker", "Landroid/view/VelocityTracker;", "maximumFlingVelocity", "", "maximumNumberOfTouches", "getMaximumNumberOfTouches", "()I", "setMaximumNumberOfTouches", "(I)V", "minimumFlingVelocity", "getMinimumFlingVelocity", "minimumNumberOfTouches", "getMinimumNumberOfTouches", "setMinimumNumberOfTouches", "relativeScrollX", "", "getRelativeScrollX$annotations", "getRelativeScrollX", "()F", "relativeScrollY", "getRelativeScrollY$annotations", "getRelativeScrollY", "scaledTouchSlop", "getScaledTouchSlop", "setScaledTouchSlop", "<set-?>", "scrollX", "getScrollX", "scrollY", "getScrollY", "startLocationX", "getStartLocationX", "startLocationY", "getStartLocationY", "translationX", "getTranslationX", "translationY", "getTranslationY", "xVelocity", "getXVelocity", "yVelocity", "getYVelocity", "fireActionEventIfCanRecognizeSimultaneously", "", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onStateChanged", "recognizer", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UIPanGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int scaledTouchSlop;
    private final int minimumFlingVelocity;
    private final int maximumFlingVelocity;
    private int minimumNumberOfTouches;
    private int maximumNumberOfTouches;
    private float scrollX;
    private float scrollY;
    private float translationX;
    private float translationY;
    private float yVelocity;
    private float xVelocity;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private boolean mDown;
    private boolean mStarted;
    @NotNull
    private PointF mLastFocusLocation;
    @NotNull
    private PointF mDownFocusLocation;
    @NotNull
    private PointF mStartLocation;
    private static final int MESSAGE_RESET = 4;

    public UIPanGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.minimumNumberOfTouches = 1;
        this.maximumNumberOfTouches = Integer.MAX_VALUE;
        this.mLastFocusLocation = new PointF();
        this.mDownFocusLocation = new PointF();
        this.mStartLocation = new PointF();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.minimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.scaledTouchSlop = configuration.getScaledTouchSlop();
        if (UIGestureRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "scaledTouchSlop: " + this.scaledTouchSlop);
            this.logMessage(4, "minimumFlingVelocity: " + this.minimumFlingVelocity);
            this.logMessage(4, "maximumFlingVelocity: " + this.maximumFlingVelocity);
        }
    }

    public final int getScaledTouchSlop() {
        return this.scaledTouchSlop;
    }

    public final void setScaledTouchSlop(int n) {
        this.scaledTouchSlop = n;
    }

    public final int getMinimumFlingVelocity() {
        return this.minimumFlingVelocity;
    }

    public final int getMinimumNumberOfTouches() {
        return this.minimumNumberOfTouches;
    }

    public final void setMinimumNumberOfTouches(int n) {
        this.minimumNumberOfTouches = n;
    }

    public final int getMaximumNumberOfTouches() {
        return this.maximumNumberOfTouches;
    }

    public final void setMaximumNumberOfTouches(int n) {
        this.maximumNumberOfTouches = n;
    }

    public final float getScrollX() {
        return this.scrollX;
    }

    public final float getScrollY() {
        return this.scrollY;
    }

    public final float getRelativeScrollX() {
        return -this.scrollX;
    }

    public static /* synthetic */ void getRelativeScrollX$annotations() {
    }

    public final float getRelativeScrollY() {
        return -this.scrollY;
    }

    public static /* synthetic */ void getRelativeScrollY$annotations() {
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final float getYVelocity() {
        return this.yVelocity;
    }

    public final float getXVelocity() {
        return this.xVelocity;
    }

    public final boolean isFling() {
        return this.getState() == UIGestureRecognizer.State.Ended && (Math.abs(this.xVelocity) > (float)this.minimumFlingVelocity || Math.abs(this.yVelocity) > (float)this.minimumFlingVelocity);
    }

    public static /* synthetic */ void isFling$annotations() {
    }

    public final float getStartLocationX() {
        return this.mStartLocation.x;
    }

    public final float getStartLocationY() {
        return this.mStartLocation.y;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg.what == 4) {
            this.handleReset();
        }
    }

    private final void handleReset() {
        this.mStarted = false;
        this.mDown = false;
        this.setBeginFiringEvents(false);
        this.setState(UIGestureRecognizer.State.Possible);
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.mStarted && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began})) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
                this.setBeginFiringEvents(false);
                this.mStarted = false;
            }
        }
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        VelocityTracker tracker = velocityTracker;
        switch (action) {
            case 5: {
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.mLastFocusLocation);
                if (!this.mDown || this.getState() != UIGestureRecognizer.State.Possible) break;
                int n = this.minimumNumberOfTouches;
                int n2 = this.maximumNumberOfTouches;
                int n3 = this.getNumberOfTouches();
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl) {
                    this.computeFocusPoint(event, this.mStartLocation);
                    break;
                }
                if (this.getNumberOfTouches() <= this.maximumNumberOfTouches) break;
                this.setState(UIGestureRecognizer.State.Failed);
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 6: {
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.mLastFocusLocation);
                tracker.computeCurrentVelocity(1000, (float)this.maximumFlingVelocity);
                int upIndex = event.getActionIndex();
                int id1 = event.getPointerId(upIndex);
                float x1 = tracker.getXVelocity(id1);
                float y1 = tracker.getYVelocity(id1);
                int n = event.getPointerCount();
                for (int i = 0; i < n; ++i) {
                    float y;
                    int id2;
                    float x;
                    float dot;
                    if (i == upIndex || !((dot = (x = x1 * tracker.getXVelocity(id2 = event.getPointerId(i))) + (y = y1 * tracker.getYVelocity(id2))) < 0.0f)) continue;
                    tracker.clear();
                    break;
                }
                if (!this.mDown || this.getState() != UIGestureRecognizer.State.Possible) break;
                this.computeFocusPoint(event, this.mStartLocation);
                if (this.getNumberOfTouches() >= this.minimumNumberOfTouches) break;
                this.setState(UIGestureRecognizer.State.Failed);
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 0: {
                if (!this.mStarted) {
                    Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) {
                        this.mDown = false;
                        this.mStarted = false;
                        return this.getCancelsTouchesInView();
                    }
                }
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.mLastFocusLocation);
                this.mStartLocation.set(this.getMCurrentLocation());
                tracker.clear();
                tracker.addMovement(event);
                this.mStarted = false;
                this.mDown = true;
                this.stopListenForOtherStateChanges();
                int[] upIndex = new int[]{4};
                this.removeMessages(upIndex);
                this.setState(UIGestureRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                break;
            }
            case 2: {
                this.scrollX = this.mLastFocusLocation.x - this.getMCurrentLocation().x;
                this.scrollY = this.mLastFocusLocation.y - this.getMCurrentLocation().y;
                tracker.addMovement(event);
                if (this.getState() == UIGestureRecognizer.State.Possible && !this.mStarted && this.mDown) {
                    float distance = GeometryKt.distance(this.getMCurrentLocation(), this.mDownFocusLocation);
                    this.logMessage(2, "distance: " + distance + " > " + this.scaledTouchSlop);
                    if (!(distance > (float)this.scaledTouchSlop)) break;
                    tracker.computeCurrentVelocity(1000, (float)this.maximumFlingVelocity);
                    this.yVelocity = tracker.getYVelocity();
                    this.xVelocity = tracker.getXVelocity();
                    this.translationX -= this.scrollX;
                    this.translationY -= this.scrollY;
                    this.mLastFocusLocation.set(this.getMCurrentLocation());
                    this.mStarted = true;
                    this.logMessage(2, "touches: " + this.getNumberOfTouches() + " in " + this.minimumNumberOfTouches + " .. " + this.maximumNumberOfTouches);
                    int n = this.minimumNumberOfTouches;
                    int n4 = this.maximumNumberOfTouches;
                    int n5 = this.getNumberOfTouches();
                    boolean bl = n <= n5 ? n5 <= n4 : false;
                    if (bl) {
                        Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                        Boolean bl2 = function1 != null && (function1 = function1.getShouldBegin()) != null ? (Boolean)function1.invoke((Object)this) : null;
                        Intrinsics.checkNotNull(bl2);
                        if (bl2.booleanValue()) {
                            this.setState(UIGestureRecognizer.State.Began);
                            if (this.getRequireFailureOf() == null) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                                break;
                            }
                            UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                            Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                            if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                                break;
                            }
                            UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                            Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed};
                            if (uIGestureRecognizer2.inState(stateArray)) {
                                this.setState(UIGestureRecognizer.State.Failed);
                                break;
                            }
                            this.listenForOtherStateChanges();
                            this.setBeginFiringEvents(false);
                            this.logMessage(3, "waiting...");
                            break;
                        }
                    }
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                UIGestureRecognizer.State[] distance = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
                if (!this.inState(distance) || !this.mDown) break;
                this.translationX -= this.scrollX;
                this.translationY -= this.scrollY;
                int pointerId = event.getPointerId(0);
                tracker.computeCurrentVelocity(1000, (float)this.maximumFlingVelocity);
                this.yVelocity = tracker.getYVelocity(pointerId);
                this.xVelocity = tracker.getXVelocity(pointerId);
                if (this.hasBeganFiringEvents()) {
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                }
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                break;
            }
            case 1: {
                UIGestureRecognizer.State[] pointerId = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
                if (this.inState(pointerId)) {
                    if (this.getState() == UIGestureRecognizer.State.Changed) {
                        this.scrollX = this.mLastFocusLocation.x - this.getMCurrentLocation().x;
                        this.scrollY = this.mLastFocusLocation.y - this.getMCurrentLocation().y;
                        this.translationX -= this.scrollX;
                        this.translationY -= this.scrollY;
                    }
                    boolean began = this.hasBeganFiringEvents();
                    this.setState(UIGestureRecognizer.State.Ended);
                    if (began) {
                        this.fireActionEvent();
                    }
                }
                if (this.getState() == UIGestureRecognizer.State.Possible || !this.mStarted) {
                    this.xVelocity = this.yVelocity = 0.0f;
                }
                if (this.mVelocityTracker != null) {
                    VelocityTracker velocityTracker2 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker2);
                    velocityTracker2.recycle();
                    this.mVelocityTracker = null;
                }
                this.getMHandler().sendEmptyMessage(4);
                break;
            }
            case 3: {
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.getMHandler().sendEmptyMessage(4);
            }
        }
        return this.getCancelsTouchesInView();
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended};
        if (this.inState(stateArray)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else {
            UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
            Intrinsics.checkNotNull((Object)uIGestureRecognizerDelegate);
            if (uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) {
                this.setBeginFiringEvents(true);
                this.fireActionEvent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{4};
        this.removeMessages(nArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lit/sephiroth/android/library/uigestures/UIPanGestureRecognizer$Companion;", "", "()V", "MESSAGE_RESET", "", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

