/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.os.Message;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.UIDiscreteGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIKeyEventRecognizer;
import it.sephiroth.android.library.uigestures.UIKeyEventRecognizerDelegate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0001H\u0016J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020\u001bH\u0014J\b\u0010*\u001a\u00020\u001bH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lit/sephiroth/android/library/uigestures/UIKeyTapGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIKeyEventRecognizer;", "Lit/sephiroth/android/library/uigestures/UIDiscreteGestureRecognizer;", "context", "Landroid/content/Context;", "keyCode", "", "(Landroid/content/Context;I)V", "doubleTapTimeout", "", "getDoubleTapTimeout", "()J", "setDoubleTapTimeout", "(J)V", "getKeyCode", "()I", "mNumTaps", "mStarted", "", "tapTimeout", "getTapTimeout", "setTapTimeout", "tapsRequired", "getTapsRequired", "setTapsRequired", "(I)V", "delayedFail", "", "fireActionEventIfCanRecognizeSimultaneously", "handleFailed", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onKeyEvent", "event", "Landroid/view/KeyEvent;", "onStateChanged", "recognizer", "postReset", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UIKeyTapGestureRecognizer
extends UIKeyEventRecognizer
implements UIDiscreteGestureRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int keyCode;
    private int tapsRequired;
    private long tapTimeout;
    private long doubleTapTimeout;
    private boolean mStarted;
    private int mNumTaps;
    private static final int MESSAGE_FAILED = 1;
    private static final int MESSAGE_RESET = 2;
    private static final int MESSAGE_POINTER_UP = 3;
    private static final int MESSAGE_LONG_PRESS = 4;

    public UIKeyTapGestureRecognizer(@NotNull Context context, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.keyCode = keyCode;
        this.tapsRequired = 1;
        this.tapTimeout = UIKeyEventRecognizer.Companion.getTAP_TIMEOUT() * (long)2;
        this.doubleTapTimeout = UIKeyEventRecognizer.Companion.getDOUBLE_TAP_TIMEOUT();
        this.mStarted = false;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        if (UIKeyEventRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "tapTimeout: " + this.tapTimeout);
            this.logMessage(4, "doubleTapTimeout: " + this.doubleTapTimeout);
        }
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getTapsRequired() {
        return this.tapsRequired;
    }

    public final void setTapsRequired(int n) {
        this.tapsRequired = n;
    }

    public final long getTapTimeout() {
        return this.tapTimeout;
    }

    public final void setTapTimeout(long l) {
        this.tapTimeout = l;
    }

    public final long getDoubleTapTimeout() {
        return this.doubleTapTimeout;
    }

    public final void setDoubleTapTimeout(long l) {
        this.doubleTapTimeout = l;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (msg.what) {
            case 2: {
                this.logMessage(4, "handleMessage(MESSAGE_RESET)");
                this.handleReset();
                break;
            }
            case 1: {
                this.logMessage(4, "handleMessage(MESSAGE_FAILED)");
                this.handleFailed();
                break;
            }
            case 3: {
                this.logMessage(4, "handleMessage(MESSAGE_POINTER_UP)");
                break;
            }
            case 4: {
                this.logMessage(4, "handleMessage(MESSAGE_LONG_PRESS)");
                this.handleFailed();
                break;
            }
            default: {
                this.logMessage(5, "message " + msg.what + " not handled");
            }
        }
    }

    @Override
    public void onStateChanged(@NotNull UIKeyEventRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (UIKeyEventRecognizer.Companion.getLogEnabled()) {
            UIKeyEventRecognizer.State state = recognizer.getState();
            this.logMessage(2, "onStateChanged(" + (state != null ? state.name() : null) + ")");
            this.logMessage(2, "mStarted: " + this.mStarted);
        }
        if (recognizer.getState() == UIKeyEventRecognizer.State.Failed && this.getState() == UIKeyEventRecognizer.State.Ended) {
            this.stopListenForOtherStateChanges();
            this.postReset();
        } else {
            UIKeyEventRecognizer.State[] stateArray = new UIKeyEventRecognizer.State[]{UIKeyEventRecognizer.State.Began, UIKeyEventRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.mStarted && this.inState(stateArray = new UIKeyEventRecognizer.State[]{UIKeyEventRecognizer.State.Possible, UIKeyEventRecognizer.State.Ended})) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIKeyEventRecognizer.State.Failed);
                this.mStarted = false;
            }
        }
    }

    @Override
    public boolean onKeyEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (UIKeyEventRecognizer.Companion.getLogEnabled()) {
            this.logMessage(4, "onKeyEvent(action=" + event.getAction() + ", code=" + event.getKeyCode() + ", longPress=" + event.isLongPress() + ", repeat=" + event.getRepeatCount() + ")");
            this.logMessage(2, "mStarted=" + this.mStarted + ", state=" + this.getState());
        }
        super.onKeyEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.removeMessages();
                if (!this.mStarted) {
                    Function1<UIKeyEventRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    boolean bl = function1 != null && (function1 = function1.getShouldReceiveKeyEvents()) != null ? !((Boolean)function1.invoke((Object)this)).booleanValue() : false;
                    if (bl) {
                        return false;
                    }
                    if (event.getKeyCode() != this.keyCode || event.isLongPress() || event.getRepeatCount() > 0) {
                        return false;
                    }
                }
                this.setState(UIKeyEventRecognizer.State.Possible);
                this.setBeginFiringEvents(false);
                if (!this.mStarted) {
                    this.stopListenForOtherStateChanges();
                    this.mNumTaps = 0;
                    this.mStarted = true;
                }
                this.getMHandler().sendEmptyMessageDelayed(4, this.tapTimeout + (long)5);
                return this.getCancelsKeyEventsInView();
            }
            case 1: {
                int[] nArray = new int[]{2, 3, 4};
                this.removeMessages(nArray);
                if (this.getState() == UIKeyEventRecognizer.State.Possible && this.mStarted) {
                    if (event.getKeyCode() != this.keyCode) {
                        this.handleFailed();
                        break;
                    }
                    int n = this.mNumTaps;
                    this.mNumTaps = n + 1;
                    if (UIKeyEventRecognizer.Companion.getLogEnabled()) {
                        this.logMessage(2, "numTaps = " + this.mNumTaps + ", tapsRequired = " + this.tapsRequired);
                    }
                    if (this.mNumTaps < this.tapsRequired) {
                        this.delayedFail();
                        break;
                    }
                    Function1<UIKeyEventRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                    boolean bl = function1 != null && (function1 = function1.getShouldBegin()) != null ? ((Boolean)function1.invoke((Object)this)).booleanValue() : false;
                    if (bl) {
                        this.setState(UIKeyEventRecognizer.State.Ended);
                        if (this.getRequireFailureOf() == null) {
                            this.fireActionEventIfCanRecognizeSimultaneously();
                            this.postReset();
                        } else {
                            UIKeyEventRecognizer uIKeyEventRecognizer = this.getRequireFailureOf();
                            if ((uIKeyEventRecognizer != null ? uIKeyEventRecognizer.getState() : null) == UIKeyEventRecognizer.State.Failed) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                                this.postReset();
                            } else {
                                UIKeyEventRecognizer.State[] stateArray;
                                UIKeyEventRecognizer uIKeyEventRecognizer2 = this.getRequireFailureOf();
                                boolean bl2 = uIKeyEventRecognizer2 != null ? uIKeyEventRecognizer2.inState(stateArray = new UIKeyEventRecognizer.State[]{UIKeyEventRecognizer.State.Began, UIKeyEventRecognizer.State.Ended, UIKeyEventRecognizer.State.Changed}) : false;
                                if (bl2) {
                                    this.setState(UIKeyEventRecognizer.State.Failed);
                                } else {
                                    this.listenForOtherStateChanges();
                                }
                            }
                        }
                    } else {
                        this.setState(UIKeyEventRecognizer.State.Failed);
                    }
                    this.mStarted = false;
                    break;
                }
                this.handleReset();
            }
        }
        return this.getCancelsKeyEventsInView();
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIKeyEventRecognizerDelegate uIKeyEventRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
        Boolean bl = uIKeyEventRecognizerDelegate != null ? Boolean.valueOf(uIKeyEventRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) : null;
        Intrinsics.checkNotNull((Object)bl);
        if (bl.booleanValue()) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIKeyEventRecognizer.State[] stateArray = new UIKeyEventRecognizer.State[]{UIKeyEventRecognizer.State.Ended};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{1, 2, 3, 4};
        this.removeMessages(nArray);
    }

    private final void postReset() {
        this.getMHandler().sendEmptyMessage(2);
    }

    private final void delayedFail() {
        this.getMHandler().sendEmptyMessageDelayed(1, this.doubleTapTimeout);
    }

    private final void handleFailed() {
        this.setState(UIKeyEventRecognizer.State.Failed);
        this.setBeginFiringEvents(false);
        this.removeMessages();
        this.mStarted = false;
    }

    private final void handleReset() {
        this.setState(UIKeyEventRecognizer.State.Possible);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lit/sephiroth/android/library/uigestures/UIKeyTapGestureRecognizer$Companion;", "", "()V", "MESSAGE_FAILED", "", "MESSAGE_LONG_PRESS", "MESSAGE_POINTER_UP", "MESSAGE_RESET", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

