/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\u00020\u0001:\u0003?@AB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010;\u001a\u00020\u001aH\u0002J\u0010\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020>H\u0007R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001c\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010 R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u00020$2\u0006\u0010\t\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001e\u00101\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\rR\u001e\u00103\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\rR\u001e\u00105\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\rR\u0011\u00107\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\rR\u0011\u00109\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0015\u00a8\u0006B"}, d2={"Lit/sephiroth/android/library/uigestures/ScaleGestureDetector;", "", "mContext", "Landroid/content/Context;", "mListener", "Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$OnScaleGestureListener;", "mHandler", "Landroid/os/Handler;", "(Landroid/content/Context;Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$OnScaleGestureListener;Landroid/os/Handler;)V", "<set-?>", "", "currentSpan", "getCurrentSpan", "()F", "currentSpanX", "getCurrentSpanX", "currentSpanY", "getCurrentSpanY", "", "eventTime", "getEventTime", "()J", "focusX", "getFocusX", "focusY", "getFocusY", "", "isInProgress", "()Z", "scales", "isQuickScaleEnabled", "setQuickScaleEnabled", "(Z)V", "isStylusScaleEnabled", "setStylusScaleEnabled", "mAnchoredScaleMode", "", "mAnchoredScaleStartX", "mAnchoredScaleStartY", "mEventBeforeOrAboveStartingGestureEvent", "mGestureDetector", "Landroid/view/GestureDetector;", "mInitialSpan", "mMinSpan", "mPrevTime", "mSpanSlop", "numberOfTouches", "getNumberOfTouches", "()I", "previousSpan", "getPreviousSpan", "previousSpanX", "getPreviousSpanX", "previousSpanY", "getPreviousSpanY", "scaleFactor", "getScaleFactor", "timeDelta", "getTimeDelta", "inAnchoredScaleMode", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "Companion", "OnScaleGestureListener", "SimpleOnScaleGestureListener", "uigesturerecognizer_release"})
public final class ScaleGestureDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context mContext;
    @NotNull
    private final OnScaleGestureListener mListener;
    @Nullable
    private final Handler mHandler;
    private int numberOfTouches;
    private float focusX;
    private float focusY;
    private boolean isQuickScaleEnabled;
    private boolean isStylusScaleEnabled;
    private float currentSpan;
    private float previousSpan;
    private float mInitialSpan;
    private float currentSpanX;
    private float currentSpanY;
    private float previousSpanX;
    private float previousSpanY;
    private long eventTime;
    private long mPrevTime;
    private boolean isInProgress;
    private final int mSpanSlop;
    private final int mMinSpan;
    private float mAnchoredScaleStartX;
    private float mAnchoredScaleStartY;
    private int mAnchoredScaleMode;
    @Nullable
    private GestureDetector mGestureDetector;
    private boolean mEventBeforeOrAboveStartingGestureEvent;
    @NotNull
    private static final String TAG = "ScaleGestureDetector";
    private static final long TOUCH_STABILIZE_TIME = 128L;
    private static final float SCALE_FACTOR = 0.5f;
    private static final int ANCHORED_SCALE_MODE_NONE = 0;
    private static final int ANCHORED_SCALE_MODE_DOUBLE_TAP = 1;
    private static final int ANCHORED_SCALE_MODE_STYLUS = 2;

    @JvmOverloads
    public ScaleGestureDetector(@NotNull Context mContext, @NotNull OnScaleGestureListener mListener, @Nullable Handler mHandler) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)mListener, (String)"mListener");
        this.mContext = mContext;
        this.mListener = mListener;
        this.mHandler = mHandler;
        this.mSpanSlop = ViewConfiguration.get((Context)this.mContext).getScaledTouchSlop() * 2;
        Resources res = this.mContext.getResources();
        this.mMinSpan = res.getDimensionPixelSize(R.dimen.gestures_config_minScalingSpan);
        this.numberOfTouches = 0;
        int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion > 18) {
            this.setQuickScaleEnabled(true);
        }
        if (targetSdkVersion > 22) {
            this.isStylusScaleEnabled = true;
        }
    }

    public /* synthetic */ ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener, Handler handler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            handler = null;
        }
        this(context, onScaleGestureListener, handler);
    }

    public final int getNumberOfTouches() {
        return this.numberOfTouches;
    }

    public final float getFocusX() {
        return this.focusX;
    }

    public final float getFocusY() {
        return this.focusY;
    }

    public final boolean isQuickScaleEnabled() {
        return this.isQuickScaleEnabled;
    }

    public final void setQuickScaleEnabled(boolean scales) {
        this.isQuickScaleEnabled = scales;
        if (this.isQuickScaleEnabled && this.mGestureDetector == null) {
            GestureDetector.SimpleOnGestureListener gestureListener2 = new GestureDetector.SimpleOnGestureListener(this){
                final /* synthetic */ ScaleGestureDetector this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onDoubleTap(@NotNull MotionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ScaleGestureDetector.access$setMAnchoredScaleStartX$p(this.this$0, e.getX());
                    ScaleGestureDetector.access$setMAnchoredScaleStartY$p(this.this$0, e.getY());
                    ScaleGestureDetector.access$setMAnchoredScaleMode$p(this.this$0, 1);
                    return true;
                }
            };
            this.mGestureDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)gestureListener2, this.mHandler);
        }
    }

    public final boolean isStylusScaleEnabled() {
        return this.isStylusScaleEnabled;
    }

    public final void setStylusScaleEnabled(boolean bl) {
        this.isStylusScaleEnabled = bl;
    }

    public final float getCurrentSpan() {
        return this.currentSpan;
    }

    public final float getPreviousSpan() {
        return this.previousSpan;
    }

    public final float getCurrentSpanX() {
        return this.currentSpanX;
    }

    public final float getCurrentSpanY() {
        return this.currentSpanY;
    }

    public final float getPreviousSpanX() {
        return this.previousSpanX;
    }

    public final float getPreviousSpanY() {
        return this.previousSpanY;
    }

    public final long getEventTime() {
        return this.eventTime;
    }

    public final boolean isInProgress() {
        return this.isInProgress;
    }

    public final float getScaleFactor() {
        if (this.inAnchoredScaleMode()) {
            boolean scaleUp = this.mEventBeforeOrAboveStartingGestureEvent && this.currentSpan < this.previousSpan || !this.mEventBeforeOrAboveStartingGestureEvent && this.currentSpan > this.previousSpan;
            float spanDiff = Math.abs(1.0f - this.currentSpan / this.previousSpan) * 0.5f;
            return this.previousSpan <= 0.0f ? 1.0f : (scaleUp ? 1.0f + spanDiff : 1.0f - spanDiff);
        }
        return this.previousSpan > 0.0f ? this.currentSpan / this.previousSpan : 1.0f;
    }

    public final long getTimeDelta() {
        return this.eventTime - this.mPrevTime;
    }

    @SuppressLint(value={"NewApi"})
    public final boolean onTouchEvent(@NotNull MotionEvent event) {
        int minSpan;
        boolean streamComplete;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventTime = event.getEventTime();
        int action = event.getActionMasked();
        if (this.isQuickScaleEnabled) {
            GestureDetector gestureDetector = this.mGestureDetector;
            Intrinsics.checkNotNull((Object)gestureDetector);
            gestureDetector.onTouchEvent(event);
        }
        int count = event.getPointerCount();
        boolean isStylusButtonDown = false;
        if (Build.VERSION.SDK_INT >= 23) {
            isStylusButtonDown = (event.getButtonState() & 0x20) != 0;
        }
        boolean anchoredScaleCancelled = this.mAnchoredScaleMode == 2 && !isStylusButtonDown;
        boolean bl = streamComplete = action == 1 || action == 3 || anchoredScaleCancelled;
        if (action == 0 || streamComplete) {
            if (this.isInProgress) {
                this.mListener.onScaleEnd(this);
                this.isInProgress = false;
                this.mInitialSpan = 0.0f;
                this.mAnchoredScaleMode = 0;
            } else if (this.inAnchoredScaleMode() && streamComplete) {
                this.isInProgress = false;
                this.mInitialSpan = 0.0f;
                this.mAnchoredScaleMode = 0;
            }
            if (streamComplete) {
                return true;
            }
        }
        if (!this.isInProgress && this.isStylusScaleEnabled && !this.inAnchoredScaleMode() && !streamComplete && isStylusButtonDown) {
            this.mAnchoredScaleStartX = event.getX();
            this.mAnchoredScaleStartY = event.getY();
            this.mAnchoredScaleMode = 2;
            this.mInitialSpan = 0.0f;
        }
        boolean configChanged = action == 0 || action == 6 || action == 5 || anchoredScaleCancelled;
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? event.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int div = pointerUp ? count - 1 : count;
        float focusX = 0.0f;
        float focusY = 0.0f;
        int n = this.numberOfTouches = pointerUp ? count - 1 : count;
        if (this.inAnchoredScaleMode()) {
            focusX = this.mAnchoredScaleStartX;
            focusY = this.mAnchoredScaleStartY;
            this.mEventBeforeOrAboveStartingGestureEvent = event.getY() < focusY;
        } else {
            for (int i = 0; i < count; ++i) {
                if (skipIndex == i) continue;
                sumX += event.getX(i);
                sumY += event.getY(i);
            }
            focusX = sumX / (float)div;
            focusY = sumY / (float)div;
        }
        float devSumX = 0.0f;
        float devSumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            devSumX += Math.abs(event.getX(i) - focusX);
            devSumY += Math.abs(event.getY(i) - focusY);
        }
        float devX = devSumX / (float)div;
        float devY = devSumY / (float)div;
        float spanX = devX * (float)2;
        float spanY = devY * (float)2;
        float span = 0.0f;
        span = this.inAnchoredScaleMode() ? spanY : (float)Math.hypot(spanX, spanY);
        boolean wasInProgress = this.isInProgress;
        this.focusX = focusX;
        this.focusY = focusY;
        if (!this.inAnchoredScaleMode() && this.isInProgress && configChanged) {
            this.mListener.onScaleEnd(this);
            this.isInProgress = false;
            this.mInitialSpan = span;
        }
        if (configChanged) {
            this.previousSpanX = this.currentSpanX = spanX;
            this.previousSpanY = this.currentSpanY = spanY;
            this.mInitialSpan = this.previousSpan = (this.currentSpan = span);
        }
        int n2 = minSpan = this.inAnchoredScaleMode() ? this.mSpanSlop : this.mMinSpan;
        if (!this.isInProgress && span >= (float)minSpan && (wasInProgress || Math.abs(span - this.mInitialSpan) > (float)this.mSpanSlop)) {
            this.previousSpanX = this.currentSpanX = spanX;
            this.previousSpanY = this.currentSpanY = spanY;
            this.previousSpan = this.currentSpan = span;
            this.mPrevTime = this.eventTime;
            this.isInProgress = this.mListener.onScaleBegin(this);
        }
        if (action == 2) {
            this.currentSpanX = spanX;
            this.currentSpanY = spanY;
            this.currentSpan = span;
            boolean updatePrev = true;
            if (this.isInProgress) {
                updatePrev = this.mListener.onScale(this);
            }
            if (updatePrev) {
                this.previousSpanX = this.currentSpanX;
                this.previousSpanY = this.currentSpanY;
                this.previousSpan = this.currentSpan;
                this.mPrevTime = this.eventTime;
            }
        }
        return true;
    }

    private final boolean inAnchoredScaleMode() {
        return this.mAnchoredScaleMode != 0;
    }

    @JvmOverloads
    public ScaleGestureDetector(@NotNull Context mContext, @NotNull OnScaleGestureListener mListener) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)mListener, (String)"mListener");
        this(mContext, mListener, null, 4, null);
    }

    public static final /* synthetic */ void access$setMAnchoredScaleStartX$p(ScaleGestureDetector $this, float f) {
        $this.mAnchoredScaleStartX = f;
    }

    public static final /* synthetic */ void access$setMAnchoredScaleStartY$p(ScaleGestureDetector $this, float f) {
        $this.mAnchoredScaleStartY = f;
    }

    public static final /* synthetic */ void access$setMAnchoredScaleMode$p(ScaleGestureDetector $this, int n) {
        $this.mAnchoredScaleMode = n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$Companion;", "", "()V", "ANCHORED_SCALE_MODE_DOUBLE_TAP", "", "ANCHORED_SCALE_MODE_NONE", "ANCHORED_SCALE_MODE_STYLUS", "SCALE_FACTOR", "", "TAG", "", "TOUCH_STABILIZE_TIME", "", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$OnScaleGestureListener;", "", "onScale", "", "detector", "Lit/sephiroth/android/library/uigestures/ScaleGestureDetector;", "onScaleBegin", "onScaleEnd", "", "uigesturerecognizer_release"})
    public static interface OnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector var1);

        public boolean onScaleBegin(@NotNull ScaleGestureDetector var1);

        public void onScaleEnd(@NotNull ScaleGestureDetector var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$SimpleOnScaleGestureListener;", "Lit/sephiroth/android/library/uigestures/ScaleGestureDetector$OnScaleGestureListener;", "()V", "onScale", "", "detector", "Lit/sephiroth/android/library/uigestures/ScaleGestureDetector;", "onScaleBegin", "onScaleEnd", "", "uigesturerecognizer_release"})
    public static final class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        @Override
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            return false;
        }

        @Override
        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            return true;
        }

        @Override
        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        }
    }
}

