/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.OnGestureRecognizerStateChangeListener;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \u0093\u00012\u00020\u0001:\u0006\u0093\u0001\u0094\u0001\u0095\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010q\u001a\u00020g2\u0006\u0010r\u001a\u00020\u0001H\u0004J\r\u0010s\u001a\u00020gH\u0000\u00a2\u0006\u0002\btJ\u0018\u0010u\u001a\u00020L2\u0006\u0010v\u001a\u0002052\u0006\u0010w\u001a\u00020?H\u0004J\b\u0010x\u001a\u00020gH\u0004J\b\u0010y\u001a\u00020gH\u0004J\b\u0010z\u001a\u00020%H\u0002J\u0010\u0010{\u001a\u00020g2\u0006\u0010|\u001a\u00020}H$J\b\u0010~\u001a\u00020\rH\u0016J\u0016\u0010\u007f\u001a\u00020\r2\f\u0010\u0080\u0001\u001a\u00030\u0081\u0001\"\u00020LH\u0004J\u0011\u0010\u0082\u0001\u001a\u00020\r2\u0006\u0010r\u001a\u00020\u0001H\u0004J#\u0010\u0083\u0001\u001a\u00020\r2\u0014\u0010\u0084\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020_0\u0085\u0001\"\u00020_\u00a2\u0006\u0003\u0010\u0086\u0001J\t\u0010\u0087\u0001\u001a\u00020gH\u0004J\u001c\u0010\u0088\u0001\u001a\u00020g2\u0007\u0010\u0089\u0001\u001a\u00020L2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0004J\u0011\u0010\u008c\u0001\u001a\u00020\r2\u0006\u0010v\u001a\u000205H\u0017J\t\u0010\u008d\u0001\u001a\u00020gH$J\u0017\u0010\u008d\u0001\u001a\u00020g2\f\u0010\u0080\u0001\u001a\u00030\u0081\u0001\"\u00020LH\u0004J\u0011\u0010\u008e\u0001\u001a\u00020\r2\u0006\u0010r\u001a\u00020\u0001H\u0004J\t\u0010\u008f\u0001\u001a\u00020gH\u0016J\u0011\u0010\u0090\u0001\u001a\u00020g2\u0006\u00100\u001a\u00020\rH\u0004J\t\u0010\u0091\u0001\u001a\u00020gH\u0004J\n\u0010\u0092\u0001\u001a\u00030\u008b\u0001H\u0016R*\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0011\u0010\"\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0017\u0010$\u001a\u00020%8F\u00a2\u0006\f\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)R&\u0010+\u001a\u00020%2\u0006\u0010*\u001a\u00020%@DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\b/\u001a\u0004\b,\u0010)\"\u0004\b-\u0010.R$\u00101\u001a\u00020\r2\u0006\u00100\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u000f\"\u0004\b2\u0010\u0011R\u0014\u00103\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000fR(\u00106\u001a\u0004\u0018\u0001052\b\u00104\u001a\u0004\u0018\u000105@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u00020?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010AR\u001a\u0010D\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010)\"\u0004\bF\u0010.R\u0018\u0010G\u001a\u00060HR\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u000e\u0010K\u001a\u00020LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\u00020?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010AR\u001a\u0010O\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010)\"\u0004\bQ\u0010.R2\u0010R\u001a&\u0012\f\u0012\n T*\u0004\u0018\u00010\u00010\u0001 T*\u0012\u0012\f\u0012\n T*\u0004\u0018\u00010\u00010\u0001\u0018\u00010U0SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010V\u001a\u00020L8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR(\u0010Z\u001a\u0004\u0018\u00010\u00002\b\u0010Y\u001a\u0004\u0018\u00010\u0000@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R(\u0010`\u001a\u0004\u0018\u00010_2\b\u00100\u001a\u0004\u0018\u00010_@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR8\u0010e\u001a \u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010_\u0012\u0006\u0012\u0004\u0018\u00010_\u0012\u0004\u0012\u00020g\u0018\u00010fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u001c\u0010l\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010p\u00a8\u0006\u0096\u0001"}, d2={"Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/OnGestureRecognizerStateChangeListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "actionListener", "Lkotlin/Function1;", "", "getActionListener", "()Lkotlin/jvm/functions/Function1;", "setActionListener", "(Lkotlin/jvm/functions/Function1;)V", "cancelsTouchesInView", "", "getCancelsTouchesInView", "()Z", "setCancelsTouchesInView", "(Z)V", "getContext", "()Landroid/content/Context;", "currentLocationX", "", "getCurrentLocationX", "()F", "currentLocationY", "getCurrentLocationY", "delegate", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizerDelegate;", "getDelegate$uigesturerecognizer_release", "()Lit/sephiroth/android/library/uigestures/UIGestureRecognizerDelegate;", "setDelegate$uigesturerecognizer_release", "(Lit/sephiroth/android/library/uigestures/UIGestureRecognizerDelegate;)V", "downLocationX", "getDownLocationX", "downLocationY", "getDownLocationY", "downTime", "", "getDownTime$annotations", "()V", "getDownTime", "()J", "<set-?>", "id", "getId", "setId", "(J)V", "id$1", "value", "isEnabled", "setEnabled", "isListeningForOtherStateChanges", "mLastEvent", "Landroid/view/MotionEvent;", "lastEvent", "getLastEvent", "()Landroid/view/MotionEvent;", "setLastEvent", "(Landroid/view/MotionEvent;)V", "mBeganFiringEvents", "mContextRef", "Ljava/lang/ref/WeakReference;", "mCurrentLocation", "Landroid/graphics/PointF;", "getMCurrentLocation", "()Landroid/graphics/PointF;", "mDownLocation", "getMDownLocation", "mDownTime", "getMDownTime", "setMDownTime", "mHandler", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$GestureHandler;", "getMHandler", "()Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$GestureHandler;", "mNumberOfTouches", "", "mPreviousDownLocation", "getMPreviousDownLocation", "mPreviousDownTime", "getMPreviousDownTime", "setMPreviousDownTime", "mStateListeners", "", "kotlin.jvm.PlatformType", "", "numberOfTouches", "getNumberOfTouches", "()I", "other", "requireFailureOf", "getRequireFailureOf", "()Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "setRequireFailureOf", "(Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;)V", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$State;", "state", "getState", "()Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$State;", "setState", "(Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$State;)V", "stateListener", "Lkotlin/Function3;", "", "getStateListener", "()Lkotlin/jvm/functions/Function3;", "setStateListener", "(Lkotlin/jvm/functions/Function3;)V", "tag", "getTag", "()Ljava/lang/Object;", "setTag", "(Ljava/lang/Object;)V", "addOnStateChangeListenerListener", "listener", "clearStateListeners", "clearStateListeners$uigesturerecognizer_release", "computeFocusPoint", "event", "out", "finalize", "fireActionEvent", "generateId", "handleMessage", "msg", "Landroid/os/Message;", "hasBeganFiringEvents", "hasMessages", "messages", "", "hasOnStateChangeListenerListener", "inState", "states", "", "([Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$State;)Z", "listenForOtherStateChanges", "logMessage", "level", "fmt", "", "onTouchEvent", "removeMessages", "removeOnStateChangeListenerListener", "reset", "setBeginFiringEvents", "stopListenForOtherStateChanges", "toString", "Companion", "GestureHandler", "State", "uigesturerecognizer_release"})
public abstract class UIGestureRecognizer
implements OnGestureRecognizerStateChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final List<OnGestureRecognizerStateChangeListener> mStateListeners;
    private boolean mBeganFiringEvents;
    @NotNull
    private final WeakReference<Context> mContextRef;
    private int mNumberOfTouches;
    @NotNull
    private final PointF mDownLocation;
    @NotNull
    private final PointF mPreviousDownLocation;
    private long mDownTime;
    private long mPreviousDownTime;
    @NotNull
    private final PointF mCurrentLocation;
    @NotNull
    private final GestureHandler mHandler;
    @Nullable
    private UIGestureRecognizerDelegate delegate;
    @Nullable
    private Function1<? super UIGestureRecognizer, ? extends Object> actionListener;
    @Nullable
    private Function3<? super UIGestureRecognizer, ? super State, ? super State, Unit> stateListener;
    @Nullable
    private State state;
    private boolean isEnabled;
    private boolean cancelsTouchesInView;
    @Nullable
    private Object tag;
    private long id$1;
    @Nullable
    private UIGestureRecognizer requireFailureOf;
    @Nullable
    private MotionEvent lastEvent;
    @NotNull
    private static final String LOG_TAG;
    private static int id;
    private static boolean sDebug;
    public static final int TIMEOUT_DELAY_MILLIS = 5;
    private static final long LONG_PRESS_TIMEOUT;
    private static final long TAP_TIMEOUT;
    private static final long DOUBLE_TAP_TIMEOUT;
    public static final int TOUCH_SLOP = 8;
    public static final int DOUBLE_TAP_SLOP = 100;
    public static final int DOUBLE_TAP_TOUCH_SLOP = 8;

    public UIGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mStateListeners = Collections.synchronizedList(new ArrayList());
        this.mContextRef = new WeakReference<Context>(context);
        this.mDownLocation = new PointF();
        this.mPreviousDownLocation = new PointF();
        this.mCurrentLocation = new PointF();
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"getMainLooper(...)");
        this.mHandler = new GestureHandler(looper);
        this.isEnabled = true;
        this.cancelsTouchesInView = true;
        this.id$1 = this.generateId();
    }

    @NotNull
    protected final PointF getMDownLocation() {
        return this.mDownLocation;
    }

    @NotNull
    protected final PointF getMPreviousDownLocation() {
        return this.mPreviousDownLocation;
    }

    protected final long getMDownTime() {
        return this.mDownTime;
    }

    protected final void setMDownTime(long l) {
        this.mDownTime = l;
    }

    protected final long getMPreviousDownTime() {
        return this.mPreviousDownTime;
    }

    protected final void setMPreviousDownTime(long l) {
        this.mPreviousDownTime = l;
    }

    @NotNull
    protected final PointF getMCurrentLocation() {
        return this.mCurrentLocation;
    }

    @NotNull
    protected final GestureHandler getMHandler() {
        return this.mHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isListeningForOtherStateChanges() {
        if (this.requireFailureOf == null) return false;
        UIGestureRecognizer uIGestureRecognizer = this.requireFailureOf;
        Intrinsics.checkNotNull((Object)uIGestureRecognizer);
        if (!uIGestureRecognizer.hasOnStateChangeListenerListener(this)) return false;
        return true;
    }

    @Nullable
    public final UIGestureRecognizerDelegate getDelegate$uigesturerecognizer_release() {
        return this.delegate;
    }

    public final void setDelegate$uigesturerecognizer_release(@Nullable UIGestureRecognizerDelegate uIGestureRecognizerDelegate) {
        this.delegate = uIGestureRecognizerDelegate;
    }

    @Nullable
    public final Function1<UIGestureRecognizer, Object> getActionListener() {
        return this.actionListener;
    }

    public final void setActionListener(@Nullable Function1<? super UIGestureRecognizer, ? extends Object> function1) {
        this.actionListener = function1;
    }

    @Nullable
    public final Function3<UIGestureRecognizer, State, State, Unit> getStateListener() {
        return this.stateListener;
    }

    public final void setStateListener(@Nullable Function3<? super UIGestureRecognizer, ? super State, ? super State, Unit> function3) {
        this.stateListener = function3;
    }

    @Nullable
    public final State getState() {
        return this.state;
    }

    protected final void setState(@Nullable State value) {
        State state = this.state;
        State state2 = value;
        this.logMessage(4, "setState: " + (state != null ? state.name() : null) + " --> " + (state2 != null ? state2.name() : null));
        State oldValue = this.state;
        boolean changed = this.state != value || value == State.Changed;
        this.state = value;
        if (changed) {
            Function3<? super UIGestureRecognizer, ? super State, ? super State, Unit> function3 = this.stateListener;
            if (function3 != null) {
                function3.invoke((Object)this, (Object)oldValue, (Object)value);
            }
            ListIterator<OnGestureRecognizerStateChangeListener> iterator = this.mStateListeners.listIterator();
            while (iterator.hasNext()) {
                iterator.next().onStateChanged(this);
            }
        }
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean value) {
        if (this.isEnabled != value) {
            this.isEnabled = value;
            if (!value) {
                this.reset();
            }
        }
    }

    public final long getDownTime() {
        return this.mDownTime;
    }

    public static /* synthetic */ void getDownTime$annotations() {
    }

    public final float getDownLocationX() {
        return this.mDownLocation.x;
    }

    public final float getDownLocationY() {
        return this.mDownLocation.y;
    }

    public float getCurrentLocationX() {
        return this.mCurrentLocation.x;
    }

    public float getCurrentLocationY() {
        return this.mCurrentLocation.y;
    }

    public final boolean getCancelsTouchesInView() {
        return this.cancelsTouchesInView;
    }

    public final void setCancelsTouchesInView(boolean bl) {
        this.cancelsTouchesInView = bl;
    }

    @Nullable
    public final Object getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable Object object) {
        this.tag = object;
    }

    public final long getId() {
        return this.id$1;
    }

    protected final void setId(long l) {
        this.id$1 = l;
    }

    @Nullable
    public final UIGestureRecognizer getRequireFailureOf() {
        return this.requireFailureOf;
    }

    public final void setRequireFailureOf(@Nullable UIGestureRecognizer other) {
        UIGestureRecognizer uIGestureRecognizer = this.requireFailureOf;
        if (uIGestureRecognizer != null) {
            uIGestureRecognizer.removeOnStateChangeListenerListener(this);
        }
        this.requireFailureOf = other;
    }

    @Nullable
    public final MotionEvent getLastEvent() {
        return this.lastEvent;
    }

    protected final void setLastEvent(@Nullable MotionEvent mLastEvent) {
        MotionEvent motionEvent = mLastEvent;
        if (motionEvent != null) {
            motionEvent.recycle();
        }
        this.lastEvent = mLastEvent;
    }

    @Nullable
    public final Context getContext() {
        return (Context)this.mContextRef.get();
    }

    public int getNumberOfTouches() {
        return this.mNumberOfTouches;
    }

    private final long generateId() {
        long l = this.id$1;
        this.id$1 = l + 1L;
        return l;
    }

    public void reset() {
        this.setState(null);
        this.stopListenForOtherStateChanges();
        this.setBeginFiringEvents(false);
        this.removeMessages();
    }

    public boolean hasBeganFiringEvents() {
        return this.mBeganFiringEvents;
    }

    protected final void setBeginFiringEvents(boolean value) {
        this.mBeganFiringEvents = value;
    }

    protected abstract void removeMessages();

    protected final void removeMessages(int ... messages) {
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        for (int message : messages) {
            this.mHandler.removeMessages(message);
        }
    }

    protected final boolean hasMessages(int ... messages) {
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        for (int message : messages) {
            if (!this.mHandler.hasMessages(message)) continue;
            return true;
        }
        return false;
    }

    public final void clearStateListeners$uigesturerecognizer_release() {
        this.mStateListeners.clear();
    }

    protected final void fireActionEvent() {
        block0: {
            Function1<? super UIGestureRecognizer, ? extends Object> function1 = this.actionListener;
            if (function1 == null) break block0;
            function1.invoke((Object)this);
        }
    }

    protected final void addOnStateChangeListenerListener(@NotNull OnGestureRecognizerStateChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.mStateListeners.contains(listener)) {
            this.mStateListeners.add(listener);
        }
    }

    protected final boolean removeOnStateChangeListenerListener(@NotNull OnGestureRecognizerStateChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.mStateListeners.remove(listener);
    }

    protected final boolean hasOnStateChangeListenerListener(@NotNull OnGestureRecognizerStateChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.mStateListeners.contains(listener);
    }

    @SuppressLint(value={"Recycle"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setLastEvent(MotionEvent.obtain((MotionEvent)event));
        if (event.getActionMasked() == 0) {
            this.mPreviousDownLocation.set(this.mDownLocation);
            this.mDownLocation.set(event.getX(), event.getY());
            this.mPreviousDownTime = this.mDownTime;
            this.mDownTime = event.getDownTime();
        }
        this.mNumberOfTouches = this.computeFocusPoint(event, this.mCurrentLocation);
        return false;
    }

    protected final int computeFocusPoint(@NotNull MotionEvent event, @NotNull PointF out) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int actionMasked = event.getActionMasked();
        int count = event.getPointerCount();
        boolean pointerUp = actionMasked == 6;
        int skipIndex = pointerUp ? event.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += event.getX(i);
            sumY += event.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        out.x = sumX / (float)div;
        out.y = sumY / (float)div;
        return pointerUp ? count - 1 : count;
    }

    protected final void finalize() throws Throwable {
    }

    protected abstract void handleMessage(@NotNull Message var1);

    public final boolean inState(State ... states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        return ArraysKt.contains((Object[])states, (Object)((Object)this.state));
    }

    protected final void stopListenForOtherStateChanges() {
        block0: {
            UIGestureRecognizer uIGestureRecognizer = this.requireFailureOf;
            if (uIGestureRecognizer == null) break block0;
            uIGestureRecognizer.removeOnStateChangeListenerListener(this);
        }
    }

    protected final void listenForOtherStateChanges() {
        block0: {
            UIGestureRecognizer uIGestureRecognizer = this.requireFailureOf;
            if (uIGestureRecognizer == null) break block0;
            uIGestureRecognizer.addOnStateChangeListenerListener(this);
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "[state: " + this.state + ", tag:" + this.tag + "], touches: " + this.getNumberOfTouches();
    }

    protected final void logMessage(int level, @NotNull String fmt) {
        Intrinsics.checkNotNullParameter((Object)fmt, (String)"fmt");
        if (!sDebug) {
            return;
        }
        Log.println((int)level, (String)LOG_TAG, (String)("[" + this.getClass().getSimpleName() + ":" + this.tag + "] " + fmt));
    }

    static {
        String string = UIGestureRecognizer.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        LOG_TAG = string;
        LONG_PRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001e\u00a8\u0006$"}, d2={"Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$Companion;", "", "()V", "DOUBLE_TAP_SLOP", "", "DOUBLE_TAP_TIMEOUT", "", "getDOUBLE_TAP_TIMEOUT", "()J", "DOUBLE_TAP_TOUCH_SLOP", "LOG_TAG", "", "getLOG_TAG", "()Ljava/lang/String;", "LONG_PRESS_TIMEOUT", "getLONG_PRESS_TIMEOUT", "TAP_TIMEOUT", "getTAP_TIMEOUT", "TIMEOUT_DELAY_MILLIS", "TOUCH_SLOP", "<set-?>", "id", "getId", "()I", "value", "", "logEnabled", "getLogEnabled", "()Z", "setLogEnabled", "(Z)V", "sDebug", "getSDebug", "setSDebug", "eventActionToString", "action", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getLOG_TAG() {
            return LOG_TAG;
        }

        public final int getId() {
            return id;
        }

        protected final boolean getSDebug() {
            return sDebug;
        }

        protected final void setSDebug(boolean bl) {
            sDebug = bl;
        }

        public final long getLONG_PRESS_TIMEOUT() {
            return LONG_PRESS_TIMEOUT;
        }

        public final long getTAP_TIMEOUT() {
            return TAP_TIMEOUT;
        }

        public final long getDOUBLE_TAP_TIMEOUT() {
            return DOUBLE_TAP_TIMEOUT;
        }

        public final boolean getLogEnabled() {
            return this.getSDebug();
        }

        public final void setLogEnabled(boolean value) {
            this.setSDebug(value);
        }

        @NotNull
        public final String eventActionToString(int action) {
            return switch (action) {
                case 0 -> "ACTION_DOWN";
                case 1 -> "ACTION_UP";
                case 3 -> "ACTION_CANCEL";
                case 2 -> "ACTION_MOVE";
                case 5 -> "ACTION_POINTER_DOWN";
                case 6 -> "ACTION_POINTER_UP";
                default -> "ACTION_OTHER";
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0085\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$GestureHandler;", "Landroid/os/Handler;", "mainLooper", "Landroid/os/Looper;", "(Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;Landroid/os/Looper;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "uigesturerecognizer_release"})
    @SuppressLint(value={"HandlerLeak"})
    protected final class GestureHandler
    extends Handler {
        public GestureHandler(Looper mainLooper) {
            Intrinsics.checkNotNullParameter((Object)mainLooper, (String)"mainLooper");
            super(mainLooper);
        }

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            UIGestureRecognizer.this.handleMessage(msg);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lit/sephiroth/android/library/uigestures/UIGestureRecognizer$State;", "", "(Ljava/lang/String;I)V", "Possible", "Began", "Changed", "Failed", "Cancelled", "Ended", "uigesturerecognizer_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Possible = new State();
        public static final /* enum */ State Began = new State();
        public static final /* enum */ State Changed = new State();
        public static final /* enum */ State Failed = new State();
        public static final /* enum */ State Cancelled = new State();
        public static final /* enum */ State Ended = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Possible, State.Began, State.Changed, State.Failed, State.Cancelled, State.Ended};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

