/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.GeometryKt;
import it.sephiroth.android.library.uigestures.R;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizerDelegate;
import it.sephiroth.android.library.uigestures.UIRectEdge;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0001OB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\rH\u0002J\b\u0010:\u001a\u00020;H\u0002J8\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010C\u001a\u00020;2\u0006\u0010D\u001a\u00020EH\u0014J\b\u0010F\u001a\u00020;H\u0002J\b\u0010G\u001a\u00020\u0013H\u0016J\u0010\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020\u0001H\u0016J\u0010\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020;H\u0014J\b\u0010N\u001a\u00020;H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u0011\u0010#\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0011\u0010%\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000fR\u001a\u0010'\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001d\"\u0004\b)\u0010\u001fR\u001e\u0010+\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u000fR\u001e\u0010-\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u000fR\u001e\u0010/\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000fR\u001e\u00101\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u000fR\u001e\u00103\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u000fR\u001e\u00105\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u000f\u00a8\u0006P"}, d2={"Lit/sephiroth/android/library/uigestures/UIScreenEdgePanGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIGestureRecognizer;", "Lit/sephiroth/android/library/uigestures/UIContinuousRecognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "edge", "Lit/sephiroth/android/library/uigestures/UIRectEdge;", "getEdge", "()Lit/sephiroth/android/library/uigestures/UIRectEdge;", "setEdge", "(Lit/sephiroth/android/library/uigestures/UIRectEdge;)V", "edgeLimit", "", "getEdgeLimit", "()F", "setEdgeLimit", "(F)V", "mDown", "", "mDownFocusLocation", "Landroid/graphics/PointF;", "mLastFocusLocation", "mStarted", "mVelocityTracker", "Landroid/view/VelocityTracker;", "maximumNumberOfTouches", "", "getMaximumNumberOfTouches", "()I", "setMaximumNumberOfTouches", "(I)V", "minimumNumberOfTouches", "getMinimumNumberOfTouches", "setMinimumNumberOfTouches", "relativeScrollX", "getRelativeScrollX", "relativeScrollY", "getRelativeScrollY", "scaledTouchSlop", "getScaledTouchSlop", "setScaledTouchSlop", "<set-?>", "scrollX", "getScrollX", "scrollY", "getScrollY", "translationX", "getTranslationX", "translationY", "getTranslationY", "xVelocity", "getXVelocity", "yVelocity", "getYVelocity", "computeState", "x", "y", "fireActionEventIfCanRecognizeSimultaneously", "", "getTouchDirection", "x1", "y1", "x2", "y2", "velocityX", "velocityY", "handleMessage", "msg", "Landroid/os/Message;", "handleReset", "hasBeganFiringEvents", "onStateChanged", "recognizer", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "removeMessages", "reset", "Companion", "uigesturerecognizer_release"})
public class UIScreenEdgePanGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int minimumNumberOfTouches;
    private int maximumNumberOfTouches;
    private float scrollX;
    private float scrollY;
    private float translationX;
    private float translationY;
    private float yVelocity;
    private float xVelocity;
    @NotNull
    private UIRectEdge edge;
    private int scaledTouchSlop;
    private float edgeLimit;
    private boolean mStarted;
    private boolean mDown;
    @Nullable
    private VelocityTracker mVelocityTracker;
    @NotNull
    private PointF mLastFocusLocation;
    @NotNull
    private PointF mDownFocusLocation;
    private static final int MESSAGE_RESET = 4;

    public UIScreenEdgePanGestureRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.minimumNumberOfTouches = 1;
        this.maximumNumberOfTouches = Integer.MAX_VALUE;
        this.edge = UIRectEdge.LEFT;
        this.mLastFocusLocation = new PointF();
        this.mDownFocusLocation = new PointF();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.scaledTouchSlop = configuration.getScaledTouchSlop();
        this.edgeLimit = context.getResources().getDimension(R.dimen.gestures_screen_edge_limit);
    }

    public final int getMinimumNumberOfTouches() {
        return this.minimumNumberOfTouches;
    }

    public final void setMinimumNumberOfTouches(int n) {
        this.minimumNumberOfTouches = n;
    }

    public final int getMaximumNumberOfTouches() {
        return this.maximumNumberOfTouches;
    }

    public final void setMaximumNumberOfTouches(int n) {
        this.maximumNumberOfTouches = n;
    }

    public final float getScrollX() {
        return this.scrollX;
    }

    public final float getScrollY() {
        return this.scrollY;
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final float getYVelocity() {
        return this.yVelocity;
    }

    public final float getXVelocity() {
        return this.xVelocity;
    }

    public final float getRelativeScrollX() {
        return -this.scrollX;
    }

    public final float getRelativeScrollY() {
        return -this.scrollY;
    }

    @NotNull
    public final UIRectEdge getEdge() {
        return this.edge;
    }

    public final void setEdge(@NotNull UIRectEdge uIRectEdge) {
        Intrinsics.checkNotNullParameter((Object)((Object)uIRectEdge), (String)"<set-?>");
        this.edge = uIRectEdge;
    }

    public final int getScaledTouchSlop() {
        return this.scaledTouchSlop;
    }

    public final void setScaledTouchSlop(int n) {
        this.scaledTouchSlop = n;
    }

    public final float getEdgeLimit() {
        return this.edgeLimit;
    }

    public final void setEdgeLimit(float f) {
        this.edgeLimit = f;
    }

    @Override
    protected void handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg.what == 4) {
            this.handleReset();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.handleReset();
    }

    private final void handleReset() {
        this.mStarted = false;
        this.mDown = false;
        this.setBeginFiringEvents(false);
        this.setState(UIGestureRecognizer.State.Possible);
    }

    @Override
    public void onStateChanged(@NotNull UIGestureRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else {
            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended};
            if (recognizer.inState(stateArray) && this.mStarted && this.mDown && this.inState(stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began})) {
                this.stopListenForOtherStateChanges();
                this.removeMessages();
                this.setState(UIGestureRecognizer.State.Failed);
                this.setBeginFiringEvents(false);
                this.mStarted = false;
                this.mDown = false;
            }
        }
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        float rawX = event.getRawX();
        float rawY = event.getRawY();
        switch (action) {
            case 5: {
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                if (this.getState() != UIGestureRecognizer.State.Possible || this.getNumberOfTouches() <= this.maximumNumberOfTouches) break;
                this.setState(UIGestureRecognizer.State.Failed);
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 6: {
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                VelocityTracker velocityTracker = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker);
                velocityTracker.computeCurrentVelocity(1000, 0.0f);
                int upIndex = event.getActionIndex();
                int id1 = event.getPointerId(upIndex);
                VelocityTracker velocityTracker2 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker2);
                float x1 = velocityTracker2.getXVelocity(id1);
                VelocityTracker velocityTracker3 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker3);
                float y1 = velocityTracker3.getYVelocity(id1);
                int n = event.getPointerCount();
                for (int i = 0; i < n; ++i) {
                    if (i == upIndex) continue;
                    int id2 = event.getPointerId(i);
                    VelocityTracker velocityTracker4 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker4);
                    float x = x1 * velocityTracker4.getXVelocity(id2);
                    VelocityTracker velocityTracker5 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker5);
                    float y = y1 * velocityTracker5.getYVelocity(id2);
                    float dot = x + y;
                    if (!(dot < 0.0f)) continue;
                    VelocityTracker velocityTracker6 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker6);
                    velocityTracker6.clear();
                    break;
                }
                if (this.getState() != UIGestureRecognizer.State.Possible || this.getNumberOfTouches() >= this.minimumNumberOfTouches) break;
                this.setState(UIGestureRecognizer.State.Failed);
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                break;
            }
            case 0: {
                UIGestureRecognizer.State state;
                Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                Boolean bl = function1 != null && (function1 = function1.getShouldReceiveTouch()) != null ? (Boolean)function1.invoke((Object)this) : null;
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) break;
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                this.mDownFocusLocation.set(this.getMCurrentLocation());
                VelocityTracker velocityTracker = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker);
                velocityTracker.clear();
                VelocityTracker velocityTracker7 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker7);
                velocityTracker7.addMovement(event);
                this.mStarted = false;
                this.mDown = true;
                this.stopListenForOtherStateChanges();
                int[] upIndex = new int[]{4};
                this.removeMessages(upIndex);
                if (!this.computeState(rawX, rawY)) {
                    this.logMessage(5, "outside edge limits");
                    state = UIGestureRecognizer.State.Failed;
                } else {
                    state = UIGestureRecognizer.State.Possible;
                }
                this.setState(state);
                this.setBeginFiringEvents(false);
                break;
            }
            case 2: {
                this.scrollX = this.mLastFocusLocation.x - this.getMCurrentLocation().x;
                this.scrollY = this.mLastFocusLocation.y - this.getMCurrentLocation().y;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker);
                velocityTracker.addMovement(event);
                if (this.mDown && this.getState() == UIGestureRecognizer.State.Possible && !this.mStarted) {
                    float distance = GeometryKt.distance(this.getMCurrentLocation(), this.mDownFocusLocation);
                    if (!(distance > (float)this.scaledTouchSlop)) break;
                    VelocityTracker velocityTracker8 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker8);
                    velocityTracker8.computeCurrentVelocity(1000, Float.MAX_VALUE);
                    VelocityTracker velocityTracker9 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker9);
                    this.yVelocity = velocityTracker9.getYVelocity();
                    VelocityTracker velocityTracker10 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker10);
                    this.xVelocity = velocityTracker10.getXVelocity();
                    this.logMessage(4, "velocity: " + this.xVelocity + ", " + this.yVelocity);
                    this.translationX -= this.scrollX;
                    this.translationY -= this.scrollY;
                    this.mLastFocusLocation.set(this.getMCurrentLocation());
                    this.mStarted = true;
                    int n = this.minimumNumberOfTouches;
                    int n2 = this.maximumNumberOfTouches;
                    int n3 = this.getNumberOfTouches();
                    boolean bl = n <= n3 ? n3 <= n2 : false;
                    if (bl) {
                        Function1<UIGestureRecognizer, Boolean> function1 = this.getDelegate$uigesturerecognizer_release();
                        Boolean bl2 = function1 != null && (function1 = function1.getShouldBegin()) != null ? (Boolean)function1.invoke((Object)this) : null;
                        Intrinsics.checkNotNull(bl2);
                        if (bl2.booleanValue() && this.getTouchDirection(this.mDownFocusLocation.x, this.mDownFocusLocation.y, this.getMCurrentLocation().x, this.getMCurrentLocation().y, this.xVelocity, this.yVelocity) == this.edge) {
                            this.setState(UIGestureRecognizer.State.Began);
                            if (this.getRequireFailureOf() == null) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                                break;
                            }
                            UIGestureRecognizer uIGestureRecognizer = this.getRequireFailureOf();
                            Intrinsics.checkNotNull((Object)uIGestureRecognizer);
                            if (uIGestureRecognizer.getState() == UIGestureRecognizer.State.Failed) {
                                this.fireActionEventIfCanRecognizeSimultaneously();
                                break;
                            }
                            UIGestureRecognizer uIGestureRecognizer2 = this.getRequireFailureOf();
                            Intrinsics.checkNotNull((Object)uIGestureRecognizer2);
                            UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed};
                            if (uIGestureRecognizer2.inState(stateArray)) {
                                this.setState(UIGestureRecognizer.State.Failed);
                                break;
                            }
                            this.listenForOtherStateChanges();
                            this.setBeginFiringEvents(false);
                            this.logMessage(3, "waiting...");
                            break;
                        }
                    }
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                UIGestureRecognizer.State[] distance = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
                if (!this.inState(distance)) break;
                this.translationX -= this.scrollX;
                this.translationY -= this.scrollY;
                int pointerId = event.getPointerId(0);
                VelocityTracker velocityTracker11 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker11);
                velocityTracker11.computeCurrentVelocity(1000, Float.MAX_VALUE);
                VelocityTracker velocityTracker12 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker12);
                this.yVelocity = velocityTracker12.getYVelocity(pointerId);
                VelocityTracker velocityTracker13 = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker13);
                this.xVelocity = velocityTracker13.getXVelocity(pointerId);
                if (this.hasBeganFiringEvents()) {
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                }
                this.mLastFocusLocation.set(this.getMCurrentLocation());
                break;
            }
            case 1: {
                this.mDown = false;
                UIGestureRecognizer.State[] pointerId = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
                if (this.inState(pointerId)) {
                    if (this.getState() == UIGestureRecognizer.State.Changed) {
                        this.scrollX = this.mLastFocusLocation.x - this.getMCurrentLocation().x;
                        this.scrollY = this.mLastFocusLocation.y - this.getMCurrentLocation().y;
                        this.translationX -= this.scrollX;
                        this.translationY -= this.scrollY;
                    }
                    boolean began = this.hasBeganFiringEvents();
                    this.setState(UIGestureRecognizer.State.Ended);
                    if (began) {
                        this.fireActionEvent();
                    }
                }
                if (this.getState() == UIGestureRecognizer.State.Possible || !this.mStarted) {
                    this.xVelocity = this.yVelocity = 0.0f;
                }
                if (this.mVelocityTracker != null) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker);
                    velocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.getMHandler().sendEmptyMessage(4);
                break;
            }
            case 3: {
                int[] nArray = new int[]{4};
                this.removeMessages(nArray);
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.setBeginFiringEvents(false);
                this.getMHandler().sendEmptyMessage(4);
            }
        }
        return this.getCancelsTouchesInView();
    }

    private final void fireActionEventIfCanRecognizeSimultaneously() {
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended};
        if (this.inState(stateArray)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else {
            UIGestureRecognizerDelegate uIGestureRecognizerDelegate = this.getDelegate$uigesturerecognizer_release();
            Intrinsics.checkNotNull((Object)uIGestureRecognizerDelegate);
            if (uIGestureRecognizerDelegate.shouldRecognizeSimultaneouslyWithGestureRecognizer$uigesturerecognizer_release(this)) {
                this.setBeginFiringEvents(true);
                this.fireActionEvent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasBeganFiringEvents() {
        if (!super.hasBeganFiringEvents()) return false;
        UIGestureRecognizer.State[] stateArray = new UIGestureRecognizer.State[]{UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed};
        if (!this.inState(stateArray)) return false;
        return true;
    }

    @Override
    protected void removeMessages() {
        int[] nArray = new int[]{4};
        this.removeMessages(nArray);
    }

    private final UIRectEdge getTouchDirection(float x1, float y1, float x2, float y2, float velocityX, float velocityY) {
        float diffY = y2 - y1;
        float diffX = x2 - x1;
        if (Math.abs(diffX) > Math.abs(diffY)) {
            if (Math.abs(diffX) > 0.0f) {
                return diffX > 0.0f ? UIRectEdge.LEFT : UIRectEdge.RIGHT;
            }
        } else if (Math.abs(diffY) > 0.0f) {
            return diffY > 0.0f ? UIRectEdge.TOP : UIRectEdge.BOTTOM;
        }
        return UIRectEdge.NONE;
    }

    private final boolean computeState(float x, float y) {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = context;
        if (this.edge == UIRectEdge.LEFT && x > this.edgeLimit) {
            return false;
        }
        if (this.edge == UIRectEdge.RIGHT) {
            int w = context2.getResources().getDisplayMetrics().widthPixels;
            return x >= (float)w - this.edgeLimit;
        }
        if (this.edge == UIRectEdge.TOP && y > this.edgeLimit) {
            return false;
        }
        if (this.edge == UIRectEdge.BOTTOM) {
            int h = context2.getResources().getDisplayMetrics().heightPixels;
            return y >= (float)h - this.edgeLimit;
        }
        return this.edge != UIRectEdge.NONE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lit/sephiroth/android/library/uigestures/UIScreenEdgePanGestureRecognizer$Companion;", "", "()V", "MESSAGE_RESET", "", "uigesturerecognizer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

