/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.os.Build;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.view.MotionEvent;
import it.sephiroth.android.library.uigestures.ScaleGestureDetector;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;

public class UIPinchGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer,
ScaleGestureDetector.OnScaleGestureListener {
    private static final int MESSAGE_RESET = 1;
    private final ScaleGestureDetector mScaleGestureDetector;
    private float mTotalScale;

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.setState(UIGestureRecognizer.State.Possible);
                break;
            }
        }
    }

    public UIPinchGestureRecognizer(@Nullable Context context) {
        super(context);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this);
        this.setQuickScaleEnabled(false);
    }

    public void setQuickScaleEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT > 18) {
            this.mScaleGestureDetector.setQuickScaleEnabled(enabled);
        }
    }

    @RequiresApi(api=23)
    public void setStylusScaleEnabled(boolean enabled) {
        this.mScaleGestureDetector.setStylusScaleEnabled(enabled);
    }

    @Override
    protected boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (this.isEnabled()) {
            this.mScaleGestureDetector.onTouchEvent(ev);
            return this.getCancelsTouchesInView();
        }
        return false;
    }

    @Override
    public int getNumberOfTouches() {
        return this.mScaleGestureDetector.getNumberOfTouches();
    }

    public float getScale() {
        return this.mTotalScale;
    }

    public float getScaleFactor() {
        return this.mScaleGestureDetector.getScaleFactor();
    }

    @Override
    public void onStateChanged(@NonNull UIGestureRecognizer recognizer) {
        this.logMessage(2, "onStateChanged(%s, %s)", new Object[]{recognizer, recognizer.getState()});
        this.logMessage(2, "state: %s", new Object[]{this.getState()});
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
        } else if (recognizer.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended) && this.inState(UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began)) {
            this.stopListenForOtherStateChanges();
            this.removeMessages();
            this.setState(UIGestureRecognizer.State.Failed);
        }
    }

    @Override
    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        if (this.isEnabled() && this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed)) {
            this.mTotalScale += scaleGestureDetector.getScaleFactor() - 1.0f;
            if (this.getState() == UIGestureRecognizer.State.Began) {
                if (this.hasBeganFiringEvents()) {
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                }
            } else if (this.getState() == UIGestureRecognizer.State.Changed) {
                this.setState(UIGestureRecognizer.State.Changed);
                this.fireActionEvent();
            }
        }
        return true;
    }

    @Override
    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        this.setState(UIGestureRecognizer.State.Possible);
        if (this.isEnabled() && this.getState() == UIGestureRecognizer.State.Possible) {
            this.mTotalScale = scaleGestureDetector.getScaleFactor();
            this.removeMessages(1);
            if (this.getDelegate().shouldBegin(this)) {
                this.setState(UIGestureRecognizer.State.Began);
                if (null == this.getRequireFailureOf()) {
                    this.fireActionEventIfCanRecognizeSimultaneously();
                } else if (this.getRequireFailureOf().getState() == UIGestureRecognizer.State.Failed) {
                    this.fireActionEventIfCanRecognizeSimultaneously();
                } else if (this.getRequireFailureOf().inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended, UIGestureRecognizer.State.Changed)) {
                    this.setState(UIGestureRecognizer.State.Failed);
                } else {
                    this.listenForOtherStateChanges();
                    this.setBeginFiringEvents(false);
                    this.logMessage(3, "waiting...", new Object[0]);
                }
            } else {
                this.setState(UIGestureRecognizer.State.Failed);
            }
            return true;
        }
        return true;
    }

    @Override
    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        if (this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed)) {
            this.setState(UIGestureRecognizer.State.Ended);
            if (this.hasBeganFiringEvents()) {
                this.fireActionEvent();
            }
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private void fireActionEventIfCanRecognizeSimultaneously() {
        if (this.inState(UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else if (this.getDelegate().shouldRecognizeSimultaneouslyWithGestureRecognizer(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    @Override
    protected boolean hasBeganFiringEvents() {
        return super.hasBeganFiringEvents() && this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed);
    }

    @Override
    public float getCurrentLocationX() {
        return this.mScaleGestureDetector.getFocusX();
    }

    @Override
    public float getCurrentLocationY() {
        return this.mScaleGestureDetector.getFocusY();
    }

    public float getCurrentSpan() {
        return this.mScaleGestureDetector.getCurrentSpan();
    }

    public float getCurrentSpanX() {
        return this.mScaleGestureDetector.getCurrentSpanX();
    }

    public float getCurrentSpanY() {
        return this.mScaleGestureDetector.getCurrentSpanY();
    }

    public float getPreviousSpan() {
        return this.mScaleGestureDetector.getPreviousSpan();
    }

    public float getPreviousSpanX() {
        return this.mScaleGestureDetector.getPreviousSpanX();
    }

    public float getPreviousSpanY() {
        return this.mScaleGestureDetector.getPreviousSpanY();
    }

    public long getTimeDelta() {
        return this.mScaleGestureDetector.getTimeDelta();
    }

    @Override
    protected void removeMessages() {
        this.removeMessages(1);
    }
}

