/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.uigestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import it.sephiroth.android.library.uigestures.UIContinuousRecognizer;
import it.sephiroth.android.library.uigestures.UIGestureRecognizer;

public class UILongPressGestureRecognizer
extends UIGestureRecognizer
implements UIContinuousRecognizer {
    private long longPressTimeOut = TAP_TIMEOUT + LONG_PRESS_TIMEOUT;
    private static final int MESSAGE_FAILED = 1;
    private static final int MESSAGE_RESET = 2;
    private static final int MESSAGE_POINTER_UP = 3;
    private static final int MESSAGE_LONG_PRESS = 4;
    private int mTouchesRequired = 1;
    private int mTapsRequired = 0;
    private boolean mAlwaysInTapRegion;
    private float mDownFocusX;
    private float mDownFocusY;
    private float mTouchSlopSquare;
    private float mAllowableMovementSquare;
    private boolean mStarted = false;
    private int mNumTaps = 0;
    private int mNumTouches = 0;
    private final PointF mCurrentLocation = new PointF();
    private boolean mBegan = false;

    public UILongPressGestureRecognizer(@Nullable Context context) {
        super(context);
        int touchSlop;
        if (context == null) {
            touchSlop = ViewConfiguration.getTouchSlop();
        } else {
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            touchSlop = configuration.getScaledTouchSlop();
        }
        this.mAllowableMovementSquare = this.mTouchSlopSquare = (float)(touchSlop * touchSlop);
    }

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                this.logMessage(4, "handleMessage(MESSAGE_RESET)", new Object[0]);
                this.handleReset();
                break;
            }
            case 1: {
                this.logMessage(4, "handleMessage(MESSAGE_FAILED)", new Object[0]);
                this.handleFailed();
                break;
            }
            case 3: {
                this.logMessage(4, "handleMessage(MESSAGE_POINTER_UP)", new Object[0]);
                this.mNumTouches = msg.arg1;
                break;
            }
            case 4: {
                this.logMessage(4, "handleMessage(MESSAGE_LONG_PRESS)", new Object[0]);
                this.handleLongPress();
                break;
            }
        }
    }

    @Override
    public int getNumberOfTouches() {
        return this.mNumTouches;
    }

    @Override
    public void onStateChanged(@NonNull UIGestureRecognizer recognizer) {
        this.logMessage(2, "onStateChanged(%s, %s)", new Object[]{recognizer, recognizer.getState()});
        this.logMessage(2, "started: %b, state: %s", new Object[]{this.mStarted, this.getState()});
        if (recognizer.getState() == UIGestureRecognizer.State.Failed && this.getState() == UIGestureRecognizer.State.Began) {
            this.stopListenForOtherStateChanges();
            this.fireActionEventIfCanRecognizeSimultaneously();
            if (this.mBegan && this.hasBeganFiringEvents()) {
                this.setState(UIGestureRecognizer.State.Changed);
            }
        } else if (recognizer.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Ended) && this.mStarted && this.inState(UIGestureRecognizer.State.Possible, UIGestureRecognizer.State.Began)) {
            this.stopListenForOtherStateChanges();
            this.removeMessages();
            this.setState(UIGestureRecognizer.State.Failed);
            this.setBeginFiringEvents(false);
            this.mStarted = false;
        }
    }

    public void setNumberOfTapsRequired(int value) {
        this.mTapsRequired = value;
    }

    public void setNumberOfTouchesRequired(int value) {
        this.mTouchesRequired = value;
    }

    @Override
    protected boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        if (!this.isEnabled()) {
            return false;
        }
        int action = ev.getAction();
        int count = ev.getPointerCount();
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        this.mCurrentLocation.set(focusX, focusY);
        switch (action & 0xFF) {
            case 0: {
                this.removeMessages();
                this.mAlwaysInTapRegion = true;
                this.mNumTouches = count;
                this.mBegan = false;
                if (!this.mStarted) {
                    this.stopListenForOtherStateChanges();
                    this.setState(UIGestureRecognizer.State.Possible);
                    this.setBeginFiringEvents(false);
                    this.mNumTaps = 0;
                    this.mStarted = true;
                } else {
                    ++this.mNumTaps;
                }
                if (this.mNumTaps == this.mTapsRequired) {
                    this.mHandler.sendEmptyMessageAtTime(4, ev.getDownTime() + this.longPressTimeOut);
                } else {
                    long timeout = LONG_PRESS_TIMEOUT;
                    if (timeout >= this.longPressTimeOut) {
                        timeout = this.longPressTimeOut - 1L;
                    }
                    this.mHandler.sendEmptyMessageDelayed(1, timeout);
                }
                this.mDownFocusX = focusX;
                this.mDownFocusY = focusY;
                break;
            }
            case 5: {
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    this.removeMessages(3);
                    this.mNumTouches = count;
                    if (this.mNumTouches > 1 && this.mNumTouches > this.mTouchesRequired) {
                        this.removeMessages();
                        this.setState(UIGestureRecognizer.State.Failed);
                    }
                    this.mDownFocusX = focusX;
                    this.mDownFocusY = focusY;
                    break;
                }
                if (!this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed) || !this.mStarted) break;
                this.mNumTouches = count;
                break;
            }
            case 6: {
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    this.removeMessages(3);
                    this.mDownFocusX = focusX;
                    this.mDownFocusY = focusY;
                    Message message = this.mHandler.obtainMessage(3);
                    message.arg1 = this.mNumTouches - 1;
                    this.mHandler.sendMessageDelayed(message, TAP_TIMEOUT);
                    break;
                }
                if (!this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed) || this.mNumTouches - 1 >= this.mTouchesRequired) break;
                boolean began = this.hasBeganFiringEvents();
                this.setState(UIGestureRecognizer.State.Ended);
                if (began) {
                    this.fireActionEvent();
                }
                this.setBeginFiringEvents(false);
                break;
            }
            case 2: {
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    float deltaY;
                    float deltaX;
                    float distance;
                    if (!this.mAlwaysInTapRegion || !((distance = (deltaX = focusX - this.mDownFocusX) * deltaX + (deltaY = focusY - this.mDownFocusY) * deltaY) > this.mAllowableMovementSquare)) break;
                    this.logMessage(5, "moved too much!: " + distance, new Object[0]);
                    this.mAlwaysInTapRegion = false;
                    this.removeMessages();
                    this.setState(UIGestureRecognizer.State.Failed);
                    break;
                }
                if (this.getState() == UIGestureRecognizer.State.Began) {
                    float deltaY;
                    float deltaX;
                    float distance;
                    if (this.mBegan || !((distance = (deltaX = focusX - this.mDownFocusX) * deltaX + (deltaY = focusY - this.mDownFocusY) * deltaY) > this.mTouchSlopSquare)) break;
                    this.mBegan = true;
                    if (!this.hasBeganFiringEvents()) break;
                    this.setState(UIGestureRecognizer.State.Changed);
                    this.fireActionEvent();
                    break;
                }
                if (this.getState() != UIGestureRecognizer.State.Changed) break;
                this.setState(UIGestureRecognizer.State.Changed);
                if (!this.hasBeganFiringEvents()) break;
                this.fireActionEvent();
                break;
            }
            case 1: {
                this.removeMessages(2, 3, 4);
                if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
                    if (this.mNumTouches != this.mTouchesRequired) {
                        this.mStarted = false;
                        this.removeMessages();
                        this.setState(UIGestureRecognizer.State.Failed);
                        this.postReset();
                    } else if (this.mNumTaps < this.mTapsRequired) {
                        this.removeMessages(1);
                        this.delayedFail();
                    } else {
                        this.mNumTaps = 0;
                        this.mStarted = false;
                        this.removeMessages();
                        this.setState(UIGestureRecognizer.State.Failed);
                    }
                } else if (this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed)) {
                    this.mNumTaps = 0;
                    this.mStarted = false;
                    boolean began = this.hasBeganFiringEvents();
                    this.setState(UIGestureRecognizer.State.Ended);
                    if (began) {
                        this.fireActionEvent();
                    }
                    this.postReset();
                } else {
                    this.mStarted = false;
                    this.postReset();
                }
                this.setBeginFiringEvents(false);
                break;
            }
            case 3: {
                this.removeMessages();
                this.mStarted = false;
                this.mNumTaps = 0;
                this.setState(UIGestureRecognizer.State.Cancelled);
                this.postReset();
                break;
            }
        }
        return this.getCancelsTouchesInView();
    }

    @Override
    protected void removeMessages() {
        this.removeMessages(1, 2, 3, 4);
    }

    private void postReset() {
        this.mHandler.sendEmptyMessage(2);
    }

    private void delayedFail() {
        this.mHandler.sendEmptyMessageDelayed(1, DOUBLE_TAP_TIMEOUT);
    }

    private void handleFailed() {
        this.removeMessages();
        this.setState(UIGestureRecognizer.State.Failed);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
    }

    private void handleReset() {
        this.setState(UIGestureRecognizer.State.Possible);
        this.setBeginFiringEvents(false);
        this.mStarted = false;
    }

    private void handleLongPress() {
        this.logMessage(4, "handleLongPress", new Object[0]);
        this.removeMessages(1);
        if (this.getState() == UIGestureRecognizer.State.Possible && this.mStarted) {
            if (this.mNumTouches == this.mTouchesRequired && this.getDelegate().shouldBegin(this)) {
                this.setState(UIGestureRecognizer.State.Began);
                if (null == this.getRequireFailureOf()) {
                    this.fireActionEventIfCanRecognizeSimultaneously();
                } else if (this.getRequireFailureOf().getState() == UIGestureRecognizer.State.Failed) {
                    this.fireActionEventIfCanRecognizeSimultaneously();
                } else if (this.getRequireFailureOf().inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended)) {
                    this.setState(UIGestureRecognizer.State.Failed);
                    this.setBeginFiringEvents(false);
                    this.mStarted = false;
                    this.mNumTaps = 0;
                } else {
                    this.listenForOtherStateChanges();
                    this.setBeginFiringEvents(false);
                    this.logMessage(3, "waiting...", new Object[0]);
                }
            } else {
                this.setState(UIGestureRecognizer.State.Failed);
                this.setBeginFiringEvents(false);
                this.mStarted = false;
                this.mNumTaps = 0;
            }
        }
    }

    private void fireActionEventIfCanRecognizeSimultaneously() {
        if (this.inState(UIGestureRecognizer.State.Changed, UIGestureRecognizer.State.Ended)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        } else if (this.getDelegate().shouldRecognizeSimultaneouslyWithGestureRecognizer(this)) {
            this.setBeginFiringEvents(true);
            this.fireActionEvent();
        }
    }

    @Override
    protected boolean hasBeganFiringEvents() {
        return super.hasBeganFiringEvents() && this.inState(UIGestureRecognizer.State.Began, UIGestureRecognizer.State.Changed);
    }

    @Override
    public float getCurrentLocationX() {
        return this.mCurrentLocation.x;
    }

    @Override
    public float getCurrentLocationY() {
        return this.mCurrentLocation.y;
    }

    public void setAllowableMovement(float value) {
        this.mAllowableMovementSquare = value * value;
    }

    public float getAllowableMovement() {
        return this.mAllowableMovementSquare;
    }

    public void setMinimumPressDuration(long value) {
        this.longPressTimeOut = value;
    }

    public long getMinimumPressDuration() {
        return this.longPressTimeOut;
    }
}

