/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ManualResetEvent {
    private volatile CountDownLatch event;
    private final Integer mutex = new Integer(-1);

    public ManualResetEvent(boolean signalled) {
        this.event = signalled ? new CountDownLatch(0) : new CountDownLatch(1);
    }

    public void set() {
        this.event.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Integer n = this.mutex;
        synchronized (n) {
            if (this.event.getCount() == 0L) {
                this.event = new CountDownLatch(1);
            }
        }
    }

    public void waitOne() throws InterruptedException {
        this.event.await();
    }

    public boolean waitOne(int timeout, TimeUnit unit) throws InterruptedException {
        return this.event.await(timeout, unit);
    }

    public boolean isSignalled() {
        return this.event.getCount() == 0L;
    }
}

