/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.request;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.models.Batch;
import com.github.segmentio.request.BlockingRequester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingRequester
extends BlockingRequester {
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    private int retries;
    private int backoff;

    public RetryingRequester(AnalyticsClient client) {
        super(client);
        this.retries = client.getOptions().getRetries();
        this.backoff = client.getOptions().getBackoff();
    }

    public boolean send(Batch batch) {
        int attempts = 0;
        boolean success = super.send(batch);
        while (!success && attempts < this.retries) {
            ++attempts;
            try {
                Thread.sleep(this.backoff);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted during backoff", (Throwable)e);
            }
            logger.info("Retrying request [attempt {}] ..", (Object)attempts);
            success = super.send(batch);
        }
        if (!success) {
            logger.error("Unable to complete request after {} attempts", (Object)attempts);
        }
        return success;
    }
}

