/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.Options;
import com.github.segmentio.models.Callback;
import com.github.segmentio.models.Context;
import com.github.segmentio.models.EventProperties;
import com.github.segmentio.models.Traits;
import com.github.segmentio.stats.AnalyticsStatistics;
import org.joda.time.DateTime;

public class Analytics {
    public static final String VERSION = "0.4.0";
    private static AnalyticsClient defaultClient;

    public static synchronized void initialize(String writeKey) {
        if (defaultClient == null) {
            defaultClient = new AnalyticsClient(writeKey, new Options());
        }
    }

    public static synchronized void initialize(String writeKey, Options options) {
        if (defaultClient == null) {
            defaultClient = new AnalyticsClient(writeKey, options);
        }
    }

    private static void checkInitialized() {
        if (defaultClient == null) {
            throw new IllegalStateException("Analytics client is not initialized. Please call Analytics.iniitalize(..); before calling identify / track / or flush.");
        }
    }

    public static void identify(String userId, Traits traits) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, null, null, null);
    }

    public static void identify(String userId, Traits traits, Context context) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, null, context, null);
    }

    public static void identify(String userId, Traits traits, DateTime timestamp, Context context) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, timestamp, context, null);
    }

    public static void identify(String userId, Traits traits, DateTime timestamp, Context context, Callback callback) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, timestamp, context, callback);
    }

    public static void track(String userId, String event, EventProperties properties) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, null, null, null);
    }

    public static void track(String userId, String event) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, null, null, null, null);
    }

    public static void track(String userId, String event, EventProperties properties, DateTime timestamp) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, timestamp, null, null);
    }

    public static void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, timestamp, context, null);
    }

    public static void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context, Callback callback) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, timestamp, context, callback);
    }

    public static void alias(String from, String to) {
        Analytics.checkInitialized();
        defaultClient.alias(from, to, null, null, null);
    }

    public static void alias(String from, String to, DateTime timestamp) {
        Analytics.checkInitialized();
        defaultClient.alias(from, to, timestamp, null, null);
    }

    public static void alias(String from, String to, Context context) {
        Analytics.checkInitialized();
        defaultClient.alias(from, to, null, context, null);
    }

    public static void alias(String from, String to, DateTime timestamp, Context context) {
        Analytics.checkInitialized();
        defaultClient.alias(from, to, timestamp, context, null);
    }

    public static void alias(String from, String to, DateTime timestamp, Context context, Callback callback) {
        Analytics.checkInitialized();
        defaultClient.alias(from, to, timestamp, context, callback);
    }

    public static void flush() {
        Analytics.checkInitialized();
        defaultClient.flush();
    }

    public static void close() {
        Analytics.checkInitialized();
        defaultClient.close();
    }

    public static AnalyticsStatistics getStatistics() {
        Analytics.checkInitialized();
        return defaultClient.getStatistics();
    }

    public static AnalyticsClient getDefaultClient() {
        return defaultClient;
    }
}

