/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.kotlin.android;

import android.content.Context;
import android.content.SharedPreferences;
import com.segment.analytics.kotlin.android.AndroidStorage$WhenMappings;
import com.segment.analytics.kotlin.android.utilities.AndroidKVS;
import com.segment.analytics.kotlin.core.Storage;
import com.segment.analytics.kotlin.core.System;
import com.segment.analytics.kotlin.core.UserInfo;
import com.segment.analytics.kotlin.core.utilities.EventsFileManager;
import com.segment.analytics.kotlin.core.utilities.KVS;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sovran.kotlin.Store;
import sovran.kotlin.Subscriber;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\bH\u0016R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/segment/analytics/kotlin/android/AndroidStorage;", "Lsovran/kotlin/Subscriber;", "Lcom/segment/analytics/kotlin/core/Storage;", "context", "Landroid/content/Context;", "store", "Lsovran/kotlin/Store;", "writeKey", "", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Landroid/content/Context;Lsovran/kotlin/Store;Ljava/lang/String;Lkotlinx/coroutines/CoroutineDispatcher;)V", "eventsFile", "Lcom/segment/analytics/kotlin/core/utilities/EventsFileManager;", "getEventsFile$android_release", "()Lcom/segment/analytics/kotlin/core/utilities/EventsFileManager;", "sharedPreferences", "Landroid/content/SharedPreferences;", "storageDirectory", "Ljava/io/File;", "read", "key", "Lcom/segment/analytics/kotlin/core/Storage$Constants;", "remove", "", "removeFile", "filePath", "subscribeToStore", "", "write", "value", "android_release"})
public final class AndroidStorage
implements Subscriber,
Storage {
    private final SharedPreferences sharedPreferences;
    private final File storageDirectory;
    @NotNull
    private final EventsFileManager eventsFile;
    private final Store store;
    private final CoroutineDispatcher ioDispatcher;

    @NotNull
    public final EventsFileManager getEventsFile$android_release() {
        return this.eventsFile;
    }

    public void subscribeToStore() {
        Store.subscribe$default((Store)this.store, (Subscriber)this, (KClass)Reflection.getOrCreateKotlinClass(UserInfo.class), (boolean)true, null, (Function1)((Function1)new Function1<UserInfo, Unit>(this){

            public final void invoke(@NotNull UserInfo p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((AndroidStorage)this.receiver).userInfoUpdate(p1);
            }
        }), (int)8, null);
        Store.subscribe$default((Store)this.store, (Subscriber)this, (KClass)Reflection.getOrCreateKotlinClass(System.class), (boolean)true, null, (Function1)((Function1)new Function1<System, Unit>(this){

            public final void invoke(@NotNull System p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((AndroidStorage)this.receiver).systemUpdate(p1);
            }
        }), (int)8, null);
    }

    public void write(@NotNull Storage.Constants key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (AndroidStorage$WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
            case 1: {
                if (value.length() < 32000) {
                    this.eventsFile.storeEvent(value);
                    break;
                }
                throw (Throwable)new Exception("enqueued payload is too large");
            }
            default: {
                this.sharedPreferences.edit().putString(key.getRawVal(), value).apply();
            }
        }
    }

    @Nullable
    public String read(@NotNull Storage.Constants key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        switch (AndroidStorage$WhenMappings.$EnumSwitchMapping$1[key.ordinal()]) {
            case 1: {
                string = CollectionsKt.joinToString$default((Iterable)this.eventsFile.read(), null, null, null, (int)0, null, null, (int)63, null);
                break;
            }
            default: {
                string = this.sharedPreferences.getString(key.getRawVal(), null);
            }
        }
        return string;
    }

    public boolean remove(@NotNull Storage.Constants key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        switch (AndroidStorage$WhenMappings.$EnumSwitchMapping$2[key.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                this.sharedPreferences.edit().putString(key.getRawVal(), null).apply();
                bl = true;
            }
        }
        return bl;
    }

    public boolean removeFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.eventsFile.remove(filePath);
    }

    public AndroidStorage(@NotNull Context context, @NotNull Store store, @NotNull String writeKey, @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)writeKey, (String)"writeKey");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        this.store = store;
        this.ioDispatcher = ioDispatcher;
        SharedPreferences sharedPreferences = context.getSharedPreferences("analytics-android-" + writeKey, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026y\", Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        File file = context.getDir("segment-disk-queue", 0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDir(\"segment-\u2026e\", Context.MODE_PRIVATE)");
        this.storageDirectory = file;
        this.eventsFile = new EventsFileManager(this.storageDirectory, writeKey, (KVS)new AndroidKVS(this.sharedPreferences));
    }

    public void systemUpdate(@NotNull System system) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        Storage.DefaultImpls.systemUpdate((Storage)this, (System)system);
    }

    public void userInfoUpdate(@NotNull UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Storage.DefaultImpls.userInfoUpdate((Storage)this, (UserInfo)userInfo);
    }
}

