/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressSeqRangeList;
import inet.ipaddr.format.util.BigSpliterator;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSeqRange;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.stream.Stream;

public class IPv4AddressSeqRangeList
extends IPAddressSeqRangeList
implements Iterable<IPv4Address> {
    private static final long serialVersionUID = 1L;

    public IPv4AddressSeqRangeList() {
    }

    public IPv4AddressSeqRangeList(int initialCapacity) {
        super(initialCapacity);
    }

    public IPv4AddressSeqRange[] getSeqRanges() {
        return this.ranges.toArray(new IPv4AddressSeqRange[this.ranges.size()]);
    }

    @Override
    public IPv4AddressSeqRangeList complementIntoList() {
        IPv4AddressNetwork network = this.isEmpty() ? IPv4Address.defaultIpv4Network() : this.getLowerSeqRange().getLower().getNetwork();
        IPv4Address zero = (IPv4Address)network.getNetworkMask(0, false);
        IPv4Address max = (IPv4Address)network.getNetworkMask(zero.getBitCount(), false);
        IPv4AddressSeqRangeList result = new IPv4AddressSeqRangeList();
        this.complement(result, zero, max);
        return result;
    }

    @Override
    public IPv4AddressSeqRangeList removeIntoList(IPAddressSeqRangeList list) {
        IPv4AddressSeqRangeList result = new IPv4AddressSeqRangeList();
        super.remove(list, result);
        return result;
    }

    @Override
    public IPv4AddressSeqRangeList intersectIntoList(IPAddressSeqRangeList list) {
        IPv4AddressSeqRangeList result = new IPv4AddressSeqRangeList();
        super.intersect(list, result);
        return result;
    }

    @Override
    public IPv4AddressSeqRangeList joinIntoList(IPAddressSeqRangeList list) {
        if (list.getSeqRangeCount() == 0) {
            return this.clone();
        }
        if (!list.getSeqRange(0).isIPv4()) {
            throw new IllegalArgumentException(IPv4AddressSeqRangeList.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        IPv4AddressSeqRangeList result = new IPv4AddressSeqRangeList();
        super.join(list, result);
        return result;
    }

    @Override
    public boolean add(IPAddress address) {
        if (!address.isIPv4()) {
            throw new IllegalArgumentException(IPv4AddressSeqRangeList.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        if (this.ranges.size() == 0) {
            this.addAddressToEmptyList(address);
            return true;
        }
        return this.doAdd(address);
    }

    void addInternalToNewList(IPv4Address address) {
        this.addAddressToEmptyList(address);
    }

    @Override
    public boolean add(IPAddressSeqRange seqRange) {
        if (!seqRange.isIPv4()) {
            throw new IllegalArgumentException(IPv4AddressSeqRangeList.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        if (this.ranges.size() == 0) {
            this.addRangeToEmptyList(seqRange);
            return true;
        }
        return this.doAdd(seqRange);
    }

    @Override
    public IPv4Address getLower() {
        return (IPv4Address)super.getLower();
    }

    @Override
    public IPv4Address getUpper() {
        return (IPv4Address)super.getUpper();
    }

    @Override
    public IPv4AddressSeqRange getLowerSeqRange() {
        return (IPv4AddressSeqRange)super.getLowerSeqRange();
    }

    @Override
    public IPv4AddressSeqRange getUpperSeqRange() {
        return (IPv4AddressSeqRange)super.getUpperSeqRange();
    }

    @Override
    public IPv4AddressSeqRangeList clone() {
        return (IPv4AddressSeqRangeList)super.clone();
    }

    @Override
    public IPv4AddressSeqRange getSeqRange(int rangeIndex) {
        return (IPv4AddressSeqRange)this.ranges.get(rangeIndex);
    }

    @Override
    public IPv4Address remove(long addressIndex) {
        return (IPv4Address)super.remove(addressIndex);
    }

    @Override
    public IPv4Address increment(long addressIndex) {
        return (IPv4Address)super.increment(addressIndex);
    }

    @Override
    public IPv4Address get(long addressIndex) {
        return (IPv4Address)super.get(addressIndex);
    }

    @Override
    public IPv4AddressSeqRange getContainingSeqRange(long addressIndex) {
        return (IPv4AddressSeqRange)super.getContainingSeqRange(addressIndex);
    }

    @Override
    public IPv4Address remove(BigInteger addressIndex) {
        if (addressIndex.compareTo(IPv4AddressSection.LONG_MAX) >= 0 || addressIndex.compareTo(IPv4AddressSection.LONG_MIN) <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.remove(addressIndex.longValue());
    }

    @Override
    public IPv4Address increment(BigInteger addressIndex) {
        if (addressIndex.compareTo(IPv4AddressSection.LONG_MAX) >= 0 || addressIndex.compareTo(IPv4AddressSection.LONG_MIN) <= 0) {
            throw new AddressValueException(addressIndex);
        }
        return this.increment(addressIndex.longValue());
    }

    @Override
    public IPv4Address get(BigInteger addressIndex) {
        if (addressIndex.compareTo(IPv4AddressSection.LONG_MAX) >= 0 || addressIndex.compareTo(IPv4AddressSection.LONG_MIN) <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(addressIndex.longValue());
    }

    @Override
    public IPv4AddressSeqRange getContainingSeqRange(BigInteger addressIndex) {
        return (IPv4AddressSeqRange)super.getContainingSeqRange(addressIndex);
    }

    @Override
    public IPv4AddressSeqRange coverWithSequentialRange() {
        return (IPv4AddressSeqRange)super.coverWithSequentialRange();
    }

    @Override
    public IPv4Address coverWithPrefixBlock() {
        return this.getLower().coverWithPrefixBlock(this.getUpper());
    }

    public IPv4Address[] spanWithPrefixBlocks() {
        if (this.ranges.size() == 0) {
            return IPv4AddressNetwork.EMPTY_ADDRESS;
        }
        return (IPv4Address[])this.getSpanningBlocks(IPv4AddressSeqRange::spanWithPrefixBlocks, IPv4Address[]::new);
    }

    public IPv4Address[] spanWithSequentialBlocks() {
        if (this.ranges.size() == 0) {
            return IPv4AddressNetwork.EMPTY_ADDRESS;
        }
        return (IPv4Address[])this.getSpanningBlocks(IPv4AddressSeqRange::spanWithSequentialBlocks, IPv4Address[]::new);
    }

    public Iterable<IPv4Address> getIterable() {
        return this;
    }

    public Iterable<IPv4AddressSeqRange> getSeqRangeIterable() {
        return super.getSeqRangeIterable();
    }

    public Iterator<IPv4AddressSeqRange> seqRangeIterator() {
        return super.seqRangeIterator();
    }

    @Override
    public Iterator<IPv4Address> iterator() {
        return super.iterator();
    }

    @Override
    public BigSpliterator<IPv4Address> spliterator() {
        return super.spliterator();
    }

    @Override
    public Stream<IPv4Address> stream() {
        return super.stream();
    }
}

