/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.AssociativeAddedTree;
import inet.ipaddr.format.util.AssociativeAddressTrie;
import inet.ipaddr.format.util.BinaryTreeNode;
import inet.ipaddr.format.util.IPAddressTrie;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.util.Iterator;
import java.util.Spliterator;

public class IPAddressAssociativeTrie<V>
extends AssociativeAddressTrie<IPAddress, V> {
    private static final long serialVersionUID = 1L;
    static final IPv6Address IPV6_ROOT = IPAddressTrie.IPV6_ROOT;
    static final IPv4Address IPV4_ROOT = IPAddressTrie.IPV4_ROOT;

    public IPAddressAssociativeTrie() {
        super(new IPAddressAssociativeTrieNode());
    }

    protected IPAddressAssociativeTrie(IPAddressAssociativeTrieNode<V> root, AddressTrie.AddressBounds<IPAddress> bounds) {
        super(root, bounds);
    }

    protected IPAddressAssociativeTrie(AddressTrie.AddressBounds<IPAddress> bounds) {
        super(new IPAddressAssociativeTrieNode(), bounds);
    }

    @Override
    protected void adjustRoot(IPAddress addr) {
        if (this.isInitialRoot()) {
            if (addr.isIPv6()) {
                ((IPAddressAssociativeTrieNode)this.absoluteRoot()).setIPv6Key();
            } else {
                ((IPAddressAssociativeTrieNode)this.absoluteRoot()).setIPv4Key();
            }
        }
    }

    @Override
    protected IPAddressAssociativeTrie<V> createNew(AddressTrie.AddressBounds<IPAddress> bounds) {
        return new IPAddressAssociativeTrie<V>(bounds);
    }

    @Override
    protected IPAddressAssociativeTrie<V> createSubTrie(AddressTrie.AddressBounds<IPAddress> bounds) {
        return new IPAddressAssociativeTrie<V>(this.absoluteRoot(), bounds);
    }

    @Override
    protected IPAddressAssociativeTrieNode<V> absoluteRoot() {
        return (IPAddressAssociativeTrieNode)super.absoluteRoot();
    }

    @Override
    public IPAddressAssociativeTrieNode<V> getRoot() {
        return (IPAddressAssociativeTrieNode)super.getRoot();
    }

    @Override
    public AssociativeAddedTree<IPAddress, V> constructAddedNodesTree() {
        IPAddressAssociativeTrie trie = new IPAddressAssociativeTrie();
        this.contructAssociativeAddedTree(trie);
        return new AssociativeAddedTree(trie);
    }

    @Override
    public String toAddedNodesTreeString() {
        IPAddressAssociativeTrie trie = new IPAddressAssociativeTrie();
        this.contructAssociativeAddedTree(trie);
        return IPAddressAssociativeTrie.toAddedNodesTreeString(trie);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> removeElementsContainedBy(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.removeElementsContainedBy(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> elementsContainedBy(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.elementsContainedBy(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> elementsContaining(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.elementsContaining(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> longestPrefixMatchNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.longestPrefixMatchNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> getAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.getAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> getNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.getNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> addNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.addNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> addTrie(AddressTrie.TrieNode<IPAddress> trie) {
        return (IPAddressAssociativeTrieNode)super.addTrie(trie);
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> nodeIterator(boolean forward) {
        return super.nodeIterator(forward);
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> allNodeIterator(boolean forward) {
        return super.allNodeIterator(forward);
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> blockSizeNodeIterator(boolean lowerSubNodeFirst) {
        return super.blockSizeNodeIterator(lowerSubNodeFirst);
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> blockSizeAllNodeIterator(boolean lowerSubNodeFirst) {
        return super.blockSizeAllNodeIterator(lowerSubNodeFirst);
    }

    @Override
    public <C> BinaryTreeNode.CachingIterator<IPAddressAssociativeTrieNode<V>, IPAddress, C> blockSizeCachingAllNodeIterator() {
        return super.blockSizeCachingAllNodeIterator();
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> containingFirstIterator(boolean forwardSubNodeOrder) {
        return super.containingFirstIterator(forwardSubNodeOrder);
    }

    @Override
    public <C> BinaryTreeNode.CachingIterator<IPAddressAssociativeTrieNode<V>, IPAddress, C> containingFirstAllNodeIterator(boolean forwardSubNodeOrder) {
        return super.containingFirstAllNodeIterator(forwardSubNodeOrder);
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> containedFirstIterator(boolean forwardSubNodeOrder) {
        return super.containedFirstIterator(forwardSubNodeOrder);
    }

    @Override
    public Iterator<IPAddressAssociativeTrieNode<V>> containedFirstAllNodeIterator(boolean forwardSubNodeOrder) {
        return super.containedFirstAllNodeIterator(forwardSubNodeOrder);
    }

    @Override
    public Spliterator<IPAddressAssociativeTrieNode<V>> nodeSpliterator(boolean forward) {
        return super.nodeSpliterator(forward);
    }

    @Override
    public Spliterator<IPAddressAssociativeTrieNode<V>> allNodeSpliterator(boolean forward) {
        return super.allNodeSpliterator(forward);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> removeElementsIntersectedBy(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.removeElementsIntersectedBy(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> addIfNoElementsContaining(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.addIfNoElementsContaining(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> containingFloorAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.containingFloorAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> containingLowerAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.containingLowerAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> containingCeilingAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.containingCeilingAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> containingHigherAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.containingHigherAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> lowerAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.lowerAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> floorAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.floorAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> higherAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.higherAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> ceilingAddedNode(IPAddress addr) {
        return (IPAddressAssociativeTrieNode)super.ceilingAddedNode(addr);
    }

    @Override
    public IPAddressAssociativeTrieNode<V> firstNode() {
        return (IPAddressAssociativeTrieNode)super.firstNode();
    }

    @Override
    public IPAddressAssociativeTrieNode<V> lastNode() {
        return (IPAddressAssociativeTrieNode)super.lastNode();
    }

    @Override
    public IPAddressAssociativeTrieNode<V> firstAddedNode() {
        return (IPAddressAssociativeTrieNode)super.firstAddedNode();
    }

    @Override
    public IPAddressAssociativeTrieNode<V> lastAddedNode() {
        return (IPAddressAssociativeTrieNode)super.lastAddedNode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof IPAddressAssociativeTrie && super.equals(o);
    }

    @Override
    public IPAddressAssociativeTrie<V> clone() {
        return (IPAddressAssociativeTrie)super.clone();
    }

    public static class IPAddressAssociativeTrieNode<V>
    extends AssociativeAddressTrie.AssociativeTrieNode<IPAddress, V> {
        private static final long serialVersionUID = 1L;

        protected IPAddressAssociativeTrieNode(IPAddress addr) {
            super(addr);
        }

        public IPAddressAssociativeTrieNode() {
            super(null);
        }

        @Override
        protected void replaceThisRoot(BinaryTreeNode<IPAddress> replacement) {
            super.replaceThisRoot(replacement);
            if (replacement == null) {
                this.setKey(null);
            }
        }

        void setIPv6Key() {
            this.setKey(IPV6_ROOT);
        }

        void setIPv4Key() {
            this.setKey(IPV4_ROOT);
        }

        @Override
        protected IPAddressAssociativeTrieNode<V> createNewImpl(IPAddress newAddr) {
            return new IPAddressAssociativeTrieNode<V>(newAddr);
        }

        @Override
        protected IPAddressAssociativeTrie<V> createNewTree() {
            return new IPAddressAssociativeTrie();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> getUpperSubNode() {
            return (IPAddressAssociativeTrieNode)super.getUpperSubNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> getLowerSubNode() {
            return (IPAddressAssociativeTrieNode)super.getLowerSubNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> getParent() {
            return (IPAddressAssociativeTrieNode)super.getParent();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> removeElementsContainedBy(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.removeElementsContainedBy(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> elementsContainedBy(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.elementsContainedBy(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> elementsContaining(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.elementsContaining(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> longestPrefixMatchNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.longestPrefixMatchNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> getAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.getAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> getNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.getNode(addr);
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> nodeIterator(boolean forward) {
            return super.nodeIterator(forward);
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> allNodeIterator(boolean forward) {
            return super.allNodeIterator(forward);
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> blockSizeNodeIterator(boolean lowerSubNodeFirst) {
            return super.blockSizeNodeIterator(lowerSubNodeFirst);
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> blockSizeAllNodeIterator(boolean lowerSubNodeFirst) {
            return super.blockSizeAllNodeIterator(lowerSubNodeFirst);
        }

        @Override
        public <C> BinaryTreeNode.CachingIterator<IPAddressAssociativeTrieNode<V>, IPAddress, C> blockSizeCachingAllNodeIterator() {
            return super.blockSizeCachingAllNodeIterator();
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> containingFirstIterator(boolean forwardSubNodeOrder) {
            return super.containingFirstIterator(forwardSubNodeOrder);
        }

        @Override
        public <C> BinaryTreeNode.CachingIterator<IPAddressAssociativeTrieNode<V>, IPAddress, C> containingFirstAllNodeIterator(boolean forwardSubNodeOrder) {
            return super.containingFirstAllNodeIterator(forwardSubNodeOrder);
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> containedFirstIterator(boolean forwardSubNodeOrder) {
            return super.containedFirstIterator(forwardSubNodeOrder);
        }

        @Override
        public Iterator<IPAddressAssociativeTrieNode<V>> containedFirstAllNodeIterator(boolean forwardSubNodeOrder) {
            return super.containedFirstAllNodeIterator(forwardSubNodeOrder);
        }

        @Override
        public Spliterator<IPAddressAssociativeTrieNode<V>> nodeSpliterator(boolean forward) {
            return super.nodeSpliterator(forward);
        }

        @Override
        public Spliterator<IPAddressAssociativeTrieNode<V>> allNodeSpliterator(boolean forward) {
            return super.allNodeSpliterator(forward);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> previousAddedNode() {
            return (IPAddressAssociativeTrieNode)super.previousAddedNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> nextAddedNode() {
            return (IPAddressAssociativeTrieNode)super.nextAddedNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> nextNode() {
            return (IPAddressAssociativeTrieNode)super.nextNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> previousNode() {
            return (IPAddressAssociativeTrieNode)super.previousNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> removeElementsIntersectedBy(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.removeElementsIntersectedBy(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> containingFloorAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.containingFloorAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> containingLowerAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.containingLowerAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> containingCeilingAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.containingCeilingAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> containingHigherAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.containingHigherAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> lowerAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.lowerAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> floorAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.floorAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> higherAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.higherAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> ceilingAddedNode(IPAddress addr) {
            return (IPAddressAssociativeTrieNode)super.ceilingAddedNode(addr);
        }

        @Override
        public IPAddressAssociativeTrieNode<V> firstNode() {
            return (IPAddressAssociativeTrieNode)super.firstNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> lastNode() {
            return (IPAddressAssociativeTrieNode)super.lastNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> firstAddedNode() {
            return (IPAddressAssociativeTrieNode)super.firstAddedNode();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> lastAddedNode() {
            return (IPAddressAssociativeTrieNode)super.lastAddedNode();
        }

        @Override
        public IPAddressAssociativeTrie<V> asNewTrie() {
            return (IPAddressAssociativeTrie)super.asNewTrie();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> cloneTree() {
            return (IPAddressAssociativeTrieNode)super.cloneTree();
        }

        @Override
        public IPAddressAssociativeTrieNode<V> clone() {
            return (IPAddressAssociativeTrieNode)super.clone();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof IPAddressAssociativeTrieNode && super.equals(o);
        }
    }
}

