/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.AssociativeAddressTrie;
import inet.ipaddr.format.util.BaseDualIPv4v6Tries;
import inet.ipaddr.format.util.DualIPv4v6Tries;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressAssociativeTrie;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressAssociativeTrie;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class DualIPv4v6AssociativeTries<V>
extends BaseDualIPv4v6Tries<IPv4AddressAssociativeTrie<V>, IPv6AddressAssociativeTrie<V>> {
    private static final long serialVersionUID = 1L;
    private IPv6AddressAssociativeTrie<V> ipv6Trie;
    private IPv4AddressAssociativeTrie<V> ipv4Trie;

    public DualIPv4v6AssociativeTries() {
        this(new IPv4AddressAssociativeTrie(), new IPv6AddressAssociativeTrie());
    }

    public DualIPv4v6AssociativeTries(IPv4AddressAssociativeTrie<V> ipv4Trie, IPv6AddressAssociativeTrie<V> ipv6Trie) {
        super(ipv4Trie, ipv6Trie);
        this.ipv4Trie = ipv4Trie;
        this.ipv6Trie = ipv6Trie;
    }

    @Override
    public DualIPv4v6AssociativeTries<V> clone() {
        DualIPv4v6AssociativeTries result = (DualIPv4v6AssociativeTries)super.clone();
        result.ipv4Trie = this.ipv4Trie.clone();
        result.ipv6Trie = this.ipv6Trie.clone();
        result.assignTrackers(result.ipv4Trie, result.ipv6Trie);
        return result;
    }

    @Override
    public IPv4AddressAssociativeTrie<V> getIPv4Trie() {
        return this.ipv4Trie;
    }

    @Override
    public IPv6AddressAssociativeTrie<V> getIPv6Trie() {
        return this.ipv6Trie;
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> elementsContaining(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::elementsContaining, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::elementsContaining);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> elementsContainedBy(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::elementsContainedBy, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::elementsContainedBy);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> removeElementsContainedBy(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::removeElementsContainedBy, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::removeElementsContainedBy);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> getAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::getAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::getAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> longestPrefixMatchNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::longestPrefixMatchNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::longestPrefixMatchNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> addNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::addNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::addNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> addTrie(AddressTrie.TrieNode<? extends IPAddress> trie) {
        return (AssociativeAddressTrie.AssociativeTrieNode)DualIPv4v6AssociativeTries.unaryOp(trie, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::addTrie, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::addTrie);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> removeElementsIntersectedBy(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::removeElementsIntersectedBy, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::removeElementsIntersectedBy);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> addIfNoElementsContaining(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::addIfNoElementsContaining, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::addIfNoElementsContaining);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> containingFloorAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::containingFloorAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::containingHigherAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> containingLowerAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::containingLowerAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::containingHigherAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> containingCeilingAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::containingCeilingAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::containingHigherAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> containingHigherAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::containingHigherAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::containingHigherAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> floorAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::floorAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::floorAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> lowerAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::lowerAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::lowerAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> ceilingAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::ceilingAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::ceilingAddedNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> higherAddedNode(IPAddress addr) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::higherAddedNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::higherAddedNode);
    }

    @Override
    public Iterator<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V>> nodeIterator(boolean forward) {
        return this.combineNodeIterators(forward, ((IPv4AddressAssociativeTrie)this.getIPv4Trie()).nodeIterator(forward), ((IPv6AddressAssociativeTrie)this.getIPv6Trie()).nodeIterator(forward));
    }

    @Override
    public Iterator<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V>> containingFirstIterator(boolean forwardSubNodeOrder) {
        return this.combineNodeIterators(forwardSubNodeOrder, ((IPv4AddressAssociativeTrie)this.getIPv4Trie()).containingFirstIterator(forwardSubNodeOrder), ((IPv6AddressAssociativeTrie)this.getIPv6Trie()).containingFirstIterator(forwardSubNodeOrder));
    }

    @Override
    public Iterator<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V>> containedFirstIterator(boolean forwardSubNodeOrder) {
        return this.combineNodeIterators(forwardSubNodeOrder, ((IPv4AddressAssociativeTrie)this.getIPv4Trie()).containedFirstIterator(forwardSubNodeOrder), ((IPv6AddressAssociativeTrie)this.getIPv6Trie()).containedFirstIterator(forwardSubNodeOrder));
    }

    @Override
    public Iterator<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V>> blockSizeNodeIterator(boolean lowerSubNodeFirst) {
        return this.combineBlockSizeNodeIterators(lowerSubNodeFirst, ((IPv4AddressAssociativeTrie)this.getIPv4Trie()).blockSizeNodeIterator(lowerSubNodeFirst), ((IPv6AddressAssociativeTrie)this.getIPv6Trie()).blockSizeNodeIterator(lowerSubNodeFirst));
    }

    @Override
    public Spliterator<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V>> nodeSpliterator(boolean forward) {
        return this.combineNodeSpliterators(forward, ((IPv4AddressAssociativeTrie)this.getIPv4Trie()).nodeSpliterator(forward), ((IPv6AddressAssociativeTrie)this.getIPv6Trie()).nodeSpliterator(forward));
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> addTrie(AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> trie) {
        return (AssociativeAddressTrie.AssociativeTrieNode)DualIPv4v6Tries.unaryOp(trie, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::addTrie, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::addTrie);
    }

    public V get(IPAddress addr) {
        return (V)DualIPv4v6Tries.addressFuncOp(addr, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::get, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::get);
    }

    public V put(IPAddress addr, V value) {
        return (V)DualIPv4v6Tries.addressValValBiFuncOp(addr, value, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::put, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::put);
    }

    public boolean putNew(IPAddress addr, V value) {
        return DualIPv4v6Tries.addressValBiFuncOp(addr, value, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::putNew, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::putNew);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> putNode(IPAddress addr, V value) {
        return DualIPv4v6Tries.addressValBiFuncOp(addr, value, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::putNode, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::putNode);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> putTrie(AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> trie) {
        return (AssociativeAddressTrie.AssociativeTrieNode)DualIPv4v6Tries.unaryOp(trie, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::putTrie, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::putTrie);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> remap(IPAddress addr, Function<? super V, ? extends V> remapper) {
        return DualIPv4v6AssociativeTries.addressFuncOp(addr, remapper, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::remap, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::remap);
    }

    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, V> remapIfAbsent(IPAddress addr, Supplier<? extends V> remapper, boolean insertNull) {
        return DualIPv4v6AssociativeTries.addressFuncBoolOp(addr, remapper, insertNull, ((IPv4AddressAssociativeTrie)this.getIPv4Trie())::remapIfAbsent, ((IPv6AddressAssociativeTrie)this.getIPv6Trie())::remapIfAbsent);
    }

    static <T, V, F> T addressFuncOp(IPAddress addr, F remapper, BiFunction<IPv4Address, F, T> ipv4Op, BiFunction<IPv6Address, F, T> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.apply(addr.toIPv4(), remapper);
        }
        if (addr.isIPv6()) {
            return ipv6Op.apply(addr.toIPv6(), remapper);
        }
        return null;
    }

    static <T, V, F> T addressFuncBoolOp(IPAddress addr, F remapper, boolean insertNull, TriBoolFunction<IPv4Address, F, T> ipv4Op, TriBoolFunction<IPv6Address, F, T> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.apply(addr.toIPv4(), remapper, insertNull);
        }
        if (addr.isIPv6()) {
            return ipv6Op.apply(addr.toIPv6(), remapper, insertNull);
        }
        return null;
    }

    @FunctionalInterface
    public static interface TriBoolFunction<T, U, R> {
        public R apply(T var1, U var2, boolean var3);
    }
}

